/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository.adapter;

import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.adapter.UtilAttrValueConverter;
import com.sas.svcs.reportrepository.client.CacheItemServiceInterface;
import com.sas.svcs.reportrepository.client.domain.AttributeEntryType;
import com.sas.svcs.reportrepository.client.domain.AttributesType;
import com.sas.svcs.reportrepository.client.domain.ObjectFactory;
import com.sas.svcs.reportrepository.client.domain.RepositoryExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryIOExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryLockedExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryNotFoundExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.SecurityExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.UnsupportedOperationExceptionHolder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CacheItemInterfaceServiceAdapter
implements CacheItemInterface {
    private static final Logger logger = LogManager.getLogger(CacheItemInterfaceServiceAdapter.class);
    protected CacheItemServiceInterface cacheItemService;
    protected String entryPathUrl;
    protected String cacheName;
    protected String cacheItemName;

    public CacheItemInterfaceServiceAdapter(CacheItemServiceInterface cacheItemService, String entryPathUrl, String cacheName, String cacheItemName) {
        this.cacheItemService = cacheItemService;
        this.entryPathUrl = entryPathUrl;
        this.cacheName = cacheName;
        this.cacheItemName = cacheItemName;
    }

    @Override
    public CacheInterface getParentCache() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close(OutputStream stream) throws RepositoryIOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete() throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.cacheItemService.delete(this.entryPathUrl, this.cacheName, this.cacheItemName);
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public void deleteContent() throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getAttribute(String attribName) throws RepositoryNotFoundException, RepositoryException, RepositoryLockedException, SecurityException {
        try {
            Object attrValue = this.cacheItemService.getAttribute(this.entryPathUrl, this.cacheName, this.cacheItemName, attribName);
            return UtilAttrValueConverter.convertFromServiceAttrValue(attrValue, true);
        }
        catch (RepositoryNotFoundExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryNotFoundException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public Iterator getAttributes() throws RepositoryException, SecurityException {
        try {
            HashMap<String, Object> attrMap = new HashMap<String, Object>();
            List attrs = this.cacheItemService.getAttributes(this.entryPathUrl, this.cacheName, this.cacheItemName);
            for (AttributeEntryType attr : attrs) {
                String attrName = attr.getAttrName();
                Object attrValue = attr.getAttrValue();
                attrMap.put(attrName, attrValue);
            }
            return attrMap.entrySet().iterator();
        }
        catch (RepositoryNotFoundExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryNotFoundException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public String getContentLocation() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getInputStream() throws RepositoryIOException, SecurityException {
        try {
            byte[] contents = this.cacheItemService.getContent(this.entryPathUrl, this.cacheName, this.cacheItemName);
            return new ByteArrayInputStream(contents);
        }
        catch (RepositoryIOExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryIOException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public Object getMetadataObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.cacheItemName;
    }

    @Override
    public OutputStream getOutputStream() throws SecurityException, RepositoryIOException {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                try {
                    CacheItemInterfaceServiceAdapter.this.cacheItemService.setContent(CacheItemInterfaceServiceAdapter.this.entryPathUrl, CacheItemInterfaceServiceAdapter.this.cacheName, CacheItemInterfaceServiceAdapter.this.cacheItemName, this.toByteArray());
                }
                catch (RepositoryIOExceptionHolder e) {
                    logger.error((Object)e);
                    throw new RuntimeException(e.getExceptionType().getMessage());
                }
                catch (SecurityExceptionHolder e) {
                    logger.error((Object)e);
                    throw new RuntimeException(e.getExceptionType().getMessage());
                }
            }
        };
    }

    @Override
    public EntryInterface getParentEntry() throws RepositoryNotFoundException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getSizeOfContent() throws UnsupportedOperationException, RepositoryException {
        try {
            return this.cacheItemService.getSizeOfContents(this.entryPathUrl, this.cacheName, this.cacheItemName);
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (UnsupportedOperationExceptionHolder e) {
            logger.error((Object)e);
            throw new UnsupportedOperationException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public boolean isEmpty() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(InputStream stream, byte[] data) throws RepositoryIOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            attributeValue = UtilAttrValueConverter.convertToServiceAttrValue(attributeName, attributeValue, this.entryPathUrl);
            this.cacheItemService.setAttribute(this.entryPathUrl, this.cacheName, this.cacheItemName, attributeName, attributeValue);
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public void setAttributes(Map attributes) throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            AttributesType attrsService = new ObjectFactory().createAttributesType();
            for (Map.Entry entry : attributes.entrySet()) {
                String attrName = (String)entry.getKey();
                Object attrValue = entry.getValue();
                attrValue = UtilAttrValueConverter.convertToServiceAttrValue(attrName, attrValue, this.entryPathUrl);
                AttributeEntryType attrService = new ObjectFactory().createAttributeEntryType();
                attrService.setAttrName(attrName);
                attrService.setAttrValue(attrValue);
                attrsService.getAttributeEntry().add(attrService);
            }
            this.cacheItemService.setAttributes(this.entryPathUrl, this.cacheName, this.cacheItemName, attrsService);
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public int write(OutputStream stream, byte[] data, int len) throws RepositoryIOException {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        if (this.entryPathUrl != null) {
            return this.entryPathUrl.hashCode() + this.cacheName != null ? this.cacheName.hashCode() : (0 + this.cacheItemName != null ? this.cacheItemName.hashCode() : 0);
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.stringEquals(this.entryPathUrl, ((CacheItemInterfaceServiceAdapter)o).entryPathUrl) && this.stringEquals(this.cacheName, ((CacheItemInterfaceServiceAdapter)o).cacheName) && this.stringEquals(this.cacheItemName, ((CacheItemInterfaceServiceAdapter)o).cacheItemName);
    }

    protected boolean stringEquals(String str1, String str2) {
        if (str1 != null) {
            return str1.equals(str2);
        }
        return str2 == null;
    }

    @Override
    public void lock() throws RepositoryLockedException, RepositoryException, UnsupportedOperationException, SecurityException {
        try {
            this.cacheItemService.lock(this.entryPathUrl, this.cacheName, this.cacheItemName);
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public void unlock() throws RepositoryLockedException, RepositoryException, UnsupportedOperationException, SecurityException {
        try {
            this.cacheItemService.unlock(this.entryPathUrl, this.cacheName, this.cacheItemName);
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }
}

