/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.framework.services.remoting.EndpointLocator;
import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.OMRDirectory;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.OMRReportDirectory;
import com.sas.report.repository.Repository;
import com.sas.report.repository.adapter.DirectoryInterfaceServiceAdapter;
import com.sas.report.repository.adapter.EntryInterfaceServiceAdapter;
import com.sas.report.repository.adapter.ProjectContentInterfaceServiceAdapter;
import com.sas.report.repository.adapter.RepositoryServiceAdapter;
import com.sas.services.ServiceException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.commons.webservice.client.SecurityTokenServiceClient;
import com.sas.svcs.commons.webservice.client.ServiceRegistryClient;
import com.sas.svcs.commons.webservice.omrclient.DAVCredentialsHelper;
import com.sas.svcs.commons.webservice.omrclient.SecurityTokenServiceOMRClient;
import com.sas.svcs.registry.client.ServiceParameters;
import com.sas.svcs.registry.client.ServiceRegistryInterface;
import com.sas.svcs.registry.client.ServiceType;
import com.sas.svcs.remoting.client.SASClientTicketingProxy;
import com.sas.svcs.reportrepository.client.CacheItemServiceInterface;
import com.sas.svcs.reportrepository.client.CacheServiceInterface;
import com.sas.svcs.reportrepository.client.CacheSetServiceInterface;
import com.sas.svcs.reportrepository.client.DirectoryServiceInterface;
import com.sas.svcs.reportrepository.client.EntryServiceInterface;
import com.sas.svcs.reportrepository.client.ImportedEntryServiceInterface;
import com.sas.svcs.reportrepository.client.ProjectContentServiceInterface;
import com.sas.svcs.reportrepository.client.RepositoryFactoryServiceInterface;
import com.sas.svcs.reportrepository.client.RepositoryServiceInterface;
import com.sas.svcs.reportrepository.proxy.CacheItemServiceInterfaceProxy;
import com.sas.svcs.reportrepository.proxy.CacheServiceInterfaceProxy;
import com.sas.svcs.reportrepository.proxy.CacheSetServiceInterfaceProxy;
import com.sas.svcs.reportrepository.proxy.DirectoryServiceInterfaceProxy;
import com.sas.svcs.reportrepository.proxy.EntryServiceInterfaceProxy;
import com.sas.svcs.reportrepository.proxy.ImportedEntryServiceInterfaceProxy;
import com.sas.svcs.reportrepository.proxy.ProjectContentServiceInterfaceProxy;
import com.sas.svcs.reportrepository.proxy.RepositoryFactoryServiceInterfaceProxy;
import com.sas.svcs.reportrepository.proxy.RepositoryServiceInterfaceProxy;
import com.sas.svcs.security.authentication.omr.client.AuthenticationClientHelper;
import java.rmi.RemoteException;

public class UtilReportReposService {
    private static final String SECURITY_TOKEN_SERVICE_CLIENT = "SecurityTokenServiceClient";
    private static final String SECURITY_TOKEN_RR_SERVICE_URL = "ReportRepositoryServiceUrl";
    private static final String SASLOGONMGR = "SAS Logon Manager";

    public static boolean credentialsAccessible(MetadataInterface metadataObj) throws ServiceException, RemoteException {
        return OMRID.securedUserAvailable() || !DAVCredentialsHelper.credentialsSecured((MetadataInterface)metadataObj);
    }

    public static boolean credentialsAccessible(UserContextInterface uc) throws ServiceException, RemoteException {
        return OMRID.securedUserAvailable() || !DAVCredentialsHelper.credentialsSecured((UserContextInterface)uc);
    }

    public static EntryInterface getEntryServiceAdapter(InformationServiceInterface is, MetadataInterface mi) throws RemoteException, ServiceException {
        UserContextInterface uc = mi.getRepository().getUserContext();
        return new EntryInterfaceServiceAdapter(UtilReportReposService.getEntryService(is, uc), UtilReportReposService.getImportedEntryService(is, uc), UtilReportReposService.getDirService(is, uc), UtilReportReposService.getCacheSetService(is, uc), UtilReportReposService.getCacheService(is, uc), UtilReportReposService.getCacheItemService(is, uc), mi.getPathUrl().toString(), mi.getRepository().getServer(), mi);
    }

    public static DirectoryInterface getDirServiceAdapter(InformationServiceInterface is, MetadataInterface mi) throws RemoteException, ServiceException {
        UserContextInterface uc = mi.getRepository().getUserContext();
        return new DirectoryInterfaceServiceAdapter(UtilReportReposService.getDirService(is, uc), UtilReportReposService.getEntryService(is, uc), UtilReportReposService.getImportedEntryService(is, uc), UtilReportReposService.getCacheSetService(is, uc), UtilReportReposService.getCacheService(is, uc), UtilReportReposService.getCacheItemService(is, uc), mi.getPathUrl().toString(), mi.getRepository().getServer(), mi);
    }

    public static ContentInterface getProjectContentServiceAdapter(InformationServiceInterface is, MetadataInterface mi) throws RemoteException, ServiceException {
        UserContextInterface uc = mi.getRepository().getUserContext();
        return new ProjectContentInterfaceServiceAdapter(UtilReportReposService.getProjectContentService(is, uc), mi.getPathUrl().toString());
    }

    public static Repository getRepositoryAdapter(InformationServiceInterface is, UserContextInterface uc, String reposName) throws RemoteException, ServiceException {
        return new RepositoryServiceAdapter(UtilReportReposService.getRepositoryService(is, uc), UtilReportReposService.getEntryService(is, uc), UtilReportReposService.getImportedEntryService(is, uc), UtilReportReposService.getDirService(is, uc), UtilReportReposService.getCacheSetService(is, uc), UtilReportReposService.getCacheService(is, uc), UtilReportReposService.getCacheItemService(is, uc), reposName, uc.getAuthServer());
    }

    private static EntryServiceInterface getEntryService(InformationServiceInterface infoService, UserContextInterface userContext) throws RemoteException, ServiceException {
        SecurityTokenServiceClient stsClient = UtilReportReposService.getSTSClient(infoService, userContext);
        String serviceURL = UtilReportReposService.getServiceUrl(infoService, userContext);
        EntryServiceInterfaceProxy entryService = new EntryServiceInterfaceProxy(serviceURL, stsClient);
        return entryService;
    }

    private static DirectoryServiceInterface getDirService(InformationServiceInterface infoService, UserContextInterface userContext) throws RemoteException, ServiceException {
        SecurityTokenServiceClient stsClient = UtilReportReposService.getSTSClient(infoService, userContext);
        String serviceURL = UtilReportReposService.getServiceUrl(infoService, userContext);
        DirectoryServiceInterfaceProxy dirService = new DirectoryServiceInterfaceProxy(serviceURL, stsClient);
        return dirService;
    }

    private static CacheSetServiceInterface getCacheSetService(InformationServiceInterface infoService, UserContextInterface userContext) throws RemoteException, ServiceException {
        SecurityTokenServiceClient stsClient = UtilReportReposService.getSTSClient(infoService, userContext);
        String serviceURL = UtilReportReposService.getServiceUrl(infoService, userContext);
        CacheSetServiceInterfaceProxy cacheSetService = new CacheSetServiceInterfaceProxy(serviceURL, stsClient);
        return cacheSetService;
    }

    private static CacheServiceInterface getCacheService(InformationServiceInterface infoService, UserContextInterface userContext) throws RemoteException, ServiceException {
        SecurityTokenServiceClient stsClient = UtilReportReposService.getSTSClient(infoService, userContext);
        String serviceURL = UtilReportReposService.getServiceUrl(infoService, userContext);
        CacheServiceInterfaceProxy cacheService = new CacheServiceInterfaceProxy(serviceURL, stsClient);
        return cacheService;
    }

    private static CacheItemServiceInterface getCacheItemService(InformationServiceInterface infoService, UserContextInterface userContext) throws RemoteException, ServiceException {
        SecurityTokenServiceClient stsClient = UtilReportReposService.getSTSClient(infoService, userContext);
        String serviceURL = UtilReportReposService.getServiceUrl(infoService, userContext);
        CacheItemServiceInterfaceProxy cacheItemService = new CacheItemServiceInterfaceProxy(serviceURL, stsClient);
        return cacheItemService;
    }

    private static ImportedEntryServiceInterface getImportedEntryService(InformationServiceInterface infoService, UserContextInterface userContext) throws RemoteException, ServiceException {
        SecurityTokenServiceClient stsClient = UtilReportReposService.getSTSClient(infoService, userContext);
        String serviceURL = UtilReportReposService.getServiceUrl(infoService, userContext);
        ImportedEntryServiceInterfaceProxy importedEntryService = new ImportedEntryServiceInterfaceProxy(serviceURL, stsClient);
        return importedEntryService;
    }

    private static ProjectContentServiceInterface getProjectContentService(InformationServiceInterface infoService, UserContextInterface userContext) throws RemoteException, ServiceException {
        SecurityTokenServiceClient stsClient = UtilReportReposService.getSTSClient(infoService, userContext);
        String serviceURL = UtilReportReposService.getServiceUrl(infoService, userContext);
        ProjectContentServiceInterfaceProxy projectContentService = new ProjectContentServiceInterfaceProxy(serviceURL, stsClient);
        return projectContentService;
    }

    public static RepositoryFactoryServiceInterface getRepositoryFactoryService(InformationServiceInterface infoService, UserContextInterface userContext) throws RemoteException, ServiceException {
        SecurityTokenServiceClient stsClient = UtilReportReposService.getSTSClient(infoService, userContext);
        String serviceURL = UtilReportReposService.getServiceUrl(infoService, userContext);
        RepositoryFactoryServiceInterfaceProxy reposFactoryService = new RepositoryFactoryServiceInterfaceProxy(serviceURL, stsClient);
        return reposFactoryService;
    }

    private static RepositoryServiceInterface getRepositoryService(InformationServiceInterface infoService, UserContextInterface userContext) throws RemoteException, ServiceException {
        SecurityTokenServiceClient stsClient = UtilReportReposService.getSTSClient(infoService, userContext);
        String serviceURL = UtilReportReposService.getServiceUrl(infoService, userContext);
        RepositoryServiceInterfaceProxy reposService = new RepositoryServiceInterfaceProxy(serviceURL, stsClient);
        return reposService;
    }

    public static void expireSTSClient(UserContextInterface userContext) {
        try {
            SessionContextInterface sessionContext = userContext.getSessionContext();
            SecurityTokenServiceClient stsClient = (SecurityTokenServiceClient)sessionContext.getAttribute(SECURITY_TOKEN_SERVICE_CLIENT);
            if (stsClient != null) {
                stsClient.cancelToken();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static OMRID getOMRID(DirectoryInterface di) {
        try {
            if (di instanceof OMRDirectory) {
                return ((OMRDirectory)di).getOMRID();
            }
            Object mo = di.getMetadataObject();
            if (mo instanceof OMRReportDirectory) {
                return ((OMRReportDirectory)mo).getOMRID();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static synchronized SecurityTokenServiceClient getSTSClient(InformationServiceInterface infoService, UserContextInterface userContext) throws RemoteException, ServiceException {
        SessionContextInterface sessionContext = userContext.getSessionContext();
        AuthenticationClientHelper.setAuthentication((SessionContextInterface)sessionContext);
        SecurityTokenServiceClient stsClient = (SecurityTokenServiceClient)sessionContext.getAttribute(SECURITY_TOKEN_SERVICE_CLIENT);
        if (stsClient == null) {
            String registryUrl = EndpointLocator.getServiceRegistryUrl((UserContextInterface)sessionContext.getUserContext());
            SASClientTicketingProxy registryProxy = new SASClientTicketingProxy();
            registryProxy.setServiceInterface(ServiceRegistryInterface.class);
            registryProxy.setServiceUrl(registryUrl);
            registryProxy.afterPropertiesSet();
            ServiceRegistryInterface serviceRegistry = (ServiceRegistryInterface)registryProxy.getObject();
            String soapRegistryURL = serviceRegistry.getService(new ServiceParameters("ServiceRegistry", ServiceType.SOAP)).getUrl();
            stsClient = new SecurityTokenServiceOMRClient(soapRegistryURL, userContext);
            stsClient.obtainToken();
            ServiceRegistryClient srClient = new ServiceRegistryClient(soapRegistryURL);
            srClient.obtainServices();
            String rrServiceEndpointURL = srClient.getServiceURL("ReportRepositoryService");
            sessionContext.setAttribute(SECURITY_TOKEN_SERVICE_CLIENT, (Object)stsClient);
            sessionContext.setAttribute(SECURITY_TOKEN_RR_SERVICE_URL, (Object)rrServiceEndpointURL);
        }
        return stsClient;
    }

    private static synchronized String getServiceUrl(InformationServiceInterface infoService, UserContextInterface userContext) throws RemoteException, ServiceException {
        SessionContextInterface sessionContext = userContext.getSessionContext();
        String serviceUrl = (String)sessionContext.getAttribute(SECURITY_TOKEN_RR_SERVICE_URL);
        return serviceUrl;
    }
}

