/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MapPool;
import com.sas.metadata.remote.Root;
import com.sas.report.repository.AdapterFactory;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.PFServices;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RepositoryException;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.discovery.Services;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryEvent;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.RepositoryListenerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class SmartObjectHelper
implements RepositoryListenerInterface {
    private OMRID myOMRID;
    private OMIRepositoryInterface myOmiRepository;

    public SmartObjectHelper(RepositoryInterface repos) throws IllegalStateException, RemoteException {
        if (!(repos instanceof OMIRepositoryInterface)) {
            throw new IllegalStateException(RBUtil.getStringResource("OMRReportEntrynotOMIRepository.txt"));
        }
        this.myOmiRepository = (OMIRepositoryInterface)repos;
    }

    public void initOMRID(SessionContextInterface sessionContext, OMIRepositoryInterface omiRepository) throws RepositoryException, RemoteException {
        HashMap<OMIRepositoryInterface, OMRID> omridMap = (HashMap<OMIRepositoryInterface, OMRID>)sessionContext.getAttribute(OMRID.SESSION_CONTEXT_MAP_KEY);
        if (omridMap == null) {
            omridMap = new HashMap<OMIRepositoryInterface, OMRID>();
            sessionContext.setAttribute(OMRID.SESSION_CONTEXT_MAP_KEY, omridMap);
        }
        if (omridMap.containsKey(omiRepository)) {
            this.myOMRID = (OMRID)omridMap.get(omiRepository);
        } else {
            PFServices pfs = new PFServices(sessionContext);
            this.myOMRID = new OMRID(omiRepository, pfs);
            omridMap.put(omiRepository, this.myOMRID);
            try {
                omiRepository.addListener((RepositoryListenerInterface)this);
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
    }

    public OMRID getOMRID() {
        return this.myOMRID;
    }

    public UserContextInterface getUserContext() throws RemoteException {
        return this.myOmiRepository.getUserContext();
    }

    public void initRepository(int reposFlag, Object reposObj, String name) throws IllegalStateException, RemoteException {
        try {
            UserContextInterface userContext;
            if (reposFlag == 2) {
                Root root = (Root)reposObj;
                Map map = root.getAssocs();
                AssociationList trees = (AssociationList)map.get("Trees");
                if (trees != null && trees.size() > 0 && (trees.getState() & 0x20) > 0) {
                    trees.resetState(32);
                }
                MapPool.returnMap((Map)map);
            }
            if ((userContext = this.myOmiRepository.getUserContext()) == null) {
                String msg = RBUtil.getStringResource("OMRReportEntrynoUserSession.txt", name);
                throw new IllegalStateException(msg);
            }
            SessionContextInterface sessionContext = userContext.getSessionContext();
            if (sessionContext == null) {
                String msg = RBUtil.getStringResource("OMRReportEntrynoSession.txt", name);
                throw new IllegalStateException(msg);
            }
            if (AdapterFactory.isRemote((Remote)sessionContext)) {
                String sessionId = sessionContext.getEntityKey();
                PfsAction action = new PfsAction(sessionId, this.myOmiRepository);
                try {
                    sessionContext = (SessionContextInterface)AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException pae) {
                    Throwable th = pae.getCause();
                    th.printStackTrace();
                    throw (IllegalStateException)new IllegalStateException(th.getMessage()).initCause(th);
                }
            } else {
                this.initOMRID(sessionContext, this.myOmiRepository);
            }
            if (sessionContext == null) {
                throw new IllegalStateException(RBUtil.getStringResource("SmartObjectHelper.SessionContextNull.txt"));
            }
            if (AdapterFactory.isRemote((Remote)sessionContext)) {
                throw new IllegalStateException(RBUtil.getStringResource("SmartObjectHelper.SessionContextIsStub.txt"));
            }
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
    }

    public void repositoryCallback(RepositoryEvent event) throws RemoteException {
        if (event.getEvent() == 3) {
            try {
                Map omridMap;
                SessionContextInterface sessionContext;
                UserContextInterface user;
                ServerInterface server;
                RepositoryInterface ri = event.getRepository();
                if (ri != null && (server = ri.getServer()) != null && (user = server.getUserContext()) != null && (sessionContext = user.getSessionContext()) != null && !sessionContext.isDestroyPending() && (omridMap = (Map)sessionContext.getAttribute(OMRID.SESSION_CONTEXT_MAP_KEY)) != null && omridMap.containsKey(ri)) {
                    omridMap.remove(ri);
                }
            }
            catch (ServiceException ex) {
                ex.printStackTrace();
            }
        }
    }

    class PfsAction
    implements PrivilegedExceptionAction {
        private String mySessionId;
        private OMIRepositoryInterface myOmiRepository;

        public PfsAction(String sessionId, OMIRepositoryInterface omiRepository) {
            this.mySessionId = sessionId;
            this.myOmiRepository = omiRepository;
        }

        public Object run() throws Exception {
            SessionServiceInterface sessionService = (SessionServiceInterface)DiscoveryService.defaultInstance().findService(new ServiceTemplate(new Class[]{SessionServiceInterface.class}, null));
            SessionContextInterface sessionContext = sessionService.getSessionContext(this.mySessionId);
            if (sessionContext == null) {
                Services serviceList = DiscoveryService.defaultInstance().findServices(new ServiceTemplate(new Class[]{SessionServiceInterface.class}, null), Integer.MAX_VALUE, new Services());
                Iterator itor = serviceList.iterator();
                while (itor.hasNext() && sessionContext == null) {
                    SessionServiceInterface aSession = (SessionServiceInterface)itor.next();
                    sessionContext = aSession.getSessionContext(this.mySessionId);
                }
            }
            if (sessionContext == null) {
                throw new IllegalStateException(RBUtil.getStringResource("SmartObjectHelper.unableToObtainSession.fmt.txt", this.mySessionId));
            }
            SmartObjectHelper.this.initOMRID(sessionContext, this.myOmiRepository);
            return sessionContext;
        }
    }
}

