/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.util.RBBase;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class RepositoryResource
extends RBBase {
    private static RepositoryResource defaultBundle = new RepositoryResource();
    private static final String EMPTY_STR = new String();

    protected RepositoryResource() {
    }

    public RepositoryResource(String source) {
        super(source);
    }

    public RepositoryResource(String source, Locale locale) {
        super(source);
        this._getResources(locale);
    }

    public static String getStringResource(String classKey, String subKey) {
        String result = defaultBundle._getStringResource(classKey + subKey);
        if (result == null) {
            result = EMPTY_STR;
        }
        return result;
    }

    public static String getStringResource(String key) {
        String result = null;
        try {
            result = defaultBundle._getStringResource(key);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result == null) {
            result = EMPTY_STR;
            System.err.println("RepositoryResource.getStringResource(\"" + key + "\") == null");
        }
        return result;
    }

    public static int getIntResource(String key) {
        return RepositoryResource.getIntResource(key, 0);
    }

    public static int getIntResource(String key, int notFoundReturnValue) {
        int result = Integer.MIN_VALUE;
        try {
            String strValue = RepositoryResource.getStringResource(key);
            result = Integer.parseInt(strValue);
        }
        catch (NumberFormatException nfe) {
            result = notFoundReturnValue;
        }
        return result;
    }

    public static ResourceBundle getResources() {
        return defaultBundle._getResources();
    }

    public static String getMessageString(String key, Object[] args) {
        String pattern = RepositoryResource.getStringResource(key);
        return MessageFormat.format(pattern, args);
    }

    public static String getMessageString(String key, int argsNumber, String[] argString) {
        Object[] args = new Object[argsNumber];
        for (int _arg = 0; _arg < argsNumber; ++_arg) {
            args[_arg] = new String(argString[_arg]);
        }
        String pattern = RepositoryResource.getStringResource(key);
        return MessageFormat.format(pattern, args);
    }

    public String getString(String classKey, String subKey) {
        String key = classKey + subKey;
        String result = this._getStringResource(key);
        if (result == null) {
            result = RepositoryResource.getStringResource(key);
        }
        return result;
    }

    public String getString(String key) {
        String result = this._getStringResource(key);
        if (result == null) {
            result = RepositoryResource.getStringResource(key);
        }
        return result;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int notFoundReturnValue) {
        int result = Integer.MIN_VALUE;
        try {
            String strValue = this.getString(key);
            result = strValue.length() > 0 ? Integer.parseInt(strValue) : notFoundReturnValue;
        }
        catch (NumberFormatException nfe) {
            result = notFoundReturnValue;
        }
        return result;
    }

    public ResourceBundle getResourceBundle() {
        return this._getResources();
    }

    public String messageString(String key, Object[] args) {
        String pattern = RepositoryResource.getStringResource(key);
        return MessageFormat.format(pattern, args);
    }
}

