/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.RepositoryStreamListener;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class RepositoryOutputStream
extends FilterOutputStream {
    private boolean myCloseMethodCalled;
    private OutputStream myStream;
    private String myName;
    private RepositoryStreamListener myClosingListener;

    public RepositoryOutputStream(String name, OutputStream out) {
        super(new BufferedOutputStream(out));
        this.myName = name;
        this.myStream = out;
        this.myCloseMethodCalled = false;
    }

    public RepositoryOutputStream(OutputStream out) {
        this("", out);
    }

    public void setClosingListener(RepositoryStreamListener listener) {
        this.myClosingListener = listener;
    }

    @Override
    public void close() throws IOException {
        this.myCloseMethodCalled = true;
        super.close();
        this.notifyListener();
    }

    private void notifyListener() throws IOException {
        if (this.myClosingListener != null) {
            try {
                this.myClosingListener.streamClosing(this.myName, this.myStream);
            }
            catch (Exception e) {
                IOException ioe = new IOException(e.toString());
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    public boolean isClosed() {
        return this.myCloseMethodCalled;
    }

    public boolean isOpen() {
        return !this.myCloseMethodCalled;
    }
}

