/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.metadata.remote.Transformation;
import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.OMREntry;
import com.sas.report.repository.OMRGeneralEntryAdapter;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.OMRIQEntry;
import com.sas.report.repository.ReportEntryCreator;
import com.sas.report.repository.ReportEntryCreatorInterface;
import com.sas.report.repository.ReportFileFilter;
import com.sas.report.repository.ReportTypeDescriptor;
import com.sas.report.repository.RepositoryException;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ReportTypeDescriptorPlatform
extends ReportTypeDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(ReportTypeDescriptorPlatform.class);
    private static Map<ReportTypeDescriptor.ServerComparer, Collection<ReportTypeDescriptor>> reportTypeDescriptorsCollectionMap = new HashMap<ReportTypeDescriptor.ServerComparer, Collection<ReportTypeDescriptor>>();
    private static Map<ReportTypeDescriptor.ServerComparer, Collection<String>> publicTypesCollectionMap = new HashMap<ReportTypeDescriptor.ServerComparer, Collection<String>>();
    private static Map<ReportTypeDescriptor.ServerComparer, Collection<ReportTypeDescriptor>> reportTypeDescriptorsSupportingAddContentCollectionMap = new HashMap<ReportTypeDescriptor.ServerComparer, Collection<ReportTypeDescriptor>>();
    private static Map<ReportTypeDescriptor.ServerComparer, Collection<String>> publicTypesSupportingAddContentCollectionMap = new HashMap<ReportTypeDescriptor.ServerComparer, Collection<String>>();
    private static Map<ReportTypeDescriptor.ServerComparer, Map<String, ReportTypeDescriptor>> publicTypeToReportTypeDescriptorMapMap = new HashMap<ReportTypeDescriptor.ServerComparer, Map<String, ReportTypeDescriptor>>();

    ReportTypeDescriptorPlatform() {
    }

    protected static void initializeReportTypeDescriptor(ReportTypeDescriptor.ServerComparer serverComparer) throws ServiceException, RemoteException {
        ServerInterface server = serverComparer.getServer();
        ReportTypeDescriptor reportRTD = ReportTypeDescriptorPlatform.createPlatformReportTypeDescriptor(true, server.getTypeDescriptor("Report"), "Report", new String[]{"srx", "srz", "srt"}, new _CreateOMREntry());
        if (log.isDebugEnabled()) {
            log.debug("Success: loading ReportTypeDescriptor for Report");
        }
        ReportTypeDescriptor reportImageRTD = ReportTypeDescriptorPlatform.createPlatformReportTypeDescriptor(true, server.getTypeDescriptor("Report.Image"), "Report.Image", new String[]{"png", "gif", "jpg", "jpeg", "bmp"}, new _CreateOMREntry());
        if (log.isDebugEnabled()) {
            log.debug("Success: loading ReportTypeDescriptor for Report.Image");
        }
        ReportTypeDescriptor reportComponentRTD = ReportTypeDescriptorPlatform.createPlatformReportTypeDescriptor(true, server.getTypeDescriptor("Report.Component"), "Report.Component", new String[]{"*"}, new _CreateOMREntry());
        if (log.isDebugEnabled()) {
            log.debug("Success: loading ReportTypeDescriptor for Report.Component");
        }
        ReportTypeDescriptor infomapRTD = ReportTypeDescriptorPlatform.createPlatformReportTypeDescriptor(false, server.getTypeDescriptor("InformationMap"), "InformationMap", null, new _CreateOMRIQEntry());
        if (log.isDebugEnabled()) {
            log.debug("Success: loading ReportTypeDescriptor for InformationMap");
        }
        ReportTypeDescriptor infomapOlapRTD = ReportTypeDescriptorPlatform.createPlatformReportTypeDescriptor(false, server.getTypeDescriptor("InformationMap.OLAP"), "InformationMap.OLAP", null, new _CreateOMRIQEntry());
        if (log.isDebugEnabled()) {
            log.debug("Success: loading ReportTypeDescriptor for InformationMap.OLAP");
        }
        ReportTypeDescriptor infomapRelationalRTD = ReportTypeDescriptorPlatform.createPlatformReportTypeDescriptor(false, server.getTypeDescriptor("InformationMap.Relational"), "InformationMap.Relational", null, new _CreateOMRIQEntry());
        if (log.isDebugEnabled()) {
            log.debug("Success: loading ReportTypeDescriptor for InformationMap.Relational");
        }
        ReportTypeDescriptor storedprocRTD = ReportTypeDescriptorPlatform.createPlatformReportTypeDescriptor(false, server.getTypeDescriptor("StoredProcess"), "StoredProcess", null, new _CreateOMREntry());
        if (log.isDebugEnabled()) {
            log.debug("Success: loading ReportTypeDescriptor for StoredProcess");
        }
        ReportTypeDescriptor reportStoredprocRTD = ReportTypeDescriptorPlatform.createPlatformReportTypeDescriptor(false, server.getTypeDescriptor("Report.StoredProcess"), "Report.StoredProcess", null, new _CreateOMREntry());
        if (log.isDebugEnabled()) {
            log.debug("Success: loading ReportTypeDescriptor for Report.StoredProcess");
        }
        ReportTypeDescriptor transformationRTD = ReportTypeDescriptorPlatform.createPlatformReportTypeDescriptor(false, server.getTypeDescriptor("Transformation"), "Transformation", null, new _CreateOMREntry());
        if (log.isDebugEnabled()) {
            log.debug("Success: loading ReportTypeDescriptor for Transformation");
        }
        String XLS_RTD_ClassName = "com.sas.metadata.logical.reportdocument.ExcelSpreadsheetReportTypeDescriptor";
        String PDF_RTD_ClassName = "com.sas.metadata.logical.reportdocument.PDFDocumentReportTypeDescriptor";
        HashSet<ReportTypeDescriptor> reportTypeDescriptorSet = new HashSet<ReportTypeDescriptor>(14);
        reportTypeDescriptorSet.add(reportRTD);
        reportTypeDescriptorSet.add(reportImageRTD);
        reportTypeDescriptorSet.add(reportComponentRTD);
        reportTypeDescriptorSet.add(infomapRTD);
        reportTypeDescriptorSet.add(infomapOlapRTD);
        reportTypeDescriptorSet.add(infomapRelationalRTD);
        reportTypeDescriptorSet.add(storedprocRTD);
        reportTypeDescriptorSet.add(reportStoredprocRTD);
        reportTypeDescriptorSet.add(transformationRTD);
        HashSet<String> publicTypesSet = new HashSet<String>(14);
        publicTypesSet.add("Report");
        publicTypesSet.add("Report.Image");
        publicTypesSet.add("Report.Component");
        publicTypesSet.add("InformationMap");
        publicTypesSet.add("InformationMap.OLAP");
        publicTypesSet.add("InformationMap.Relational");
        publicTypesSet.add("StoredProcess");
        publicTypesSet.add("Report.StoredProcess");
        publicTypesSet.add("Transformation");
        HashSet<ReportTypeDescriptor> reportTypeDescriptorSupportingAddContentSet = new HashSet<ReportTypeDescriptor>(14);
        reportTypeDescriptorSupportingAddContentSet.add(reportRTD);
        reportTypeDescriptorSupportingAddContentSet.add(reportImageRTD);
        reportTypeDescriptorSupportingAddContentSet.add(reportComponentRTD);
        HashSet<String> publicTypesSupportingAddContentSet = new HashSet<String>(14);
        publicTypesSupportingAddContentSet.add("Report");
        publicTypesSupportingAddContentSet.add("Report.Image");
        publicTypesSupportingAddContentSet.add("Report.Component");
        HashMap<String, ReportTypeDescriptor> publicTypeToReportTypeDescriptorMap = new HashMap<String, ReportTypeDescriptor>(14);
        publicTypeToReportTypeDescriptorMap.put("Report", reportRTD);
        publicTypeToReportTypeDescriptorMap.put("Report.Image", reportImageRTD);
        publicTypeToReportTypeDescriptorMap.put("Report.Component", reportComponentRTD);
        publicTypeToReportTypeDescriptorMap.put("InformationMap", infomapRTD);
        publicTypeToReportTypeDescriptorMap.put("InformationMap.OLAP", infomapOlapRTD);
        publicTypeToReportTypeDescriptorMap.put("InformationMap.Relational", infomapRelationalRTD);
        publicTypeToReportTypeDescriptorMap.put("StoredProcess", storedprocRTD);
        publicTypeToReportTypeDescriptorMap.put("Report.StoredProcess", reportStoredprocRTD);
        publicTypeToReportTypeDescriptorMap.put("Transformation", transformationRTD);
        HashSet<String> excludedPlatformTypesAlreadyHardcodedSet = new HashSet<String>(Arrays.asList("com.sas.metadata.logical.reportdocument.ExcelSpreadsheetReportTypeDescriptor", "com.sas.metadata.logical.reportdocument.PDFDocumentReportTypeDescriptor"));
        try {
            for (TypeDescriptorInterface type : ((MetadataServerInterface)server).getTypeDictionaryMap().values()) {
                String typeName = type.getTypeName();
                String reporTypeDescriptorClassName = type.getPropertyValue("ReportTypeDescriptorClass");
                if (reporTypeDescriptorClassName == null) continue;
                try {
                    ReportTypeDescriptor typeDescriptor = ReportTypeDescriptor.getReportTypeDescriptor(reporTypeDescriptorClassName);
                    if (!typeDescriptor.isPlatformType()) continue;
                    reportTypeDescriptorSet.add(typeDescriptor);
                    publicTypesSet.add(typeName);
                    publicTypeToReportTypeDescriptorMap.put(typeName, typeDescriptor);
                    if (typeDescriptor.isAddContentSupported()) {
                        reportTypeDescriptorSupportingAddContentSet.add(typeDescriptor);
                        publicTypesSupportingAddContentSet.add(typeName);
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Success: loading ReportTypeDescriptor for " + typeName);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Failure: loading ReportTypeDescriptor for " + typeName + ".  Cause " + e.getMessage());
                }
            }
        }
        catch (RemoteException re) {
            throw new RuntimeException(re);
        }
        catch (ServiceException se) {
            throw new RuntimeException(se);
        }
        reportTypeDescriptorsCollectionMap.put(serverComparer, reportTypeDescriptorSet);
        publicTypesCollectionMap.put(serverComparer, publicTypesSet);
        reportTypeDescriptorsSupportingAddContentCollectionMap.put(serverComparer, reportTypeDescriptorSupportingAddContentSet);
        publicTypesSupportingAddContentCollectionMap.put(serverComparer, publicTypesSupportingAddContentSet);
        publicTypeToReportTypeDescriptorMapMap.put(serverComparer, publicTypeToReportTypeDescriptorMap);
    }

    protected static void deinitializeReportTypeDescriptor(ReportTypeDescriptor.ServerComparer serverComparer) {
        if (reportTypeDescriptorsCollectionMap.containsKey(serverComparer)) {
            reportTypeDescriptorsCollectionMap.remove(serverComparer);
        }
        if (publicTypesCollectionMap.containsKey(serverComparer)) {
            publicTypesCollectionMap.remove(serverComparer);
        }
        if (reportTypeDescriptorsSupportingAddContentCollectionMap.containsKey(serverComparer)) {
            reportTypeDescriptorsSupportingAddContentCollectionMap.remove(serverComparer);
        }
        if (publicTypesSupportingAddContentCollectionMap.containsKey(serverComparer)) {
            publicTypesSupportingAddContentCollectionMap.remove(serverComparer);
        }
        if (publicTypeToReportTypeDescriptorMapMap.containsKey(serverComparer)) {
            publicTypeToReportTypeDescriptorMapMap.remove(serverComparer);
        }
    }

    private static ReportTypeDescriptor createPlatformReportTypeDescriptor(String reportTypeDescriptorClassName) {
        return ReportTypeDescriptor.getReportTypeDescriptor(reportTypeDescriptorClassName);
    }

    private static ReportTypeDescriptor createPlatformReportTypeDescriptor(final boolean addContentSupported, final TypeDescriptorInterface tdi, final String publicType, final String[] extensions, final _CreateEntry _createEntry) {
        return new ReportTypeDescriptorPlatform(){
            private static final long serialVersionUID = 1L;
            private Map<Locale, FileFilter> fileFiltersMap = new HashMap<Locale, FileFilter>();
            private Object token = new Object();

            @Override
            public boolean isAddContentSupported() {
                return addContentSupported;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FileFilter getAddContentFileFilter(Locale locale) {
                Locale _locale;
                if (!addContentSupported || extensions == null) {
                    return null;
                }
                Locale locale2 = _locale = locale == null ? Locale.getDefault() : locale;
                if (this.fileFiltersMap.containsKey(_locale)) {
                    return this.fileFiltersMap.get(_locale);
                }
                String label = null;
                if (tdi != null) {
                    try {
                        label = tdi.getType(_locale);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (label != null && label.length() == 0) {
                        label = null;
                    }
                }
                if (label == null) {
                    label = publicType;
                }
                final String description = 1.generateDescription(label, extensions);
                ReportFileFilter filter = new ReportFileFilter(){
                    private String _publicType;
                    private String _description;
                    {
                        this._publicType = publicType;
                        this._description = description;
                    }

                    @Override
                    public String getPublicType() {
                        return this._publicType;
                    }

                    @Override
                    public boolean accept(File f) {
                        block5: {
                            block4: {
                                if (f.isDirectory()) {
                                    return true;
                                }
                                String name = f.getName();
                                int pos = name.lastIndexOf(46);
                                if (pos <= 0) break block4;
                                String ext = name.substring(pos + 1);
                                if (ext == null) break block5;
                                ext = ext.toLowerCase();
                                for (String extension : extensions) {
                                    if ("*".equals(extension)) {
                                        return true;
                                    }
                                    if (!ext.startsWith(extension)) continue;
                                    return true;
                                }
                                break block5;
                            }
                            for (String extension : extensions) {
                                if (!"*".equals(extension)) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    @Override
                    public String getDescription() {
                        return this._description;
                    }
                };
                Object object = this.token;
                synchronized (object) {
                    if (!this.fileFiltersMap.containsKey(_locale)) {
                        this.fileFiltersMap.put(_locale, filter);
                    }
                }
                return filter;
            }

            @Override
            public ReportEntryCreatorInterface getEntryCreator() throws RepositoryException {
                return new ReportEntryCreator(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public EntryInterface createEntry(MetadataInterface entryObject, OMRID omrRepositoryId, ContentInterface content) throws RepositoryException, RemoteException {
                        String type = entryObject.getType();
                        if ("Transformation".equals(type)) {
                            String role = ((Transformation)entryObject.getRepositoryEntity()).getTransformRole();
                            if ("Report".equals(role)) {
                                return _createEntry.create(entryObject, omrRepositoryId, content);
                            }
                            return null;
                        }
                        return _createEntry.create(entryObject, omrRepositoryId, content);
                    }

                    @Override
                    public EntryInterface createEntry(String entryName, String publicType, OMRID omrRepositoryId, ContentInterface content, OMIRepositoryInterface omiRepository) throws RepositoryException, RemoteException {
                        return _createEntry.create(entryName, publicType, omrRepositoryId, content, omiRepository);
                    }
                };
            }
        };
    }

    public static Collection<ReportTypeDescriptor> getAllTypeDescriptors(ServerInterface server) {
        ReportTypeDescriptor.ServerComparer sc = new ReportTypeDescriptor.ServerComparer(server);
        return reportTypeDescriptorsCollectionMap.containsKey(sc) ? reportTypeDescriptorsCollectionMap.get(sc) : null;
    }

    public static Collection<String> getAllPublicTypes(ServerInterface server) {
        ReportTypeDescriptor.ServerComparer sc = new ReportTypeDescriptor.ServerComparer(server);
        return publicTypesCollectionMap.containsKey(sc) ? publicTypesCollectionMap.get(sc) : null;
    }

    public static Collection<ReportTypeDescriptor> getTypeDescriptorsSupportingAddContent(ServerInterface server) {
        ReportTypeDescriptor.ServerComparer sc = new ReportTypeDescriptor.ServerComparer(server);
        return reportTypeDescriptorsSupportingAddContentCollectionMap.containsKey(sc) ? reportTypeDescriptorsSupportingAddContentCollectionMap.get(sc) : null;
    }

    public static Collection<String> getPublicTypesSupportingAddContent(ServerInterface server) {
        ReportTypeDescriptor.ServerComparer sc = new ReportTypeDescriptor.ServerComparer(server);
        return publicTypesSupportingAddContentCollectionMap.containsKey(sc) ? publicTypesSupportingAddContentCollectionMap.get(sc) : null;
    }

    public static Map<String, ReportTypeDescriptor> getPublicTypeToReportTypeDescriptorMap(ServerInterface server) {
        ReportTypeDescriptor.ServerComparer sc = new ReportTypeDescriptor.ServerComparer(server);
        return publicTypeToReportTypeDescriptorMapMap.containsKey(sc) ? publicTypeToReportTypeDescriptorMapMap.get(sc) : null;
    }

    private static class _CreateOMREntry
    implements _CreateEntry {
        private _CreateOMREntry() {
        }

        @Override
        public EntryInterface create(MetadataInterface entryObject, OMRID omrRepositoryId, ContentInterface content) throws RepositoryException, RemoteException {
            return new OMREntry(entryObject, omrRepositoryId, content);
        }

        @Override
        public EntryInterface create(String entryName, String publicType, OMRID omrRepositoryId, ContentInterface content, OMIRepositoryInterface omiRepository) throws RepositoryException, RemoteException {
            return new OMREntry(entryName, publicType, omrRepositoryId, content, omiRepository);
        }
    }

    private static interface _CreateEntry {
        public EntryInterface create(MetadataInterface var1, OMRID var2, ContentInterface var3) throws RepositoryException, RemoteException;

        public EntryInterface create(String var1, String var2, OMRID var3, ContentInterface var4, OMIRepositoryInterface var5) throws RepositoryException, RemoteException;
    }

    private static class _CreateOMRIQEntry
    implements _CreateEntry {
        private _CreateOMRIQEntry() {
        }

        @Override
        public EntryInterface create(MetadataInterface entryObject, OMRID omrRepositoryId, ContentInterface content) throws RepositoryException, RemoteException {
            return new OMRIQEntry(entryObject, omrRepositoryId, null);
        }

        @Override
        public EntryInterface create(String entryName, String publicType, OMRID omrRepositoryId, ContentInterface content, OMIRepositoryInterface omiRepository) throws RepositoryException, RemoteException {
            return new OMRGeneralEntryAdapter(entryName, publicType, omrRepositoryId, content, omiRepository);
        }
    }
}

