/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.io.InputStreamAdapter;
import com.sas.io.OutputStreamProxy;
import com.sas.io.RemoteInputStreamInterface;
import com.sas.io.RemoteOutputStreamInterface;
import com.sas.report.repository.AgingPolicy;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RemoteCacheSetAdapter;
import com.sas.report.repository.RemoteCacheSetInterface;
import com.sas.report.repository.RemoteDirectoryAdapter;
import com.sas.report.repository.RemoteDirectoryInterface;
import com.sas.report.repository.RemoteEntryInterface;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryNotDirectoryException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.services.information.metadata.PathUrl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class RemoteEntryAdapter
implements EntryInterface {
    private RemoteEntryInterface myRemoteEntry;

    public RemoteEntryAdapter(RemoteEntryInterface remoteEntry) {
        this.myRemoteEntry = remoteEntry;
    }

    @Override
    public PathUrl getLocationUrl() throws RepositoryException {
        try {
            return this.myRemoteEntry.getLocationUrl();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public AgingPolicy getAgingPolicy() throws RepositoryException, SecurityException {
        try {
            return this.myRemoteEntry.getAgingPolicy();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void setAgingPolicy(AgingPolicy agingPolicy) throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.myRemoteEntry.setAgingPolicy(agingPolicy);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public Iterator getKeywords() throws RepositoryException, SecurityException {
        try {
            return this.myRemoteEntry.getKeywords().iterator();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public boolean isKeyword(String keyword) throws RepositoryException, SecurityException {
        try {
            return this.myRemoteEntry.isKeyword(keyword);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void setKeywords(List keywords) throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.myRemoteEntry.setKeywords(keywords);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void setKeyword(String keyword, String keywordDescription) throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.myRemoteEntry.setKeyword(keyword, keywordDescription);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void setKeyword(String keyword) throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.myRemoteEntry.setKeyword(keyword);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void addKeywords(List keywords) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        try {
            this.myRemoteEntry.addKeywords(keywords);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void addKeyword(String keyword) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        try {
            this.myRemoteEntry.addKeyword(keyword);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void addKeyword(String keyword, String keywordDescription) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        try {
            this.myRemoteEntry.addKeyword(keyword, keywordDescription);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void removeKeyword(String keyword) throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.myRemoteEntry.removeKeyword(keyword);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void removeAllKeywords() throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.myRemoteEntry.removeAllKeywords();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public EntryInterface getGeneration(long generation) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            return new RemoteEntryAdapter(this.myRemoteEntry.getGeneration(generation));
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void age(long generationIncrement) throws RepositoryException, SecurityException {
        try {
            this.myRemoteEntry.age(generationIncrement);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public EntryInterface createEntry(String entryName) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new RepositoryNotDirectoryException(RBUtil.getStringResource("OMREntrynotDir.txt", this.getName()));
    }

    @Override
    public EntryInterface createEntry(String entryName, AgingPolicy agePolicy) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new RepositoryNotDirectoryException(RBUtil.getStringResource("OMREntrynotDir.txt", this.getName()));
    }

    @Override
    public EntryInterface createEntry(Object entryMetadataObject) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new RepositoryNotDirectoryException(RBUtil.getStringResource("OMREntrynotDir.txt", this.getName()));
    }

    @Override
    public boolean entryExists(String entryName) throws RepositoryIllegalNameException, RepositoryException, SecurityException {
        try {
            return this.myRemoteEntry.entryExists(entryName);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public EntryInterface getEntry(String entryName) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException {
        throw new RepositoryNotDirectoryException(RBUtil.getStringResource("OMREntrynotDir.txt", this.getName()));
    }

    @Override
    public EntryInterface getEntry(String entryName, long generation) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException {
        throw new RepositoryNotDirectoryException(RBUtil.getStringResource("OMREntrynotDir.txt", this.getName()));
    }

    @Override
    public void renameTo(String newContentName) throws RepositoryIllegalNameException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.myRemoteEntry.renameTo(newContentName);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void moveTo(EntryInterface entry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        if (entry == null) {
            throw new IllegalArgumentException("Null entry passed to moveTo method");
        }
        try {
            PathUrl destPathUrl = entry.getLocationUrl();
            this.myRemoteEntry.moveTo(destPathUrl);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void copyTo(EntryInterface entry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        if (entry == null) {
            throw new IllegalArgumentException("Null entry passed to copyTo method");
        }
        try {
            PathUrl destPathUrl = entry.getLocationUrl();
            this.myRemoteEntry.copyTo(destPathUrl);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    RemoteEntryInterface getRemoteEntry() {
        return this.myRemoteEntry;
    }

    @Override
    public void copyWithoutCaches(EntryInterface destEntry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        if (destEntry == null) {
            throw new IllegalArgumentException("Null entry passed to copyWithoutCaches method");
        }
        try {
            PathUrl destPathUrl = destEntry.getLocationUrl();
            this.myRemoteEntry.copyWithoutCaches(destPathUrl);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void delete(long generation) throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.myRemoteEntry.delete(generation);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public String getParent() throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            return this.myRemoteEntry.getParent();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public boolean canRead() throws SecurityException {
        try {
            return this.myRemoteEntry.canRead();
        }
        catch (Exception e) {
            throw (SecurityException)new SecurityException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public boolean canWrite() throws SecurityException {
        try {
            return this.myRemoteEntry.canWrite();
        }
        catch (Exception e) {
            throw (SecurityException)new SecurityException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.myRemoteEntry.isDirectory();
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public CacheSetInterface getCacheSetInterface() throws RepositoryException {
        try {
            RemoteCacheSetInterface rmtCacheSet = this.myRemoteEntry.getCacheSetInterface();
            return new RemoteCacheSetAdapter(rmtCacheSet);
        }
        catch (Exception e) {
            throw (SecurityException)new SecurityException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public OutputStream getOutputStream(boolean deleteCaches) throws SecurityException, RepositoryIOException {
        try {
            RemoteOutputStreamInterface rmtOptStream = this.myRemoteEntry.getOutputStream(deleteCaches);
            return new OutputStreamProxy(rmtOptStream);
        }
        catch (Exception e) {
            throw (SecurityException)new SecurityException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public String getContentLocation() throws RepositoryException {
        try {
            return this.myRemoteEntry.getContentLocation();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void delete() throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.myRemoteEntry.delete();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void deleteContent() throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.myRemoteEntry.deleteContent();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public Iterator getAttributes() throws RepositoryException, SecurityException {
        try {
            Map attributes = this.myRemoteEntry.getAttributesAsMap();
            return attributes.entrySet().iterator();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public EntryInterface getParentEntry() throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            RemoteDirectoryInterface rmtDir = this.myRemoteEntry.getParentEntry();
            return new RemoteDirectoryAdapter(rmtDir);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.myRemoteEntry.setAttribute(attributeName, attributeValue);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void setAttributes(Map attributes) throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.myRemoteEntry.setAttributes(attributes);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public Object getMetadataObject() {
        try {
            return this.myRemoteEntry.getMetadataObject();
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public String getName() {
        try {
            return this.myRemoteEntry.getName();
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public InputStream getInputStream() throws RepositoryIOException, SecurityException {
        try {
            RemoteInputStreamInterface ris = this.myRemoteEntry.getInputStream();
            return new InputStreamAdapter(ris);
        }
        catch (RemoteException e) {
            throw new RepositoryIOException(e, e.getLocalizedMessage());
        }
    }

    @Override
    public OutputStream getOutputStream() throws SecurityException, RepositoryIOException {
        try {
            RemoteOutputStreamInterface ros = this.myRemoteEntry.getOutputStream();
            return new OutputStreamProxy(ros);
        }
        catch (RemoteException e) {
            throw new RepositoryIOException(e, e.getLocalizedMessage());
        }
    }

    @Override
    public Object getAttribute(String attribName) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            return this.myRemoteEntry.getAttribute(attribName);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public int read(InputStream stream, byte[] data) throws RepositoryIOException {
        try {
            return stream.read(data);
        }
        catch (IOException e) {
            throw (RepositoryIOException)((Object)new RepositoryIOException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public int write(OutputStream stream, byte[] data, int len) throws RepositoryIOException {
        try {
            stream.write(data, 0, len);
        }
        catch (IOException e) {
            throw new RepositoryIOException(e, e.getMessage());
        }
        return len;
    }

    @Override
    public void close(OutputStream stream) throws RepositoryIOException {
        try {
            stream.close();
        }
        catch (IOException e) {
            throw new RepositoryIOException(e, e.getMessage());
        }
    }

    @Override
    public boolean isEmpty() throws RepositoryException {
        try {
            return this.myRemoteEntry.isEmpty();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public long getSizeOfContent() throws UnsupportedOperationException, RepositoryException {
        try {
            return this.myRemoteEntry.getSizeOfContent();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public String getApplicationData(String applicationDataName) throws RepositoryException {
        try {
            return this.myRemoteEntry.getApplicationData(applicationDataName);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void setApplicationData(String applicationDataName, String value) throws RepositoryException {
        try {
            this.myRemoteEntry.setApplicationData(applicationDataName, value);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void setApplicationData(String applicationDataName, String value, boolean transientData, boolean updateTimestamps) throws RepositoryException {
        try {
            this.myRemoteEntry.setApplicationData(applicationDataName, value, transientData, updateTimestamps);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void refresh() {
        try {
            this.myRemoteEntry.refresh();
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
    }
}

