/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.AgingPolicy;
import com.sas.report.repository.RemoteEntryInterface;
import com.sas.report.repository.RepositoryCreateException;
import com.sas.report.repository.RepositoryDeleteException;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryFilter;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryMetadataFilter;
import com.sas.report.repository.RepositoryNotDirectoryException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.SortOrder;
import com.sas.services.information.metadata.PathUrl;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

interface RemoteDirectoryInterface
extends Remote {
    public RemoteDirectoryInterface getDirectory(String var1) throws RemoteException, RepositoryNotFoundException, RepositoryException, SecurityException;

    public RemoteDirectoryInterface createDirectory(String var1) throws RemoteException, RepositoryCreateException, RepositoryIllegalNameException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException;

    public void delete(RepositoryMetadataFilter var1) throws RemoteException, RepositoryDeleteException, RepositoryException;

    public String[] list() throws RemoteException, RepositoryException, SecurityException;

    public String[] list(RepositoryFilter var1) throws RemoteException, RepositoryException, SecurityException;

    public List listDirs(RepositoryFilter var1, SortOrder var2) throws RemoteException, RepositoryException, SecurityException;

    public List listFiles(RepositoryFilter var1, SortOrder var2) throws RemoteException, RepositoryException, SecurityException;

    public RemoteDirectoryInterface ensurePath(PathUrl var1) throws RemoteException, RepositoryException;

    public PathUrl getLocationUrl() throws RemoteException, RepositoryException;

    public RemoteEntryInterface createEntry(String var1) throws RemoteException, RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException;

    public RemoteEntryInterface createEntry(String var1, AgingPolicy var2) throws RemoteException, RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException;

    public RemoteEntryInterface createEntry(Object var1) throws RemoteException, RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException;

    public boolean entryExists(String var1) throws RemoteException, RepositoryIllegalNameException, RepositoryException, SecurityException;

    public RemoteEntryInterface getEntry(String var1) throws RemoteException, RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException;

    public void renameTo(String var1) throws RemoteException, RepositoryIllegalNameException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException;

    public void moveTo(RemoteDirectoryInterface var1) throws RemoteException, RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException;

    public void copyTo(RemoteDirectoryInterface var1) throws RemoteException, RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException;

    public String getParent() throws RemoteException, RepositoryNotFoundException, RepositoryException, SecurityException;

    public boolean canRead() throws RemoteException, SecurityException;

    public boolean canWrite() throws RemoteException, SecurityException;

    public boolean isDirectory() throws RemoteException;

    public String getContentLocation() throws RemoteException, RepositoryException;

    public void delete() throws RemoteException, RepositoryLockedException, RepositoryException, SecurityException;

    public Map getAttributes() throws RemoteException, RepositoryException, SecurityException;

    public RemoteDirectoryInterface getParentEntry() throws RemoteException, RepositoryNotFoundException, RepositoryException, SecurityException;

    public void setAttribute(String var1, Object var2) throws RemoteException, RepositoryLockedException, RepositoryException, SecurityException;

    public void setAttributes(Map var1) throws RemoteException, RepositoryLockedException, RepositoryException, SecurityException;

    public Object getMetadataObject() throws RemoteException;

    public String getName() throws RemoteException;

    public Object getAttribute(String var1) throws RemoteException, RepositoryNotFoundException, RepositoryException, SecurityException;

    public boolean isEmpty() throws RemoteException, RepositoryException;

    public void refresh() throws RemoteException;
}

