/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.CacheFilter;
import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.RemoteCacheAdapter;
import com.sas.report.repository.RemoteCacheInterface;
import com.sas.report.repository.RemoteCacheItemAdapter;
import com.sas.report.repository.RemoteCacheItemInterface;
import com.sas.report.repository.RemoteCacheSetInterface;
import com.sas.report.repository.RemoteEntryAdapter;
import com.sas.report.repository.RemoteEntryInterface;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class RemoteCacheSetAdapter
implements CacheSetInterface {
    private RemoteCacheSetInterface myRemoteCacheSet;

    public RemoteCacheSetAdapter(RemoteCacheSetInterface remoteCacheSet) {
        this.myRemoteCacheSet = remoteCacheSet;
    }

    @Override
    public CacheInterface create(String cacheName, boolean transientCache) throws RepositoryIllegalNameException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException {
        try {
            RemoteCacheInterface rCache = this.myRemoteCacheSet.create(cacheName, transientCache);
            return new RemoteCacheAdapter(rCache);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public CacheInterface create(String cacheName) throws RepositoryIllegalNameException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException {
        try {
            RemoteCacheInterface rCache = this.myRemoteCacheSet.create(cacheName);
            return new RemoteCacheAdapter(rCache);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public List list(CacheFilter filter) throws RepositoryException {
        try {
            List remoteCaches = this.myRemoteCacheSet.list(filter);
            ArrayList<RemoteCacheAdapter> adaptedCaches = new ArrayList<RemoteCacheAdapter>(remoteCaches.size());
            for (RemoteCacheInterface remoteCache : remoteCaches) {
                adaptedCaches.add(new RemoteCacheAdapter(remoteCache));
            }
            return adaptedCaches;
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public List listCacheItems(CacheFilter filter) throws RepositoryException {
        try {
            List remoteItems = this.myRemoteCacheSet.listCacheItems(filter);
            ArrayList<RemoteCacheItemAdapter> adaptedItems = new ArrayList<RemoteCacheItemAdapter>(remoteItems.size());
            for (RemoteCacheItemInterface remoteItem : remoteItems) {
                adaptedItems.add(new RemoteCacheItemAdapter(remoteItem));
            }
            return adaptedItems;
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public boolean exists(String cacheName) throws RepositoryException {
        try {
            return this.myRemoteCacheSet.exists(cacheName);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public CacheInterface get(String cacheName) throws RepositoryException, RepositoryNotFoundException {
        try {
            RemoteCacheInterface rCache = this.myRemoteCacheSet.get(cacheName);
            return new RemoteCacheAdapter(rCache);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void deleteAll() throws RepositoryException {
        try {
            this.myRemoteCacheSet.deleteAll();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void deleteTransient() throws RepositoryException {
        try {
            this.myRemoteCacheSet.deleteTransient();
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public EntryInterface getEntryInterface() {
        try {
            RemoteEntryInterface rEntry = this.myRemoteCacheSet.getEntryInterface();
            return new RemoteEntryAdapter(rEntry);
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public int getMaxNumberOfVersions() {
        try {
            return this.myRemoteCacheSet.getMaxNumberOfVersions();
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public void setMaxNumberOfVersions(int maxVersionsToKeep) {
        try {
            this.myRemoteCacheSet.setMaxNumberOfVersions(maxVersionsToKeep);
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public int archivePDFs(String srcCacheName, Date archiveDate) {
        try {
            return this.myRemoteCacheSet.archivePDFs(srcCacheName, archiveDate);
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
    }
}

