/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.CacheFilter;
import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.RemoteCacheInterface;
import com.sas.report.repository.RemoteCacheItemAdapter;
import com.sas.report.repository.RemoteCacheItemInterface;
import com.sas.report.repository.RemoteEntryAdapter;
import com.sas.report.repository.RemoteEntryInterface;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIllegalNameException;
import java.util.ArrayList;
import java.util.List;

class RemoteCacheAdapter
implements CacheInterface {
    private RemoteCacheInterface myRemoteCache;

    public RemoteCacheAdapter(RemoteCacheInterface remoteCache) {
        this.myRemoteCache = remoteCache;
    }

    @Override
    public String getName() throws RepositoryException {
        try {
            return this.myRemoteCache.getName();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public CacheItemInterface create(String cacheEntryName) throws RepositoryIllegalNameException, RepositoryDuplicateNameException, RepositoryException {
        try {
            RemoteCacheItemInterface rItem = this.myRemoteCache.create(cacheEntryName);
            return new RemoteCacheItemAdapter(rItem);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public CacheItemInterface get(String cacheEntryName) throws RepositoryException {
        try {
            RemoteCacheItemInterface rItem = this.myRemoteCache.get(cacheEntryName);
            return new RemoteCacheItemAdapter(rItem);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public List list(CacheFilter filter) throws RepositoryException {
        try {
            List remoteItems = this.myRemoteCache.list(filter);
            ArrayList<RemoteCacheItemAdapter> adaptedItems = new ArrayList<RemoteCacheItemAdapter>(remoteItems.size());
            for (RemoteCacheItemInterface remoteItem : remoteItems) {
                adaptedItems.add(new RemoteCacheItemAdapter(remoteItem));
            }
            return adaptedItems;
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void delete() throws RepositoryException {
        try {
            this.myRemoteCache.delete();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public boolean exists(String cacheEntryName) throws RepositoryException {
        try {
            return this.myRemoteCache.exists(cacheEntryName);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public EntryInterface getParentEntry() throws RepositoryException {
        try {
            RemoteEntryInterface rEntry = this.myRemoteCache.getParentEntry();
            return new RemoteEntryAdapter(rEntry);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void createTransactionStart() throws IllegalStateException {
        try {
            this.myRemoteCache.createTransactionStart();
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public void createTransactionEnd() throws IllegalStateException, RepositoryException {
        try {
            this.myRemoteCache.createTransactionEnd();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }
}

