/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.impl.ClassifierMapImpl;
import com.sas.metadata.remote.impl.ClassifierMapImpl_Stub;
import com.sas.report.repository.ContentException;
import com.sas.report.repository.ContentFactory;
import com.sas.report.repository.ContentFileException;
import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.ContentNameNotFoundException;
import com.sas.report.repository.Entry;
import com.sas.report.repository.OMRDirectory;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.ProjectInterface;
import com.sas.report.repository.RB;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RepositoryCreateException;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryInputStream;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.RepositoryOutputStream;
import com.sas.report.repository.SmartObjectHelper;
import com.sas.report.repository.UtilReportReposService;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Project
extends Metadata
implements ProjectInterface {
    private static final Logger log = LogManager.getLogger((String)Project.class.getName());
    private RepositoryInputStream myEntryInputStream;
    private RepositoryOutputStream myEntryOutputStream;
    private ContentInterface myContent;
    private SmartObjectHelper myHelper;
    private PathUrl myCachedPathUrl;
    private String myCachedPathUrlStr;

    public Project() throws RemoteException {
        super(Project.class);
    }

    public Project(ClassifierMap o) throws RemoteException {
        super((Object)o, Project.class);
    }

    public Project(ClassifierMapImpl o) throws RemoteException {
        super((Object)o, Project.class);
    }

    public Project(ClassifierMapImpl_Stub o) throws RemoteException {
        super((Object)o, Project.class);
    }

    public void setRepository(RepositoryInterface repos) throws IllegalStateException, RemoteException {
        this.myHelper = new SmartObjectHelper(repos);
        super.setRepository(repos);
    }

    @Override
    public InputStream getInputStream() throws RemoteException, ServiceException, SecurityException {
        InputStream iStream = this.getIStream();
        if (iStream == null) {
            if (this.myEntryInputStream != null) {
                try {
                    this.myEntryInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.myEntryInputStream = null;
            }
            iStream = this.getIStream();
        }
        return iStream;
    }

    private InputStream getIStream() throws ServiceException, SecurityException, RemoteException {
        String name = this.getName();
        if (this.getContent() == null) {
            throw new ServiceException(RB.getStringResource("ProjectUnableToOpen.fmt.txt", name));
        }
        if (this.myEntryInputStream == null || this.myEntryInputStream.isClosed()) {
            try {
                this.myEntryInputStream = new RepositoryInputStream(this.getContent().get(name));
            }
            catch (ContentFileException e) {
                throw new ServiceException((Throwable)((Object)e), e.getMessage());
            }
            catch (ContentNameNotFoundException e) {
                throw new ServiceException((Throwable)((Object)e), e.getMessage());
            }
            catch (ContentException e) {
                throw new ServiceException((Throwable)((Object)e), e.getMessage());
            }
        }
        if (this.myEntryInputStream == null) {
            throw new ServiceException(RBUtil.getStringResource("ProjectUnableToOpen.fmt.txt", name));
        }
        return this.myEntryInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws RemoteException, ServiceException, SecurityException {
        if (this.getContent() != null && (this.myEntryOutputStream == null || this.myEntryOutputStream.isClosed())) {
            String name = this.getName();
            try {
                PathUrl pathUrl = this.getPathUrl();
                if (pathUrl == null) {
                    throw new ServiceException(RB.getStringResource("ProjectNullPathUrl.fmt.txt", name));
                }
                this.myEntryOutputStream = new RepositoryOutputStream(this.getContent().write(name));
            }
            catch (ContentFileException ex) {
                throw new ServiceException((Throwable)((Object)ex), ex.getMessage());
            }
            catch (ContentException ex) {
                throw new ServiceException((Throwable)((Object)ex), ex.getMessage());
            }
        }
        return this.myEntryOutputStream;
    }

    public Object newServiceObject() throws ServiceException, RemoteException {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ContentInterface getContent() throws IllegalStateException, RemoteException, ServiceException {
        if (this.myContent != null) return this.myContent;
        if (UtilReportReposService.credentialsAccessible(this)) {
            this.myHelper.initRepository(this._repositoryFlag, this._repositoryObject, this.getName());
            OMRID omrid = this.myHelper.getOMRID();
            try {
                List parentDirList = this.getParents();
                if (parentDirList.size() <= 0) {
                    String name = this.getName();
                    if (name != null) throw new IllegalStateException(RB.getStringResource("ProjectNoParent.fmt.txt", name));
                    name = "(null)";
                    throw new IllegalStateException(RB.getStringResource("ProjectNoParent.fmt.txt", name));
                }
                FolderInterface parentFolder = (FolderInterface)parentDirList.get(0);
                PathUrl parentPathUrl = parentFolder.getPathUrl();
                String contentLocation = omrid.resolveName(parentPathUrl);
                if (contentLocation == null || contentLocation.length() == 0) return this.myContent;
                this.myContent = ContentFactory.create(omrid, this.getPathUrl(), contentLocation);
                return this.myContent;
            }
            catch (ContentException e) {
                throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause((Throwable)((Object)e));
            }
            catch (RepositoryException e) {
                throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause((Throwable)((Object)e));
            }
            catch (ServiceException e) {
                throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
            }
        } else {
            this.myContent = UtilReportReposService.getProjectContentServiceAdapter(Project.getInformationService(), this);
        }
        return this.myContent;
    }

    public void delete() throws ServiceException, RemoteException {
        try {
            String location = this.getLocationUrl().getName();
            this.getContent();
            super.delete();
            this.deleteContent(location);
        }
        catch (RepositoryLockedException ex) {
            throw new RemoteException();
        }
        catch (RepositoryException ex) {
            throw new RemoteException();
        }
    }

    public void deleteContent() throws RepositoryLockedException, RepositoryException {
        try {
            String location = this.getLocationUrl().getName();
            this.deleteContent(location);
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    private void deleteContent(String location) throws RepositoryLockedException, RepositoryException, ServiceException, RemoteException {
        if (this.myEntryInputStream != null && this.myEntryInputStream.isOpen()) {
            throw new RepositoryLockedException(RB.getStringResource("ProjectOpenForReading.txt"));
        }
        if (this.myEntryOutputStream != null && this.myEntryOutputStream.isOpen()) {
            throw new RepositoryLockedException(RB.getStringResource("ProjectOpenForWriting.txt"));
        }
        if (this.getContent() != null && location != null) {
            try {
                this.getContent().delete(location);
            }
            catch (ContentNameNotFoundException contentNameNotFoundException) {
            }
            catch (ContentFileException e) {
                throw new RepositoryException((Throwable)((Object)e), e.getMessage());
            }
            catch (ContentException e) {
                throw new RepositoryException((Throwable)((Object)e), e.getMessage());
            }
        }
    }

    void invalidatePathUrl() {
        this.myCachedPathUrl = null;
        this.myCachedPathUrlStr = null;
    }

    public PathUrl getLocationUrl() throws RepositoryException {
        if (this.myCachedPathUrl == null) {
            try {
                this.myCachedPathUrl = this.getPathUrl();
                if (this.myCachedPathUrl == null) {
                    String name = this.getName();
                    if (name == null) {
                        name = "(null)";
                    }
                    throw new RepositoryNotFoundException(RB.getStringResource("ProjectNullPathUrl.fmt.txt", name));
                }
            }
            catch (ServiceException e) {
                throw new RepositoryException(e, e.getMessage());
            }
            catch (RemoteException e) {
                throw new RepositoryException(e, e.getMessage());
            }
        }
        return this.myCachedPathUrl;
    }

    protected String getLocation() throws RepositoryException {
        if (this.myCachedPathUrlStr == null) {
            this.myCachedPathUrlStr = this.getLocationUrl().toString();
        }
        return this.myCachedPathUrlStr;
    }

    public void rename(String newName) throws RepositoryIllegalNameException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        Entry.validateName(newName);
        if (this.checkDuplicateName(newName)) {
            throw new RepositoryDuplicateNameException(RB.getStringResource("ProjectExists.fmt.txt", newName));
        }
        try {
            if (!this.canWrite()) {
                throw new RepositoryCreateException(RB.getStringResource("ProjectNoWriteMetadata.txt"));
            }
        }
        catch (SecurityException e) {
            throw (RepositoryCreateException)((Object)new RepositoryCreateException(e.getMessage()).initCause(e));
        }
        try {
            String oldName = this.getName();
            this.setName(newName);
            this.invalidatePathUrl();
            boolean contentRenamed = false;
            if (this.getContent() != null && oldName.length() > 0 && !oldName.equals(newName)) {
                try {
                    if (this.getContent().exists(oldName)) {
                        this.getContent().renameTo(oldName, newName);
                        contentRenamed = true;
                    }
                }
                catch (ContentException ee) {
                    throw new RepositoryException((Throwable)((Object)ee), ee.getMessage());
                }
            }
            try {
                this.updateMetadataAll();
            }
            catch (RepositoryException e) {
                if (contentRenamed) {
                    try {
                        this.getContent().renameTo(newName, oldName);
                    }
                    catch (ContentException ee) {
                        throw new RepositoryException((Throwable)((Object)ee), ee.getMessage());
                    }
                }
                this.setName(oldName);
                this.invalidatePathUrl();
                throw e;
            }
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    private boolean checkDuplicateName(String name) throws RepositoryException {
        try {
            FolderInterface parentFolder = this.getParentFolder();
            List subtrees = parentFolder.getSubfolders();
            for (MetadataInterface tree : subtrees) {
                if (!name.equals(tree.getName())) continue;
                return true;
            }
            List members = parentFolder.getItems();
            for (MetadataInterface member : members) {
                if (!name.equals(member.getName())) continue;
                return true;
            }
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        return false;
    }

    public FolderInterface getParentFolder() throws RepositoryNotFoundException, RepositoryException, SecurityException {
        FolderInterface parentFolder = null;
        try {
            List parentDirList = this.getParents();
            if (parentDirList.size() <= 0) {
                String name = this.getName();
                if (name == null) {
                    name = "(null)";
                }
                throw new IllegalStateException(RB.getStringResource("ProjectNoParent.fmt.txt", name));
            }
            parentFolder = (FolderInterface)parentDirList.get(0);
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        return parentFolder;
    }

    public boolean canWrite() throws SecurityException {
        try {
            boolean retVal = this.isAuthorized("WriteMemberMetadata");
            return retVal;
        }
        catch (ServiceException e) {
            throw (SecurityException)new SecurityException(e.getMessage()).initCause(e);
        }
        catch (RemoteException e) {
            throw (SecurityException)new SecurityException(e.getMessage()).initCause(e);
        }
    }

    private void updateMetadataAll() throws RepositoryException {
        try {
            this.update();
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public List getDependencies() throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> objs = new ArrayList<MetadataInterface>();
        try {
            ClassifierMap map = (ClassifierMap)this._repositoryObject;
            AssociationList assoc = map.getTransformationSources();
            for (Root obj : assoc) {
                MetadataInterface mi = this._repository.factoryProcess((Object)obj);
                objs.add(mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException((Throwable)mdex, mdex.getMessage());
        }
        return objs;
    }

    public void moveTo(FolderInterface folder) throws ServiceException, RemoteException {
        Object object;
        if (null == folder) {
            return;
        }
        if (null == this.myContent) {
            this.getContent();
        }
        if ((object = folder.newServiceObject()) instanceof OMRDirectory) {
            OMRDirectory directory = (OMRDirectory)object;
            try {
                super.moveTo(folder);
                ContentInterface destination = directory.getContent(true);
                this.myContent.moveTo(this.getName(), destination, this.getName());
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
        }
    }
}

