/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.RB;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class OperationResult
implements Serializable {
    static final long serialVersionUID = -1229077403561576110L;
    public static final Code EXCEPTION = new Code(0, "EXCEPTION");
    public static final Code FILTER_DENY = new Code(1, "FILTER_DENY");
    public static final Code NOT_EMPTY = new Code(2, "NOT_EMPTY");
    private String myPathUrlStr;
    private Code myCode;
    private Exception myException;

    public OperationResult(String pathUrlStr, Code code, Exception exception) {
        if (pathUrlStr == null) {
            throw new IllegalArgumentException(RB.getStringResource("OperationResultNullUrl.txt"));
        }
        if (code == null) {
            throw new IllegalArgumentException(RB.getStringResource("OperationResultNullCode.txt"));
        }
        this.myPathUrlStr = pathUrlStr;
        this.myCode = code;
        this.myException = exception;
    }

    public OperationResult(String pathUrlStr, Code code) {
        this(pathUrlStr, code, null);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.myPathUrlStr);
        buf.append(" [");
        buf.append(this.myCode);
        if (this.myCode == EXCEPTION && this.myException != null) {
            buf.append(": ");
            buf.append(this.myException);
        }
        buf.append("]");
        return buf.toString();
    }

    public String getUrl() {
        return this.myPathUrlStr;
    }

    public Code getCode() {
        return this.myCode;
    }

    public Exception getException() {
        return this.myException;
    }

    public static final class Code
    implements Serializable {
        static final long serialVersionUID = 5958213651418053237L;
        private static final Code[] PRIVATE_VALUES = new Code[]{EXCEPTION, FILTER_DENY, NOT_EMPTY};
        private final int myIndex;
        private final String myValue;

        private Code(int index, String value) {
            this.myIndex = index;
            this.myValue = value;
        }

        public String toString() {
            return this.myValue;
        }

        private Object readResolve() throws ObjectStreamException {
            Code retVal = PRIVATE_VALUES[this.myIndex];
            return retVal;
        }
    }
}

