/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.metadata.remote.SoftwareComponent;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.OMRRepository;
import com.sas.report.repository.PFServices;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.Repository;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryMessager;
import com.sas.report.repository.RepositoryService;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class OMRRepositoryService
extends RepositoryService {
    List repositories = null;
    List reportRepositories = null;
    String protocol = null;
    String IPName = null;
    String port = null;
    private static final Logger log = LogManager.getLogger(OMRRepositoryService.class);
    private PFServices pfs = null;
    private RepositoryMessager rm = null;
    private static final String METASERVER = "METASERVER";

    public OMRRepositoryService(PFServices pfs) throws RepositoryException, RemoteException, SecurityException {
        this.pfs = pfs;
        this.userID = pfs.getUserName();
        if (this.userID == null) {
            this.userID = "";
        }
    }

    @Override
    public void connect(String xmlStartupFile) throws RepositoryIOException, RepositoryException {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public List getRepositories() throws RepositoryException {
        if (this.repositories == null) {
            List omiRep = null;
            try {
                omiRep = this.pfs.getUserContextRepositories();
            }
            catch (RemoteException e) {
                throw new RepositoryException(e, e.getMessage());
            }
            ArrayList<OMRRepository> reps = new ArrayList<OMRRepository>(3);
            try {
                ArrayList<OMIRepositoryInterface> repsList = new ArrayList<OMIRepositoryInterface>();
                for (ServerInterface si : this.pfs.getUserContext().getServers()) {
                    RootFolderInterface rootFolder = si.getRootFolder();
                    for (FolderInterface folder : rootFolder.getSubfolders()) {
                        RepositoryInterface ri = folder.getRepository();
                        if (repsList.contains(ri) || !(ri instanceof OMIRepositoryInterface)) continue;
                        OMIRepositoryInterface omiri = (OMIRepositoryInterface)ri;
                        repsList.add(omiri);
                        OMRID omrID = new OMRID(omiri, this.pfs);
                        OMRRepository rr = new OMRRepository(omrID);
                        rr.setName(omiri.getISName());
                        reps.add(rr);
                    }
                }
            }
            catch (ServiceException e) {
                throw new RepositoryException(e, e.getMessage());
            }
            catch (RemoteException e) {
                throw new RepositoryException(e, e.getMessage());
            }
            this.repositories = reps;
        }
        return this.repositories;
    }

    @Override
    public List getReportRepositories() throws RepositoryException {
        if (this.reportRepositories == null) {
            ArrayList<Repository> rrList = new ArrayList<Repository>(3);
            List l = this.getRepositories();
            for (Repository r : l) {
                if (!r.hasReportRepositoryService()) continue;
                rrList.add(r);
            }
            this.reportRepositories = rrList;
        }
        return this.reportRepositories;
    }

    @Override
    public Repository getRepository(String repositoryName) throws RepositoryException {
        String rName = null;
        if (repositoryName == null || repositoryName.trim().length() == 0) {
            return null;
        }
        rName = repositoryName.trim();
        try {
            this.pfs.verifyRepository(repositoryName);
        }
        catch (RepositoryException e) {
            log.error(RBUtil.getStringResource("OMRRepositoryServiceInvalidUser.txt"));
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        for (Repository r : this.getRepositories()) {
            if (!rName.equals(r.getName())) continue;
            return r;
        }
        return null;
    }

    @Override
    public Repository getReportRepository(String repositoryName) throws RepositoryException {
        if (repositoryName == null) {
            return null;
        }
        if ((repositoryName = repositoryName.trim()).length() == 0) {
            return null;
        }
        try {
            this.pfs.verifyRepository(repositoryName);
        }
        catch (RepositoryException e) {
            log.error(RBUtil.getStringResource("OMRRepositoryServiceInvalidUser.txt"));
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        for (Repository r : this.getReportRepositories()) {
            String altRepositoryName = "METASERVER." + repositoryName;
            if (!repositoryName.equals(r.getName()) && !altRepositoryName.equals(r.getName())) continue;
            return r;
        }
        return null;
    }

    @Override
    public Repository getReportRepository(PathUrl pathUrl) throws RepositoryException {
        if (pathUrl == null) {
            return null;
        }
        if (pathUrl.getServer().length() == 0) {
            return null;
        }
        String _isName = this.getISName(pathUrl);
        if (_isName == null) {
            return null;
        }
        try {
            this.pfs.verifyRepository(_isName);
        }
        catch (RepositoryException e) {
            log.error(RBUtil.getStringResource("OMRRepositoryServiceInvalidUser.txt"));
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        for (Repository r : this.getReportRepositories()) {
            if (!_isName.equals(r.getName())) continue;
            return r;
        }
        return null;
    }

    private String getISName(PathUrl pathUrl) {
        try {
            ServerInterface si = this.pfs.getUserContext().getServer(pathUrl.getServer());
            PathUrl _pathUrl = (PathUrl)pathUrl.clone();
            _pathUrl.setPath(null);
            _pathUrl.setType(null);
            _pathUrl.setName(null);
            MetadataInterface md = si.getObjectByPath(_pathUrl);
            if (md == null) {
                return null;
            }
            return md.getRepository().getISName();
        }
        catch (ServiceException e) {
            return null;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Override
    public Repository setupRepository(String repositoryName) throws RepositoryException {
        throw new RepositoryException("setupRepository() not supported.  Please use SAS Management Console.");
    }

    private SoftwareComponent addSoftwareComponent(OMRID repositoryId) throws RepositoryException {
        throw new RepositoryException("setupRepository() not supported.  Please use SAS Management Console.");
    }
}

