/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.impl.TransformationImpl;
import com.sas.metadata.remote.impl.TransformationImpl_Stub;
import com.sas.report.repository.AdapterFactory;
import com.sas.report.repository.ContentException;
import com.sas.report.repository.ContentFactory;
import com.sas.report.repository.ContentHelper;
import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.EntryInstantiatorInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.GeneralEntryInterface;
import com.sas.report.repository.OMRDirectory;
import com.sas.report.repository.OMREntry;
import com.sas.report.repository.OMRGeneralEntry;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RemoteDirectoryInterface;
import com.sas.report.repository.RemoteEntry;
import com.sas.report.repository.ReportEntryInterface;
import com.sas.report.repository.ReportManagementCache;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.SmartObjectHelper;
import com.sas.report.repository.UtilReportReposService;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.ContentImportStatusInterface;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.util.UsageVersion;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OMRReportEntry
extends Metadata
implements ReportEntryInterface,
LocalizableProperties,
ContentImportStatusInterface {
    private static final String OBJECT_TYPE = "Report";
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private EntryInterface myReportEntry;
    private SmartObjectHelper myHelper;
    private boolean _contentAvailable;

    public OMRReportEntry() throws RemoteException {
    }

    public OMRReportEntry(Transformation o) throws RemoteException {
        super((Object)o);
        this.setCompatibility(this.getOldestVersion(), this.getCurrentVersion());
        String roleType = o.getTransformRole();
        if (roleType.equals(this.getType()) || this.getType().startsWith(roleType + ".") || this instanceof GeneralEntryInterface) {
            return;
        }
        throw new RuntimeException(RBUtil.getStringResource("OMRReportEntryunableToCreate.txt", o.toString()));
    }

    public OMRReportEntry(TransformationImpl o) throws RemoteException {
        super((Object)o);
        this.setCompatibility(this.getOldestVersion(), this.getCurrentVersion());
        String roleType = o.getTransformRole();
        if (roleType.equals(this.getType()) || this.getType().startsWith(roleType + ".") || this instanceof GeneralEntryInterface) {
            return;
        }
        throw new RuntimeException(RBUtil.getStringResource("OMRReportEntryunableToCreate.txt", this.getName()));
    }

    public OMRReportEntry(TransformationImpl_Stub o) throws RemoteException {
        super((Object)o);
        this.setCompatibility(this.getOldestVersion(), this.getCurrentVersion());
        String roleType = o.getTransformRole();
        if (roleType.equals(this.getType()) || this.getType().startsWith(roleType + ".") || this instanceof GeneralEntryInterface) {
            return;
        }
        throw new RuntimeException(RBUtil.getStringResource("OMRReportEntryunableToCreate.txt", this.getName()));
    }

    public String getType() throws RemoteException {
        PrimaryType cr = (PrimaryType)this.getRepositoryEntity();
        if (cr == null) {
            String type = OBJECT_TYPE;
            return type;
        }
        return cr.getPublicType();
    }

    protected UsageVersion getOldestVersion() {
        return OLDEST_VERSION;
    }

    protected UsageVersion getCurrentVersion() {
        return CURRENT_VERSION;
    }

    public void setRepository(RepositoryInterface repos) throws IllegalStateException, RemoteException {
        this.myHelper = new SmartObjectHelper(repos);
        super.setRepository(repos);
    }

    public void delete() throws ServiceException, RemoteException {
        EntryInterface entry = this.getRepositoryObject();
        try {
            entry.delete();
        }
        catch (RepositoryLockedException e) {
            throw new ServiceException((Throwable)((Object)e), e.getMessage());
        }
        catch (RepositoryException e) {
            throw new ServiceException((Throwable)((Object)e), e.getMessage());
        }
    }

    public Date getModifyDate() throws ServiceException, RemoteException {
        try {
            this._omrModifyDate = null;
            Date d = super.getModifyDate();
            return d;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e, e.getMessage());
        }
    }

    Date getModifyDateFromParent() throws ServiceException, RemoteException {
        return super.getModifyDate();
    }

    public Date getCreateDate() throws ServiceException, RemoteException {
        try {
            Date d = super.getCreateDate();
            return d;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e, e.getMessage());
        }
    }

    Date getCreateDateFromParent() throws ServiceException, RemoteException {
        return super.getModifyDate();
    }

    public Object newServiceObject() throws ServiceException, RemoteException {
        EntryInterface entry = this.getRepositoryObject();
        if (AdapterFactory.isCallerRemote() && entry instanceof OMREntry) {
            return new RemoteEntry(entry);
        }
        return entry;
    }

    public Object newServiceObject(EntryInstantiatorInterface ei) throws ServiceException, RemoteException {
        EntryInterface entry = this.getRepositoryObject_p(ei);
        if (AdapterFactory.isCallerRemote() && entry instanceof OMREntry) {
            return new RemoteEntry(entry);
        }
        return entry;
    }

    private EntryInterface getRepositoryObject() throws IllegalStateException, RemoteException, ServiceException {
        this.getRepositoryObject_p(null);
        return this.myReportEntry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EntryInterface getRepositoryObject_p(EntryInstantiatorInterface ei) throws IllegalStateException, RemoteException, ServiceException {
        if (this.myReportEntry != null) return this.myReportEntry;
        if (UtilReportReposService.credentialsAccessible(this)) {
            this.myHelper.initRepository(this._repositoryFlag, this._repositoryObject, this.getName());
            OMRID omrid = this.myHelper.getOMRID();
            String className = "com.sas.report.repository.OMRID";
            try {
                ReportManagementCache cache = omrid.getCache();
                PathUrl pathUrl = this.getPathUrl();
                if (pathUrl != null) {
                    String pathUrlStr = pathUrl.toString();
                    this.myReportEntry = (OMREntry)cache.get(pathUrlStr);
                }
                if (this.myReportEntry != null) return this.myReportEntry;
                List parentDirList = this.getParents();
                if (parentDirList.size() <= 0) {
                    String name = this.getName();
                    if (name != null) throw new IllegalStateException(RBUtil.getStringResource("OMRReportEntrynoParent.txt", name));
                    name = "(null)";
                    throw new IllegalStateException(RBUtil.getStringResource("OMRReportEntrynoParent.txt", name));
                }
                FolderInterface parentFolder = (FolderInterface)parentDirList.get(0);
                PathUrl parentPathUrl = parentFolder.getPathUrl();
                String parentURL = parentPathUrl.toString();
                OMRDirectory parentDir = (OMRDirectory)cache.get(parentURL);
                if (parentDir == null) {
                    parentDir = new OMRDirectory(parentFolder, omrid);
                    cache.put(parentURL, parentDir);
                }
                ContentInterface content = null;
                String contentLocation = omrid.resolveName(parentPathUrl);
                if (contentLocation != null && contentLocation.length() != 0) {
                    OMRID.ContentInfo contentInfo = omrid.getContentInfo(this.getPathUrl());
                    String userId = contentInfo.getUserId();
                    String pw = contentInfo.getPassword();
                    content = ContentFactory.create(omrid, contentLocation, userId, pw);
                }
                if (ei == null) {
                    boolean isUnknownType = false;
                    try {
                        Class _getServiceObjectClass;
                        Constructor _getServiceObjectConstructor;
                        Method _getServiceObjectClassMethod = this.getClass().getDeclaredMethod("getServiceObjectClass", new Class[0]);
                        if (_getServiceObjectClassMethod != null && (_getServiceObjectConstructor = (_getServiceObjectClass = (Class)_getServiceObjectClassMethod.invoke((Object)this, (Object[])new Class[0])).getConstructor(OMRID.class)) != null) {
                            String omridClassName = omrid.getClass().getName();
                            if (!className.equals(omridClassName)) throw new IllegalStateException();
                            EntryInstantiatorInterface eii = (EntryInstantiatorInterface)_getServiceObjectConstructor.newInstance(omrid);
                            if (eii != null) {
                                this.myReportEntry = eii.get(null, this, omrid, content);
                                isUnknownType = true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!isUnknownType) {
                        this.myReportEntry = new OMREntry(this, omrid, content);
                    }
                    String string = ((OMREntry)this.myReportEntry).getLocation();
                } else {
                    this.myReportEntry = ei.get(null, this, omrid, content);
                    String isUnknownType = ((OMRGeneralEntry)this.myReportEntry).getLocation();
                }
                String key = ((OMREntry)this.myReportEntry).getLocation();
                cache.put(key, this.myReportEntry);
                return this.myReportEntry;
            }
            catch (ContentException e) {
                throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause((Throwable)((Object)e));
            }
            catch (RepositoryException e) {
                throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause((Throwable)((Object)e));
            }
            catch (ServiceException e) {
                throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
            }
        }
        this.myReportEntry = UtilReportReposService.getEntryServiceAdapter(OMRReportEntry.getInformationService(), this);
        return this.myReportEntry;
    }

    void setEntryInterface(EntryInterface entry, OMRID repositoryId) throws IllegalStateException, RemoteException {
        super.setRepository((RepositoryInterface)repositoryId.getOMIRepository());
        this.myReportEntry = (OMREntry)entry;
    }

    public void refresh() throws ServiceException, RemoteException {
        super.refresh();
        this.myReportEntry = null;
    }

    public PropertyList getLocalizableProperties() {
        PropertyList list = new PropertyList();
        try {
            list.addProperty("Name", this.getName());
            list.addProperty("Description", this.getDescription());
            EntryInterface report = (EntryInterface)this.newServiceObject();
            ContentHelper contentHelper = new ContentHelper();
            InputStream is = report.getInputStream();
            Map localizableMapItems = contentHelper.retrieveMapOfLocalizableItems(is);
            int mapSize = localizableMapItems.size();
            Iterator iter = localizableMapItems.entrySet().iterator();
            for (int j = 1; j < mapSize + 1; ++j) {
                Map.Entry entry = iter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                list.addProperty(key.toString(), value.toString());
            }
        }
        catch (RemoteException e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        catch (IOException e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        catch (RepositoryIOException e) {
            throw new UnexpectedLocalizationException((Throwable)((Object)e));
        }
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) {
        try {
            if (map.containsProperty("Name")) {
                this.setName(map.getProperty("Name"));
            }
            if (map.containsProperty("Description")) {
                this.setDescription(map.getProperty("Description"));
            }
            if (map.containsProperty("Name")) {
                this.setName(map.getProperty("Name"));
            }
            if (map.containsProperty("Description")) {
                this.setDescription(map.getProperty("Description"));
            }
        }
        catch (RemoteException e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
    }

    public void setContentAvailable(boolean available) throws ServiceException, RemoteException {
        this._contentAvailable = available;
    }

    public boolean isContentAvailable() throws ServiceException, RemoteException {
        return this._contentAvailable;
    }

    public void moveTo(FolderInterface folder) throws ServiceException, RemoteException {
        try {
            Object o = folder.newServiceObject();
            EntryInterface destOMREntry = null;
            DirectoryInterface di = null;
            if (this.myReportEntry == null) {
                this.getRepositoryObject();
            }
            if (o instanceof RemoteDirectoryInterface) {
                di = (DirectoryInterface)this.myReportEntry.getParentEntry();
                OMRDirectory omrParent = (OMRDirectory)di;
                OMRID omrid = omrParent.getOMRID();
                di = new OMRDirectory(folder, omrid);
                destOMREntry = di;
            } else {
                destOMREntry = (EntryInterface)o;
            }
            this.myReportEntry.moveTo(destOMREntry);
        }
        catch (RepositoryIllegalNameException e) {
            throw new ServiceException((Throwable)((Object)e));
        }
        catch (RepositoryNotFoundException e) {
            throw new ServiceException((Throwable)((Object)e));
        }
        catch (RepositoryDuplicateNameException e) {
            throw new ServiceException((Throwable)((Object)e));
        }
        catch (RepositoryLockedException e) {
            throw new ServiceException((Throwable)((Object)e));
        }
        catch (RepositoryException e) {
            throw new ServiceException((Throwable)((Object)e));
        }
        catch (SecurityException e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

