/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.impl.TreeImpl;
import com.sas.metadata.remote.impl.TreeImpl_Stub;
import com.sas.report.repository.AdapterFactory;
import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.OMRDirectory;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RemoteDirectory;
import com.sas.report.repository.ReportDirectoryInterface;
import com.sas.report.repository.ReportManagementCache;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.SmartObjectHelper;
import com.sas.report.repository.UtilReportReposService;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.Folder;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RB;
import com.sas.services.util.Names;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.Date;

public class OMRReportDirectory
extends Folder
implements ReportDirectoryInterface {
    private static final String TREE_TYPE = "BIP Folder";
    private static final String FOLDER = "Folder";
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private DirectoryInterface myReportDir;
    private SmartObjectHelper myHelper;

    public OMRReportDirectory() throws RemoteException {
    }

    public OMRReportDirectory(Tree o) throws RemoteException {
        super(o);
        String publicType = o.getPublicType();
        if (publicType.equals(FOLDER)) {
            return;
        }
        throw new RuntimeException(RBUtil.getStringResource("OMRReportEntryunableToCreate.txt", this.getName()));
    }

    public OMRReportDirectory(TreeImpl o) throws RemoteException {
        super(o);
        String publicType = o.getPublicType();
        if (publicType.equals(FOLDER)) {
            return;
        }
        throw new RuntimeException(RBUtil.getStringResource("OMRReportEntryunableToCreate.txt", this.getName()));
    }

    public OMRReportDirectory(TreeImpl_Stub o) throws RemoteException {
        super(o);
        String publicType = o.getPublicType();
        if (publicType.equals(FOLDER)) {
            return;
        }
        throw new RuntimeException(RBUtil.getStringResource("OMRReportEntryunableToCreate.txt", this.getName()));
    }

    public void setRepository(RepositoryInterface repos) throws IllegalStateException, RemoteException {
        this.myHelper = new SmartObjectHelper(repos);
        super.setRepository(repos);
    }

    public void delete() throws ServiceException, RemoteException {
        DirectoryInterface dir = this.getRepositoryObject();
        try {
            dir.delete();
        }
        catch (RepositoryLockedException e) {
            throw new ServiceException((Throwable)((Object)e), e.getMessage());
        }
        catch (RepositoryException e) {
            throw new ServiceException((Throwable)((Object)e), e.getMessage());
        }
    }

    public Date getModifyDate() throws ServiceException, RemoteException {
        DirectoryInterface entry = this.getRepositoryObject();
        if (entry == null) {
            throw new ServiceException(RB.getStringResource((String)"OMRReportEntrynotInitialized.txt"));
        }
        try {
            Date d = (Date)entry.getAttribute("Modified Date");
            return d;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e, e.getMessage());
        }
    }

    Date getModifyDateFromParent() throws ServiceException, RemoteException {
        return super.getModifyDate();
    }

    public Date getCreateDate() throws ServiceException, RemoteException {
        DirectoryInterface entry = this.getRepositoryObject();
        if (entry == null) {
            throw new ServiceException(RB.getStringResource((String)"OMRReportEntrynotInitialized.txt"));
        }
        try {
            Date d = (Date)entry.getAttribute("Creation Date");
            return d;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e, e.getMessage());
        }
    }

    Date getCreateDateFromParent() throws ServiceException, RemoteException {
        return super.getModifyDate();
    }

    public Object newServiceObject() throws ServiceException, RemoteException {
        DirectoryInterface dir = this.getRepositoryObject();
        if (AdapterFactory.isCallerRemote() && dir instanceof OMRDirectory) {
            return new RemoteDirectory(dir);
        }
        return dir;
    }

    void setEntryInterface(EntryInterface entry, OMRID repositoryId) throws IllegalStateException, RemoteException {
        super.setRepository((RepositoryInterface)repositoryId.getOMIRepository());
        this.myReportDir = (OMRDirectory)entry;
    }

    private DirectoryInterface getRepositoryObject() throws IllegalStateException, RemoteException, ServiceException {
        if (this.myReportDir == null) {
            if (UtilReportReposService.credentialsAccessible((MetadataInterface)this)) {
                this.myHelper.initRepository(this._repositoryFlag, this._repositoryObject, this.getName());
                OMRID omrid = this.myHelper.getOMRID();
                try {
                    PathUrl pathUrl = this.getPathUrl();
                    String pathUrlStr = pathUrl.toString();
                    ReportManagementCache cache = omrid.getCache();
                    OMRDirectory dir = (OMRDirectory)cache.get(pathUrlStr);
                    if (dir == null) {
                        dir = new OMRDirectory(this, omrid);
                        cache.put(pathUrlStr, dir);
                    }
                    this.myReportDir = dir;
                }
                catch (RepositoryException e) {
                    throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause((Throwable)((Object)e));
                }
                catch (ServiceException e) {
                    throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
                }
            } else {
                this.myReportDir = UtilReportReposService.getDirServiceAdapter(OMRReportDirectory.getInformationService(), (MetadataInterface)this);
            }
        }
        return this.myReportDir;
    }

    public void refresh() throws ServiceException, RemoteException {
        super.refresh();
        this.myReportDir = null;
    }

    public void setName(String name) throws RemoteException {
        if (!Names.validateOMRObjectName((String)name, (boolean)true)) {
            throw new IllegalArgumentException(RB.getStringResource((String)"OMRReportDirectory.invalidName.ex.txt", (String)name));
        }
        try {
            FolderInterface parent = this.getParent();
            if (parent != null && parent.hasDuplicateSubfolder(name)) {
                throw new IllegalArgumentException(RB.getStringResource((String)"OMRReportDirectory.conflictingName.ex.txt", (String)name));
            }
            Tree theTree = (Tree)this._repositoryObject;
            theTree.setName(name);
        }
        catch (ServiceException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public OMRID getOMRID() {
        return this.myHelper != null ? this.myHelper.getOMRID() : null;
    }
}

