/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.ReportCacheInterface;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class OMRReportCache
implements ReportCacheInterface {
    private static final String CACHENAME = "ReportCache";
    private static final String SBIPLOCAL = "SBIP://_REPORTCACHE_/";
    private static final int SBIPLOCALPREFIXSIZE = 21;
    protected CacheInterface cache = null;
    private String myName;

    public OMRReportCache(EntryInterface entry) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            CacheSetInterface cs = entry.getCacheSetInterface();
            this.cache = cs.exists(CACHENAME) ? cs.get(CACHENAME) : cs.create(CACHENAME, true);
            this.myName = CACHENAME;
        }
        catch (SecurityException e) {
            throw new SecurityException(e);
        }
        catch (RepositoryNotFoundException e) {
            throw new RepositoryNotFoundException((Throwable)((Object)e), e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
    }

    public OMRReportCache(EntryInterface entry, String cacheName) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            CacheSetInterface cs = entry.getCacheSetInterface();
            this.cache = cs.exists(cacheName) ? cs.get(cacheName) : cs.create(cacheName, true);
            this.myName = cacheName;
        }
        catch (SecurityException e) {
            throw new SecurityException(e);
        }
        catch (RepositoryNotFoundException e) {
            throw new RepositoryNotFoundException((Throwable)((Object)e), e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
    }

    @Override
    public CacheItemInterface createItem(String localSBIP) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        String itemName = this.parseLocalSBIP(localSBIP);
        CacheItemInterface item = null;
        try {
            item = !this.cache.exists(itemName) ? this.cache.create(itemName) : this.cache.get(itemName);
        }
        catch (SecurityException e) {
            throw new SecurityException(e);
        }
        catch (RepositoryNotFoundException e) {
            throw new RepositoryNotFoundException((Throwable)((Object)e), e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        return item;
    }

    @Override
    public CacheItemInterface getItem(String localSBIP) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        String itemName = this.parseLocalSBIP(localSBIP);
        CacheItemInterface item = null;
        try {
            item = this.cache.get(itemName);
        }
        catch (SecurityException e) {
            throw new SecurityException(e);
        }
        catch (RepositoryNotFoundException e) {
            throw new RepositoryNotFoundException((Throwable)((Object)e), e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        return item;
    }

    @Override
    public void deleteItem(String localSBIP) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        String itemName = this.parseLocalSBIP(localSBIP);
        CacheItemInterface item = this.cache.get(itemName);
        try {
            item.delete();
        }
        catch (SecurityException e) {
            throw new SecurityException(e);
        }
        catch (RepositoryNotFoundException e) {
            throw new RepositoryNotFoundException((Throwable)((Object)e), e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
    }

    @Override
    public String readItem(CacheItemInterface item) throws IOException, SecurityException, RepositoryException {
        StringBuffer sBuf = new StringBuffer();
        try (InputStream iStream = null;){
            iStream = item.getInputStream();
            int b = iStream.read();
            while (b != -1) {
                sBuf.append((char)b);
                b = iStream.read();
            }
        }
        return sBuf.toString();
    }

    @Override
    public String writeItem(CacheItemInterface item, String myContent) throws RepositoryException, IOException {
        String content = null;
        try (OutputStream oStream = null;){
            oStream = item.getOutputStream();
            content = this.addContent(oStream, myContent);
        }
        return content;
    }

    @Override
    public boolean itemExists(String localSBIP) throws RepositoryException {
        try {
            String itemName = this.parseLocalSBIP(localSBIP);
            return this.cache.exists(itemName);
        }
        catch (RepositoryException e) {
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
    }

    @Override
    public boolean itemExists(CacheItemInterface item) throws RepositoryException {
        try {
            return this.cache.exists(item.getName());
        }
        catch (RepositoryException e) {
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
    }

    public String getName() {
        return this.myName;
    }

    private String addContent(OutputStream oStream, String myContent) throws RepositoryException, IOException {
        oStream.write(myContent.getBytes(), 0, myContent.length());
        return myContent;
    }

    private String parseLocalSBIP(String localSBIP) throws RepositoryException {
        String itemName = null;
        try {
            if (!localSBIP.startsWith(SBIPLOCAL)) {
                String e = RBUtil.getStringResource("SBIPReportCachePrefix.txt", localSBIP);
                throw new Exception(e);
            }
            itemName = localSBIP.substring(21);
        }
        catch (Exception e) {
            throw new RepositoryException(e, e.getMessage());
        }
        return itemName;
    }
}

