/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Timestamp;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.report.repository.BIPprovider;
import com.sas.report.repository.OMRDirectory;
import com.sas.report.repository.OMRReportEntry;
import com.sas.report.repository.PFServices;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.ReportEntryInterface;
import com.sas.report.repository.ReportManagementCache;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.RepositoryUtils;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.Folder;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.webdav.ConnectionInfo;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OMRID {
    public static final String BIP_SERVICE_CID = "E5F27790-2149-11D6-8828-AA0004006D06";
    public static final String BIP_SERVICE_NAME = "BIP Service";
    public static final String REPOSITORY_CONTENT_MAPPING = "Report Repository Content Mapping";
    public static final String BIP_TREE_TYPE = "BIP Folder";
    public static final String DAV_URI_TYPE = "DAV";
    public static final String SESSION_CONTEXT_KEY = RBUtil.getStringResource("OMRIDsessionContextKey.notrans");
    public static final String SESSION_CONTEXT_MAP_KEY = RBUtil.getStringResource("OMRIDsessionContextMapKey.notrans");
    public static final String MD_STRING_TYPE = "String";
    public static final Date EPOCH_DATE = new Date(0L);
    private static boolean contentUserFailedMessageFlag = false;
    private static int totalCallsToConstructor = 0;
    private static InformationServiceInterface infoService;
    private static UserContextInterface securedUser;
    protected SoftwareComponent bipService;
    protected SoftwareComponent rootbipService;
    protected ArrayList omrProviderList;
    protected String omrRepositoryId;
    protected String omrRepositorySuffix;
    private PFServices pfs;
    private OMIRepositoryInterface omiRepository;
    private boolean logEverything;
    private ReportManagementCache myCache;
    private Map myContentRootCache;
    private Object myContentResource;
    private String myBasePath = null;
    private static final Logger log;

    public static synchronized void setInformationService(InformationServiceInterface i) {
        infoService = i;
    }

    public static synchronized void setSecuredUser(UserContextInterface u) {
        securedUser = u;
    }

    public static synchronized void setSecuredUser(UserServiceInterface u, String userId, String password, String domain) throws RemoteException, ServiceException {
        if (securedUser != null) {
            securedUser.destroy();
        }
        securedUser = u.newUser(userId, password, domain);
    }

    public static synchronized boolean securedUserAvailable() {
        return securedUser != null && infoService != null;
    }

    public static boolean pingDAVServer(String dirPathUrl) throws RemoteException, ServiceException {
        if (OMRID.securedUserAvailable()) {
            PathUrl folderPathUrl = new PathUrl(dirPathUrl);
            PathUrl clonedPathUrl = (PathUrl)folderPathUrl.clone();
            clonedPathUrl.setName("/");
            clonedPathUrl.setType(null);
            clonedPathUrl.setPath(null);
            PathUrl rootPathUrl = new PathUrl(clonedPathUrl.toString());
            FolderInterface rootFolder = (FolderInterface)infoService.getObjectByPath(securedUser, rootPathUrl);
            com.sas.services.information.ContentInfo ci = rootFolder.getContentInfo();
            if (ci != null) {
                String url = ci.getRoot();
                String path = ci.getPath();
                String userid = ci.getUserId();
                String passwd = ci.getPassword();
                ConnectionInfo cxn = new ConnectionInfo(url + (path != null ? path : ""), userid, passwd);
                try {
                    DAVResource dr = new DAVResource(cxn);
                    int status = dr.getStatusCode();
                    dr.close();
                    if ((status /= 100) == 2) {
                        return true;
                    }
                }
                catch (DAVException ex) {
                    throw new ServiceException((Throwable)ex, ex.getMessage());
                }
            }
        }
        return false;
    }

    public OMRID(OMIRepositoryInterface omiRepository, PFServices pfs) throws RemoteException {
        SessionContextInterface sc;
        this.pfs = pfs;
        this.omiRepository = omiRepository;
        this.setRepositoryId(omiRepository.getBase());
        log.debug("OMRID:total calls to constructor = " + ++totalCallsToConstructor);
        this.myCache = new ReportManagementCache();
        this.myContentRootCache = new HashMap();
        if (pfs != null && (sc = pfs.getSessionContext()) != null) {
            HashMap<OMIRepositoryInterface, OMRID> omridMap = (HashMap<OMIRepositoryInterface, OMRID>)sc.getAttribute(SESSION_CONTEXT_MAP_KEY);
            if (omridMap == null) {
                omridMap = new HashMap<OMIRepositoryInterface, OMRID>();
                sc.setAttribute(SESSION_CONTEXT_MAP_KEY, omridMap);
            }
            omridMap.put(this.getOMIRepository(), this);
            this.debug("Binding OMRID in SessionContext");
        }
    }

    public synchronized Object checkoutContentResource() {
        Object rval = this.myContentResource;
        this.myContentResource = null;
        return rval;
    }

    public synchronized Object checkinContentResource(Object resource) {
        Object rval = this.myContentResource;
        this.myContentResource = resource;
        if (this.myBasePath == null && resource instanceof DAVResource) {
            try {
                String url = ((DAVResource)resource).getURL().toExternalForm();
                for (ContentInfo ci : this.myContentRootCache.values()) {
                    if (!url.startsWith(ci.getPath())) continue;
                    url = ci.getPath();
                    int p1 = url.indexOf("://");
                    int p2 = url.indexOf("/", p1 + 3);
                    this.myBasePath = url.substring(p2);
                    break;
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (DAVException e) {
                e.printStackTrace();
            }
        }
        return rval;
    }

    public PFServices getPFServices() {
        return this.pfs;
    }

    public String getRepositoryId() {
        return this.omrRepositoryId;
    }

    public ReportManagementCache getCache() {
        return this.myCache;
    }

    public OMIRepositoryInterface getOMIRepository() {
        return this.omiRepository;
    }

    public String getRepositorySuffix() {
        return this.omrRepositorySuffix;
    }

    private void setRepositoryId(String repositoryId) {
        this.omrRepositoryId = repositoryId;
        this.omrRepositorySuffix = repositoryId.substring(repositoryId.indexOf(46) + 1);
    }

    public MetadataInterface createReportSmartObject(String name) throws RemoteException, ServiceException {
        Transformation jomaObj = (Transformation)this.omiRepository.createMetadata(name, "Transformation");
        jomaObj.setTransformRole("Report");
        String _reportType = RepositoryUtils.publicType(name);
        jomaObj.setPublicType(_reportType);
        jomaObj.setUsageVersion(OMRReportEntry.CURRENT_VERSION.encode());
        MetadataInterface smartObj = this.omiRepository.factoryProcess((Object)jomaObj);
        if (!(smartObj instanceof ReportEntryInterface)) {
            throw new IllegalStateException(RBUtil.getStringResource("OMRIDbadTypeCreatingReportSmartObject.fmt.txt", smartObj.getClass().getName()));
        }
        return smartObj;
    }

    public MetadataInterface createReportSmartObject(String name, OMIRepositoryInterface omiRepository) throws RemoteException, ServiceException {
        Transformation jomaObj = (Transformation)omiRepository.createMetadata(name, "Transformation");
        jomaObj.setTransformRole("Report");
        String _reportType = RepositoryUtils.publicType(name);
        jomaObj.setPublicType(_reportType);
        jomaObj.setUsageVersion(OMRReportEntry.CURRENT_VERSION.encode());
        MetadataInterface smartObj = omiRepository.factoryProcess((Object)jomaObj);
        if (!(smartObj instanceof ReportEntryInterface)) {
            throw new IllegalStateException(RBUtil.getStringResource("OMRIDbadTypeCreatingReportSmartObject.fmt.txt", smartObj.getClass().getName()));
        }
        return smartObj;
    }

    public MetadataInterface createReportSmartObject(String name, String publicType, OMIRepositoryInterface omiRepository) throws RemoteException, ServiceException {
        UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
        String TRANSFORM_ROLE = publicType;
        if (publicType.equals("Report.Image") || publicType.equals("Report.Component")) {
            TRANSFORM_ROLE = "Report";
        }
        return this.createSmartObject(name, omiRepository, publicType, TRANSFORM_ROLE, CURRENT_VERSION.encode());
    }

    public MetadataInterface createSmartObject(String name, OMIRepositoryInterface omiRepository, String publicType, String transformRole, double inUsageVersion) throws RemoteException, ServiceException {
        Transformation jomaObj = (Transformation)omiRepository.createMetadata(name, "Transformation");
        jomaObj.setTransformRole(transformRole);
        String _publicType = publicType;
        jomaObj.setPublicType(_publicType);
        jomaObj.setUsageVersion(inUsageVersion);
        MetadataInterface smartObj = omiRepository.factoryProcess((Object)jomaObj);
        log.debug("SmartObj -> " + smartObj.getClass().getName());
        log.debug("PublicType -> " + _publicType);
        if (!(smartObj instanceof ReportEntryInterface)) {
            throw new IllegalStateException(RBUtil.getStringResource("OMRIDbadTypeCreatingReportSmartObject.fmt.txt", smartObj.getClass().getName()));
        }
        return smartObj;
    }

    public FolderInterface createReportFolderSmartObject(String name) throws RemoteException, ServiceException {
        return this.createReportFolderSmartObject(name, this.omiRepository);
    }

    public FolderInterface createReportFolderSmartObject(String name, OMIRepositoryInterface omiRepository) throws RemoteException, ServiceException {
        InformationServiceInterface _is = Metadata.getInformationService();
        FolderInterface smartObj = (FolderInterface)_is.newMetadata(null, name, (RepositoryInterface)omiRepository, "Folder");
        Date date = new Date();
        smartObj.setContentCreateDate(date);
        smartObj.setContentModifyDate(date);
        return smartObj;
    }

    public MetadataInterface createMetadataObject(String name, String jomaObjectType) throws RepositoryException, RemoteException {
        MetadataInterface smartObj = null;
        try {
            Root jomaObj = this.omiRepository.createMetadata(name, jomaObjectType);
            smartObj = this.omiRepository.factoryProcess((Object)jomaObj);
            if (log.isDebugEnabled()) {
                Object[] args = new Object[]{"1", jomaObj.getId(), jomaObj.getName(), jomaObj.getCMetadataType()};
                log.debug(RBUtil.getStringResource("OMRIDcreateObject.notrans", args));
            }
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        return smartObj;
    }

    public MetadataInterface createMetadataObject(String name, String jomaObjectType, OMIRepositoryInterface omiRepository) throws RepositoryException, RemoteException {
        MetadataInterface smartObj = null;
        try {
            Root jomaObj = omiRepository.createMetadata(name, jomaObjectType);
            smartObj = omiRepository.factoryProcess((Object)jomaObj);
            log.debug("smartObj (joma) -> " + smartObj.getClass().getName());
            if (log.isDebugEnabled()) {
                Object[] args = new Object[]{"1", jomaObj.getId(), jomaObj.getName(), jomaObj.getCMetadataType()};
                log.debug(RBUtil.getStringResource("OMRIDcreateObject.notrans", args));
            }
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        return smartObj;
    }

    public MetadataInterface createMetadataObject(MetadataInterface object) throws RepositoryException, RemoteException {
        CMetadata origJomaObj = (CMetadata)object.getRepositoryEntity();
        return this.createMetadataObject(origJomaObj);
    }

    public MetadataInterface createMetadataObject(MetadataInterface object, OMIRepositoryInterface omiRepository) throws RepositoryException, RemoteException {
        CMetadata origJomaObj = (CMetadata)object.getRepositoryEntity();
        return this.createMetadataObject(origJomaObj, omiRepository);
    }

    public MetadataInterface createMetadataObject(CMetadata jomaObj) throws RepositoryException, RemoteException {
        String name = jomaObj.getName();
        String type = jomaObj.getCMetadataType();
        return this.createMetadataObject(name, type);
    }

    public MetadataInterface createMetadataObject(CMetadata jomaObj, OMIRepositoryInterface omiRepository) throws RepositoryException, RemoteException {
        String name = jomaObj.getName();
        String type = jomaObj.getCMetadataType();
        return this.createMetadataObject(name, type, omiRepository);
    }

    public MetadataInterface cloneMetadataObject(MetadataInterface srcObject) throws RepositoryException, RemoteException {
        MetadataInterface destObject = this.createMetadataObject(srcObject);
        CMetadata destC = (CMetadata)destObject.getRepositoryEntity();
        CMetadata srcC = (CMetadata)srcObject.getRepositoryEntity();
        Map attrs = srcC.getAttrs();
        attrs.put("Id", destC.getFQID());
        MdStoreUtil.setMetaObjectAttributes((CMetadata)srcC, (CMetadata)destC, (Map)attrs, (int)1);
        return destObject;
    }

    public MetadataInterface cloneMetadataObject(MetadataInterface srcObject, OMIRepositoryInterface omiRepository) throws RepositoryException, RemoteException {
        MetadataInterface destObject = this.createMetadataObject(srcObject, omiRepository);
        CMetadata destC = (CMetadata)destObject.getRepositoryEntity();
        CMetadata srcC = (CMetadata)srcObject.getRepositoryEntity();
        Map attrs = srcC.getAttrs();
        attrs.put("Id", destC.getFQID());
        MdStoreUtil.setMetaObjectAttributes((CMetadata)srcC, (CMetadata)destC, (Map)attrs, (int)1);
        return destObject;
    }

    public List findTransformationAndAssociations(MetadataInterface mdObj) throws RepositoryException, RemoteException {
        String template = "<Templates><Transformation><Trees/><Properties/><Timestamps/><Notes/><Keywords/></Transformation></Templates>";
        try {
            Filter filter = new Filter("Id", 0, mdObj.getReposId());
            filter.setOMRRepository(this.omrRepositoryId);
            filter.setType("Transformation");
            filter.setOMRFlags(260);
            filter.setOMRTemplate("<Templates><Transformation><Trees/><Properties/><Timestamps/><Notes/><Keywords/></Transformation></Templates>");
            return this.omiRepository.search((FilterInterface)filter);
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    private SoftwareComponent findRootSoftwareComponent(String rrServicesName) throws RepositoryException, RemoteException {
        try {
            Filter filter = new Filter("ClassIdentifier", 0, BIP_SERVICE_CID);
            filter.setOMRRepository(((OMIRepositoryInterface)this.omiRepository.getServer().getFoundationRepository()).getDefaultRepositoryId());
            filter.setType("SoftwareComponent");
            filter.setOMRFlags(16);
            List rootComponents = null;
            try {
                rootComponents = this.omiRepository.getServer().getFoundationRepository().search((FilterInterface)filter);
            }
            catch (ServiceException e) {
                log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
                throw new RepositoryException(e, e.getMessage());
            }
            Iterator rootIt = rootComponents.iterator();
            if (rootIt.hasNext()) {
                MetadataInterface folder = (MetadataInterface)rootIt.next();
                try {
                    SoftwareComponent sc = (SoftwareComponent)folder.getRepositoryEntity();
                    return sc;
                }
                catch (Exception e) {
                    throw new RepositoryException(e, e.getMessage());
                }
            }
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, "Error in findRootSoftwareComponent");
        }
        return null;
    }

    private SoftwareComponent findSoftwareComponent(String rrServicesName) throws RepositoryException, RemoteException {
        Filter filter = new Filter("ClassIdentifier", 0, BIP_SERVICE_CID);
        filter.setOMRRepository(this.omrRepositoryId);
        filter.setType("SoftwareComponent");
        filter.setOMRFlags(16);
        List rootComponents = null;
        try {
            rootComponents = this.omiRepository.search((FilterInterface)filter);
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        Iterator rootIt = rootComponents.iterator();
        if (rootIt.hasNext()) {
            MetadataInterface folder = (MetadataInterface)rootIt.next();
            try {
                SoftwareComponent sc = (SoftwareComponent)folder.getRepositoryEntity();
                return sc;
            }
            catch (Exception e) {
                throw new RepositoryException(e, e.getMessage());
            }
        }
        return null;
    }

    public MetadataInterface findPerson(String name) throws RepositoryException, RemoteException {
        if (name == null || name.length() == 0) {
            return null;
        }
        Filter filter = new Filter("Name", 0, name);
        filter.setOMRRepository(this.omrRepositoryId);
        filter.setType("Person");
        filter.setOMRFlags(8208);
        List people = null;
        try {
            people = this.omiRepository.search((FilterInterface)filter);
            if (people.size() > 0) {
                return (MetadataInterface)people.get(0);
            }
            return null;
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public List getRootFolders() throws RepositoryException, RemoteException {
        try {
            return this.omiRepository.getRootFolders();
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public FolderInterface getRootFolder(String rootFolderName) throws RepositoryException, RemoteException {
        List rootFolders = this.getRootFolders();
        for (FolderInterface folder : rootFolders) {
            if (!rootFolderName.equals(folder.getName())) continue;
            return folder;
        }
        throw new RepositoryNotFoundException(RBUtil.getStringResource("OMRIDnoBIPTree.txt", (Object)rootFolderName, this.omiRepository.getISName()));
    }

    public OMRDirectory getRootOMRDirectory(String rootFolderName) throws RepositoryException, RemoteException {
        FolderInterface bipRoot = this.getRootFolder(rootFolderName);
        ReportManagementCache cache = this.getCache();
        try {
            String key = bipRoot.getPathUrl().toString();
            OMRDirectory rootDir = (OMRDirectory)cache.get(key);
            if (rootDir == null) {
                rootDir = new OMRDirectory(bipRoot, this);
                cache.put(key, rootDir);
            }
            return rootDir;
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public String getUserName() throws SecurityException, RepositoryException, RemoteException {
        if (this.pfs == null) {
            return null;
        }
        try {
            return this.pfs.getUserName();
        }
        catch (SecurityException esc) {
            throw new SecurityException();
        }
    }

    public Person getCurrentPersonObject() throws RemoteException {
        UserContextInterface uci = this.pfs.getUserContext();
        if (uci == null) {
            throw new NullPointerException(RBUtil.getStringResource("OMRIDnullUserContextInterface.txt"));
        }
        IdentityInterface ii = uci.getPerson();
        if (ii == null) {
            throw new NullPointerException(RBUtil.getStringResource("OMRIDnullIdentityInterface.txt"));
        }
        Person p = (Person)ii.getRepositoryEntity();
        if (p == null) {
            throw new NullPointerException(RBUtil.getStringResource("OMRIDnullPerson.txt"));
        }
        return p;
    }

    public void debug(String textIn) {
        log.debug(RBUtil.getStringResource("OMRIDonearg.notrans", textIn));
    }

    public void debug(String textIn, Throwable exception) {
        log.debug(RBUtil.getStringResource("OMRIDonearg.notrans", (Object)textIn, exception));
    }

    public void warn(String textIn) {
        log.warn(RBUtil.getStringResource("OMRIDonearg.txt", textIn));
    }

    public void warn(String textIn, Throwable exception) {
        log.warn(RBUtil.getStringResource("OMRIDonearg.txt", (Object)textIn, exception));
    }

    public void error(String textIn) {
        log.error(RBUtil.getStringResource("OMRIDonearg.txt", textIn));
    }

    public void error(String textIn, Throwable exception) {
        log.error(RBUtil.getStringResource("OMRIDonearg.txt", (Object)textIn, exception));
    }

    public void info(String textIn) {
        log.info(RBUtil.getStringResource("OMRIDonearg.txt", textIn));
    }

    public void fatal(String textIn) {
        log.fatal(RBUtil.getStringResource("OMRIDonearg.txt", textIn));
    }

    public void fatal(String textIn, Throwable exception) {
        log.fatal(RBUtil.getStringResource("OMRIDonearg.txt", (Object)textIn, exception));
    }

    public SoftwareComponent findBIPService() throws RepositoryException, RemoteException {
        if (this.bipService == null) {
            this.bipService = this.findSoftwareComponent(BIP_SERVICE_NAME);
            if (this.bipService != null) {
                String bipServiceClassId = this.bipService.getClassIdentifier();
                if (BIP_SERVICE_CID.compareTo(bipServiceClassId) != 0) {
                    String _msg = RBUtil.getStringResource("OMRIDclassIdentifier.txt", (Object)BIP_SERVICE_NAME, (Object)bipServiceClassId, BIP_SERVICE_CID);
                    throw new RepositoryException(_msg);
                }
            } else {
                String _msg = RBUtil.getStringResource("OMRIDnoBIPService.txt", this.omiRepository.getISName());
                throw new RepositoryException(_msg);
            }
        }
        return this.bipService;
    }

    public SoftwareComponent findRootBIPService() throws RepositoryException, RemoteException {
        if (this.rootbipService == null) {
            this.rootbipService = this.findRootSoftwareComponent(BIP_SERVICE_NAME);
            if (this.rootbipService != null) {
                String bipServiceClassId = this.rootbipService.getClassIdentifier();
                if (BIP_SERVICE_CID.compareTo(bipServiceClassId) != 0) {
                    String _msg = RBUtil.getStringResource("OMRIDclassIdentifier.txt", (Object)BIP_SERVICE_NAME, (Object)bipServiceClassId, BIP_SERVICE_CID);
                    throw new RepositoryException(_msg);
                }
            } else {
                String _msg = RBUtil.getStringResource("OMRIDnoBIPService.txt", this.omiRepository.getISName());
                throw new RepositoryException(_msg);
            }
        }
        return this.rootbipService;
    }

    public ContentInfo getContentInfo(PathUrl sbipUrl) throws IllegalStateException, RepositoryException {
        PathUrl sbipRoot = (PathUrl)sbipUrl.clone();
        sbipRoot.setPath(null);
        sbipRoot.setName(null);
        sbipRoot.setType(null);
        String sbipRootFolder = sbipRoot.getRootTree();
        String sbipRootUrlStr = sbipRoot.toString();
        ContentInfo contentInfo = (ContentInfo)this.myContentRootCache.get(sbipRootUrlStr);
        if (contentInfo == null) {
            try {
                String pw;
                String userId;
                TextStore ts;
                Document doc = this.getContentInfoDoc(sbipRootFolder, sbipRootUrlStr);
                String uri = doc.getURI();
                if (REPOSITORY_CONTENT_MAPPING.equals(doc.getName())) {
                    if ((uri = uri.trim()).charAt(uri.length() - 1) != '/') {
                        uri = uri + "/";
                    }
                    uri = uri + sbipUrl.getRootTree();
                }
                if ((ts = this.getAuthenticationTextStore(doc)) != null) {
                    String storedTextEncoded = ts.getStoredText();
                    String storedText = null;
                    boolean sasPasswordEncoding = storedTextEncoded.startsWith("{sas");
                    try {
                        if (sasPasswordEncoding) {
                            storedText = SasPasswordString.decode((String)storedTextEncoded);
                        } else {
                            MdObjectStore store = (MdObjectStore)ts.getObjectStore();
                            MdFactory factory = store.getFactory();
                            storedText = factory.getUtil().decrypt(storedTextEncoded);
                        }
                    }
                    catch (SasPasswordEncodingException e) {
                        log.warn(e.toString());
                        throw new RepositoryException(e, e.getMessage());
                    }
                    int delimiterPos = storedText.indexOf(10);
                    if (delimiterPos > 0 && delimiterPos < storedText.length() - 1) {
                        userId = storedText.substring(0, delimiterPos);
                        pw = storedText.substring(delimiterPos + 1);
                    } else {
                        userId = storedText;
                        pw = "";
                    }
                } else {
                    boolean davCredentialsFound = false;
                    userId = "";
                    pw = "";
                    if (DAV_URI_TYPE.equals(doc.getURIType()) && OMRID.securedUserAvailable()) {
                        com.sas.services.information.ContentInfo contentInfoFS;
                        FolderInterface folder;
                        if (log.isDebugEnabled()) {
                            log.debug("Secured User is available. Using Secured User to get content info");
                        }
                        if ((folder = (FolderInterface)infoService.getObjectByPath(securedUser, new PathUrl(sbipRootUrlStr + "/"))) == null) {
                            log.debug("Folder [" + sbipRootUrlStr + "/] submitted to getObjectByPath is null.  Check status of folder if deleted, or if (content agent) sastrust has permission to read folder.");
                            throw new IllegalStateException();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("ContentInfo Root Folder [" + sbipRootUrlStr + "/] found: " + folder);
                        }
                        if ((contentInfoFS = folder.getContentInfo()) != null) {
                            userId = contentInfoFS.getUserId();
                            pw = contentInfoFS.getPassword();
                            davCredentialsFound = true;
                        }
                    }
                    if (!davCredentialsFound) {
                        userId = "";
                        pw = "";
                        if (!contentUserFailedMessageFlag) {
                            log.info(RBUtil.getStringResource("OMRIDretrieveContentUserFailed.txt", doc.getURI()));
                            contentUserFailedMessageFlag = true;
                        }
                    }
                }
                contentInfo = new ContentInfo(uri, userId, pw);
                this.myContentRootCache.put(sbipRootUrlStr, contentInfo);
            }
            catch (RemoteException e) {
                log.debug(RBUtil.getStringResource("OMRIDError.notrans", e));
                throw new RepositoryException(e, e.getMessage());
            }
            catch (ServiceException e) {
                log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
                throw new RepositoryException(e, e.getMessage());
            }
        }
        return contentInfo;
    }

    public void clearContentRootCache() {
        this.myContentRootCache.clear();
    }

    private Document getContentInfoDoc(String rootFolderName, String rootFolderUrlStr) throws IllegalArgumentException, RepositoryException {
        try {
            FolderInterface rootFolder = this.omiRepository.getRootFolder(rootFolderName);
            Tree rootFolderMdObj = null;
            if (rootFolder != null) {
                rootFolderMdObj = (Tree)rootFolder.getRepositoryEntity();
            }
            if (rootFolderMdObj == null) {
                throw new IllegalStateException(RBUtil.getStringResource("OMRIDnoMatchForRoot.txt", rootFolderUrlStr));
            }
            AssociationList rootDocList = rootFolderMdObj.getDocuments();
            Document contentInfoDoc = this.getContentInfoDocFromList((List)rootDocList, rootFolderName);
            if (contentInfoDoc != null) {
                return contentInfoDoc;
            }
            SoftwareComponent sc = this.findRootBIPService();
            if (sc == null) {
                throw new IllegalStateException(RBUtil.getStringResource("OMRIDnoBIPServiceForRoot.txt", rootFolderUrlStr));
            }
            AssociationList scDocList = sc.getDocuments();
            contentInfoDoc = this.getContentInfoDocFromList((List)scDocList, rootFolderName);
            if (contentInfoDoc == null && (contentInfoDoc = this.getContentInfoDocFromList((List)scDocList, REPOSITORY_CONTENT_MAPPING)) == null) {
                throw new IllegalStateException(RBUtil.getStringResource("OMRIDnoContentForRoot.txt", (Object)rootFolderName, rootFolderUrlStr));
            }
            return contentInfoDoc;
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (MdException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    private Document getContentInfoDocFromList(List list, String docName) throws RemoteException {
        Document contentInfoDoc = null;
        Iterator docItor = list.iterator();
        while (contentInfoDoc == null && docItor.hasNext()) {
            Document doc = (Document)docItor.next();
            if (!doc.getName().equals(docName)) continue;
            contentInfoDoc = doc;
        }
        return contentInfoDoc;
    }

    public ArrayList findOMRProviders(SoftwareComponent dc) throws RepositoryException, RemoteException {
        if (this.omrProviderList != null) {
            return this.omrProviderList;
        }
        if (dc == null) {
            return null;
        }
        AssociationList documentList = null;
        try {
            documentList = dc.getDocuments(false);
            if (documentList == null || documentList.size() <= 0) {
                documentList = dc.getDocuments(true);
            }
        }
        catch (MdException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        this.omrProviderList = new ArrayList();
        if (documentList != null) {
            for (Document d : documentList) {
                String providerName = d.getName();
                String providerLocation = d.getURI();
                BIPprovider provider = new BIPprovider(providerName, providerLocation);
                this.omrProviderList.add(provider);
            }
            if (this.omrProviderList.size() > 1) {
                log.warn(RBUtil.getStringResource("OMRIDwarnMultURI.txt", dc.getName()));
            }
        }
        return this.omrProviderList;
    }

    public String resolveName(PathUrl sbipPathUrl) throws RepositoryException, RemoteException {
        String type;
        String rawName;
        String rawPath;
        ContentInfo contentInfo = this.getContentInfo(sbipPathUrl);
        String contentRootStr = contentInfo.getPath();
        if (contentRootStr == null || contentRootStr.length() < 1) {
            throw new RepositoryException(RBUtil.getStringResource("OMRIDnoValidContentMapping.txt"));
        }
        StringBuffer contentLocation = new StringBuffer(contentRootStr);
        int lastCharPos = contentRootStr.length() - 1;
        char lastChar = contentRootStr.charAt(lastCharPos);
        if (lastChar != '/' && lastChar != '\\') {
            contentLocation.append('/');
        }
        if ((rawPath = sbipPathUrl.getPath()) != null) {
            contentLocation.append(rawPath);
            contentLocation.append('/');
        }
        if ((rawName = sbipPathUrl.getName()) != null) {
            contentLocation.append(rawName);
        }
        if ((type = sbipPathUrl.getType()) != null && !type.equalsIgnoreCase("Folder")) {
            contentLocation.append('(');
            contentLocation.append(type);
            contentLocation.append(')');
        }
        return contentLocation.toString();
    }

    public AssociationList getProperties(MetadataInterface mdi) throws RepositoryException, RemoteException {
        Root object = (Root)mdi.getRepositoryEntity();
        AssociationList properties = null;
        try {
            properties = object.getProperties(false);
            if (properties == null || properties.size() <= 0) {
                properties = object.getProperties(true);
            }
        }
        catch (MdException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        return properties;
    }

    public AssociationList getKeywords(MetadataInterface mdi) throws RepositoryException, RemoteException {
        AssociationList keywords = this.getKeywords(mdi, false);
        if (keywords == null || keywords.size() <= 0) {
            keywords = this.getKeywords(mdi, true);
        }
        return keywords;
    }

    public AssociationList getKeywords(MetadataInterface mdi, boolean goToServer) throws RepositoryException, RemoteException {
        Root object = (Root)mdi.getRepositoryEntity();
        try {
            return object.getKeywords(goToServer);
        }
        catch (MdException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    private TextStore getAuthenticationTextStore(Document doc) throws RepositoryException {
        try {
            String nameToMatch = doc.getName();
            AssociationList noteList = doc.getNotes();
            for (TextStore textStore : noteList) {
                String tsName = textStore.getName();
                if (!nameToMatch.equals(tsName)) continue;
                return textStore;
            }
            return null;
        }
        catch (MdException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public AssociationList getResponsibilitiesForPerson(Person person) throws RepositoryException, RemoteException {
        AssociationList responsibilities = null;
        try {
            responsibilities = person.getResponsibilities(false);
            if (responsibilities.size() <= 0) {
                responsibilities = person.getResponsibilities(true);
            }
            return responsibilities;
        }
        catch (MdException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public AssociationList getReportsForResponsibleParty(ResponsibleParty rp) throws RepositoryException, RemoteException {
        AssociationList reports = null;
        try {
            reports = rp.getObjects(false);
            if (reports.size() <= 1) {
                reports = rp.getObjects(true);
            }
            return reports;
        }
        catch (MdException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public AssociationList getResponsibleParties(MetadataInterface mdi) throws RepositoryException, RemoteException {
        Root root = (Root)mdi.getRepositoryEntity();
        return this.getResponsibleParties(root);
    }

    private AssociationList getResponsibleParties(Root root) throws RepositoryException, RemoteException {
        AssociationList responsibleParties = null;
        try {
            responsibleParties = root.getResponsibleParties(false);
            if (responsibleParties == null || responsibleParties.size() <= 0) {
                responsibleParties = root.getResponsibleParties(true);
            }
            return responsibleParties;
        }
        catch (MdException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public AssociationList getPersons(ResponsibleParty responsibleParty) throws RepositoryException, RemoteException {
        AssociationList persons = null;
        try {
            persons = responsibleParty.getPersons(false);
            if (persons == null || persons.size() <= 0) {
                persons = responsibleParty.getPersons(true);
            }
        }
        catch (MdException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        return persons;
    }

    public AssociationList getLogins(Person person) throws RepositoryException, RemoteException {
        try {
            AssociationList logins = person.getLogins(false);
            if (logins == null || logins.size() <= 0) {
                logins = person.getLogins(true);
            }
            return logins;
        }
        catch (MdException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public AssociationList getNotes(MetadataInterface mdi, boolean goToServer) throws RepositoryException, RemoteException {
        Root object = (Root)mdi.getRepositoryEntity();
        try {
            return object.getNotes(goToServer);
        }
        catch (MdException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public AssociationList getNotes(MetadataInterface mdi) throws RepositoryException, RemoteException {
        AssociationList notes = this.getNotes(mdi, false);
        if (notes == null || notes.size() <= 0) {
            notes = this.getNotes(mdi, true);
        }
        return notes;
    }

    public AssociationList getTimestamps(MetadataInterface mdi) throws RepositoryException, RemoteException {
        Root object = (Root)mdi.getRepositoryEntity();
        AssociationList timeStamps = null;
        try {
            timeStamps = object.getTimestamps(false);
            if (timeStamps == null || timeStamps.size() <= 0) {
                timeStamps = object.getTimestamps(true);
            }
        }
        catch (MdException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        return timeStamps;
    }

    public Date getTimestampAsDate(MetadataInterface mdi, String timestampRole) throws RepositoryException, RemoteException {
        Timestamp ts = this.getTimestamp(mdi, timestampRole);
        Date retVal = null;
        if (ts != null) {
            retVal = new Date((long)ts.getDateandTime());
        } else {
            try {
                retVal = "Creation Date".equals(timestampRole) ? (mdi instanceof Folder ? ((Folder)mdi).getCreateDate() : (mdi instanceof OMRReportEntry ? ((OMRReportEntry)mdi).getCreateDateFromParent() : mdi.getCreateDate())) : (mdi instanceof Folder ? ((Folder)mdi).getCreateDate() : (mdi instanceof OMRReportEntry ? ((OMRReportEntry)mdi).getModifyDateFromParent() : mdi.getModifyDate()));
            }
            catch (ServiceException e) {
                throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
            }
        }
        return retVal;
    }

    public Timestamp getTimestamp(MetadataInterface mdi, String timestampRole) throws RepositoryException, RemoteException {
        AssociationList vTimestampObjects = this.getTimestamps(mdi);
        for (Timestamp timestamp : vTimestampObjects) {
            String timestampName = timestamp.getTimestampRole();
            if (timestampRole.compareTo(timestampName) != 0) continue;
            return timestamp;
        }
        return null;
    }

    public Timestamp setTimestamp(MetadataInterface mdi, String timestampRole, Date dateValue) throws RepositoryException, RemoteException {
        Timestamp timestamp = this.getTimestamp(mdi, timestampRole);
        if (timestamp != null) {
            timestamp.setDateandTime((double)dateValue.getTime());
        } else {
            MetadataInterface mdiTime = this.createMetadataObject(timestampRole, "Timestamp");
            timestamp = (Timestamp)mdiTime.getRepositoryEntity();
            timestamp.setTimestampRole(timestampRole);
            timestamp.setDateandTime((double)dateValue.getTime());
            AssociationList timestampList = this.getTimestamps(mdi);
            timestampList.add((Object)timestamp);
        }
        return timestamp;
    }

    public FolderInterface getParentTree(FolderInterface folder) throws RepositoryException, RemoteException {
        FolderInterface parent = null;
        try {
            parent = folder.getParent();
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        return parent;
    }

    public void setUserDefinedProperty(MetadataInterface mdi, String propName, Object value) throws RepositoryException, RemoteException {
        if (value == null) {
            this.deleteUserDefinedProperty(mdi, propName);
        } else if (value instanceof String) {
            this.setProperty(mdi, propName, (String)value);
        } else if (value instanceof Date) {
            this.setTimestamp(mdi, propName, (Date)value);
        } else {
            throw new IllegalArgumentException(RBUtil.getStringResource("OMRIDunsupportedType.txt", (Object)value.getClass().toString(), propName));
        }
    }

    public void deleteUserDefinedProperty(MetadataInterface mdi, String propName) throws RepositoryException, RemoteException {
        boolean timestampFound = false;
        AssociationList vTimestampObjects = this.getTimestamps(mdi);
        String timestampRole = propName;
        for (Timestamp timestamp : vTimestampObjects) {
            String timestampName = timestamp.getTimestampRole();
            if (timestampRole.compareTo(timestampName) != 0) continue;
            this.deleteTimestamp(mdi, timestampRole);
            timestampFound = true;
            break;
        }
        if (!timestampFound) {
            AssociationList properties = this.getProperties(mdi);
            Property p = null;
            if (properties != null) {
                String s;
                Iterator propertyIterator = properties.iterator();
                while (propertyIterator.hasNext() && ((s = (p = (Property)propertyIterator.next()).getName()) == null || s.compareTo(propName) != 0)) {
                    p = null;
                }
                if (p != null) {
                    this.deleteProperty(mdi, propName);
                }
            }
        }
    }

    protected void addUserDefinedAttributesToMap(Map map, MetadataInterface mdObj) throws RepositoryException {
        try {
            AssociationList strProps = this.getProperties(mdObj);
            for (Property p : strProps) {
                String key = p.getName();
                String value = p.getDefaultValue();
                map.put(key, value);
            }
            AssociationList tProps = this.getTimestamps(mdObj);
            for (Timestamp timestamp : tProps) {
                String key = timestamp.getTimestampRole();
                if (key.equals("Creation Date") && key.equals("Modified Date") && key.equals("Reference Date")) continue;
                Date value = new Date((long)timestamp.getDateandTime());
                map.put(key, value);
            }
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    protected void verifyStringType(String name, Object o) {
        if (o == null) {
            throw new IllegalArgumentException(RBUtil.getStringResource("OMRIDattributeNull.txt", name));
        }
        if (o instanceof String) {
            return;
        }
        throw new IllegalArgumentException(RBUtil.getStringResource("OMRIDunsupportedType.txt", (Object)o.getClass().toString(), (Object)name, String.class.toString()));
    }

    protected void verifyDateType(String name, Object o) {
        if (o == null) {
            throw new IllegalArgumentException(RBUtil.getStringResource("OMRIDattributeNull.txt", name));
        }
        if (o instanceof Date) {
            return;
        }
        throw new IllegalArgumentException(RBUtil.getStringResource("OMRIDunsupportedType.txt", (Object)o.getClass().toString(), (Object)name, Date.class.toString()));
    }

    protected void verifyListType(String name, Object o) {
        if (o == null) {
            throw new IllegalArgumentException(RBUtil.getStringResource("OMRIDattributeNull.txt", name));
        }
        if (o instanceof List) {
            return;
        }
        throw new IllegalArgumentException(RBUtil.getStringResource("OMRIDunsupportedType.txt", (Object)o.getClass().toString(), (Object)name, List.class.toString()));
    }

    public Object getUserDefinedProperty(MetadataInterface mdi, String propName) throws RepositoryException, RemoteException {
        String strVal = this.getProperty(mdi, propName);
        if (strVal != null) {
            return strVal;
        }
        Timestamp dateVal = this.getTimestamp(mdi, propName);
        if (dateVal != null) {
            return new Date((long)dateVal.getDateandTime());
        }
        return null;
    }

    public String getProperty(MetadataInterface mdi, String propName) throws RepositoryException, RemoteException {
        String s;
        log.debug(RBUtil.getStringResource("OMRIDgetProperty.notrans", (Object)mdi.getName(), propName));
        AssociationList properties = this.getProperties(mdi);
        Iterator propertyIterator = properties.iterator();
        Property p = null;
        while (propertyIterator.hasNext() && (s = (p = (Property)propertyIterator.next()).getName()).compareTo(propName) != 0) {
            p = null;
        }
        return p == null ? null : p.getDefaultValue();
    }

    public void setProperty(MetadataInterface mdi, String propName, String propValue) throws RepositoryException, RemoteException {
        log.debug(RBUtil.getStringResource("OMRIDsetProperty.notrans", (Object)propName, propValue));
        AssociationList properties = this.getProperties(mdi);
        Property p = null;
        if (properties != null) {
            String s;
            Iterator propertyIterator = properties.iterator();
            while (propertyIterator.hasNext() && ((s = (p = (Property)propertyIterator.next()).getName()) == null || s.compareTo(propName) != 0)) {
                p = null;
            }
            if (p == null) {
                MetadataInterface mdiProp = this.createMetadataObject(MD_STRING_TYPE, "PropertyType");
                PropertyType propType = (PropertyType)mdiProp.getRepositoryEntity();
                propType.setSQLType(12);
                mdiProp = this.createMetadataObject(propName, "Property");
                p = (Property)mdiProp.getRepositoryEntity();
                p.setOwningType(propType);
                properties.add((Object)p);
            }
            p.setDefaultValue(propValue);
        }
    }

    public AssociationList getPropertyTypes(Property property) throws RepositoryException, RemoteException {
        AssociationList a = null;
        if (property != null) {
            try {
                a = property.getOwningTypes(false);
                if (a == null || a.size() <= 0) {
                    a = property.getOwningTypes(true);
                }
            }
            catch (MdException e) {
                log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
                throw new RepositoryException(e, e.getMessage());
            }
            catch (RemoteException e) {
                throw new RepositoryException(e, e.getMessage());
            }
        }
        return a;
    }

    public AssociationList getSourceCodes(MetadataInterface mdi) throws RepositoryException, RemoteException {
        Transformation object = (Transformation)mdi.getRepositoryEntity();
        AssociationList a = null;
        try {
            a = object.getSourceCodes(false);
            if (a == null || a.size() <= 0) {
                a = object.getSourceCodes(true);
            }
        }
        catch (MdException e) {
            log.debug(RBUtil.getStringResource("OMRIDError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        return a;
    }

    public void close() {
        if (this.myContentResource != null) {
            if (this.myContentResource instanceof DAVResource) {
                log.info(RBUtil.getStringResource("OMRIDcloseConnection.txt"));
                DAVResource r = (DAVResource)this.myContentResource;
                try {
                    r.close();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            this.myContentResource = null;
        }
    }

    protected String getContentBasePath() {
        return this.myBasePath;
    }

    public void deleteProperty(MetadataInterface mdi, String propName) throws RepositoryException, RemoteException {
        AssociationList properties = this.getProperties(mdi);
        Property p = null;
        if (properties != null) {
            String s;
            Iterator propertyIterator = properties.iterator();
            while (propertyIterator.hasNext() && ((s = (p = (Property)propertyIterator.next()).getName()) == null || s.compareTo(propName) != 0)) {
                p = null;
            }
            if (p != null) {
                p.delete();
            }
        }
    }

    public void deleteTimestamp(MetadataInterface mdi, String timestampRole) throws RepositoryException, RemoteException {
        AssociationList vTimestampObjects = this.getTimestamps(mdi);
        for (Timestamp timestamp : vTimestampObjects) {
            String timestampName = timestamp.getTimestampRole();
            if (timestampRole.compareTo(timestampName) != 0) continue;
            timestamp.delete();
            break;
        }
    }

    static {
        log = LogManager.getLogger(OMRID.class);
    }

    static final class ContentInfo {
        private String myPath;
        private String myUserId;
        private String myPassword;

        public ContentInfo(String path, String userId, String password) {
            this.myPath = path;
            this.myUserId = userId;
            this.myPassword = password;
        }

        public String getPath() {
            return this.myPath;
        }

        public String getUserId() {
            return this.myUserId;
        }

        public String getPassword() {
            return this.myPassword;
        }
    }

    static class RootFolderFilter
    extends Filter {
        final String queryString = "<XMLSelect search=\"*[SoftwareComponents/*[@ClassIdentifier = 'E5F27790-2149-11D6-8828-AA0004006D06']]\"/>";

        RootFolderFilter() {
        }

        public String getXMLSelectString() {
            return "<XMLSelect search=\"*[SoftwareComponents/*[@ClassIdentifier = 'E5F27790-2149-11D6-8828-AA0004006D06']]\"/>";
        }
    }
}

