/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.EntryInstantiatorInterface;
import com.sas.report.repository.OMREntry;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import java.rmi.RemoteException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class OMRGeneralEntry
extends OMREntry
implements EntryInstantiatorInterface {
    private String _publicType = null;
    private String _transformRole = null;
    private double _usageVersion = 0.0;
    private static final Logger log = LogManager.getLogger(OMRGeneralEntry.class);

    public OMRGeneralEntry(OMRID omrRepositoryId) {
        super(omrRepositoryId);
        this._publicType = null;
    }

    public OMRGeneralEntry(OMRID omrRepositoryId, String publicType) {
        super(omrRepositoryId);
        if (this._publicType != null) {
            throw new IllegalArgumentException();
        }
        this._publicType = publicType;
    }

    public OMRGeneralEntry(OMRID omrRepositoryId, String publicType, String transformRole, double usageVersion) {
        super(omrRepositoryId);
        if (this._publicType != null) {
            throw new IllegalArgumentException();
        }
        this._publicType = publicType;
        if (this._transformRole != null) {
            throw new IllegalArgumentException();
        }
        this._transformRole = transformRole;
        if (this._usageVersion != 0.0) {
            throw new IllegalArgumentException();
        }
        this._usageVersion = usageVersion;
    }

    public OMRGeneralEntry(String entryName, OMRID omrRepositoryId, ContentInterface content) throws RepositoryException, RemoteException {
        super(entryName, omrRepositoryId, content);
    }

    public OMRGeneralEntry(MetadataInterface entryObject, OMRID omrRepositoryId, ContentInterface content) throws RepositoryException, RemoteException {
        super(entryObject, omrRepositoryId, content);
    }

    public OMRGeneralEntry(MetadataInterface mi, OMRID omrRepositoryId, ContentInterface content, String publicType, String transformRole, double inUsageVersion) throws RepositoryException, RemoteException {
        super(omrRepositoryId);
        this.setOMRID(omrRepositoryId);
        this.myContent = content;
        String name = mi.getName();
        log.debug(RBUtil.getStringResource("OMREntrygetName.notrans", (Object)mi, this.repositoryId.getRepositoryId()));
        try {
            MetadataInterface smartObj = this.repositoryId.createSmartObject(name, this.repositoryId.getOMIRepository(), publicType, transformRole, inUsageVersion);
            this.setMetadataObject(smartObj);
        }
        catch (RemoteException e) {
            log.error(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public OMRGeneralEntry(String entryName, String publicType, OMRID omrRepositoryId, ContentInterface content, OMIRepositoryInterface omiRepository) throws RepositoryException, RemoteException {
        super(entryName, publicType, omrRepositoryId, content, omiRepository);
        this.set_publicType(publicType);
        this.set_usageVersion(this.metadataObject.getUsageVersion().encode());
    }

    private void setOMRID(OMRID repositoryId) {
        this.repositoryId = repositoryId;
    }

    @Override
    public OMREntry create(String entryName, OMRID omrRepositoryId, ContentInterface ci) throws RepositoryException {
        this.setOMRID(omrRepositoryId);
        this.myContent = ci;
        log.debug(RBUtil.getStringResource("OMREntrygetName.notrans", (Object)entryName, this.repositoryId.getRepositoryId()));
        try {
            MetadataInterface smartObj = this.repositoryId.createSmartObject(entryName, this.repositoryId.getOMIRepository(), this._publicType, this._transformRole, this._usageVersion);
            this.setMetadataObject(smartObj);
        }
        catch (RemoteException e) {
            log.error(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        return this;
    }

    public String get_publicType() {
        return this._publicType;
    }

    public void set_publicType(String type) {
        this._publicType = type;
    }

    public String get_transformRole() {
        return this._transformRole;
    }

    public void set_transformRole(String role) {
        this._transformRole = role;
    }

    public double get_usageVersion() {
        return this._usageVersion;
    }

    public void set_usageVersion(double version) {
        this._usageVersion = version;
    }

    @Override
    public OMREntry get(String publicType, MetadataInterface entryObject, OMRID repositoryID, ContentInterface ci) throws RepositoryException {
        this.setOMRID(repositoryID);
        this.myContent = ci;
        this.setMetadataObject(entryObject);
        return this;
    }

    @Override
    public abstract boolean isValidType(String var1);

    @Override
    public abstract boolean isValidEntry();

    @Override
    public abstract String getImportFileName();

    @Override
    public boolean entryExists(String entryName, EntryInstantiatorInterface ei) throws RepositoryIllegalNameException, RepositoryException, SecurityException {
        return this.getName().equals(entryName);
    }
}

