/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.report.repository.AgingPolicy;
import com.sas.report.repository.Alert;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.ContentException;
import com.sas.report.repository.ContentFactory;
import com.sas.report.repository.ContentFileException;
import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.ContentNameNotFoundException;
import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.Entry;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.ImportedEntryInterface;
import com.sas.report.repository.OMRCacheSet;
import com.sas.report.repository.OMRDirectory;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.OMRReportEntry;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.ReportManagementCache;
import com.sas.report.repository.ReportTypeDescriptor;
import com.sas.report.repository.RepositoryBetweenRepositoriesException;
import com.sas.report.repository.RepositoryCreateException;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryFactory;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryInputStream;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryNotDirectoryException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.RepositoryOutputStream;
import com.sas.report.repository.RepositoryUtils;
import com.sas.report.repository.UserId;
import com.sas.services.ServiceException;
import com.sas.services.information.Factory;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.svcs.events.client.senders.LocalEventSender;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

class OMREntry
extends Entry
implements ImportedEntryInterface {
    private static final long TIMESTAMP_WINDOW_IN_MILLIS;
    private static final String COMMENT_TEXT_STORE_NAME = "###-COMMENT-ATTRIBUTE-###";
    private static final String NOT_TRANSIENT_PREFIX = "###-NOT-TRANSIENT-###";
    private static final int NOT_TRANSIENT_PREFIX_LENGTH;
    public static final long Report = 98L;
    public static final long ReportComponent = 99L;
    public static final long ReportImage = 100L;
    public static final long ReportBI = 106L;
    private CacheSetInterface myCacheSet;
    private RepositoryInputStream myEntryInputStream;
    private RepositoryOutputStream myEntryOutputStream;
    private long myLastModifiedUpdate;
    protected OMRID repositoryId;
    protected ContentInterface myContent;
    private static final Logger log;
    private int canWriteEntry = -1;
    private LocalEventSender sender;
    private boolean checkEventSender = true;

    protected OMREntry(OMRID omrRepositoryId) {
        log.debug("OMREntry(OMRID omrRepositoryId)");
        this.setOMRID(omrRepositoryId);
    }

    public OMREntry(String entryName, OMRID omrRepositoryId, ContentInterface content) throws RepositoryException, RemoteException {
        log.debug("OMREntry(String entryName, OMRID omrRepositoryId,");
        this.setOMRID(omrRepositoryId);
        this.myContent = content;
        log.debug(RBUtil.getStringResource("OMREntrygetName.notrans", (Object)entryName, this.repositoryId.getRepositoryId()));
        try {
            MetadataInterface smartObj = this.repositoryId.createReportSmartObject(entryName);
            this.setMetadataObject(smartObj);
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public OMREntry(String entryName, OMRID omrRepositoryId, ContentInterface content, OMIRepositoryInterface omiRepository) throws RepositoryException, RemoteException {
        log.debug("OMREntry(String entryName, OMRID omrRepositoryId");
        this.setOMRID(omrRepositoryId);
        this.myContent = content;
        log.debug(RBUtil.getStringResource("OMREntrygetName.notrans", (Object)entryName, this.repositoryId.getRepositoryId()));
        try {
            MetadataInterface smartObj = this.repositoryId.createReportSmartObject(entryName, omiRepository);
            this.setMetadataObject(smartObj);
        }
        catch (RemoteException e) {
            log.error(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public OMREntry(String entryName, String publicType, OMRID omrRepositoryId, ContentInterface content, OMIRepositoryInterface omiRepository) throws RepositoryException, RemoteException {
        log.debug(" OMREntry(String entryName, String publicType, OMRID omrRepositoryId,");
        this.setOMRID(omrRepositoryId);
        this.myContent = content;
        log.debug(RBUtil.getStringResource("OMREntrygetName.notrans", (Object)entryName, this.repositoryId.getRepositoryId()));
        try {
            MetadataInterface smartObj = this.repositoryId.createReportSmartObject(entryName, publicType, omiRepository);
            this.setMetadataObject(smartObj);
        }
        catch (RemoteException e) {
            log.error(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public OMREntry(MetadataInterface entryObject, OMRID omrRepositoryId, ContentInterface content) throws RepositoryException, RemoteException {
        log.debug("OMREntry(MetadataInterface entryObject, OMRID omrRepositoryId,");
        this.setOMRID(omrRepositoryId);
        this.myContent = content;
        if (entryObject instanceof OMRReportEntry) {
            log.debug("entryObject instance of OMRReportEntry -> " + entryObject.getClass().getName());
            this.setMetadataObject(entryObject);
        } else {
            ServerInterface server;
            Transformation omEntryObject = (Transformation)entryObject.getRepositoryEntity();
            log.debug("entryObject not instance of OMRReportEntry -> " + entryObject.getClass().getName());
            String role = omEntryObject.getTransformRole();
            if (role.equals("Report")) {
                try {
                    this.setMetadataObject(this.createReportEntrySmartObject(omEntryObject));
                }
                catch (RemoteException e) {
                    log.error(RBUtil.getStringResource("OMREntryError.txt", e));
                    throw new RepositoryException(e, e.getMessage());
                }
                catch (ServiceException e) {
                    log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
                    throw new RepositoryException(e, e.getMessage());
                }
            }
            String type = entryObject.getType();
            ArrayList<String> excludeTypes = new ArrayList<String>();
            excludeTypes.add("Report.StoredProcess");
            excludeTypes.add("InformationMap.OLAP");
            excludeTypes.add("InformationMap.Relational");
            excludeTypes.add("InformationMap");
            excludeTypes.add("StoredProcess");
            boolean setupMetadataObject = true;
            Iterator eT = excludeTypes.iterator();
            while (eT.hasNext()) {
                if (!type.contains(eT.next().toString())) continue;
                setupMetadataObject = false;
            }
            try {
                server = omrRepositoryId.getOMIRepository().getServer();
            }
            catch (ServiceException e) {
                log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
                throw new RepositoryException(e, e.getMessage());
            }
            Collection<String> allTypeNamesWithReportTypeDescriptor = ReportTypeDescriptor.getAllPublicTypes(server);
            if (allTypeNamesWithReportTypeDescriptor.contains(type) && setupMetadataObject) {
                try {
                    this.setMetadataObject(this.createReportEntrySmartObject(omEntryObject));
                }
                catch (ServiceException e) {
                    log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
                    throw new RepositoryException(e, e.getMessage());
                }
            } else {
                this.setMetadataObject(entryObject);
            }
        }
        log.debug(RBUtil.getStringResource("OMREntrygetName.notrans", (Object)this.getName(), this.repositoryId.getRepositoryId()));
    }

    private MetadataInterface createReportEntrySmartObject(Transformation trans) throws RemoteException, ServiceException, RepositoryException {
        try {
            OMRReportEntry reportEntry = (OMRReportEntry)Factory.getInstance().processWithRepository((Object)trans, (RepositoryInterface)this.repositoryId.getOMIRepository());
            reportEntry.setEntryInterface(this, this.repositoryId);
            return reportEntry;
        }
        catch (ClassCastException e) {
            throw new RepositoryException(e, RBUtil.getStringResource("OMREntrynoSmartObject.txt"));
        }
    }

    private void setOMRID(OMRID repositoryId) {
        this.repositoryId = repositoryId;
    }

    @Override
    public Iterator getAttributes() throws RepositoryException, SecurityException {
        return this.getAttributesAsMap().entrySet().iterator();
    }

    Map getAttributesAsMap() throws RepositoryException, SecurityException {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put("type", this.getAttribute("type"));
        attributeMap.put("description", this.getAttribute("description"));
        attributeMap.put("Comments", this.getAttribute("Comments"));
        attributeMap.put("Author", this.getAttribute("Author"));
        attributeMap.put("userids", this.getAttribute("userids"));
        attributeMap.put("locale", this.getAttribute("locale"));
        attributeMap.put("Creation Date", this.getAttribute("Creation Date"));
        attributeMap.put("Modified Date", this.getAttribute("Modified Date"));
        attributeMap.put("Reference Date", this.getAttribute("Reference Date"));
        MetadataInterface mdObj = (MetadataInterface)this.getMetadataObject();
        this.repositoryId.addUserDefinedAttributesToMap(attributeMap, mdObj);
        attributeMap.put("location", this.getLocation());
        attributeMap.put("name", this.getAttribute("name"));
        return attributeMap;
    }

    @Override
    public Object getAttribute(String attribName) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
        try {
            if (attribName.equals("name")) {
                String name = omEntryObject.getName();
                log.debug(RBUtil.getStringResource("OMREntrygetAttribute.notrans", (Object)name, (Object)attribName, name));
                return name;
            }
            if (attribName.equals("type")) {
                String type = this.getType_p();
                log.debug(RBUtil.getStringResource("OMREntrygetAttribute.notrans", (Object)this.getName(), (Object)attribName, type));
                return type;
            }
            if (attribName.equals("location")) {
                String location = this.getLocation();
                log.debug(RBUtil.getStringResource("OMREntrygetAttribute.notrans", (Object)this.getName(), (Object)attribName, location));
                return location;
            }
            if (attribName.equals("description")) {
                String description = omEntryObject.getDescription();
                log.debug(RBUtil.getStringResource("OMREntrygetAttribute.notrans", (Object)this.getName(), (Object)attribName, description));
                return description;
            }
            if (attribName.equals("Comments")) {
                String theComments = this.getNote(COMMENT_TEXT_STORE_NAME);
                if (theComments == null) {
                    theComments = "";
                }
                log.debug(RBUtil.getStringResource("OMREntrygetAttribute.notrans", (Object)this.getName(), (Object)attribName, theComments));
                return theComments;
            }
            if (attribName.equals("Author")) {
                String author = omEntryObject.getModifiedBy();
                log.debug(RBUtil.getStringResource("OMREntrygetAttribute.notrans", (Object)this.getName(), (Object)attribName, author));
                return author;
            }
            if (attribName.equals("Modified By")) {
                String author = omEntryObject.getModifiedBy();
                log.debug(RBUtil.getStringResource("OMREntrygetAttribute.notrans", (Object)this.getName(), (Object)attribName, author));
                return author;
            }
            if (attribName.equals("Created By")) {
                String author = omEntryObject.getCreatedBy();
                log.debug(RBUtil.getStringResource("OMREntrygetAttribute.notrans", (Object)this.getName(), (Object)attribName, author));
                return author;
            }
            if (attribName.equals("userids")) {
                List userIds = this.getUserIds_p();
                log.debug(RBUtil.getStringResource("OMREntrygetAttribute.notrans", (Object)this.getName(), (Object)attribName, userIds));
                return userIds;
            }
            if (attribName.equals("locale")) {
                String locale = this.getLocale_p();
                log.debug(RBUtil.getStringResource("OMREntrygetAttribute.notrans", (Object)this.getName(), (Object)attribName, locale));
                return locale;
            }
            if (attribName.equals("Creation Date")) {
                Date d = omEntryObject.getCreateDate();
                log.debug(RBUtil.getStringResource("OMREntrygetAttribute.notrans", (Object)this.getName(), (Object)attribName, d.toString()));
                return d;
            }
            if (attribName.equals("Modified Date")) {
                Date d = omEntryObject.getModifyDate();
                log.debug(RBUtil.getStringResource("OMREntrygetAttribute.notrans", (Object)this.getName(), (Object)attribName, d.toString()));
                return d;
            }
            if (attribName.equals("MetadataUpdated")) {
                String _metadataUpdated = this.getMetadataUpdated();
                log.debug(RBUtil.getStringResource("OMREntrygetAttribute.notrans", (Object)this.getName(), (Object)attribName, _metadataUpdated));
                return _metadataUpdated;
            }
            if (attribName.equals("Reference Date")) {
                Date d = omEntryObject.getModifyDate();
                log.debug(RBUtil.getStringResource("OMREntrygetAttribute.notrans", (Object)this.getName(), (Object)attribName, d.toString()));
                return d;
            }
            if (attribName.equals("keywords")) {
                return this.getKeywords();
            }
            Object value = this.repositoryId.getUserDefinedProperty(omEntryObject, attribName);
            if (value == null) {
                throw new RepositoryNotFoundException(RBUtil.getStringResource("OMREntryattributeNotFound.txt", attribName));
            }
            return value;
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributes(Map attributes) throws RepositoryException {
        Set attributeSet = attributes.entrySet();
        try {
            for (Map.Entry mapEntry : attributeSet) {
                this.setAttribute_p((String)mapEntry.getKey(), mapEntry.getValue());
            }
        }
        finally {
            this.updateMetadataAll();
        }
    }

    @Override
    public void setAttribute(String attribName, Object value) throws RepositoryLockedException, RepositoryException, SecurityException {
        this.setAttribute_p(attribName, value);
        this.updateMetadataAll();
    }

    @Override
    public AgingPolicy getAgingPolicy() throws SecurityException {
        return null;
    }

    @Override
    public void setAgingPolicy(AgingPolicy agingPolicy) throws SecurityException, RepositoryLockedException {
    }

    @Override
    public Iterator getKeywords() throws RepositoryException, SecurityException {
        return this.getKeywordsAsList().iterator();
    }

    List getKeywordsAsList() throws RepositoryException, SecurityException {
        MetadataInterface entryObject = (MetadataInterface)this.getMetadataObject();
        try {
            return entryObject.getKeywords();
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public boolean isKeyword(String keywordValue) throws RepositoryException, SecurityException {
        Iterator keyIterator = this.getKeywords();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            if (keywordValue.compareTo(key) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setKeywords(List keywords) throws RepositoryLockedException, RepositoryException, SecurityException {
        this.removeAllKeywords_p();
        try {
            this.addKeywords(keywords);
        }
        catch (RepositoryDuplicateNameException ex) {
            throw new RepositoryException((Throwable)((Object)ex), ex.getMessage());
        }
    }

    @Override
    public void setKeyword(String keywordName, String keywordDescription) throws SecurityException, RepositoryLockedException, RepositoryException {
        throw new RepositoryException("setKeyword() is no longer supported");
    }

    @Override
    public void setKeyword(String keyword) throws RepositoryLockedException, RepositoryException, SecurityException {
        if (keyword == null || keyword.trim().length() == 0) {
            throw new IllegalArgumentException(RBUtil.getStringResource("OMREntryillegalKeywordName.txt"));
        }
        this.removeAllKeywords_p();
        this.addKeyword_p(keyword);
        this.updateMetadataAll();
    }

    @Override
    public void addKeywords(List keywords) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        for (String keywordValue : keywords) {
            if (Entry.isBlankString(keywordValue)) {
                throw new IllegalArgumentException(RBUtil.getStringResource("OMREntryillegalKeywordName.txt"));
            }
            this.addKeyword_p(keywordValue);
        }
        this.updateMetadataAll();
    }

    protected void generateEvent(String eventName, Map<String, Object> eventInfo) {
        if (this.sender == null && this.checkEventSender) {
            this.sender = Alert.getEventSender();
        }
        this.checkEventSender = false;
        if (this.sender != null) {
            try {
                MetadataInterface mi = (MetadataInterface)this.getMetadataObject();
                if (mi != null && !eventName.equals("SAS.Content.Deleted")) {
                    this.addMetadataInfo(mi, eventInfo);
                }
            }
            catch (ServiceException e) {
                log.warn(e.getMessage());
            }
            catch (RemoteException e) {
                log.warn(e.getMessage());
            }
            Alert.generateEvent(eventName, eventInfo);
        }
    }

    protected void addMetadataInfo(MetadataInterface mi, Map<String, Object> eventInfo) throws RemoteException, ServiceException {
        String typeName = mi.getType();
        eventInfo.put("objectId", mi.getGUID());
        eventInfo.put("objectId", mi.getReposKey());
        eventInfo.put("objectTypeName", typeName);
        eventInfo.put("objectTypeId", this.getObjectId(typeName));
        eventInfo.put("modifiedDate", mi.getModifyDate().toString());
        eventInfo.put("createdBy", mi.getCreatedBy());
        eventInfo.put("createdDate", mi.getCreateDate().toString());
        eventInfo.put("modifiedBy", mi.getModifiedBy());
    }

    private long getObjectId(String type) {
        if (type.equals("Report.BI")) {
            return 106L;
        }
        if (type.equals("Report")) {
            return 98L;
        }
        if (type.equals("Report.image")) {
            return 100L;
        }
        if (type.equals("Report.component")) {
            return 99L;
        }
        return 0L;
    }

    @Override
    public void addKeyword(String keywordName) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        if (keywordName == null || keywordName.trim().length() == 0) {
            throw new IllegalArgumentException(RBUtil.getStringResource("OMREntryillegalKeywordName.txt"));
        }
        this.addKeyword_p(keywordName);
    }

    @Override
    public void addKeyword(String keywordName, String keywordDescription) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new RepositoryException("setKeyword() is no longer supported");
    }

    @Override
    public void removeKeyword(String keywordValue) throws RepositoryLockedException, RepositoryException, SecurityException {
        this.removeKeyword_p(keywordValue);
        this.updateMetadataAll();
    }

    @Override
    public void removeAllKeywords() throws RepositoryLockedException, RepositoryException, SecurityException {
        this.removeAllKeywords_p();
        this.updateMetadataAll();
    }

    @Override
    public String getContentLocation() throws RepositoryException {
        try {
            PathUrl sbipLocationUrl = this.getLocationUrl();
            String contentLocation = null;
            if (sbipLocationUrl != null) {
                contentLocation = this.repositoryId.resolveName(sbipLocationUrl);
            }
            return contentLocation;
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public InputStream getInputStream() throws RepositoryIOException, SecurityException {
        InputStream iStream = this.getInputStream_p();
        if (iStream == null) {
            if (this.myEntryInputStream != null) {
                try {
                    this.myEntryInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.myEntryInputStream = null;
            }
            iStream = this.getInputStream_p();
        }
        return iStream;
    }

    private InputStream getInputStream_p() throws RepositoryIOException, SecurityException {
        String name = this.getName();
        log.debug(RBUtil.getStringResource("OMREntryinputStream.notrans", name));
        InputStream iStream = null;
        if (this.myContent != null && (this.myEntryInputStream == null || this.myEntryInputStream.isClosed())) {
            try {
                PathUrl pathUrl;
                try {
                    pathUrl = this.getLocationUrl();
                }
                catch (RepositoryException e) {
                    throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
                }
                String type = pathUrl.getType();
                StringBuffer buf = new StringBuffer();
                buf.append(name);
                if (type != null) {
                    buf.append("(").append(type).append(")");
                }
                String nameAndType = buf.toString();
                iStream = this.getRepositoryInputStream(this.myContent.get(nameAndType));
            }
            catch (ContentFileException e) {
                throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
            }
            catch (ContentNameNotFoundException e) {
                throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
            }
            catch (ContentException e) {
                throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
            }
        }
        return iStream;
    }

    protected InputStream getRepositoryInputStream(InputStream iStream) {
        this.myEntryInputStream = new RepositoryInputStream(iStream);
        return this.myEntryInputStream;
    }

    @Override
    public OutputStream getOutputStream(boolean deleteCaches) throws RepositoryIOException, SecurityException {
        if (!this.canWrite()) {
            throw new SecurityException();
        }
        if (this.myContent != null && (this.myEntryOutputStream == null || this.myEntryOutputStream.isClosed())) {
            String name = this.getName();
            String nameAndType = null;
            try {
                PathUrl pathUrl;
                try {
                    pathUrl = this.getLocationUrl();
                }
                catch (RepositoryException e) {
                    throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
                }
                if (pathUrl == null) {
                    throw new RepositoryIOException(RBUtil.getStringResource("OMREntryNullPathUrl.fmt.txt", name));
                }
                String type = pathUrl.getType();
                StringBuffer buf = new StringBuffer();
                buf.append(name);
                if (type != null) {
                    buf.append("(").append(type).append(")");
                }
                nameAndType = buf.toString();
                this.myEntryOutputStream = new RepositoryOutputStream(this.myContent.write(nameAndType));
                log.debug(RBUtil.getStringResource("OMREntryoutputStream.notrans", nameAndType));
            }
            catch (ContentFileException ex) {
                throw new RepositoryIOException((Throwable)((Object)ex), ex.getMessage());
            }
            catch (ContentException ex) {
                throw new RepositoryIOException((Throwable)((Object)ex), ex.getMessage());
            }
        }
        this.updateLastModifiedTime();
        if (deleteCaches) {
            try {
                this.getCacheSetInterface().deleteTransient();
            }
            catch (RepositoryException e) {
                throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
            }
            try {
                this.deleteTransientApplicationData();
            }
            catch (Exception e) {
                throw new RepositoryIOException(e, e.getMessage());
            }
        }
        return this.myEntryOutputStream;
    }

    @Override
    public void deleteTransientData() throws RepositoryIOException {
        try {
            this.deleteTransientApplicationData();
        }
        catch (Exception e) {
            throw new RepositoryIOException(e, e.getMessage());
        }
    }

    private void deleteTransientApplicationData() throws RepositoryException, RemoteException, ServiceException {
        ArrayList<TextStore> objectsToDelete = new ArrayList<TextStore>();
        AssociationList notesList = this.getNotesList();
        for (Object obj : notesList) {
            if (!(obj instanceof TextStore)) continue;
            TextStore textStore = (TextStore)obj;
            String key = textStore.getName();
            String storedText = textStore.getStoredText();
            boolean persist = storedText.startsWith(NOT_TRANSIENT_PREFIX) || key.equals(COMMENT_TEXT_STORE_NAME);
            if (persist) continue;
            objectsToDelete.add(textStore);
        }
        OMIRepositoryInterface omiRepos = this.repositoryId.getOMIRepository();
        omiRepos.deleteEntities(objectsToDelete);
    }

    @Override
    public EntryInterface getGeneration(long generation) throws RepositoryNotFoundException, SecurityException {
        return null;
    }

    @Override
    public void age(long generationIncrement) throws SecurityException {
    }

    @Override
    public EntryInterface createEntry(String entryName) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, SecurityException {
        throw new RepositoryNotDirectoryException(RBUtil.getStringResource("OMREntrynotDir.txt", this.getName()));
    }

    @Override
    public EntryInterface createEntry(String entryName, AgingPolicy agingPolicy) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, SecurityException {
        throw new RepositoryNotDirectoryException(RBUtil.getStringResource("OMREntrynotDir.txt", this.getName()));
    }

    @Override
    public EntryInterface createEntry(Object entryMetadataObject) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new RepositoryNotDirectoryException(RBUtil.getStringResource("OMREntrynotDir.txt", this.getName()));
    }

    @Override
    public boolean entryExists(String entryName) throws RepositoryIllegalNameException, RepositoryException, SecurityException {
        return this.getName().equals(entryName);
    }

    @Override
    public EntryInterface getEntry(String entryName) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException {
        int openParenNdx = entryName.lastIndexOf("(");
        if (openParenNdx > -1) {
            int len = entryName.length();
            String type = entryName.substring(openParenNdx + 1, len - 1);
            if (type.equals("Report")) {
                entryName = entryName.substring(0, openParenNdx);
            } else {
                throw new RepositoryNotFoundException(RBUtil.getStringResource("OMREntrynotFound.txt", entryName));
            }
        }
        if (entryName.equals(this.getName())) {
            log.debug(RBUtil.getStringResource("OMREntrygetEntry.notrans", this.toString()));
            return this;
        }
        throw new RepositoryNotFoundException(RBUtil.getStringResource("OMREntrynotFound.txt", entryName));
    }

    @Override
    public boolean isEmpty() throws RepositoryException {
        boolean there = false;
        if (this.myContent != null) {
            String nameWithType = this.getNameWithType();
            try {
                there = !this.myContent.exists(nameWithType);
            }
            catch (ContentException e) {
                throw new RepositoryException((Throwable)((Object)e), e.getMessage());
            }
        }
        return there;
    }

    @Override
    public EntryInterface getEntry(String entryName, long generation) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException {
        if (entryName.equals(this.getName())) {
            log.debug(RBUtil.getStringResource("OMREntrygetEntry.notrans", this.toString()));
            return this;
        }
        throw new RepositoryNotFoundException(RBUtil.getStringResource("OMREntrynotFound.txt", entryName));
    }

    @Override
    public void renameTo(String newName) throws RepositoryIllegalNameException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        String oldName;
        OMRDirectory srcParentDirectory;
        block24: {
            srcParentDirectory = null;
            oldName = null;
            this.refresh();
            Entry.validateName(newName);
            srcParentDirectory = (OMRDirectory)this.getParentEntry();
            String typeSuffix = srcParentDirectory.getKnownTypeSuffix(newName);
            if (typeSuffix == null) {
                MetadataInterface srcEntryObject = (MetadataInterface)this.getMetadataObject();
                try {
                    typeSuffix = srcEntryObject.getType();
                    int subTypeSuffix = typeSuffix.lastIndexOf(46);
                    if (subTypeSuffix > 0) {
                        typeSuffix = typeSuffix.substring(0, subTypeSuffix);
                    }
                    if (srcParentDirectory.entryExists(newName + "(" + typeSuffix + ")")) {
                        throw new RepositoryDuplicateNameException(RBUtil.getStringResource("OMREntryexists.txt", newName));
                    }
                    break block24;
                }
                catch (RemoteException e) {
                    throw new RepositoryException(e, e.getMessage());
                }
            }
            if (srcParentDirectory.entryExists(newName)) {
                throw new RepositoryDuplicateNameException(RBUtil.getStringResource("OMREntryexists.txt", newName));
            }
        }
        try {
            if (!srcParentDirectory.canWrite()) {
                throw new RepositoryCreateException(RBUtil.getStringResource("OMREntrynoWriteMetadata.txt"));
            }
        }
        catch (SecurityException e) {
            throw (RepositoryCreateException)((Object)new RepositoryCreateException(e.getMessage()).initCause(e));
        }
        try {
            if (!this.canWrite()) {
                throw new RepositoryCreateException(RBUtil.getStringResource("OMREntrynoWriteMetadata.txt"));
            }
        }
        catch (SecurityException e) {
            throw (RepositoryCreateException)((Object)new RepositoryCreateException(e.getMessage()).initCause(e));
        }
        try {
            oldName = this.getName();
            String oldLocation = this.getLocation();
            PathUrl oldLocationUrl = this.getLocationUrl();
            this.setName(newName);
            this.invalidatePathUrl();
            String location = this.getLocation();
            PathUrl locationUrl = this.getLocationUrl();
            String oldContentLocation = this.repositoryId.resolveName(oldLocationUrl);
            String newContentLocation = this.repositoryId.resolveName(locationUrl);
            String oldNameAndType = this.getNameWithType(oldContentLocation);
            String newNameAndType = this.getNameWithType(newContentLocation);
            boolean contentRenamed = false;
            if (this.myContent != null && oldContentLocation.length() > 0 && !oldContentLocation.equals(newContentLocation)) {
                try {
                    if (this.myContent.exists(oldNameAndType)) {
                        this.myContent.renameTo(oldNameAndType, newNameAndType);
                        contentRenamed = true;
                    }
                }
                catch (ContentException ee) {
                    throw new RepositoryException((Throwable)((Object)ee), ee.getMessage());
                }
            }
            OMRCacheSet cs = (OMRCacheSet)this.getCacheSetInterface();
            cs.rename(oldNameAndType, newNameAndType);
            ReportManagementCache cache = this.repositoryId.getCache();
            cache.remove(oldLocation);
            cache.put(location, this);
            try {
                this.updateMetadataAll();
                HashMap<String, Object> eventInfo = new HashMap<String, Object>();
                eventInfo.put("name", oldName);
                eventInfo.put("path", this.getParent());
                eventInfo.put("newName", newName);
                this.generateEvent("SAS.Content.Renamed", eventInfo);
            }
            catch (RepositoryException e) {
                log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
                cache.remove(location);
                cache.put(oldLocation, this);
                cs.rename(newNameAndType, oldNameAndType);
                if (contentRenamed) {
                    try {
                        this.myContent.renameTo(newNameAndType, oldNameAndType);
                    }
                    catch (ContentException ee) {
                        throw new RepositoryException((Throwable)((Object)ee), ee.getMessage());
                    }
                }
                this.setName(oldName);
                this.invalidatePathUrl();
                throw e;
            }
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (Exception e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public void moveTo(EntryInterface destEntry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        this.refresh();
        FolderInterface destParentFolder = null;
        FolderInterface srcParentFolder = null;
        MetadataInterface destEntryObject = (MetadataInterface)destEntry.getMetadataObject();
        MetadataInterface srcEntryObject = (MetadataInterface)this.getMetadataObject();
        OMRDirectory destParentDirectory = null;
        OMRDirectory srcParentDirectory = null;
        PathUrl destPathUrl = null;
        PathUrl srcPathUrl = null;
        String destLocation = null;
        String destName = null;
        String destPathNameAndType = null;
        String srcLocation = null;
        String srcName = null;
        String srcPathNameAndType = null;
        String srcNameAndType = null;
        boolean destIsADir = destEntry.isDirectory();
        try {
            srcName = srcEntryObject.getName();
            String srcType = srcEntryObject.getType();
            if (srcType != null) {
                srcNameAndType = srcName + "(" + srcType + ")";
                int subType = srcType.lastIndexOf(".");
                if (subType > 0) {
                    srcNameAndType = srcName + "(" + srcType.substring(0, subType) + ")";
                }
            }
            if ((srcPathUrl = srcEntryObject.getPathUrl()) == null) {
                throw new RepositoryNotFoundException(RBUtil.getStringResource("OMREntryNullPathUrl.fmt.txt", srcName));
            }
            srcLocation = srcPathUrl.toString();
            srcPathNameAndType = this.getPathNameWithType(srcPathUrl);
            if (destIsADir) {
                destName = srcName;
                destPathUrl = this.buildPathUrl(destEntryObject, destName, srcPathUrl.getType());
                destLocation = destPathUrl.toString();
            } else {
                destPathUrl = destEntryObject.getPathUrl();
            }
            destLocation = destPathUrl.toString();
            destName = destPathUrl.getName();
            destPathNameAndType = this.getPathNameWithType(destPathUrl);
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        srcParentDirectory = (OMRDirectory)this.getParentEntry();
        srcParentFolder = (FolderInterface)srcParentDirectory.getMetadataObject();
        if (srcLocation == null || srcLocation.length() <= 0) {
            throw new RepositoryIllegalNameException(RBUtil.getStringResource("OMREntrysourceNull.txt"));
        }
        destParentDirectory = destIsADir ? (OMRDirectory)destEntry : (OMRDirectory)destEntry.getParentEntry();
        try {
            if (!destParentDirectory.canWrite()) {
                throw new RepositoryCreateException(RBUtil.getStringResource("OMREntrynoWriteMetadata.txt"));
            }
        }
        catch (SecurityException e) {
            RepositoryCreateException ex = new RepositoryCreateException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        destParentFolder = (FolderInterface)destParentDirectory.getMetadataObject();
        if (destLocation == null || destLocation.length() <= 0) {
            throw new RepositoryIllegalNameException(RBUtil.getStringResource("OMREntrydestNull.txt"));
        }
        if (srcLocation.equals(destLocation)) {
            throw new RepositoryException(RBUtil.getStringResource("OMREntrydestSourceSame.txt"));
        }
        if (!RepositoryUtils.sameRepository((MetadataInterface)destParentFolder, (MetadataInterface)srcParentFolder)) {
            throw new RepositoryBetweenRepositoriesException(RBUtil.getStringResource("OMREntrymoveTonotSupported.txt"));
        }
        ReportManagementCache cache = this.repositoryId.getCache();
        if (destIsADir) {
            if (destParentDirectory.entryExists(srcNameAndType)) {
                throw new RepositoryDuplicateNameException(RBUtil.getStringResource("OMREntryexists.txt", srcName));
            }
        } else if (destName.equals(srcName)) {
            destEntry.delete();
        } else {
            throw new RepositoryException(RBUtil.getStringResource("OMREntrymoveToWithRename.txt", (Object)srcName, destName));
        }
        try {
            srcParentFolder.removeItem(srcEntryObject);
            ContentInterface srcRoot = this.getRootContent(srcPathUrl);
            ContentInterface destRoot = this.getRootContent(destPathUrl);
            boolean contentMoved = false;
            try {
                srcRoot.moveTo(srcPathNameAndType, destRoot, destPathNameAndType);
                contentMoved = true;
            }
            catch (ContentNameNotFoundException e) {
                try {
                    String srcPathName = this.getPathName(srcPathUrl);
                    srcRoot.moveTo(srcPathName, destRoot, destPathNameAndType);
                    contentMoved = true;
                }
                catch (ContentNameNotFoundException srcPathName) {
                    // empty catch block
                }
                log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            }
            ContentInterface oldContent = this.myContent;
            this.myContent = this.getNewContentInterface(destParentDirectory.getLocationUrl());
            destParentFolder.addItem(srcEntryObject);
            if (!destIsADir) {
                OMREntry omrEntry = (OMREntry)destEntry;
                omrEntry.setMetadataObject(srcEntryObject);
                omrEntry.forceCacheSetRefresh();
            }
            OMRCacheSet cs = (OMRCacheSet)this.getCacheSetInterface();
            cs.move(srcRoot, srcPathNameAndType, destRoot, destPathNameAndType);
            cache.remove(srcLocation);
            cache.put(destLocation, this);
            this.invalidatePathUrl();
            try {
                this.updateMetadataAll();
                HashMap<String, Object> eventInfo = new HashMap<String, Object>();
                eventInfo.put("name", this.getName());
                eventInfo.put("path", srcParentDirectory.getLocation());
                eventInfo.put("newName", destName);
                eventInfo.put("newPath", destParentDirectory.getLocation());
                this.generateEvent("SAS.Content.Moved", eventInfo);
            }
            catch (RepositoryException e) {
                log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
                cache.remove(destLocation);
                cache.put(srcLocation, this);
                cs.move(destRoot, destPathNameAndType, srcRoot, srcPathNameAndType);
                this.myContent = oldContent;
                if (contentMoved) {
                    try {
                        destRoot.moveTo(destPathNameAndType, srcRoot, srcPathNameAndType);
                    }
                    catch (ContentException ee) {
                        throw new RepositoryException((Throwable)((Object)ee), ee.getMessage());
                    }
                }
                if (!destIsADir) {
                    OMREntry omrEntry = (OMREntry)destEntry;
                    omrEntry.setMetadataObject(destEntryObject);
                    omrEntry.forceCacheSetRefresh();
                }
                throw e;
            }
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ContentException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        log.debug(RBUtil.getStringResource("OMREntrymoveTo.notrans", (Object)srcPathNameAndType, destPathNameAndType));
    }

    @Override
    public void refresh() {
        MetadataInterface mdObj = (MetadataInterface)this.getMetadataObject();
        if (mdObj != null) {
            try {
                mdObj.refresh();
            }
            catch (Exception e) {
                log.warn("Error.txt", (Throwable)e);
            }
        }
        this.myCacheSet = null;
    }

    private ContentInterface getNewContentInterface(PathUrl pathUrl) throws RepositoryException {
        try {
            String contentLocation = this.repositoryId.resolveName(pathUrl);
            if (contentLocation != null && contentLocation.length() != 0) {
                OMRID.ContentInfo contentInfo = this.repositoryId.getContentInfo(pathUrl);
                String userId = contentInfo.getUserId();
                String pw = contentInfo.getPassword();
                return ContentFactory.create(this.repositoryId, contentLocation, userId, pw);
            }
            return null;
        }
        catch (ContentException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public void copyTo(EntryInterface destEntry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        this.copyEntry(destEntry, true);
    }

    @Override
    public void copyWithoutCaches(EntryInterface destEntry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        this.copyEntry(destEntry, false);
    }

    @Override
    public void delete() throws RepositoryLockedException, RepositoryException, SecurityException {
        this.delete_p(false);
    }

    private void delete_p(boolean retryInProgress) throws RepositoryLockedException, RepositoryException, SecurityException {
        MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
        if (omEntryObject == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            try {
                log.debug(RBUtil.getStringResource("OMREntrygetDelete.notrans", omEntryObject.getName()));
            }
            catch (Exception e) {
                log.debug(RBUtil.getStringResource("OMREntryError.notrans", e));
            }
        }
        this.refresh();
        if (this.myEntryInputStream != null && this.myEntryInputStream.isOpen()) {
            throw new RepositoryLockedException(RBUtil.getStringResource("OMREntryreading.txt"));
        }
        if (this.myEntryOutputStream != null && this.myEntryOutputStream.isOpen()) {
            throw new RepositoryLockedException(RBUtil.getStringResource("OMREntrywriting.txt"));
        }
        ReportManagementCache cache = this.repositoryId.getCache();
        String location = this.getLocation();
        boolean ableToWrite = false;
        try {
            ableToWrite = this.canWrite();
        }
        catch (SecurityException e) {
            if (retryInProgress) {
                throw e;
            }
            cache.remove(location);
            DirectoryInterface parentDir = (DirectoryInterface)this.getParentEntry();
            String name = this.getName();
            OMREntry entry = (OMREntry)parentDir.getEntry(name);
            entry.delete_p(true);
            return;
        }
        if (!ableToWrite) {
            throw new RepositoryException(RBUtil.getStringResource("OMREntrynoWriteMetadata.txt"));
        }
        try {
            String dName = omEntryObject.getName();
            String dPath = omEntryObject.getParent().toString();
            String dID = omEntryObject.getReposKey();
            this.repositoryId.findTransformationAndAssociations(omEntryObject);
            ArrayList<Object> objectsToDelete = new ArrayList<Object>();
            objectsToDelete.addAll((Collection<Object>)this.repositoryId.getNotes(omEntryObject, false));
            objectsToDelete.addAll((Collection<Object>)this.repositoryId.getTimestamps(omEntryObject));
            AssociationList propList = this.repositoryId.getProperties(omEntryObject);
            objectsToDelete.addAll((Collection<Object>)propList);
            for (Property property : propList) {
                objectsToDelete.addAll((Collection<Object>)this.repositoryId.getPropertyTypes(property));
            }
            objectsToDelete.addAll((Collection<Object>)this.repositoryId.getKeywords(omEntryObject, false));
            Object jomaObject = omEntryObject.getRepositoryEntity();
            objectsToDelete.add(jomaObject);
            OMRCacheSet cacheSet = (OMRCacheSet)this.getCacheSetInterface();
            cacheSet.setAllowMetadataWrites(false);
            cacheSet.deleteAll();
            try {
                RepositoryFactory.markForDeletion(jomaObject);
            }
            catch (Exception e) {
                log.warn(RBUtil.getStringResource("OMREntrymarkForDeletionFailed.txt", e));
            }
            OMIRepositoryInterface omiRepos = this.repositoryId.getOMIRepository();
            omiRepos.deleteEntities(objectsToDelete);
            cache.remove(location);
            this.setMetadataObject(null);
            this.deleteContent_p(location);
            HashMap<String, Object> eventInfo = new HashMap<String, Object>();
            eventInfo.put("name", dName);
            eventInfo.put("path", dPath);
            eventInfo.put("modifiedDate", new Date().toString());
            eventInfo.put("objectId", dID);
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            Object principalUser = null;
            if (auth != null && (principalUser = SecurityContextHolder.getContext().getAuthentication().getPrincipal()) != null) {
                eventInfo.put("modifiedBy", principalUser.toString());
            }
            this.generateEvent("SAS.Content.Deleted", eventInfo);
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public void deleteContent() throws RepositoryLockedException, RepositoryException {
        MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
        if (omEntryObject == null) {
            return;
        }
        String location = this.getLocation();
        this.deleteContent_p(location);
    }

    private void deleteContent_p(String location) throws RepositoryLockedException, RepositoryException {
        block10: {
            if (this.myEntryInputStream != null && this.myEntryInputStream.isOpen()) {
                throw new RepositoryLockedException(RBUtil.getStringResource("OMREntryreading.txt"));
            }
            if (this.myEntryOutputStream != null && this.myEntryOutputStream.isOpen()) {
                throw new RepositoryLockedException(RBUtil.getStringResource("OMREntrywriting.txt"));
            }
            if (this.myContent != null && location != null) {
                try {
                    String nameWithType = this.getNameWithType(location);
                    try {
                        this.myContent.delete(nameWithType);
                    }
                    catch (ContentNameNotFoundException ex) {
                        int lastOpenParen = nameWithType.lastIndexOf(40);
                        if (lastOpenParen > 0) {
                            this.myContent.delete(nameWithType.substring(0, lastOpenParen));
                            break block10;
                        }
                        throw ex;
                    }
                }
                catch (ContentNameNotFoundException nameWithType) {
                }
                catch (ContentFileException e) {
                    throw new RepositoryException((Throwable)((Object)e), e.getMessage());
                }
                catch (ContentException e) {
                    throw new RepositoryException((Throwable)((Object)e), e.getMessage());
                }
            }
        }
    }

    @Override
    public void delete(long generation) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new RepositoryException(RBUtil.getStringResource("OMREntrydeleteNoThereYet.txt"));
    }

    @Override
    public String getParent() throws RepositoryNotFoundException, RepositoryException, SecurityException {
        EntryInterface parentEntry = this.getParentEntry();
        return parentEntry.toString();
    }

    @Override
    public EntryInterface getParentEntry() throws RepositoryNotFoundException, RepositoryException, SecurityException {
        FolderInterface parentFolder = null;
        EntryInterface parentEntry = null;
        try {
            MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
            List parents = omEntryObject.getParents();
            if (parents.size() > 0) {
                parentFolder = (FolderInterface)parents.get(0);
                String key = parentFolder.getPathUrl().toString();
                ReportManagementCache cache = this.repositoryId.getCache();
                parentEntry = (EntryInterface)cache.get(key);
                if (parentEntry == null) {
                    parentEntry = new OMRDirectory(parentFolder, this.repositoryId);
                    cache.put(key, parentEntry);
                }
            }
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        log.debug(RBUtil.getStringResource("OMREntrygetParent.notrans", (Object)this.getName(), parentEntry));
        return parentEntry;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    public OMRID getOMRID() {
        return this.repositoryId;
    }

    @Override
    public CacheSetInterface getCacheSetInterface() throws RepositoryException {
        if (this.myCacheSet == null) {
            this.myCacheSet = new OMRCacheSet(this);
        }
        return this.myCacheSet;
    }

    private String getType_p() throws RepositoryException {
        MetadataInterface omEntry = (MetadataInterface)this.getMetadataObject();
        String t = null;
        try {
            t = this.repositoryId.getProperty(omEntry, "type");
            if (t == null) {
                Root r = (Root)omEntry.getRepositoryEntity();
                if (r instanceof Transformation) {
                    Transformation trans = (Transformation)r;
                    t = trans.getTransformRole();
                } else if (r instanceof ClassifierMap) {
                    ClassifierMap trans = (ClassifierMap)r;
                    t = trans.getTransformRole();
                }
            }
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        return t == null ? "" : t;
    }

    private void setType_p(String type) throws RepositoryException {
        if (type == null) {
            type = "";
        }
        try {
            this.repositoryId.setProperty((MetadataInterface)this.getMetadataObject(), "type", type);
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    private AssociationList getNotesList() throws RepositoryException {
        try {
            MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
            return this.repositoryId.getNotes(omEntryObject);
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    private TextStore getTextStore(AssociationList aList, String textStoreName) throws RepositoryException {
        try {
            TextStore retValue = null;
            for (Object obj : aList) {
                TextStore textStore;
                if (!(obj instanceof TextStore) || !textStoreName.equals((textStore = (TextStore)obj).getName())) continue;
                retValue = textStore;
                break;
            }
            return retValue;
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    private String getNote(String textStoreName) throws RepositoryException {
        String retValue = null;
        AssociationList notesList = this.getNotesList();
        TextStore textStore = this.getTextStore(notesList, textStoreName);
        if (textStore != null) {
            try {
                retValue = textStore.getStoredText();
            }
            catch (RemoteException e) {
                throw new RepositoryException(e, e.getMessage());
            }
        }
        return retValue;
    }

    private void setNote(String textStoreName, String textStoreValue) throws RepositoryException {
        AssociationList notesList = this.getNotesList();
        TextStore textStore = this.getTextStore(notesList, textStoreName);
        try {
            if (textStore != null) {
                if (textStoreValue == null) {
                    OMIRepositoryInterface repository = this.repositoryId.getOMIRepository();
                    repository.deleteEntity((CMetadata)textStore);
                } else {
                    textStore.setStoredText(textStoreValue);
                }
            } else if (textStoreValue != null) {
                MetadataInterface mdi = this.repositoryId.createMetadataObject(textStoreName, "TextStore");
                textStore = (TextStore)mdi.getRepositoryEntity();
                textStore.setStoredText(textStoreValue);
                textStore.setTextRole("Note");
                notesList.add((Object)textStore);
            }
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    private List getUserIds_p() throws RepositoryException {
        ArrayList<UserId> userIds = new ArrayList<UserId>();
        MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
        try {
            AssociationList authors = this.repositoryId.getResponsibleParties(omEntryObject);
            for (int i = 0; authors != null && i < authors.size(); ++i) {
                ResponsibleParty author = (ResponsibleParty)authors.get(i);
                AssociationList persons = this.repositoryId.getPersons(author);
                for (int j = 0; persons != null && j < persons.size(); ++j) {
                    Person person = (Person)persons.get(j);
                    AssociationList logins = this.repositoryId.getLogins(person);
                    for (int k = 0; logins != null && k < logins.size(); ++k) {
                        Login login = (Login)logins.get(k);
                        userIds.add(new UserId(person.getName(), login.getUserID()));
                    }
                }
            }
            return userIds;
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    private Iterator getAuthors_p(String role) throws RepositoryException {
        ArrayList<String> people = new ArrayList<String>();
        MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
        try {
            AssociationList authors = this.repositoryId.getResponsibleParties(omEntryObject);
            for (int i = 0; i < authors.size(); ++i) {
                ResponsibleParty possibleAuthor = (ResponsibleParty)authors.get(i);
                if (!possibleAuthor.getRole().equals(role)) continue;
                AssociationList persons = this.repositoryId.getPersons(possibleAuthor);
                for (int j = 0; j < persons.size(); ++j) {
                    Person person = (Person)persons.get(j);
                    people.add(person.getName());
                }
            }
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        return people.iterator();
    }

    private void setAuthors_p(String name) throws RepositoryException, SecurityException, RemoteException {
        MetadataInterface personMdObj;
        Person person = null;
        if (name.equals("##CURRENT USER##")) {
            try {
                person = this.repositoryId.getCurrentPersonObject();
            }
            catch (NullPointerException e) {
                name = this.repositoryId.getUserName();
            }
        }
        if (person == null && (personMdObj = this.repositoryId.findPerson(name)) != null) {
            person = (Person)personMdObj.getRepositoryEntity();
        }
        MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
        AssociationList rpListForReport = this.repositoryId.getResponsibleParties(omEntryObject);
        if (person == null) {
            this.removeResponsibleParties(rpListForReport);
        } else {
            AssociationList rpListForPerson = this.repositoryId.getResponsibilitiesForPerson(person);
            ResponsibleParty authorRP = this.getAuthorResponsibleParty(rpListForPerson);
            if (authorRP == null) {
                MetadataInterface mdiObj = this.repositoryId.createMetadataObject("Author", "ResponsibleParty");
                authorRP = (ResponsibleParty)mdiObj.getRepositoryEntity();
                authorRP.setRole("owner");
                rpListForPerson.add((Object)authorRP);
            } else if (rpListForReport.contains((Object)authorRP)) {
                return;
            }
            this.removeResponsibleParties(rpListForReport);
            rpListForReport.add((Object)authorRP);
        }
    }

    private void removeResponsibleParties(AssociationList rpListForReport) throws RemoteException, RepositoryException {
        for (ResponsibleParty oldRP : rpListForReport) {
            if (!oldRP.getRole().equals("owner")) continue;
            if (oldRP != null) {
                try {
                    AssociationList reportsForRP = this.repositoryId.getReportsForResponsibleParty(oldRP);
                    if (reportsForRP.size() <= 1) {
                        OMIRepositoryInterface omiRepos = this.repositoryId.getOMIRepository();
                        omiRepos.deleteEntity((CMetadata)oldRP);
                    }
                }
                catch (ServiceException e) {
                    log.warn("Error.notrans", (Throwable)e);
                }
            }
            rpListForReport.remove((Object)oldRP);
        }
    }

    private ResponsibleParty getAuthorResponsibleParty(AssociationList rpList) throws RemoteException {
        ResponsibleParty authorRP = null;
        Iterator rpIter = rpList.iterator();
        while (authorRP == null && rpIter.hasNext()) {
            ResponsibleParty rp = (ResponsibleParty)rpIter.next();
            if (rp == null || !"owner".equals(rp.getRole())) continue;
            authorRP = rp;
        }
        return authorRP;
    }

    private String getLocale_p() throws RepositoryException {
        String locale = null;
        try {
            this.repositoryId.getProperty((MetadataInterface)this.getMetadataObject(), "locale");
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        if (locale == null || locale.length() <= 0) {
            return "en_us";
        }
        return locale;
    }

    private void setLocale_p(String value) throws RepositoryException {
        try {
            this.repositoryId.setProperty((MetadataInterface)this.getMetadataObject(), "locale", value);
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    private boolean checkDuplicateName(String name) throws RepositoryException {
        MetadataInterface entryObject = (MetadataInterface)this.getMetadataObject();
        try {
            List parentList = entryObject.getParents();
            FolderInterface parentFolder = (FolderInterface)parentList.get(0);
            List subtrees = parentFolder.getSubfolders();
            for (MetadataInterface tree : subtrees) {
                if (!name.equals(tree.getName())) continue;
                return true;
            }
            List members = parentFolder.getItems();
            for (MetadataInterface member : members) {
                if (!name.equals(member.getName())) continue;
                return true;
            }
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        return false;
    }

    protected void addKeyword_p(String keywordName) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
        try {
            List keywords = omEntryObject.getKeywords();
            for (String keyword : keywords) {
                if (!keywordName.equals(keyword)) continue;
                log.debug(RBUtil.getStringResource("OMREntryduplicateKeywordName.txt", (Object)keywordName, omEntryObject.getName()));
                return;
            }
            omEntryObject.addKeyword(keywordName);
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    private void removeKeyword_p(String keywordValue) throws RepositoryLockedException, RepositoryException, SecurityException {
        MetadataInterface entryObject = (MetadataInterface)this.getMetadataObject();
        try {
            entryObject.removeKeyword(keywordValue);
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    private void removeAllKeywords_p() throws RepositoryLockedException, RepositoryException, SecurityException {
        MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
        try {
            List keywords = omEntryObject.getKeywords();
            Iterator it = keywords.iterator();
            while (it.hasNext()) {
                omEntryObject.removeKeyword((String)it.next());
            }
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    protected void setAttribute_p(String attribName, Object value) throws RepositoryLockedException, RepositoryException {
        MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
        try {
            if (attribName.equals("name")) {
                this.repositoryId.verifyStringType(attribName, value);
                log.debug(RBUtil.getStringResource("OMREntrysetAttribute.notrans", (Object)this.getName(), (Object)attribName, value));
                this.renameTo((String)value);
            } else {
                if (attribName.equals("location")) {
                    throw new IllegalArgumentException(RBUtil.getStringResource("OMREntryattributeReadonly.txt", attribName));
                }
                if (attribName.equals("type")) {
                    this.repositoryId.verifyStringType(attribName, value);
                    log.debug(RBUtil.getStringResource("OMREntrysetAttribute.notrans", (Object)this.getName(), (Object)attribName, value));
                    this.setType_p((String)value);
                } else if (attribName.equals("description")) {
                    this.repositoryId.verifyStringType(attribName, value);
                    log.debug(RBUtil.getStringResource("OMREntrysetAttribute.notrans", (Object)this.getName(), (Object)attribName, value));
                    omEntryObject.setDescription((String)value);
                } else if (attribName.equals("Comments")) {
                    this.repositoryId.verifyStringType(attribName, value);
                    log.debug(RBUtil.getStringResource("OMREntrysetAttribute.notrans", (Object)this.getName(), (Object)attribName, value));
                    this.setNote(COMMENT_TEXT_STORE_NAME, (String)value);
                } else if (attribName.equals("locale")) {
                    this.repositoryId.verifyStringType(attribName, value);
                    log.debug(RBUtil.getStringResource("OMREntrysetAttribute.notrans", (Object)this.getName(), (Object)attribName, value));
                    this.setLocale_p((String)value);
                } else if (attribName.equals("Author")) {
                    log.debug(RBUtil.getStringResource("OMREntrysetAttribute.notrans", (Object)this.getName(), (Object)attribName, value));
                } else if (attribName.equals("userids")) {
                    log.debug(RBUtil.getStringResource("OMREntrysetAttribute.notrans", (Object)this.getName(), (Object)attribName, value.toString()));
                } else if (!attribName.equals("Creation Date")) {
                    if (attribName.equals("Modified Date")) {
                        Date d = (Date)value;
                        log.debug(RBUtil.getStringResource("OMREntrysetAttribute.notrans", (Object)this.getName(), (Object)attribName, d.toString()));
                        try {
                            this.setMetadataUpdated();
                        }
                        catch (RemoteException e) {
                            log.error("setLastModDateFailed.txt", (Throwable)e);
                        }
                    } else if (!attribName.equals("Reference Date")) {
                        if (attribName.equals("keywords")) {
                            this.repositoryId.verifyListType(attribName, value);
                            List l = (List)value;
                            log.debug(RBUtil.getStringResource("OMREntrysetAttribute.notrans", (Object)this.getName(), (Object)attribName, l.toString()));
                            this.setKeywords(l);
                        } else {
                            this.repositoryId.setUserDefinedProperty(omEntryObject, attribName, value);
                        }
                    }
                }
            }
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    private void updateMetadataAll() throws RepositoryException {
        MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
        try {
            omEntryObject.update();
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    protected void copyEntry(EntryInterface destEntry, boolean copyCaches) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        boolean destIsADir;
        this.refresh();
        MetadataInterface destEntryObject = (MetadataInterface)destEntry.getMetadataObject();
        MetadataInterface srcEntryObject = (MetadataInterface)this.getMetadataObject();
        OMRDirectory destParentDirectory = null;
        PathUrl destPathUrl = null;
        PathUrl srcPathUrl = null;
        String destLocation = null;
        String destName = null;
        String destPathNameAndType = null;
        String srcLocation = null;
        String srcName = null;
        String srcPathNameAndType = null;
        String srcNameAndType = null;
        try {
            srcPathUrl = srcEntryObject.getPathUrl();
            srcLocation = srcPathUrl.toString();
            srcName = srcEntryObject.getName();
            String srcType = srcEntryObject.getType();
            if (srcType != null) {
                srcNameAndType = srcName + "(" + srcType + ")";
                int subType = srcType.lastIndexOf(".");
                if (subType > 0) {
                    srcNameAndType = srcName + "(" + srcType.substring(0, subType) + ")";
                }
            }
            srcPathNameAndType = this.getPathNameWithType(srcPathUrl);
            destIsADir = destEntry.isDirectory();
            destPathUrl = destIsADir ? this.buildPathUrl(destEntryObject, srcName, srcPathUrl.getType()) : destEntryObject.getPathUrl();
            destLocation = destPathUrl.toString();
            destName = destPathUrl.getName();
            destPathNameAndType = this.getPathNameWithType(destPathUrl);
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        if (srcLocation == null || srcLocation.length() <= 0) {
            throw new RepositoryIllegalNameException(RBUtil.getStringResource("OMREntrysourceNull.txt"));
        }
        destParentDirectory = destIsADir ? (OMRDirectory)destEntry : (OMRDirectory)destEntry.getParentEntry();
        if (destLocation == null || destLocation.length() <= 0) {
            throw new RepositoryIllegalNameException(RBUtil.getStringResource("OMREntrydestNull.txt"));
        }
        if (srcLocation.equals(destLocation)) {
            throw new RepositoryException(RBUtil.getStringResource("OMREntrydestSourceSame.txt"));
        }
        MetadataInterface destEntryObjectNew = null;
        try {
            destEntryObjectNew = this.repositoryId.cloneMetadataObject(srcEntryObject, (OMIRepositoryInterface)destEntryObject.getRepository());
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        if (destIsADir) {
            if (destParentDirectory.entryExists(srcNameAndType)) {
                throw new RepositoryDuplicateNameException(RBUtil.getStringResource("OMREntryexists.txt", srcName));
            }
        } else {
            destEntry.delete();
            try {
                destEntryObjectNew.setName(destName);
            }
            catch (RemoteException e) {
                log.debug(RBUtil.getStringResource("OMREntryError.notrans", e));
                throw new RepositoryException(e, e.getMessage());
            }
        }
        OMREntry destEntryNew = (OMREntry)destParentDirectory.createEntry(destEntryObjectNew);
        HashMap<String, Object> eventInfo = new HashMap<String, Object>();
        eventInfo.put("name", this.getName());
        eventInfo.put("path", srcLocation);
        eventInfo.put("newName", destEntryNew.getName());
        eventInfo.put("newPath", destParentDirectory.toString());
        this.generateEvent("SAS.Content.Copied", eventInfo);
        HashMap srcAttributeList = new HashMap();
        Iterator iterator = this.getAttributes();
        while (iterator.hasNext()) {
            Map.Entry mapEntry = (Map.Entry)iterator.next();
            String mapKey = (String)mapEntry.getKey();
            boolean skipThisAttribute = mapKey.equals("name") || mapKey.equals("location") || mapKey.equals("Comments") || mapKey.equals("Author") || mapKey.equals("##CACHE_NAME_LIST##") && !copyCaches;
            if (skipThisAttribute) continue;
            srcAttributeList.put(mapEntry.getKey(), mapEntry.getValue());
        }
        try {
            List srcKeywords = srcEntryObject.getKeywords();
            Iterator iter = srcKeywords.iterator();
            while (iter.hasNext()) {
                destEntryObjectNew.addKeyword((String)iter.next());
            }
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        try {
            AssociationList srcTextStores = this.repositoryId.getNotes(srcEntryObject);
            AssociationList destTextStores = this.repositoryId.getNotes(destEntryObjectNew);
            for (Object obj : srcTextStores) {
                if (!(obj instanceof TextStore)) continue;
                TextStore srcStore = (TextStore)obj;
                MetadataInterface mdObj = this.repositoryId.createMetadataObject((CMetadata)srcStore, (OMIRepositoryInterface)destEntryObject.getRepository());
                TextStore destStore = (TextStore)mdObj.getRepositoryEntity();
                destStore.setTextRole("Note");
                destTextStores.add(mdObj.getRepositoryEntity());
                destStore.setStoredText(srcStore.getStoredText());
            }
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        destEntryNew.setAttributes(srcAttributeList);
        try {
            ContentInterface srcRoot = this.getRootContent(srcPathUrl);
            ContentInterface destRoot = destEntryNew.getRootContent(destPathUrl);
            try {
                srcRoot.copyTo(srcPathNameAndType, destRoot, destPathNameAndType);
            }
            catch (ContentNameNotFoundException e) {
                try {
                    String srcPathName = this.getPathName(srcPathUrl);
                    srcRoot.copyTo(srcPathName, destRoot, destPathNameAndType);
                }
                catch (ContentNameNotFoundException contentNameNotFoundException) {
                    // empty catch block
                }
                log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            }
            if (copyCaches) {
                OMRCacheSet cs = (OMRCacheSet)this.getCacheSetInterface();
                cs.copy(srcRoot, srcPathNameAndType, destRoot, destPathNameAndType);
            }
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ContentException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        if (!destIsADir) {
            OMREntry omrEntry = (OMREntry)destEntry;
            omrEntry.setMetadataObject(destEntryNew.getMetadataObject());
            omrEntry.forceCacheSetRefresh();
        }
        log.debug(RBUtil.getStringResource("OMREntrycopyTo.notrans", (Object)srcPathNameAndType, destPathNameAndType));
    }

    private void forceCacheSetRefresh() {
        this.myCacheSet = null;
    }

    private boolean isValidReportType(MetadataInterface omEntryObject) throws RemoteException {
        String entryType = omEntryObject.getType();
        if (entryType.compareTo("Report") == 0) {
            return true;
        }
        return entryType.compareTo("Transformation") == 0;
    }

    private ContentInterface getRootContent(PathUrl pathUrl) throws RepositoryException, ContentException, RemoteException {
        pathUrl = (PathUrl)pathUrl.clone();
        pathUrl.setName(null);
        pathUrl.setPath(null);
        pathUrl.setType(null);
        String rootPath = this.repositoryId.resolveName(pathUrl);
        OMRID.ContentInfo contentInfo = this.repositoryId.getContentInfo(pathUrl);
        String userId = contentInfo.getUserId();
        String pw = contentInfo.getPassword();
        return ContentFactory.create(this.repositoryId, rootPath, userId, pw);
    }

    private PathUrl buildPathUrl(MetadataInterface mdObj, String name, String type) throws RemoteException, ServiceException {
        PathUrl newPathUrl = (PathUrl)mdObj.getPathUrl().clone();
        String newPath = newPathUrl.getName();
        String oldPath = newPathUrl.getPath();
        if (oldPath != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(oldPath).append("/").append(newPath);
            newPath = buf.toString();
        }
        newPathUrl.setPath(newPath);
        newPathUrl.setName(name);
        newPathUrl.setType(type);
        return newPathUrl;
    }

    @Override
    public boolean canWrite() throws SecurityException {
        MetadataInterface mdObj = (MetadataInterface)this.getMetadataObject();
        try {
            if (this.canWriteEntry == 1) {
                return true;
            }
            if (this.canWriteEntry == 0) {
                return false;
            }
            boolean retVal = mdObj.isAuthorized("WriteMetadata");
            this.canWriteEntry = retVal ? 1 : 0;
            return retVal;
        }
        catch (ServiceException e) {
            log.error("OMREntryError.notrans", (Throwable)e);
            throw (SecurityException)new SecurityException(e.getMessage()).initCause(e);
        }
        catch (RemoteException e) {
            log.error("OMREntryError.notrans", (Throwable)e);
            throw (SecurityException)new SecurityException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public long getSizeOfContent() throws RepositoryException {
        if (this.myContent == null) {
            throw new RepositoryException(RBUtil.getStringResource("OMREntrycontentNull.txt"));
        }
        String nameWithType = this.getNameWithType();
        try {
            return this.myContent.getSizeInBytes(nameWithType);
        }
        catch (Exception e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    void updateLastModifiedTime() {
        Date d;
        long now = System.currentTimeMillis();
        try {
            d = (Date)this.getAttribute("Modified Date");
        }
        catch (Exception e) {
            d = null;
        }
        if (d != null && d.getTime() > now - TIMESTAMP_WINDOW_IN_MILLIS) {
            return;
        }
        Date today = new Date(now);
        try {
            this.setAttribute_p("Modified Date", today);
            this.updateMetadataAll();
            HashMap<String, Object> eventInfo = new HashMap<String, Object>();
            eventInfo.put("name", this.getName());
            eventInfo.put("path", this.getParent());
            eventInfo.put("method", "updateLastModifiedTime()");
            this.generateEvent("SAS.Content.Changed", eventInfo);
            this.myLastModifiedUpdate = now;
        }
        catch (RepositoryException e) {
            log.error(RBUtil.getStringResource("OMREntrysetLastModDateFailed.txt", (Object)e));
        }
    }

    void copyTo(PathUrl destPathUrl) throws RemoteException, RepositoryException {
        EntryInterface dest = this.getReposObjectFromPathUrl(destPathUrl);
        this.copyTo(dest);
    }

    void copyWithoutCaches(PathUrl destPathUrl) throws RemoteException, RepositoryException {
        EntryInterface dest = this.getReposObjectFromPathUrl(destPathUrl);
        this.copyWithoutCaches(dest);
    }

    void moveTo(PathUrl destPathUrl) throws RemoteException, RepositoryException {
        EntryInterface dest = this.getReposObjectFromPathUrl(destPathUrl);
        this.moveTo(dest);
    }

    private EntryInterface getReposObjectFromPathUrl(PathUrl destPathUrl) throws RemoteException, RepositoryException {
        String subPathName;
        String rootDirName;
        OMRDirectory rootDir;
        String key;
        ReportManagementCache rmc = this.repositoryId.getCache();
        EntryInterface retVal = (EntryInterface)rmc.get(key = destPathUrl.toString());
        if (retVal == null && (retVal = (rootDir = this.repositoryId.getRootOMRDirectory(rootDirName = destPathUrl.getRootTree())).getEntry(subPathName = this.getPathNameWithType(destPathUrl))) != null) {
            rmc.put(key, retVal);
        }
        return retVal;
    }

    @Override
    public String getApplicationData(String applicationDataName) throws RepositoryException {
        if (Entry.isBlankString(applicationDataName)) {
            throw new IllegalArgumentException(RBUtil.getStringResource("OMREntryIllegalAppDataName.txt"));
        }
        String value = this.getNote(applicationDataName);
        if (value != null && value.startsWith(NOT_TRANSIENT_PREFIX)) {
            value = value.substring(NOT_TRANSIENT_PREFIX_LENGTH);
        }
        return value;
    }

    @Override
    public void setApplicationData(String applicationDataName, String value) throws RepositoryException {
        this.setApplicationData(applicationDataName, value, true, false);
    }

    @Override
    public void setApplicationData(String applicationDataName, String value, boolean transientData, boolean updateTimestamps) throws RepositoryException {
        if (Entry.isBlankString(applicationDataName)) {
            throw new IllegalArgumentException(RBUtil.getStringResource("OMREntryIllegalAppDataName.txt"));
        }
        String persistedValue = this.getApplicationDataValue(value, transientData);
        this.setNote(applicationDataName, persistedValue);
        if (updateTimestamps) {
            this.updateLastModifiedTime();
        }
        this.updateMetadataAll();
    }

    private String getApplicationDataValue(String value, boolean transientData) {
        if (transientData || value == null) {
            return value;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(NOT_TRANSIENT_PREFIX).append(value);
        return buf.toString();
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof OMREntry)) {
                return false;
            }
            OMREntry other = (OMREntry)obj;
            String otherLoc = other.getLocation();
            String loc = this.getLocation();
            return loc.equals(otherLoc);
        }
        catch (RepositoryException e) {
            log.debug(RBUtil.getStringResource("OMREntryError.notrans", (Object)e));
            return false;
        }
    }

    static {
        long sec = 10L;
        try {
            String secStr = System.getProperty("sas.report.repository.timestampWindowInSec");
            if (secStr != null) {
                sec = Long.parseLong(secStr);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        TIMESTAMP_WINDOW_IN_MILLIS = sec * 1000L;
        NOT_TRANSIENT_PREFIX_LENGTH = NOT_TRANSIENT_PREFIX.length();
        log = LogManager.getLogger(OMREntry.class);
    }
}

