/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.ArchiveDestFactory;
import com.sas.report.repository.CacheFilter;
import com.sas.report.repository.CacheFilterAdapter;
import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.Entry;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.OMRCache;
import com.sas.report.repository.OMREntry;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class OMRCacheSet
implements CacheSetInterface {
    private static final char CSV_NOT_TRANSIENT_SUFFIX = '*';
    private static final String CSV_DELIMITER = ",";
    private static final Logger log = LogManager.getLogger(OMRCacheSet.class);
    private OMREntry myEntry;
    private OMRID repositoryId;
    private Map myCacheNames;
    private boolean myAllowMetadataWrites;
    private int myMaxVersions;
    private CacheFilter myPdfFilter;

    static String validateAndTrim(String name) throws RepositoryIllegalNameException {
        name = name == null ? "" : name.trim();
        try {
            Entry.validateCacheName(name);
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryIllegalNameException(e, e.getMessage());
        }
        if (name.indexOf(44) != -1) {
            throw new RepositoryIllegalNameException(RBUtil.getStringResource("EntryNameIllegalChar.fmt.txt", name));
        }
        return name;
    }

    public OMRCacheSet(EntryInterface entryInterface) throws RepositoryException {
        if (!(entryInterface instanceof OMREntry)) {
            Object[] args = new String[]{entryInterface.getName()};
            throw new RepositoryException(RBUtil.getStringResource("OMRCacheSetunableToAccess.fmt.txt", args));
        }
        this.myEntry = (OMREntry)entryInterface;
        this.repositoryId = this.myEntry.getOMRID();
        this.myAllowMetadataWrites = true;
        String nameListStr = null;
        try {
            nameListStr = (String)this.myEntry.getAttribute("##CACHE_NAME_LIST##");
        }
        catch (RepositoryNotFoundException repositoryNotFoundException) {
            // empty catch block
        }
        this.myCacheNames = this.csvToMap(nameListStr);
        this.myMaxVersions = 0;
        try {
            String maxVerStr = (String)this.myEntry.getAttribute("##VERSION_RETENSION_POLICY##");
            this.myMaxVersions = Integer.parseInt(maxVerStr);
        }
        catch (RepositoryNotFoundException maxVerStr) {
        }
        catch (NumberFormatException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public EntryInterface getEntryInterface() {
        return this.myEntry;
    }

    @Override
    public CacheInterface create(String cacheName, boolean isTransient) throws RepositoryIllegalNameException, RepositoryDuplicateNameException, RepositoryException {
        cacheName = OMRCacheSet.validateAndTrim(cacheName);
        log.debug(RBUtil.getStringResource("OMRCacheSetcreate.notrans", cacheName));
        Boolean transientCache = isTransient;
        this.addCache(cacheName, transientCache);
        OMRCache omrCache = new OMRCache(this, cacheName, transientCache);
        this.myEntry.updateLastModifiedTime();
        return omrCache;
    }

    @Override
    public CacheInterface create(String cacheName) throws RepositoryIllegalNameException, RepositoryDuplicateNameException, RepositoryException {
        return this.create(cacheName, true);
    }

    @Override
    public List list(CacheFilter filter) throws RepositoryException {
        ArrayList<OMRCache> cList = new ArrayList<OMRCache>();
        for (Map.Entry entry : this.myCacheNames.entrySet()) {
            String cacheName = (String)entry.getKey();
            Boolean transientCache = (Boolean)entry.getValue();
            OMRCache omrCache = new OMRCache(this, cacheName, transientCache);
            if (filter != null && !filter.accept(omrCache)) continue;
            cList.add(omrCache);
        }
        return cList;
    }

    @Override
    public List listCacheItems(CacheFilter filter) throws RepositoryException {
        ArrayList ciList = new ArrayList();
        List cList = this.list(filter);
        for (CacheInterface cache : cList) {
            List items = cache.list(filter);
            ciList.addAll(items);
        }
        return ciList;
    }

    @Override
    public boolean exists(String cacheName) throws RepositoryException {
        return this.myCacheNames.containsKey(cacheName);
    }

    @Override
    public CacheInterface get(String cacheName) throws RepositoryException, RepositoryNotFoundException {
        Boolean transientValue = (Boolean)this.myCacheNames.get(cacheName);
        if (transientValue == null) {
            String msg = RBUtil.getStringResource("OMRCacheSetnotFound.fmt.txt", cacheName);
            log.debug(msg);
            throw new RepositoryNotFoundException(msg);
        }
        return new OMRCache(this, cacheName, transientValue);
    }

    @Override
    public void deleteAll() throws RepositoryException {
        if (!this.myEntry.canWrite()) {
            throw new SecurityException();
        }
        List caches = this.list(null);
        for (CacheInterface cache : caches) {
            cache.delete();
        }
    }

    @Override
    public void deleteTransient() throws RepositoryException {
        if (!this.myEntry.canWrite()) {
            throw new SecurityException();
        }
        List caches = this.list(null);
        for (OMRCache cache : caches) {
            if (!cache.isTransient()) continue;
            cache.delete();
        }
    }

    void copy(ContentInterface contentRoot, String srcPathNameAndType, String destPathNameAndType) throws RepositoryException {
        this.copy(contentRoot, srcPathNameAndType, contentRoot, destPathNameAndType);
    }

    void copy(ContentInterface srcRoot, String srcPathNameAndType, ContentInterface destRoot, String destPathNameAndType) throws RepositoryException {
        List caches = this.list(null);
        for (OMRCache cache : caches) {
            cache.copy(srcRoot, srcPathNameAndType, destRoot, destPathNameAndType);
        }
    }

    void rename(String oldNameAndType, String newNameAndType) throws RepositoryException {
        List caches = this.list(null);
        for (OMRCache cache : caches) {
            cache.rename(oldNameAndType, newNameAndType);
        }
    }

    void move(ContentInterface contentRoot, String srcPathNameAndType, String destPathNameAndType) throws RepositoryException {
        this.move(contentRoot, srcPathNameAndType, contentRoot, destPathNameAndType);
    }

    void move(ContentInterface srcRoot, String srcPathNameAndType, ContentInterface destRoot, String destPathNameAndType) throws RepositoryException {
        List caches = this.list(null);
        for (OMRCache cache : caches) {
            cache.move(srcRoot, srcPathNameAndType, destRoot, destPathNameAndType);
        }
    }

    private Map csvToMap(String csvString) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (csvString == null || csvString.trim().length() == 0) {
            return map;
        }
        StringTokenizer st = new StringTokenizer(csvString, CSV_DELIMITER);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int lastCharNdx = token.length() - 1;
            Boolean transientCache = Boolean.TRUE;
            if (token.charAt(lastCharNdx) == '*') {
                transientCache = Boolean.FALSE;
                token = token.substring(0, lastCharNdx);
            }
            map.put(token, transientCache);
        }
        return map;
    }

    private String mapToCsv(Map map) {
        if (map.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        Iterator itor = map.entrySet().iterator();
        if (itor.hasNext()) {
            this.addCacheEntryToBuffer(buf, itor.next());
        }
        while (itor.hasNext()) {
            buf.append(CSV_DELIMITER);
            this.addCacheEntryToBuffer(buf, itor.next());
        }
        return buf.toString();
    }

    private void addCacheEntryToBuffer(StringBuffer buf, Map.Entry mapEntry) {
        String cacheName = (String)mapEntry.getKey();
        Boolean transientCache = (Boolean)mapEntry.getValue();
        buf.append(cacheName);
        if (!transientCache.booleanValue()) {
            buf.append('*');
        }
    }

    Map getCacheNames() {
        return this.myCacheNames;
    }

    private Map addCache(String cacheName, Boolean transientCache) throws RepositoryDuplicateNameException, RepositoryException {
        if (this.myCacheNames.containsKey(cacheName)) {
            throw new RepositoryDuplicateNameException(RBUtil.getStringResource("OMRCacheSetduplicate.fmt.txt", cacheName));
        }
        this.myCacheNames.put(cacheName, transientCache);
        String csvNames = this.mapToCsv(this.myCacheNames);
        this.myEntry.setAttribute("##CACHE_NAME_LIST##", csvNames);
        return this.myCacheNames;
    }

    Map removeCache(String cacheName) throws RepositoryException {
        if (this.myCacheNames.containsKey(cacheName)) {
            this.myCacheNames.remove(cacheName);
            if (this.myAllowMetadataWrites) {
                String csvNames = this.mapToCsv(this.myCacheNames);
                this.myEntry.setAttribute("##CACHE_NAME_LIST##", csvNames);
            }
        }
        return this.myCacheNames;
    }

    void setAllowMetadataWrites(boolean allowMetadataWrites) {
        this.myAllowMetadataWrites = allowMetadataWrites;
    }

    @Override
    public int getMaxNumberOfVersions() {
        return this.myMaxVersions;
    }

    @Override
    public void setMaxNumberOfVersions(int maxVersionsToKeep) throws RepositoryException, SecurityException {
        this.myMaxVersions = maxVersionsToKeep;
        this.myEntry.setAttribute("##VERSION_RETENSION_POLICY##", Integer.toString(this.myMaxVersions));
    }

    @Override
    public int archivePDFs(String srcCacheName, Date archiveDate) {
        if (!this.myEntry.canWrite()) {
            throw new SecurityException();
        }
        if (this.myMaxVersions == 0) {
            return -1;
        }
        try {
            CacheInterface srcCache = this.get(srcCacheName);
            List pdfItems = srcCache.list(this.getPdfFilter());
            if (pdfItems.size() == 0) {
                return 0;
            }
            ArchiveDestFactory archiveDest = new ArchiveDestFactory(this, archiveDate);
            int itemsArchived = 0;
            for (CacheItemInterface srcItem : pdfItems) {
                ArchiveDestFactory.Item destItem = archiveDest.getNextDestItem();
                destItem.copyContentFrom(srcItem);
                ++itemsArchived;
            }
            if (this.myMaxVersions != -1) {
                archiveDest.purgeOlderItems(this.myMaxVersions);
            }
            return itemsArchived;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return -3;
        }
    }

    private synchronized CacheFilter getPdfFilter() {
        if (this.myPdfFilter == null) {
            this.myPdfFilter = new PdfFilter();
        }
        return this.myPdfFilter;
    }

    static class PdfFilter
    extends CacheFilterAdapter {
        PdfFilter() {
        }

        @Override
        public boolean accept(CacheItemInterface cacheItem) {
            String name = cacheItem.getName();
            name = name.toLowerCase();
            return name.endsWith(".pdf");
        }
    }
}

