/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.CacheStorage;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.OMRCache;
import com.sas.report.repository.OMREntry;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryLockedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OMRCacheItem
implements CacheItemInterface {
    private static final Logger log = LogManager.getLogger(OMRCacheItem.class);
    private OMRCache myCache;
    private OMREntry myEntry;
    private String myName;

    public OMRCacheItem(OMRCache cache, String cacheItemName) throws RepositoryException {
        this.myCache = cache;
        this.myName = cacheItemName;
        EntryInterface entry = cache.getParentEntry();
        if (!(entry instanceof OMREntry)) {
            Object[] args = new String[]{this.myEntry.getName()};
            throw new RepositoryException(RBUtil.getStringResource("OMRCacheItemunableToAccess.fmt.txt", args));
        }
        this.myEntry = (OMREntry)entry;
        OMRID oMRID = this.myEntry.getOMRID();
    }

    @Override
    public Iterator getAttributes() throws RepositoryException, SecurityException {
        return this.myCache.getStorage().getAttributes(this.myName);
    }

    @Override
    public void setAttributes(Map attributes) throws RepositoryException {
        this.myCache.getStorage().setAttributes(this.myName, attributes);
    }

    @Override
    public Object getAttribute(String attribName) throws RepositoryException {
        return this.myCache.getStorage().getAttribute(this.myName, attribName);
    }

    @Override
    public void setAttribute(String attribName, Object value) throws RepositoryException {
        this.myCache.getStorage().setAttribute(this.myName, attribName, value);
    }

    @Override
    public Object getMetadataObject() {
        return null;
    }

    @Override
    public String getContentLocation() throws RepositoryException {
        CacheStorage storage = this.myCache.getStorage();
        return storage.getContentLocation(this.myName);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public InputStream getInputStream() throws RepositoryIOException {
        try {
            String name = this.getName();
            log.debug(RBUtil.getStringResource("OMRCacheIteminputStream.notrans", name));
            CacheStorage storage = this.myCache.getStorage();
            return storage.getInputStream(name);
        }
        catch (Exception e) {
            throw new RepositoryIOException(e, e.getMessage());
        }
    }

    @Override
    public OutputStream getOutputStream() throws RepositoryIOException {
        try {
            String name = this.getName();
            log.debug(RBUtil.getStringResource("OMRCacheItemoutputStream.notrans", name));
            CacheStorage storage = this.myCache.getStorage();
            OutputStream oStream = storage.getOutputStream(name);
            return oStream;
        }
        catch (Exception e) {
            throw new RepositoryIOException(e, e.getMessage());
        }
    }

    @Override
    public void delete() throws RepositoryException {
        if (this.myName == null) {
            return;
        }
        String name = this.getName();
        CacheStorage storage = this.myCache.getStorage();
        storage.delete(name);
        this.myCache = null;
        this.myName = null;
    }

    @Override
    public void deleteContent() throws RepositoryException {
        String name = this.getName();
        CacheStorage storage = this.myCache.getStorage();
        storage.deleteContent(name);
    }

    @Override
    public int read(InputStream stream, byte[] data) throws RepositoryIOException {
        int len = 0;
        try {
            len = stream.read(data);
        }
        catch (IOException e) {
            throw new RepositoryIOException(e, e.getMessage());
        }
        return len;
    }

    @Override
    public int write(OutputStream stream, byte[] data, int len) throws RepositoryIOException {
        try {
            stream.write(data, 0, len);
        }
        catch (IOException e) {
            throw new RepositoryIOException(e, e.getMessage());
        }
        return len;
    }

    @Override
    public void close(OutputStream stream) throws RepositoryIOException {
        try {
            stream.close();
        }
        catch (IOException e) {
            throw new RepositoryIOException(e, e.getMessage());
        }
    }

    @Override
    public boolean isEmpty() throws RepositoryException {
        return this.getSizeOfContent() == 0L;
    }

    @Override
    public EntryInterface getParentEntry() throws RepositoryException {
        return this.myEntry;
    }

    @Override
    public CacheInterface getParentCache() throws RepositoryException {
        return this.myCache;
    }

    @Override
    public long getSizeOfContent() throws RepositoryException {
        CacheStorage storage = this.myCache.getStorage();
        return storage.getSizeInBytes(this.myName);
    }

    public boolean equals(Object o) {
        try {
            if (o == null) {
                return false;
            }
            if (!(o instanceof OMRCacheItem)) {
                return false;
            }
            OMRCacheItem other = (OMRCacheItem)o;
            return this.myName.equals(other.getName()) && this.getParentCache().getName().equals(other.getParentCache().getName()) && this.getParentEntry().equals(other.getParentEntry());
        }
        catch (RepositoryException e) {
            log.debug(RBUtil.getStringResource("OMRCacheItemError.notrans", (Object)e));
            return false;
        }
    }

    @Override
    public void lock() throws RepositoryException {
        try {
            this.myCache.getStorage().lock(this.myName);
        }
        catch (RepositoryIOException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
        catch (RepositoryLockedException e) {
            throw new RepositoryLockedException((Throwable)((Object)e), e.getMessage());
        }
    }

    @Override
    public void unlock() throws RepositoryException {
        try {
            this.myCache.getStorage().unlock(this.myName);
        }
        catch (RepositoryIOException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
        catch (RepositoryLockedException e) {
            throw new RepositoryLockedException((Throwable)((Object)e), e.getMessage());
        }
    }
}

