/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.CacheFilter;
import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.CacheStorage;
import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.OMRCacheItem;
import com.sas.report.repository.OMRCacheSet;
import com.sas.report.repository.OMREntry;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class OMRCache
implements CacheInterface {
    private static final Logger log = LogManager.getLogger(OMRCache.class);
    private String myName;
    private boolean _transientCache;
    private OMRID repositoryId;
    private OMRCacheSet myCacheSet;
    private OMREntry myEntry;
    private CacheStorage myStorage;

    public OMRCache(OMRCacheSet cacheSet, String name, Boolean transientCache) throws RepositoryException {
        this.myCacheSet = cacheSet;
        this.myEntry = (OMREntry)cacheSet.getEntryInterface();
        this.myName = name;
        this._transientCache = transientCache;
        this.myStorage = CacheStorage.getStorageStrategy(this.myEntry, name);
        this.repositoryId = this.myEntry.getOMRID();
    }

    @Override
    public String getName() throws RepositoryException {
        return this.myName;
    }

    @Override
    public CacheItemInterface create(String cacheItemName) throws RepositoryIllegalNameException, RepositoryException {
        cacheItemName = OMRCacheSet.validateAndTrim(cacheItemName);
        String msg = RBUtil.getStringResource("OMRCachecreate.notrans", cacheItemName);
        log.debug(msg);
        this.myStorage.create(cacheItemName);
        OMRCacheItem omrCacheItem = new OMRCacheItem(this, cacheItemName);
        return omrCacheItem;
    }

    @Override
    public CacheItemInterface get(String cacheItemName) throws RepositoryException, RepositoryNotFoundException {
        if (this.myStorage.exists(cacheItemName)) {
            return new OMRCacheItem(this, cacheItemName);
        }
        String msg = RBUtil.getStringResource("OMRCachenotFound.fmt.txt", cacheItemName);
        log.debug(msg);
        throw new RepositoryNotFoundException(msg);
    }

    @Override
    public List list(CacheFilter filter) throws RepositoryException {
        ArrayList<OMRCacheItem> itemsFound = new ArrayList<OMRCacheItem>();
        Set itemNames = this.myStorage.getItemNames();
        for (String itemName : itemNames) {
            OMRCacheItem omrCacheItem = new OMRCacheItem(this, itemName);
            if (filter != null && !filter.accept(omrCacheItem)) continue;
            itemsFound.add(omrCacheItem);
        }
        return itemsFound;
    }

    @Override
    public void delete() throws RepositoryException {
        if (this.myName == null) {
            return;
        }
        if (!this.myEntry.canWrite()) {
            throw new SecurityException();
        }
        this.myStorage.deleteAll();
        this.myCacheSet.removeCache(this.myName);
        this.myEntry.updateLastModifiedTime();
        this.myStorage = null;
        this.myEntry = null;
        this.myName = null;
    }

    @Override
    public boolean exists(String cacheItemName) throws RepositoryException {
        return this.myStorage.exists(cacheItemName);
    }

    @Override
    public EntryInterface getParentEntry() throws RepositoryException {
        return this.myEntry;
    }

    @Override
    public void createTransactionStart() throws IllegalStateException {
        this.myStorage.transactionStart();
    }

    @Override
    public void createTransactionEnd() throws IllegalStateException, RepositoryException {
        this.myStorage.transactionEnd();
    }

    public boolean equals(Object o) {
        try {
            if (o == null) {
                return false;
            }
            if (!(o instanceof OMRCache)) {
                return false;
            }
            OMRCache other = (OMRCache)o;
            String otherLoc = other.getLocation();
            String loc = this.getLocation();
            return loc.equals(otherLoc);
        }
        catch (RepositoryException e) {
            log.debug("Error.notrans", (Throwable)((Object)e));
            return false;
        }
    }

    boolean isTransient() {
        return this._transientCache;
    }

    void copy(ContentInterface contentRoot, String srcPathNameAndType, String destPathNameAndType) throws RepositoryException {
        this.copy(contentRoot, srcPathNameAndType, contentRoot, destPathNameAndType);
    }

    void copy(ContentInterface srcRoot, String srcPathNameAndType, ContentInterface destRoot, String destPathNameAndType) throws RepositoryException {
        this.myStorage.copy(srcRoot, srcPathNameAndType, destRoot, destPathNameAndType);
    }

    void move(ContentInterface contentRoot, String srcPathNameAndType, String destPathNameAndType) throws RepositoryException {
        this.move(contentRoot, srcPathNameAndType, contentRoot, destPathNameAndType);
    }

    void move(ContentInterface srcRoot, String srcPathNameAndType, ContentInterface destRoot, String destPathNameAndType) throws RepositoryException {
        this.myStorage.move(srcRoot, srcPathNameAndType, destRoot, destPathNameAndType);
    }

    void rename(String oldNameAndType, String newNameAndType) throws RepositoryException {
        this.myStorage.rename(oldNameAndType, newNameAndType);
    }

    CacheStorage getStorage() {
        return this.myStorage;
    }

    private String getLocation() throws RepositoryException {
        String entryLocation = this.myEntry.getLocationUrl().toString();
        String cacheName = this.getName();
        String fullName = entryLocation + cacheName;
        return fullName;
    }
}

