/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.AgingPolicy;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.ItemInterface;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryNotDirectoryException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.services.information.metadata.PathUrl;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;

public interface EntryInterface
extends ItemInterface {
    public static final boolean TRANSIENT = true;
    public static final boolean NOT_TRANSIENT = false;
    public static final boolean UPDATE_TIMESTAMPS = true;
    public static final boolean DO_NOT_UPDATE_TIMESTAMPS = false;

    public PathUrl getLocationUrl() throws RepositoryException;

    public AgingPolicy getAgingPolicy() throws RepositoryException, SecurityException;

    public void setAgingPolicy(AgingPolicy var1) throws RepositoryLockedException, RepositoryException, SecurityException;

    public Iterator getKeywords() throws RepositoryException, SecurityException;

    public boolean isKeyword(String var1) throws RepositoryException, SecurityException;

    public void setKeywords(List var1) throws RepositoryLockedException, RepositoryException, SecurityException;

    public void setKeyword(String var1, String var2) throws RepositoryLockedException, RepositoryException, SecurityException;

    public void setKeyword(String var1) throws RepositoryLockedException, RepositoryException, SecurityException;

    public void addKeywords(List var1) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException;

    public void addKeyword(String var1) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException;

    public void addKeyword(String var1, String var2) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException;

    public void removeKeyword(String var1) throws RepositoryLockedException, RepositoryException, SecurityException;

    public void removeAllKeywords() throws RepositoryLockedException, RepositoryException, SecurityException;

    public EntryInterface getGeneration(long var1) throws RepositoryNotFoundException, RepositoryException, SecurityException;

    public void age(long var1) throws RepositoryException, SecurityException;

    public EntryInterface createEntry(String var1) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException;

    public EntryInterface createEntry(String var1, AgingPolicy var2) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException;

    public EntryInterface createEntry(Object var1) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException;

    public boolean entryExists(String var1) throws RepositoryIllegalNameException, RepositoryException, SecurityException;

    public EntryInterface getEntry(String var1) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException;

    public EntryInterface getEntry(String var1, long var2) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException;

    public void renameTo(String var1) throws RepositoryIllegalNameException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException;

    public void moveTo(EntryInterface var1) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException;

    public void copyTo(EntryInterface var1) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException;

    public void copyWithoutCaches(EntryInterface var1) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException;

    public void delete(long var1) throws RepositoryLockedException, RepositoryException, SecurityException;

    public String getParent() throws RepositoryNotFoundException, RepositoryException, SecurityException;

    public boolean canRead() throws SecurityException;

    public boolean canWrite() throws SecurityException;

    public boolean isDirectory();

    public String toString();

    public CacheSetInterface getCacheSetInterface() throws RepositoryException;

    public OutputStream getOutputStream(boolean var1) throws SecurityException, RepositoryIOException;

    public String getApplicationData(String var1) throws RepositoryException;

    public void setApplicationData(String var1, String var2) throws RepositoryException;

    public void setApplicationData(String var1, String var2, boolean var3, boolean var4) throws RepositoryException;

    public void refresh();
}

