/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.ContentAlreadyExistsException;
import com.sas.report.repository.ContentDirectoryException;
import com.sas.report.repository.ContentDirectoryHeaderEntry;
import com.sas.report.repository.ContentException;
import com.sas.report.repository.ContentFactory;
import com.sas.report.repository.ContentFileException;
import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.ContentNameNotFoundException;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RepositoryException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ContentProviderFS
implements ContentInterface {
    protected static final String hostPathSeparator = File.separator;
    protected String rootPath = null;
    public static final String defaultUserID = "";
    public static final String defaultPassWD = "";
    protected String userID = null;
    protected String passWD = null;
    private OMRID repositoryId;
    private static final Logger log = LogManager.getLogger(ContentProviderFS.class);
    private int fileCopyBufferSize = 4096;

    public ContentProviderFS(OMRID omrid, String path, String userID, String passWD) throws ContentException, RepositoryException {
        String protocol;
        this.repositoryId = omrid;
        int idx = path.indexOf(58);
        if (idx > 0 && (protocol = path.substring(0, idx)).compareToIgnoreCase("FILE") == 0) {
            try {
                URL u = new URL(path);
                path = u.getFile().substring(1);
            }
            catch (Exception e) {
                throw new ContentException(e, e.getMessage());
            }
        }
        this.rootPath = path = path.replace('/', hostPathSeparator.charAt(0));
        this.userID = userID;
        this.passWD = passWD;
        if (this.rootPath.lastIndexOf(hostPathSeparator) == this.rootPath.length() - 1) {
            this.rootPath = this.rootPath.substring(0, this.rootPath.length() - 1);
        }
    }

    @Override
    public String getRootPath() {
        return this.rootPath;
    }

    @Override
    public String getPathSeparator() {
        return hostPathSeparator;
    }

    @Override
    public String getUserName(String userName) {
        return this.userID;
    }

    @Override
    public String getPassword(String password) {
        return this.passWD;
    }

    @Override
    public ContentInterface getParent() throws ContentException, RepositoryException {
        String path = this.rootPath;
        int idx = path.lastIndexOf(hostPathSeparator);
        if (idx == -1) {
            return null;
        }
        if (idx == path.length() - 1) {
            path = path.substring(0, idx);
            idx = path.lastIndexOf(hostPathSeparator);
        }
        if (idx == -1) {
            return null;
        }
        path = path.substring(0, idx);
        ContentProviderFS c = new ContentProviderFS(this.repositoryId, path, this.userID, this.passWD);
        return c;
    }

    @Override
    public String buildPath(String basePath, String subPath) {
        String s = basePath == null || basePath.length() == 0 ? (subPath == null ? null : new String(subPath)) : (subPath == null || subPath.length() == 0 ? (basePath.lastIndexOf(":") == this.rootPath.length() - 1 ? basePath + hostPathSeparator : basePath) : new String(basePath + hostPathSeparator + subPath));
        log.debug(RBUtil.getStringResource("ContentProviderFSBuildPath.notrans", s));
        ContentFactory.validateResolvedAddress(basePath, subPath, s);
        return s;
    }

    @Override
    public void createDirectory(String newDirectoryName) throws ContentNameNotFoundException, ContentException {
        File f = new File(this.buildPath(this.rootPath, newDirectoryName));
        log.debug(RBUtil.getStringResource("ContentProviderFSCreateDir.notrans", f));
        if (f.exists()) {
            throw new ContentException(RBUtil.getStringResource("ContentProviderFSdirExists.txt", f));
        }
        if (!f.mkdirs()) {
            throw new ContentException(RBUtil.getStringResource("ContentProviderFScantCreate.txt", f));
        }
    }

    @Override
    public boolean isDirectory(String directoryName) {
        File dir = new File(this.buildPath(this.rootPath, directoryName));
        boolean isDir = dir.isDirectory();
        log.debug(RBUtil.getStringResource("ContentProviderFSIsDir.notrans", (Object)dir, String.valueOf(isDir)));
        return isDir;
    }

    @Override
    public boolean exists(String name) {
        File f = new File(this.buildPath(this.rootPath, name));
        boolean b = f.exists();
        log.debug(RBUtil.getStringResource("ContentProviderFSExists.notrans", (Object)f, String.valueOf(f.exists())));
        return b;
    }

    @Override
    public List list(String directoryName) throws ContentNameNotFoundException, ContentException {
        File dir = new File(this.buildPath(this.rootPath, directoryName));
        log.debug(RBUtil.getStringResource("ContentProviderFSList.notrans", dir));
        String[] s = dir.list(null);
        if (s == null) {
            throw new ContentNameNotFoundException(RBUtil.getStringResource("ContentProviderFSnoName.txt", directoryName));
        }
        ArrayList<FSDirectoryHeaderEntry> l = new ArrayList<FSDirectoryHeaderEntry>();
        for (int i = 0; i < s.length; ++i) {
            String name = new String(s[i]);
            File entry = new File(this.buildPath(dir.toString(), name));
            int type = entry.isDirectory() ? 1 : 2;
            long size = entry.length();
            Date lastModifiedDate = new Date(entry.lastModified());
            String description = "";
            FSDirectoryHeaderEntry c = new FSDirectoryHeaderEntry(name, type, size, lastModifiedDate, description);
            l.add(c);
        }
        return l;
    }

    @Override
    public void deleteTree(String fileName) throws ContentNameNotFoundException, ContentException {
        String name = this.buildPath(this.rootPath, fileName);
        File f = new File(name);
        try {
            this.treeDelete(f);
        }
        catch (ContentDirectoryException contentDirectoryException) {
            // empty catch block
        }
    }

    @Override
    public void delete(String fileName) throws ContentNameNotFoundException, ContentException {
        String name = this.buildPath(this.rootPath, fileName);
        log.debug(RBUtil.getStringResource("ContentProviderFSDelete.notrans", name));
        File f = new File(name);
        Object[] args = new Object[]{new String(name)};
        if (!f.exists()) {
            throw new ContentNameNotFoundException(RBUtil.getStringResource("ContentProviderFSnoName.txt", name));
        }
        boolean successful = false;
        try {
            successful = f.delete();
        }
        catch (Exception e) {
            log.error("Error.txt", (Throwable)e);
            throw new ContentException(e, e.getMessage());
        }
        if (!successful) {
            throw new ContentException(RBUtil.getStringResource("ContentProviderFScantDelete.txt", name));
        }
    }

    @Override
    public OutputStream add(String fileName) throws ContentFileException, ContentException, ContentAlreadyExistsException {
        FileOutputStream fostream;
        String name = this.buildPath(this.rootPath, fileName);
        log.debug(RBUtil.getStringResource("ContentProviderFSAdd.notrans", name));
        File f = new File(name);
        if (f.exists()) {
            throw new ContentAlreadyExistsException(RBUtil.getStringResource("ContentProviderFSfileExists.txt", name));
        }
        try {
            fostream = new FileOutputStream(f);
        }
        catch (Exception e) {
            throw new ContentException(e, e.getMessage());
        }
        PrintStream ostream = new PrintStream(fostream);
        return ostream;
    }

    @Override
    public InputStream get(String fileName) throws ContentFileException, ContentNameNotFoundException, ContentException {
        InputStream iStream = null;
        String name = this.buildPath(this.rootPath, fileName);
        log.debug(RBUtil.getStringResource("ContentProviderFSGet.notrans", name));
        try {
            File f = new File(name);
            iStream = f.exists() ? new FileInputStream(name) : new ByteArrayInputStream(new byte[0]);
        }
        catch (FileNotFoundException e) {
            throw new ContentNameNotFoundException(e, RBUtil.getStringResource("ContentProviderFSnameNotFound.txt", name));
        }
        return iStream;
    }

    @Override
    public OutputStream update(String fileName) throws ContentFileException, ContentNameNotFoundException, ContentException {
        FileOutputStream fostream;
        String name = this.buildPath(this.rootPath, fileName);
        log.debug(RBUtil.getStringResource("ContentProviderFSUpdate.notrans", name));
        try {
            fostream = new FileOutputStream(name);
        }
        catch (FileNotFoundException e) {
            throw new ContentNameNotFoundException(e, RBUtil.getStringResource("ContentProviderFSnameNotFound.txt", name));
        }
        catch (Exception e) {
            log.error(RBUtil.getStringResource("ContentProviderFSError.txt", e));
            throw new ContentException(e, e.getMessage());
        }
        PrintStream ostream = new PrintStream(fostream);
        return ostream;
    }

    @Override
    public OutputStream write(String fileName) throws ContentFileException, ContentNameNotFoundException, ContentException {
        return this.update(fileName);
    }

    @Override
    public void renameTo(String oldName, String newName) throws ContentNameNotFoundException, ContentException {
        File o = new File(this.buildPath(this.rootPath, oldName));
        File n = new File(this.buildPath(this.rootPath, newName));
        if (!o.exists()) {
            throw new ContentNameNotFoundException(RBUtil.getStringResource("ContentProviderFSnameNotFound.txt", o));
        }
        try {
            if (!o.renameTo(n)) {
                throw new ContentException(RBUtil.getStringResource("ContentProviderFScantRename.txt", (Object)o, n));
            }
        }
        catch (Exception e) {
            throw new ContentException(e, RBUtil.getStringResource("ContentProviderFSrenameError.txt", e.getMessage()));
        }
    }

    @Override
    public void moveTo(String srcName, String destName) throws ContentNameNotFoundException, ContentException {
        this.moveTo(srcName, this, destName);
    }

    @Override
    public void moveTo(String srcName, ContentInterface dest, String destName) throws ContentNameNotFoundException, ContentException {
        this.copyTo(srcName, destName);
        File s = new File(this.buildPath(this.rootPath, srcName));
        try {
            this.treeDelete(s);
        }
        catch (ContentDirectoryException contentDirectoryException) {
        }
        catch (ContentFileException contentFileException) {
            // empty catch block
        }
    }

    @Override
    public void copyTo(String srcName, String destName) throws ContentNameNotFoundException, ContentException {
        this.copyTo(srcName, this, destName);
    }

    @Override
    public void copyTo(String srcName, ContentInterface dest, String destName) throws ContentNameNotFoundException, ContentException {
        File s = new File(this.buildPath(this.rootPath, srcName));
        File d = new File(this.buildPath(this.rootPath, destName));
        if (!s.exists()) {
            throw new ContentNameNotFoundException(RBUtil.getStringResource("ContentProviderFSnameNotFound.txt", s));
        }
        try {
            this.treeCopy(s, d);
        }
        catch (ContentDirectoryException ee) {
            log.warn("Error.txt", (Throwable)((Object)ee));
        }
        catch (ContentFileException ee) {
            log.warn("Error.txt", (Throwable)((Object)ee));
        }
    }

    private void fileCopy(File sf, File df) throws ContentFileException, ContentException {
        int len;
        FileOutputStream dest;
        FileInputStream src;
        log.debug(RBUtil.getStringResource("ContentProviderFSCopyTo.notrans", (Object)sf.getPath(), df.getPath()));
        if (!sf.canRead()) {
            throw new ContentFileException(RBUtil.getStringResource("ContentProviderFScantRead.txt", sf.getName()));
        }
        if (df.exists() && df.isDirectory()) {
            throw new ContentFileException(RBUtil.getStringResource("ContentProviderFSdestIsDir.txt", df.getName()));
        }
        String destPath = df.getPath();
        File destDir = new File(destPath = destPath.substring(0, destPath.lastIndexOf(df.getName())));
        if (!destDir.exists()) {
            try {
                destDir.mkdirs();
            }
            catch (Exception e) {
                throw new ContentException(e, e.getMessage());
            }
        }
        if (!destDir.canWrite()) {
            throw new ContentFileException(RBUtil.getStringResource("ContentProviderFScantWrite.txt", destDir.getName()));
        }
        try {
            src = new FileInputStream(sf);
        }
        catch (FileNotFoundException e) {
            throw new ContentFileException(e, RBUtil.getStringResource("ContentProviderFSnameNotFound.txt", sf.getName()));
        }
        try {
            dest = new FileOutputStream(df);
        }
        catch (Exception e) {
            log.error("ContentProviderFSError.txt", (Throwable)e);
            throw new ContentException(e, e.getMessage());
        }
        byte[] b = new byte[this.fileCopyBufferSize];
        try {
            len = src.read(b);
        }
        catch (IOException e) {
            throw new ContentFileException(e, e.getMessage());
        }
        while (len > 0) {
            try {
                dest.write(b, 0, len);
            }
            catch (IOException e) {
                String errorMsg = e.getMessage();
                try {
                    src.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    dest.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    df.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ContentException(e, errorMsg);
            }
            try {
                len = src.read(b);
            }
            catch (IOException e) {
                String errorMsg = e.getMessage();
                try {
                    src.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    dest.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    df.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ContentException(e, errorMsg);
            }
        }
        try {
            src.close();
            dest.close();
        }
        catch (IOException e) {
            throw new ContentException(e, e.getMessage());
        }
    }

    private void treeCopy(File sDir, File dDir) throws ContentNameNotFoundException, ContentDirectoryException, ContentFileException, ContentException {
        boolean bMadeDest = false;
        if (!sDir.exists()) {
            throw new ContentNameNotFoundException(RBUtil.getStringResource("ContentProviderFSnameNotFound.txt", sDir.getName()));
        }
        if (sDir.isFile()) {
            try {
                this.fileCopy(sDir, dDir);
            }
            catch (ContentException e) {
                try {
                    dDir.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            return;
        }
        if (!sDir.canRead()) {
            throw new ContentDirectoryException(RBUtil.getStringResource("ContentProviderFSdirCantRead.txt", sDir.getName()));
        }
        log.debug(RBUtil.getStringResource("ContentProviderFSCopyTo.notrans", (Object)sDir.getName(), dDir.getName()));
        if (!dDir.exists()) {
            log.debug(RBUtil.getStringResource("ContentProviderFSCreatingDir.notrans", dDir.getPath()));
            try {
                dDir.mkdirs();
                bMadeDest = true;
            }
            catch (Exception e) {
                log.error("ContentProviderFSError.txt", (Throwable)e);
                throw new ContentException(e, e.getMessage());
            }
        }
        if (!dDir.canWrite()) {
            throw new ContentDirectoryException(RBUtil.getStringResource("ContentProviderFScantWrite.txt", dDir.getName()));
        }
        File[] fList = sDir.listFiles();
        for (int i = 0; i < fList.length; ++i) {
            File subDir = new File(dDir.getPath() + File.separator + fList[i].getName());
            try {
                this.treeCopy(fList[i], subDir);
                continue;
            }
            catch (ContentException e) {
                if (bMadeDest) {
                    dDir.delete();
                } else {
                    for (int j = 0; j < i; ++j) {
                        subDir = new File(dDir.getPath() + fList[j].getName());
                        try {
                            subDir.delete();
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                throw e;
            }
        }
    }

    private void treeDelete(File dDir) throws ContentNameNotFoundException, ContentFileException, ContentDirectoryException, ContentException {
        if (!dDir.exists()) {
            throw new ContentNameNotFoundException(RBUtil.getStringResource("ContentProviderFSnoName.txt", dDir.getName()));
        }
        if (dDir.isFile()) {
            log.debug(RBUtil.getStringResource("ContentProviderFSDeletingFile.notrans", dDir.getName()));
            boolean successful = false;
            try {
                successful = dDir.delete();
            }
            catch (Exception e) {
                log.error("ContentProviderFSError.txt", (Throwable)e);
                throw new ContentException(e, e.getMessage());
            }
            if (!successful) {
                throw new ContentException(RBUtil.getStringResource("ContentProviderFScantDelete.txt", dDir.getPath()));
            }
        } else {
            File[] fList = dDir.listFiles();
            for (int i = 0; i < fList.length; ++i) {
                try {
                    this.treeDelete(fList[i]);
                    continue;
                }
                catch (ContentException contentException) {
                    // empty catch block
                }
            }
            log.debug(RBUtil.getStringResource("ContentProviderFSDeletingDir.notrans", dDir.getName()));
            boolean successful = false;
            try {
                successful = dDir.delete();
            }
            catch (Exception e) {
                log.error("ContentProviderFSError.txt", (Throwable)e);
                throw new ContentException(e, e.getMessage());
            }
            if (!successful) {
                throw new ContentException(RBUtil.getStringResource("ContentProviderFScantDelete.txt", dDir.getPath()));
            }
        }
    }

    @Override
    public long getSizeInBytes(String name) throws ContentException {
        File f = new File(this.buildPath(this.rootPath, name));
        if (f.exists()) {
            return f.length();
        }
        return 0L;
    }

    @Override
    public void close() {
    }

    @Override
    public Map getAttributes(String name) throws ContentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttributes(String name, Map attributes) throws ContentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttribute(String name, String attrName) throws ContentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(String name, String attrName, String attrValue) throws ContentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void lock(String name) throws ContentException {
    }

    @Override
    public void unlock(String name) throws ContentException {
    }

    private class FSDirectoryHeaderEntry
    extends ContentDirectoryHeaderEntry {
        public FSDirectoryHeaderEntry(String name, int type, long size, Date lastModifiedDate, String description) throws ContentException {
            if (name == null || name.length() == 0) {
                throw new ContentException(RBUtil.getStringResource("ContentProviderFSnullDir.txt"));
            }
            if (type != 1 && type != 2) {
                throw new ContentException(RBUtil.getStringResource("ContentProviderFSinvalidDirType.txt", Integer.toString(type)));
            }
            if (size < 0L) {
                throw new ContentException(RBUtil.getStringResource("ContentProviderFSinvalidDirSize.txt", Long.toString(size)));
            }
            this.name = name;
            this.type = type;
            this.size = size;
            this.lastModifiedDate = lastModifiedDate;
            this.description = description;
        }
    }
}

