/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.ContentAlreadyExistsException;
import com.sas.report.repository.ContentDirectoryException;
import com.sas.report.repository.ContentException;
import com.sas.report.repository.ContentFileException;
import com.sas.report.repository.ContentMalformedNameException;
import com.sas.report.repository.ContentNameNotFoundException;
import com.sas.report.repository.RepositoryException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public interface ContentInterface {
    public String getRootPath();

    public String buildPath(String var1, String var2);

    public String getPathSeparator();

    public ContentInterface getParent() throws ContentException, RepositoryException;

    public String getUserName(String var1);

    public String getPassword(String var1);

    public void createDirectory(String var1) throws ContentNameNotFoundException, ContentException, ContentAlreadyExistsException, ContentDirectoryException;

    public boolean isDirectory(String var1);

    public List list(String var1) throws ContentNameNotFoundException, ContentException, ContentDirectoryException;

    public OutputStream add(String var1) throws ContentFileException, ContentException, ContentAlreadyExistsException;

    public InputStream get(String var1) throws ContentNameNotFoundException, ContentFileException, ContentException;

    public OutputStream update(String var1) throws ContentNameNotFoundException, ContentFileException, ContentException;

    public OutputStream write(String var1) throws ContentFileException, ContentNameNotFoundException, ContentException;

    public boolean exists(String var1) throws ContentException;

    public void delete(String var1) throws ContentNameNotFoundException, ContentFileException, ContentException;

    public void deleteTree(String var1) throws ContentNameNotFoundException, ContentFileException, ContentException;

    public void renameTo(String var1, String var2) throws ContentMalformedNameException, ContentNameNotFoundException, ContentException;

    public void moveTo(String var1, String var2) throws ContentMalformedNameException, ContentNameNotFoundException, ContentException;

    public void moveTo(String var1, ContentInterface var2, String var3) throws ContentMalformedNameException, ContentNameNotFoundException, ContentException;

    public void copyTo(String var1, String var2) throws ContentMalformedNameException, ContentNameNotFoundException, ContentException;

    public void copyTo(String var1, ContentInterface var2, String var3) throws ContentMalformedNameException, ContentNameNotFoundException, ContentException;

    public long getSizeInBytes(String var1) throws ContentException;

    public void close();

    public Map getAttributes(String var1) throws ContentException;

    public void setAttributes(String var1, Map var2) throws ContentException;

    public String getAttribute(String var1, String var2) throws ContentException;

    public void setAttribute(String var1, String var2, String var3) throws ContentException;

    public void lock(String var1) throws ContentException;

    public void unlock(String var1) throws ContentException;
}

