/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.ContentException;
import com.sas.report.repository.RBUtil;
import java.util.Date;

abstract class ContentDirectoryHeaderEntry {
    public static final int ISDIRECTORY = 1;
    public static final int ISFILE = 2;
    protected String name;
    protected int type;
    protected long size;
    protected Date lastModifiedDate;
    protected String description;

    public ContentDirectoryHeaderEntry() {
        this.name = "";
        this.type = 1;
        this.size = 0L;
        this.lastModifiedDate = null;
        this.description = "";
    }

    public ContentDirectoryHeaderEntry(String name, int type, long size, Date lastModifiedDate, String description) throws ContentException {
        if (name == null || name.length() == 0) {
            throw new ContentException(RBUtil.getStringResource("ContentDirectoryHeaderEntrydirNull.txt"));
        }
        if (type != 1 && type != 2) {
            String _message = RBUtil.getStringResource("ContentDirectoryHeaderEntrybadDirType.txt", type);
            throw new ContentException(_message);
        }
        if (size < 0L) {
            String _message = RBUtil.getStringResource("ContentDirectoryHeaderEntrybadDirSize.txt", size);
            throw new ContentException(_message);
        }
        this.name = name;
        this.type = type;
        this.size = size;
        this.lastModifiedDate = lastModifiedDate;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public long getSize() {
        return this.size;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String getDescription() {
        return this.description;
    }
}

