/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.CacheStorage;
import com.sas.report.repository.ContentException;
import com.sas.report.repository.ContentFileException;
import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.ContentNameNotFoundException;
import com.sas.report.repository.OMREntry;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryInputStream;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryOutputStream;
import com.sas.report.repository.RepositoryStreamListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

class CacheStorageZip
extends CacheStorage {
    private static final String FILE_EXTENSION = ".zip";
    private static final long MAX_CONTENT_SIZE = 0x3200000L;
    private Map myItems = this.readZipFile();

    public CacheStorageZip(OMREntry entry, String cacheName) throws RepositoryException {
        super(entry, cacheName);
    }

    private Map readZipFile() throws RepositoryException {
        TreeMap<String, byte[]> items = new TreeMap<String, byte[]>();
        ContentInterface content = this.getContent(true);
        String contentName = this.getContentName(FILE_EXTENSION);
        try {
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(content.get(contentName)));
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                String key = zipEntry.getName();
                byte[] itemContent = this.readItemContentFromZipStream(zis);
                items.put(key, itemContent);
                zis.closeEntry();
                zipEntry = zis.getNextEntry();
            }
            zis.close();
        }
        catch (ContentNameNotFoundException zis) {
        }
        catch (ContentFileException e) {
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        catch (ContentException e) {
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        catch (IOException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        return items;
    }

    private byte[] readItemContentFromZipStream(ZipInputStream zis) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int bytesRead = zis.read(buffer);
        while (bytesRead > 0) {
            baos.write(buffer, 0, bytesRead);
            bytesRead = zis.read(buffer);
        }
        return baos.toByteArray();
    }

    private void writeZipFile() throws RepositoryException {
        ContentInterface content = this.getContent(true);
        String contentName = this.getContentName(FILE_EXTENSION);
        try {
            if (this.myItems.isEmpty()) {
                if (content.exists(contentName)) {
                    content.delete(contentName);
                }
            } else {
                OutputStream oStream = content.write(contentName);
                ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(oStream));
                for (Map.Entry mapEntry : this.myItems.entrySet()) {
                    String key = (String)mapEntry.getKey();
                    byte[] itemContent = (byte[])mapEntry.getValue();
                    ZipEntry zipEntry = new ZipEntry(key);
                    zos.putNextEntry(zipEntry);
                    if (itemContent != null) {
                        zos.write(itemContent);
                    }
                    zos.closeEntry();
                }
                zos.close();
            }
        }
        catch (ContentException e) {
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        catch (IOException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public InputStream getInputStream(String cacheItemName) throws RepositoryIOException, RepositoryLockedException, IllegalStateException {
        this.verifyInputStreamClosed();
        byte[] itemContent = (byte[])this.myItems.get(cacheItemName);
        if (itemContent == null) {
            throw new RepositoryIOException(RBUtil.getStringResource("CacheStorageZipItemNotFound.fmt.txt", cacheItemName));
        }
        this.myItemInputStream = new RepositoryInputStream(new ByteArrayInputStream(itemContent));
        return this.myItemInputStream;
    }

    @Override
    public OutputStream getOutputStream(String cacheItemName) throws RepositoryIOException, RepositoryLockedException, IllegalStateException {
        this.verifyOutputStreamClosed();
        RepositoryOutputStream ros = new RepositoryOutputStream(cacheItemName, new ByteArrayOutputStream());
        ros.setClosingListener(new RepositoryStreamListener(){

            @Override
            public void streamClosing(String name, Object stream) throws RepositoryException {
                ByteArrayOutputStream baos = (ByteArrayOutputStream)stream;
                byte[] itemContent = baos.toByteArray();
                CacheStorageZip.this.myItems.put(name, itemContent);
                if (!CacheStorageZip.this.isInTransaction()) {
                    CacheStorageZip.this.writeZipFile();
                }
            }
        });
        this.myItemOutputStream = ros;
        return this.myItemOutputStream;
    }

    @Override
    public void transactionEnd() throws IllegalStateException, RepositoryException {
        super.transactionEnd();
        this.writeZipFile();
    }

    @Override
    public void transactionStart() {
        super.transactionStart();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append("InputStream closed? ");
        buf.append(this.myItemInputStream.isClosed());
        buf.append("OutputStream closed? ");
        buf.append(this.myItemOutputStream.isClosed());
        buf.append("Cache Item names: ");
        buf.append(this.myItems.keySet());
        return buf.toString();
    }

    @Override
    public void create(String cacheItemName) throws RepositoryException, RepositoryDuplicateNameException {
        if (this.myItems.containsKey(cacheItemName)) {
            throw new RepositoryDuplicateNameException(RBUtil.getStringResource("OMRCacheduplicate.fmt.txt", cacheItemName));
        }
        this.myItems.put(cacheItemName, null);
        if (!this.isInTransaction()) {
            this.writeZipFile();
        }
    }

    @Override
    public void delete(String cacheItemName) throws RepositoryException {
        super.verifyStreamsClosed();
        if (this.myItems.containsKey(cacheItemName)) {
            this.myItems.remove(cacheItemName);
            this.writeZipFile();
        }
    }

    @Override
    public void deleteAll() throws RepositoryException {
        super.verifyStreamsClosed();
        this.myItems.clear();
        this.writeZipFile();
    }

    @Override
    public Set getItemNames() {
        return this.myItems.keySet();
    }

    @Override
    public void deleteContent(String cacheItemName) throws RepositoryException {
        super.verifyStreamsClosed();
        if (this.myItems.containsKey(cacheItemName)) {
            this.myItems.put(cacheItemName, null);
            this.writeZipFile();
        }
    }

    @Override
    public long getSizeInBytes(String cacheItemName) throws RepositoryException {
        byte[] itemContent = (byte[])this.myItems.get(cacheItemName);
        if (itemContent == null) {
            return 0L;
        }
        return itemContent.length;
    }

    @Override
    public String getContentLocation(String cacheItemName) throws RepositoryException {
        OMREntry entry = this.getEntry();
        String prefix = entry.getContentLocation();
        String contentName = this.getContentName(FILE_EXTENSION);
        return this.getContentName(prefix, contentName);
    }

    @Override
    public boolean exists(String cacheItemName) {
        return this.myItems.containsKey(cacheItemName);
    }

    @Override
    public void copy(ContentInterface contentRoot, String srcPathNameAndType, String destPathNameAndType) throws RepositoryException {
        this.copy(contentRoot, srcPathNameAndType, contentRoot, destPathNameAndType);
    }

    @Override
    public void copy(ContentInterface srcRoot, String srcPathNameAndType, ContentInterface destRoot, String destPathNameAndType) throws RepositoryException {
        this.verifyStreamsClosed();
        this.verifyNotInTransaction();
        try {
            String zipSrcName = this.getContentName(srcPathNameAndType, FILE_EXTENSION);
            String zipDestName = this.getContentName(destPathNameAndType, FILE_EXTENSION);
            srcRoot.copyTo(zipSrcName, destRoot, zipDestName);
        }
        catch (ContentNameNotFoundException zipSrcName) {
        }
        catch (Exception e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public void move(ContentInterface contentRoot, String srcPathNameAndType, String destPathNameAndType) throws RepositoryException {
        this.move(contentRoot, srcPathNameAndType, contentRoot, destPathNameAndType);
    }

    @Override
    public void move(ContentInterface srcRoot, String srcPathNameAndType, ContentInterface destRoot, String destPathNameAndType) throws RepositoryException {
        this.verifyStreamsClosed();
        this.verifyNotInTransaction();
        try {
            String zipSrcName = this.getContentName(srcPathNameAndType, FILE_EXTENSION);
            String zipDestName = this.getContentName(destPathNameAndType, FILE_EXTENSION);
            srcRoot.moveTo(zipSrcName, destRoot, zipDestName);
            this.myItems = this.readZipFile();
        }
        catch (ContentNameNotFoundException zipSrcName) {
        }
        catch (Exception e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public void rename(String oldNameAndType, String newNameAndType) throws RepositoryException {
        this.verifyStreamsClosed();
        this.verifyNotInTransaction();
        try {
            ContentInterface content = this.getContent(true);
            String zipOldName = this.getContentName(oldNameAndType, FILE_EXTENSION);
            String zipNewName = this.getContentName(newNameAndType, FILE_EXTENSION);
            content.renameTo(zipOldName, zipNewName);
            this.myItems = this.readZipFile();
        }
        catch (ContentNameNotFoundException content) {
        }
        catch (Exception e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public Object getAttribute(String cacheItemName, String attribName) throws RepositoryException {
        return null;
    }

    @Override
    public Iterator getAttributes(String cacheItemName) throws RepositoryException, SecurityException {
        return null;
    }

    @Override
    public void setAttribute(String cacheItemName, String attribName, Object value) throws RepositoryException {
    }

    @Override
    public void setAttributes(String cacheItemName, Map attributes) throws RepositoryException {
    }

    @Override
    public void lock(String cacheItemName) throws RepositoryException {
    }

    @Override
    public void unlock(String cacheItemName) throws RepositoryException {
    }
}

