/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.CacheStorage;
import com.sas.report.repository.ContentException;
import com.sas.report.repository.ContentFileException;
import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.ContentLockedException;
import com.sas.report.repository.ContentNameNotFoundException;
import com.sas.report.repository.OMREntry;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryInputStream;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.RepositoryOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class CacheStorageFlat
extends CacheStorage {
    private static final String FILE_EXTENSION = ".ndx";
    private Set myCacheItemNames = this.readIndexFile();

    public CacheStorageFlat(OMREntry entry, String cacheName) throws RepositoryException {
        super(entry, cacheName);
    }

    private Set readIndexFile() throws RepositoryException {
        TreeSet<String> itemNames = new TreeSet<String>();
        ContentInterface content = this.getContent(true);
        String ndxFileName = this.getContentName(FILE_EXTENSION);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(content.get(ndxFileName), "UTF-8"));
            String cacheItemName = reader.readLine();
            while (cacheItemName != null) {
                itemNames.add(cacheItemName);
                cacheItemName = reader.readLine();
            }
        }
        catch (ContentNameNotFoundException cacheItemName) {
        }
        catch (ContentFileException e) {
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        catch (ContentException e) {
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        catch (IOException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return itemNames;
    }

    private void writeIndexFile() throws RepositoryException {
        ContentInterface content = this.getContent(true);
        String contentName = this.getContentName(FILE_EXTENSION);
        BufferedWriter writer = null;
        try {
            if (this.myCacheItemNames.isEmpty()) {
                if (content.exists(contentName)) {
                    content.delete(contentName);
                }
            } else {
                OutputStream oStream = content.write(contentName);
                writer = new BufferedWriter(new OutputStreamWriter(oStream, "UTF-8"));
                for (String line : this.myCacheItemNames) {
                    writer.write(line);
                    writer.newLine();
                }
            }
        }
        catch (ContentException e) {
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        catch (IOException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public Set getItemNames() {
        return this.myCacheItemNames;
    }

    @Override
    public boolean exists(String cacheItemName) {
        if (cacheItemName != null) {
            return this.myCacheItemNames.contains(cacheItemName);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public OutputStream getOutputStream(String cacheItemName) throws RepositoryIOException, RepositoryLockedException, IllegalStateException {
        super.verifyOutputStreamClosed();
        try {
            ContentInterface content = this.getContent(true);
            String fullName = this.getContentNameForItem(cacheItemName);
            this.myItemOutputStream = new RepositoryOutputStream(content.write(fullName));
        }
        catch (RepositoryNotFoundException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
        catch (ContentException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
        return this.myItemOutputStream;
    }

    @Override
    public InputStream getInputStream(String cacheItemName) throws RepositoryIOException, RepositoryLockedException, IllegalStateException {
        super.verifyInputStreamClosed();
        try {
            ContentInterface content = this.getContent(true);
            String fullName = this.getContentNameForItem(cacheItemName);
            this.myItemInputStream = new RepositoryInputStream(content.get(fullName));
        }
        catch (ContentException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
        return this.myItemInputStream;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append("InputStream closed? ");
        buf.append(this.myItemInputStream.isClosed());
        buf.append("OutputStream closed? ");
        buf.append(this.myItemOutputStream.isClosed());
        buf.append("Cache Item names: ");
        buf.append(this.myCacheItemNames);
        return buf.toString();
    }

    @Override
    public void create(String cacheItemName) throws RepositoryException, RepositoryDuplicateNameException {
        if (this.myCacheItemNames.contains(cacheItemName)) {
            throw new RepositoryDuplicateNameException(RBUtil.getStringResource("OMRCacheduplicate.fmt.txt", cacheItemName));
        }
        this.myCacheItemNames.add(cacheItemName);
        if (!this.isInTransaction()) {
            this.writeIndexFile();
        }
    }

    @Override
    public void deleteAll() throws RepositoryException {
        super.verifyStreamsClosed();
        for (String cacheItemName : this.myCacheItemNames) {
            this.deleteContent(cacheItemName);
        }
        this.myCacheItemNames.clear();
        this.writeIndexFile();
    }

    @Override
    public void delete(String cacheItemName) throws RepositoryException {
        super.verifyStreamsClosed();
        if (this.myCacheItemNames.contains(cacheItemName)) {
            this.myCacheItemNames.remove(cacheItemName);
            if (!this.isInTransaction()) {
                this.writeIndexFile();
            }
            this.deleteContent(cacheItemName);
        }
    }

    private String getContentNameForItem(String cacheItemName) throws RepositoryException {
        return super.getContentName("," + cacheItemName);
    }

    private String getContentNameForItem(String prefix, String cacheItemName) throws RepositoryException {
        return super.getContentName(prefix, "," + cacheItemName);
    }

    @Override
    public void transactionEnd() throws IllegalStateException, RepositoryException {
        super.transactionEnd();
        this.writeIndexFile();
    }

    @Override
    public void deleteContent(String cacheItemName) throws RepositoryException {
        super.verifyStreamsClosed();
        ContentInterface content = this.getContent(false);
        String fullName = this.getContentNameForItem(cacheItemName);
        try {
            content.delete(fullName);
        }
        catch (ContentNameNotFoundException contentNameNotFoundException) {
        }
        catch (ContentFileException e) {
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        catch (ContentLockedException e) {
            if (!this.myCacheItemNames.contains(cacheItemName)) {
                this.myCacheItemNames.add(cacheItemName);
                if (!this.isInTransaction()) {
                    this.writeIndexFile();
                }
            }
            throw new RepositoryLockedException((Throwable)((Object)e), e.getMessage());
        }
        catch (ContentException e) {
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
    }

    @Override
    public long getSizeInBytes(String cacheItemName) throws RepositoryException {
        ContentInterface content = this.getContent(true);
        String fullName = this.getContentNameForItem(cacheItemName);
        try {
            return content.getSizeInBytes(fullName);
        }
        catch (Exception e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public String getContentLocation(String cacheItemName) throws RepositoryException {
        OMREntry entry = this.getEntry();
        String prefix = entry.getContentLocation();
        return this.getContentNameForItem(prefix, cacheItemName);
    }

    @Override
    public void copy(ContentInterface contentRoot, String srcPathNameAndType, String destPathNameAndType) throws RepositoryException {
        this.copy(contentRoot, srcPathNameAndType, contentRoot, destPathNameAndType);
    }

    @Override
    public void copy(ContentInterface srcRoot, String srcPathNameAndType, ContentInterface destRoot, String destPathNameAndType) throws RepositoryException {
        this.verifyStreamsClosed();
        this.verifyNotInTransaction();
        try {
            String ndxSrcName = this.getContentName(srcPathNameAndType, FILE_EXTENSION);
            String ndxDestName = this.getContentName(destPathNameAndType, FILE_EXTENSION);
            srcRoot.copyTo(ndxSrcName, destRoot, ndxDestName);
            for (String itemName : this.myCacheItemNames) {
                String contentSrcName = this.getContentNameForItem(srcPathNameAndType, itemName);
                String contentDestName = this.getContentNameForItem(destPathNameAndType, itemName);
                try {
                    srcRoot.copyTo(contentSrcName, destRoot, contentDestName);
                }
                catch (ContentNameNotFoundException contentNameNotFoundException) {}
            }
        }
        catch (ContentNameNotFoundException ndxSrcName) {
        }
        catch (Exception e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public void move(ContentInterface contentRoot, String srcPathNameAndType, String destPathNameAndType) throws RepositoryException {
        this.move(contentRoot, srcPathNameAndType, contentRoot, destPathNameAndType);
    }

    @Override
    public void move(ContentInterface srcRoot, String srcPathNameAndType, ContentInterface destRoot, String destPathNameAndType) throws RepositoryException {
        this.verifyStreamsClosed();
        this.verifyNotInTransaction();
        try {
            String ndxSrcName = this.getContentName(srcPathNameAndType, FILE_EXTENSION);
            String ndxDestName = this.getContentName(destPathNameAndType, FILE_EXTENSION);
            srcRoot.moveTo(ndxSrcName, destRoot, ndxDestName);
            this.myCacheItemNames = this.readIndexFile();
            for (String itemName : this.myCacheItemNames) {
                String contentSrcName = this.getContentNameForItem(srcPathNameAndType, itemName);
                String contentDestName = this.getContentNameForItem(destPathNameAndType, itemName);
                try {
                    srcRoot.moveTo(contentSrcName, destRoot, contentDestName);
                }
                catch (ContentNameNotFoundException contentNameNotFoundException) {}
            }
        }
        catch (ContentNameNotFoundException ndxSrcName) {
        }
        catch (Exception e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public void rename(String oldNameAndType, String newNameAndType) throws RepositoryException {
        this.verifyStreamsClosed();
        this.verifyNotInTransaction();
        try {
            ContentInterface content = this.getContent(true);
            String ndxOldName = this.getContentName(oldNameAndType, FILE_EXTENSION);
            String ndxNewName = this.getContentName(newNameAndType, FILE_EXTENSION);
            content.renameTo(ndxOldName, ndxNewName);
            this.myCacheItemNames = this.readIndexFile();
            for (String itemName : this.myCacheItemNames) {
                String contentOldName = this.getContentNameForItem(oldNameAndType, itemName);
                String contentNewName = this.getContentNameForItem(newNameAndType, itemName);
                try {
                    content.renameTo(contentOldName, contentNewName);
                }
                catch (ContentNameNotFoundException contentNameNotFoundException) {}
            }
        }
        catch (ContentNameNotFoundException content) {
        }
        catch (Exception e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public Iterator getAttributes(String cacheItemName) throws RepositoryException, SecurityException {
        try {
            ContentInterface content = this.getContent(true);
            String fullName = this.getContentNameForItem(cacheItemName);
            return content.getAttributes(fullName).entrySet().iterator();
        }
        catch (ContentException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
    }

    @Override
    public void setAttributes(String cacheItemName, Map attributes) throws RepositoryException {
        try {
            ContentInterface content = this.getContent(true);
            String fullName = this.getContentNameForItem(cacheItemName);
            content.setAttributes(fullName, attributes);
        }
        catch (ContentException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
    }

    @Override
    public Object getAttribute(String cacheItemName, String attribName) throws RepositoryException {
        try {
            ContentInterface content = this.getContent(true);
            String fullName = this.getContentNameForItem(cacheItemName);
            return content.getAttribute(fullName, attribName);
        }
        catch (ContentException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
    }

    @Override
    public void setAttribute(String cacheItemName, String attribName, Object value) throws RepositoryException {
        try {
            ContentInterface content = this.getContent(true);
            String fullName = this.getContentNameForItem(cacheItemName);
            content.setAttribute(fullName, attribName, (String)value);
        }
        catch (ContentLockedException e) {
            throw new RepositoryLockedException((Throwable)((Object)e), e.getMessage());
        }
        catch (ContentException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
    }

    @Override
    public void lock(String cacheItemName) throws RepositoryException {
        try {
            ContentInterface content = this.getContent(true);
            String fullName = this.getContentNameForItem(cacheItemName);
            content.lock(fullName);
        }
        catch (ContentLockedException e) {
            throw new RepositoryLockedException((Throwable)((Object)e), e.getMessage());
        }
        catch (ContentException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
    }

    @Override
    public void unlock(String cacheItemName) throws RepositoryException {
        try {
            ContentInterface content = this.getContent(true);
            String fullName = this.getContentNameForItem(cacheItemName);
            content.unlock(fullName);
        }
        catch (ContentLockedException e) {
            throw new RepositoryLockedException((Throwable)((Object)e), e.getMessage());
        }
        catch (ContentException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RepositoryIOException((Throwable)((Object)e), e.getMessage());
        }
    }
}

