/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIOException;
import com.sas.util.Comparator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

class ArchiveDestFactory {
    private static final Comparator ASCENDING_ITEM_NAME_COMPARATOR = new AscendingNameComparator();
    private String _destItemNamePrefix;
    private CacheInterface _destCache;
    private int _itemCount;

    public ArchiveDestFactory(CacheSetInterface cacheSet, Date archiveDate) throws RepositoryException {
        if (archiveDate == null) {
            archiveDate = new Date();
        }
        SimpleDateFormat sf = new SimpleDateFormat("yyyy_MM_dd");
        this._destItemNamePrefix = sf.format(archiveDate);
        this._destCache = cacheSet.exists("OldReports") ? cacheSet.get("OldReports") : cacheSet.create("OldReports", false);
    }

    public Item getNextDestItem() throws RepositoryException {
        String destItemName = this.getNextDestItemName();
        CacheItemInterface destCacheItem = null;
        destCacheItem = this._destCache.exists(destItemName) ? this._destCache.get(destItemName) : this._destCache.create(destItemName);
        return new Item(destCacheItem);
    }

    private String getNextDestItemName() {
        ++this._itemCount;
        StringBuffer buf = new StringBuffer(this._destItemNamePrefix);
        if (this._itemCount > 1) {
            buf.append('_');
            buf.append(this._itemCount);
        }
        buf.append(".pdf");
        return buf.toString();
    }

    public void purgeOlderItems(int maxItemsToKeep) throws RepositoryException {
        List itemList = this._destCache.list(null);
        int itemsToDelete = itemList.size() - maxItemsToKeep;
        if (itemsToDelete > 0) {
            Collections.sort(itemList, ASCENDING_ITEM_NAME_COMPARATOR);
            Iterator itemItor = itemList.iterator();
            while (itemItor.hasNext() && itemsToDelete > 0) {
                CacheItemInterface item = (CacheItemInterface)itemItor.next();
                item.delete();
                --itemsToDelete;
            }
        }
    }

    static class Item {
        private CacheItemInterface _destCacheItem;
        private byte[] _copyBuffer;

        Item(CacheItemInterface destCacheItem) {
            this._destCacheItem = destCacheItem;
            this._copyBuffer = new byte[4096];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void copyContentFrom(CacheItemInterface srcCacheItem) throws IOException, RepositoryIOException {
            InputStream iStream = null;
            OutputStream oStream = null;
            try {
                int bytesRead;
                iStream = srcCacheItem.getInputStream();
                oStream = this._destCacheItem.getOutputStream();
                while ((bytesRead = iStream.read(this._copyBuffer)) > 0) {
                    oStream.write(this._copyBuffer, 0, bytesRead);
                }
            }
            finally {
                if (iStream != null) {
                    try {
                        iStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (oStream != null) {
                    oStream.close();
                }
            }
        }
    }

    static class AscendingNameComparator
    implements Comparator {
        AscendingNameComparator() {
        }

        public int compare(Object first, Object second) {
            String firstName = ((CacheItemInterface)first).getName();
            String secondName = ((CacheItemInterface)second).getName();
            return firstName.compareTo(secondName);
        }
    }
}

