/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.webservices;

import com.ctc.wstx.exc.WstxUnexpectedCharException;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.visuals.LayoutConstants;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.logical.webservices.RB;
import com.sas.metadata.logical.webservices.WebServiceConfirmationPanel;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.user.UserContext;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.web.services.common.WebServiceInfo;
import com.sas.web.services.common.WebServiceMaker;
import com.sas.web.services.common.WebServiceUtilities;
import com.sas.web.services.common.operations.ListWebServicesOperation;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPasswordField;
import com.sas.workspace.WATextField;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;

@SASScope
public class WebServiceInfoPanel
extends WsDescriptionWizardTab
implements LayoutConstants {
    private static final long serialVersionUID = 1L;
    private static final String MAKERS_XMLSELECT = "<XMLSelect search=\"*[@Name=''{0}''][DescriptiveComponent/SoftwareComponent[@Name=''{1}'' or @Name=''{2}'']]\" />";
    private static final String MAKERS_TEMPLATE = "<DeployedComponent><SourceConnections /></DeployedComponent><TCPIPConnection HostName=\"\" Port=\"\" CommunicationProtocol=\"\" Service=\"\" />";
    public static final String SVCS_FLDR_PATH = "/System/Services/";
    private WebServiceInfo _wsInfo;
    static final Logger log = Logger.getLogger(WebServiceConfirmationPanel.class.getName());
    private JLabel _lblUrl;
    protected WAComboBox _comboUrl;
    private JLabel _lblName;
    protected WATextField _txtName;
    private JLabel _lblUserID;
    protected WATextField _txtUserID;
    private JLabel _lblPassword;
    protected WAPasswordField _txtPassword;
    private JRadioButton _rdoCurrentCredentials;
    private JRadioButton _rdoSpecifyCredentials;
    private static Pattern invalidServiceCharactersPattern = Pattern.compile("[\\&/\\\\:<>\\*\\?\"\\|\\s]");

    public WebServiceInfoPanel(WebServiceInfo webServiceInfo) {
        super(RB.getStringResource("WSIP.Wiz.txt"));
        this._wsInfo = webServiceInfo;
        this.initialize();
        this.layoutWidgets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        this.setName(RB.getStringResource("WSIP.Tab.txt"));
        this.setHelpProduct("webservices");
        this.setHelpTopic("webserviceinfowin");
        WorkspaceFile workspaceFile = Workspace.getWorkspace().getAppDefaultsFile();
        String defaultURL = workspaceFile.getPropertyString("com.sas.metadata.logical.webservices.MakerUrl.txt");
        boolean usedOTP = workspaceFile.getPropertyBoolean("com.sas.metadata.logical.webservices.UseOtp.bool", true);
        boolean publishMetadata = workspaceFile.getPropertyBoolean("com.sas.metadata.logical.webservices.PublishMetadata.bool", true);
        String username = null;
        if (!usedOTP) {
            username = workspaceFile.getPropertyString("WSIP.Defaults.Username.txt");
        }
        this._comboUrl = new WAComboBox();
        this._comboUrl.setEditable(true);
        this._comboUrl.setToolTipText(RB.getStringResource("WSIP.Url.tip"));
        this._lblUrl = UtilGui.createLabelForComponent((Component)this._comboUrl, (String)RB.getStringResource("WSIP.Lbl.Url.txt"));
        MdObjectStore mdStore = null;
        try {
            mdStore = Workspace.getMdFactory().createObjectStore();
            String templates = "<Templates><DeployedComponent><SourceConnections /></DeployedComponent><TCPIPConnection HostName=\"\" Port=\"\" CommunicationProtocol=\"\" Service=\"\" /></Templates>";
            String xmlSelect = MessageFormat.format(MAKERS_XMLSELECT, "WebServiceMaker", "BI Web Services for .NET 9.2", "BI Web Services for Java 9.4");
            List makers = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)mdStore, Workspace.getMdFactory().getOMIUtil().getFoundationReposID(), "DeployedComponent", 388, templates + xmlSelect);
            Iterator it = makers.iterator();
            while (it.hasNext()) {
                WebServiceMaker maker = new WebServiceMaker((DeployedComponent)it.next());
                URL makerUrl = maker.getEndpoint();
                String url = makerUrl.getProtocol() + "://" + makerUrl.getHost();
                if (makerUrl.getPort() != makerUrl.getDefaultPort()) {
                    url = url + ":" + makerUrl.getPort();
                }
                url = url + makerUrl.getPath();
                this._comboUrl.addItem((Object)url);
            }
        }
        catch (RemoteException e) {
            log.warning("Error retrieving Web Service Makers from metadata");
        }
        catch (MdException e) {
            log.warning("Error retrieving Web Service Makers from metadata");
        }
        finally {
            if (mdStore != null) {
                try {
                    mdStore.dispose();
                }
                catch (RemoteException e) {}
            }
        }
        if (defaultURL != null) {
            this._comboUrl.setSelectedItem((Object)defaultURL);
        }
        if (!publishMetadata) {
            this._wsInfo.setPublishMetadata(false);
        }
        this._txtName = new WATextField();
        this._txtName.setMaxCharacters(60);
        this._txtName.setToolTipText(RB.getStringResource("WSIP.WebServiceName.tip"));
        this._lblName = UtilGui.createLabelForComponent((Component)this._txtName, (String)RB.getStringResource("WSIP.Lbl.WebServiceName.txt"));
        this._txtUserID = new WATextField();
        this._txtUserID.setMaxCharacters(60);
        this._txtUserID.setToolTipText(RB.getStringResource("WSIP.UserID.tip"));
        if (username != null) {
            this._txtUserID.setText(username);
        }
        this._lblUserID = UtilGui.createLabelForComponent((Component)this._txtUserID, (String)RB.getStringResource("WSIP.Lbl.UserID.txt"));
        this._txtPassword = new WAPasswordField();
        this._txtPassword.setToolTipText(RB.getStringResource("WSIP.Password.tip"));
        this._lblPassword = UtilGui.createLabelForComponent((Component)this._txtPassword, (String)RB.getStringResource("WSIP.Lbl.Password.txt"));
        this._rdoCurrentCredentials = new JRadioButton(RB.getStringResource("WSIP.Lbl.CurrentCredentials.txt"));
        this._rdoCurrentCredentials.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WebServiceInfoPanel.this._txtUserID.setEnabled(false);
                WebServiceInfoPanel.this._lblUserID.setEnabled(false);
                WebServiceInfoPanel.this._txtPassword.setEnabled(false);
                WebServiceInfoPanel.this._lblPassword.setEnabled(false);
            }
        });
        this._rdoSpecifyCredentials = new JRadioButton(RB.getStringResource("WSIP.Lbl.SpecifyCredentials.txt"));
        if (usedOTP) {
            this._rdoCurrentCredentials.setSelected(true);
        } else {
            this._rdoSpecifyCredentials.setSelected(true);
        }
        this._txtUserID.setEnabled(!usedOTP);
        this._lblUserID.setEnabled(!usedOTP);
        this._txtPassword.setEnabled(!usedOTP);
        this._lblPassword.setEnabled(!usedOTP);
        this._rdoSpecifyCredentials.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WebServiceInfoPanel.this._txtUserID.setEnabled(true);
                WebServiceInfoPanel.this._lblUserID.setEnabled(true);
                WebServiceInfoPanel.this._txtPassword.setEnabled(true);
                WebServiceInfoPanel.this._lblPassword.setEnabled(true);
            }
        });
        ButtonGroup btg = new ButtonGroup();
        btg.add(this._rdoCurrentCredentials);
        btg.add(this._rdoSpecifyCredentials);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        int row = 0;
        this.add(this._lblUrl, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add((Component)this._comboUrl, new GridBagConstraints(1, row, 0, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        this.add(this._lblName, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add((Component)this._txtName, new GridBagConstraints(1, row, 0, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        this.add(this._rdoCurrentCredentials, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add(this._rdoSpecifyCredentials, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add(this._lblUserID, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add((Component)this._txtUserID, new GridBagConstraints(1, row, 0, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        this.add(this._lblPassword, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add((Component)this._txtPassword, new GridBagConstraints(1, row, 0, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        JPanel eaterPanel = new JPanel();
        this.add(eaterPanel, new GridBagConstraints(0, ++row, 3, 1, 1.0, 1.0, 10, 1, FIRST_INSETS_IN_ROW, 0, 0));
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this._txtName.setEditable(editable);
        this._comboUrl.setEditable(editable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateData() {
        try {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            String urlString = this._comboUrl.getText().trim();
            if (urlString.length() == 0) {
                MessageUtil.displayMessage((String)RB.getStringResource("WSIP.UrlErr.txt"), (String)RB.getStringResource("WSIP.UrlErr.title.txt"), (int)0);
                this._comboUrl.requestFocus();
                boolean bl = false;
                return bl;
            }
            try {
                new URL(urlString);
            }
            catch (MalformedURLException ex) {
                MessageUtil.displayMessage((String)RB.getStringResource("WSIP.UrlErr.txt"), (String)RB.getStringResource("WSIP.UrlErr.title.txt"), (int)0);
                this._comboUrl.requestFocus();
                boolean bl = false;
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                return bl;
            }
            String nameString = this._txtName.getText();
            if (nameString.length() == 0) {
                MessageUtil.displayMessage((String)RB.getStringResource("WSIP.NoName.txt"), (String)RB.getStringResource("WSIP.NameErr.title.txt"), (int)0);
                this._txtName.requestFocus();
                boolean bl = false;
                return bl;
            }
            boolean valid = WebServiceInfoPanel.validateServiceName(nameString);
            if (valid) {
                UserContextInterface userContext;
                this._wsInfo.setWebServiceMakerUrl(urlString);
                try {
                    userContext = null;
                    if (this._rdoCurrentCredentials.isSelected()) {
                        userContext = UtilPlatformServices.getUserContext();
                    } else {
                        UserServiceInterface userService = UserContext.getUserService();
                        char[] pass = this._txtPassword.getPassword();
                        String password = new String(pass);
                        String domain = UtilPlatformServices.getUserContext().getAuthServer().getDomain();
                        userContext = userService.newUser(this._txtUserID.getText(), password, domain);
                        password = null;
                        for (int i = 0; i < pass.length; ++i) {
                            pass[i] = '\u0000';
                        }
                        pass = null;
                    }
                    PathUrl servicsFolderPath = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)userContext.getAuthServer(), (String)SVCS_FLDR_PATH);
                    FolderInterface servicesFolder = (FolderInterface)userContext.getAuthServer().getObjectByPath(servicsFolderPath);
                    if (servicesFolder == null || !servicesFolder.isAuthorized(servicesFolder instanceof RootFolderInterface ? "WriteMetadata" : "WriteMemberMetadata")) {
                        WebServiceUtilities.ShowScrollableError((String)RB.getStringResource("WSIP.InsufficientMetadataPermissionError.title.txt"), (String)RB.getStringResource("WSIP.InsufficientMetadataPermissionError.short.txt"), (String)MessageFormat.format(RB.getStringResource("WSIP.InsufficientMetadataPermissionError.long.fmt.txt"), SVCS_FLDR_PATH));
                        boolean password = false;
                        return password;
                    }
                }
                catch (ServiceException e) {
                    WebServiceUtilities.ShowScrollableError((String)RB.getStringResource("COM.IntError.title.txt"), (String)RB.getStringResource("COM.IntError.txt"), (String)e.getLocalizedMessage());
                    boolean bl2 = false;
                    return bl2;
                }
                catch (RemoteException e) {
                    MessageUtil.displayRemoteExceptionMessage((RemoteException)e);
                    boolean bl3 = false;
                    return bl3;
                }
                this._wsInfo.setUserContext(userContext);
                OpRequestUI request = new OpRequestUI((Component)((Object)this), RB.getStringResource("WSIP.ListingServices.ProgressBarStatus.txt"));
                ListWebServicesOperation listServices = new ListWebServicesOperation(this._wsInfo);
                try {
                    request.executeWithCancel((Runnable)listServices);
                }
                catch (InterruptedException e) {
                    boolean bl = false;
                    Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                    return bl;
                }
                Throwable listServicesThrowable = listServices.getResultState().getCapturedThrowable();
                if (listServicesThrowable != null) {
                    String errorTitle = RB.getStringResource("COM.IntError.title.txt");
                    String shortMessage = "";
                    String longMessage = "";
                    if (listServicesThrowable instanceof AxisFault) {
                        Throwable causeOfTheCause;
                        AxisFault axisFault = (AxisFault)listServicesThrowable;
                        log.warning(RB.getStringResource("WSIP.Execution.SoapFault.txt") + ":" + axisFault.getLocalizedMessage());
                        Throwable cause = axisFault.getCause();
                        if (cause != null && (causeOfTheCause = cause.getCause()) instanceof WstxUnexpectedCharException) {
                            shortMessage = RB.getStringResource("WSIP.ParsingError.txt");
                            longMessage = axisFault.getLocalizedMessage();
                            WebServiceUtilities.ShowScrollableError((String)errorTitle, (String)shortMessage, (String)longMessage);
                            boolean bl = false;
                            return bl;
                        }
                        OMElement detailEl = axisFault.getDetail();
                        if (detailEl != null && !detailEl.toString().trim().equals("")) {
                            log.warning(detailEl.toString().trim());
                        }
                        String string = longMessage = detailEl != null ? WebServiceUtilities.GetErrorDetailFromAxisFault((AxisFault)axisFault) : axisFault.getLocalizedMessage();
                        shortMessage = axisFault.getLocalizedMessage() != null && !axisFault.getLocalizedMessage().trim().equals("") && !axisFault.getLocalizedMessage().trim().equals(longMessage) ? axisFault.getLocalizedMessage().trim() : RB.getStringResource("WSIP.GetWebServicesError.txt");
                    } else {
                        shortMessage = RB.getStringResource("COM.IntError.txt");
                        longMessage = listServicesThrowable.getLocalizedMessage();
                    }
                    WebServiceUtilities.ShowScrollableError((String)errorTitle, (String)shortMessage, (String)longMessage);
                    boolean bl = false;
                    return bl;
                }
                if (WebServiceInfoPanel.listContainsStringCaseInsensitive(listServices.getServices(), this._txtName.getText().trim())) {
                    int retVal = MessageUtil.displayMessage((String)RB.getStringResource("WSIP.DuplicateName.txt"), (String)RB.getStringResource("WSIP.ConfirmOverwrite.title.txt"), (int)0, (int)0);
                    if (retVal == 1) {
                        this._txtName.requestFocus();
                        boolean shortMessage = false;
                        return shortMessage;
                    }
                    if (retVal == 0) {
                        this._wsInfo.setOverwriteExisting(true);
                        MdObjectStore store = null;
                        try {
                            store = Workspace.getMdFactory().createObjectStore();
                            List dcList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, Workspace.getMdFactory().getOMIUtil().getFoundationReposID(), "DeployedComponent", 128, "<XMLSelect search=\"*[@Name='" + this._txtName.getText().trim() + "'][DescriptiveComponent/SoftwareComponent[@Name='" + "BI Web Services for .NET 9.2" + "' or @Name='" + "BI Web Services for Java 9.4" + "']]\" />");
                            if (dcList.size() == 1) {
                                this._wsInfo.setOldFQID(((DeployedComponent)dcList.get(0)).getFQID());
                            }
                        }
                        catch (MdException mdException) {
                        }
                        finally {
                            if (store != null) {
                                store.dispose();
                            }
                        }
                    }
                }
                this.moveDataToStore();
                this.setDataChanged(true);
                boolean bl = true;
                return bl;
            }
            WebServiceUtilities.ShowScrollableError((String)RB.getStringResource("WSIP.NameErr.title.txt"), (String)RB.getStringResource("COM.IntError.txt"), (String)MessageFormat.format(RB.getStringResource("WSIP.NameErr.InvalidCharacters.fmt.txt"), nameString));
            this._txtName.requestFocus();
            boolean bl = false;
            return bl;
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private static boolean listContainsStringCaseInsensitive(List listToCheck, String target) {
        for (String item : listToCheck) {
            if (item.compareToIgnoreCase(target) != 0) continue;
            return true;
        }
        return false;
    }

    private static boolean validateServiceName(String name) {
        char[] chars = name.toCharArray();
        if (!Character.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i])) continue;
            return false;
        }
        Matcher matcher = invalidServiceCharactersPattern.matcher(name);
        return !matcher.find();
    }

    public void moveDataToView() {
        this._txtName.setText(this._wsInfo.getDeployedWebServiceName());
        if (this._comboUrl.getText().trim().equals("")) {
            this._comboUrl.setSelectedItem((Object)this._wsInfo.getWebServiceMakerUrl());
        }
        if (this._rdoSpecifyCredentials.isSelected() && this._wsInfo.getUserContext() != null) {
            try {
                this._txtUserID.setText(this._wsInfo.getUserContext().getResolvedUserId());
            }
            catch (ServiceException serviceException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void moveDataToStore() {
        String name = this._txtName.getText();
        String url = this._comboUrl.getText();
        if (this._wsInfo.getUserContext() == null) {
            UserContextInterface userContext = null;
            if (this._rdoSpecifyCredentials.isSelected()) {
                try {
                    UserServiceInterface userService = UserContext.getUserService();
                    char[] pass = this._txtPassword.getPassword();
                    String password = new String(pass);
                    userContext = userService.newUser(this._txtUserID.getText(), password, "");
                    password = null;
                    for (int i = 0; i < pass.length; ++i) {
                        pass[i] = '\u0000';
                    }
                    pass = null;
                }
                catch (ServiceException e) {
                    WebServiceUtilities.ShowScrollableError((String)RB.getStringResource("COM.IntError.title.txt"), (String)RB.getStringResource("COM.IntError.txt"), (String)e.getLocalizedMessage());
                }
                catch (RemoteException e) {
                    UtilGui.displayRemoteException((RemoteException)e);
                }
            } else {
                userContext = UtilPlatformServices.getUserContext();
            }
            this._wsInfo.setUserContext(userContext);
        }
        this._wsInfo.setDeployedWebServiceName(name);
        this._wsInfo.setWebServiceMakerUrl(url);
        this._wsInfo.setUseDefaultCredentials(this._rdoCurrentCredentials.isSelected());
        String defaultNamespace = RB.getStringResource("WSKANP.Default.Namespace.url");
        if (!defaultNamespace.endsWith("/")) {
            defaultNamespace = defaultNamespace + "/";
        }
        this._wsInfo.setDeployedWebServiceNamespace(defaultNamespace + name);
    }

    public void populateStore() {
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (saveToModel) {
            this.moveDataToStore();
        } else {
            this.moveDataToView();
        }
        return true;
    }
}

