/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.webservices;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.MemberInterface;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.webservices.DeleteGeneratedSoapService;
import com.sas.metadata.logical.webservices.Images;
import com.sas.metadata.logical.webservices.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Keyword;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.web.services.common.WebServiceMaker;
import com.sas.workspace.Workspace;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;

@SASScope
public class GeneratedSoapServiceLogicalObject
extends LogicalObject
implements MemberInterface {
    private static final String DEPLOYEDCOMPONENT_METADATA_TEMPLATE = "<DeployedComponent><Trees /></DeployedComponent>";

    public GeneratedSoapServiceLogicalObject(DeployedComponent deployedComponent, TypeInterface typeInterface, Factory factory) throws RemoteException {
        super((Root)deployedComponent, typeInterface, factory);
    }

    public Icon getIcon() {
        return Images.getGeneratedSoapServiceLogicalObjectIcon16();
    }

    DeployedComponent getUnderlyingDeployedComponent(MdObjectStore mdObjectStore) throws RemoteException, MdException {
        return (DeployedComponent)this.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdObjectStore, this.getTypeInterface().getMetadataType(), this.getID(), null, null, "<Templates><DeployedComponent><Trees /></DeployedComponent></Templates>", 268);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(OperationUserInteractionInterface deleteInterface) throws LogicalTypeException, RemoteException {
        deleteInterface.updateProgress(RB.getStringResource("GSSLO.DeleteStatus.RetrievingMetadata.txt"));
        MdObjectStore mdObjectStore = null;
        String folderName = "";
        int response = 0;
        try {
            mdObjectStore = this.getFactory().getMdFactory().createObjectStore();
            DeployedComponent deployedComponent = null;
            Tree tree = null;
            deployedComponent = this.getUnderlyingDeployedComponent(mdObjectStore);
            try {
                if (deployedComponent != null) {
                    tree = (Tree)deployedComponent.getTrees().get(0);
                    folderName = tree.getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            deleteInterface.updateProgress(RB.getStringResource("GSSLO.DeleteStatus.CallingRemoveWS.txt"));
            boolean deletedGeneratedService = DeleteGeneratedSoapService.Delete(deployedComponent);
            boolean deletedMetadataObject = false;
            String dcId = deployedComponent.getFQID();
            String dcType = deployedComponent.getCMetadataType();
            if (deletedGeneratedService) {
                deletedMetadataObject = GeneratedSoapServiceLogicalObject.wasObjectDeleted((CMetadata)deployedComponent, mdObjectStore);
                if (!deletedMetadataObject) {
                    deployedComponent.delete();
                    deployedComponent.updateMetadataAll();
                } else {
                    HashMap<String, String> deletedMap = new HashMap<String, String>();
                    deletedMap.put(dcId, dcType);
                    this.getFactory().getMdFactory().fireMdObjectsDeleted(new MdFactoryEvent(this.getFactory().getMdFactory(), deletedMap));
                }
                boolean deletedMap = true;
                return deletedMap;
            }
            if (deleteInterface.continueOperationWithPrompting()) {
                if (response != 1) {
                    response = deleteInterface.displayMessage(RB.getStringResource("GSSLO.Delete.DeleteFailed.title.txt"), MessageFormat.format(RB.getStringResource("GSSLO.Delete.DeleteFailed.fmt.txt"), deployedComponent.getName()), 0, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                }
                if (response == 0 || response == 1) {
                    String dcName = deployedComponent.getName();
                    SoftwareComponent parent = deployedComponent.getDescriptiveComponent();
                    deletedMetadataObject = GeneratedSoapServiceLogicalObject.wasObjectDeleted((CMetadata)deployedComponent, mdObjectStore);
                    if (deletedMetadataObject) {
                        String parentName = parent.getName();
                        List matchingObjs = this.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)mdObjectStore, this.getFactory().getOMIUtil().getReposIdFromMetadataObject((CMetadata)deployedComponent), "DeployedComponent", 392, "<XMLSelect search=\"*[@Name='" + dcName + "'][DescriptiveComponent/SoftwareComponent[@Name='" + parentName + "']]\" />");
                        if (matchingObjs.size() == 1) {
                            deployedComponent = (DeployedComponent)matchingObjs.get(0);
                        } else {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    deployedComponent.delete();
                    deployedComponent.updateMetadataAll();
                    HashMap<String, String> deletedMap = new HashMap<String, String>();
                    deletedMap.put(dcId, dcType);
                    this.getFactory().getMdFactory().fireMdObjectsDeleted(new MdFactoryEvent(this.getFactory().getMdFactory(), deletedMap));
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (MdException e) {
            if (deleteInterface.continueOperationWithPrompting()) {
                String messageText = UtilMisc.getMessage((String)RB.getStringResource("GSSLO.Delete.DeleteFailed.MetadataError.txt"), (Object)this.getName(), (Object)folderName, (Object)UtilMisc.getExceptionMessageText((Exception)((Object)e)));
                int choice = deleteInterface.displayMessage(RB.getStringResource("GSSLO.Delete.DeleteFailed.title.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)deleteInterface, (int)choice);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (mdObjectStore != null) {
                mdObjectStore.dispose();
            }
        }
    }

    public boolean isRenameAllowed() throws LogicalTypeException {
        return true;
    }

    public void rename(String name, OperationUserInteractionInterface deleteInterface) throws LogicalTypeException, RemoteException {
        String originalName = name;
        if ((name = this.validateAndNormalizeName(name)) == null) {
            throw new LogicalTypeException(MessageFormat.format(RB.getStringResource("WSIP.NameErr.InvalidCharacters.fmt.txt"), originalName));
        }
        deleteInterface.updateProgress(RB.getStringResource("GSSLO.DeleteStatus.RetrievingMetadata.txt"));
        MdObjectStore mdObjectStore = null;
        mdObjectStore = this.getFactory().getMdFactory().createObjectStore();
        DeployedComponent deployedComponent = null;
        try {
            deployedComponent = this.getUnderlyingDeployedComponent(mdObjectStore);
            SoftwareComponent parent = deployedComponent.getDescriptiveComponent();
            WebServiceMaker wsm = null;
            if (parent != null) {
                AssociationList siblings = parent.getDeployedComponents();
                for (DeployedComponent sibling : siblings) {
                    if (!sibling.getName().equals("WebServiceMaker")) continue;
                    wsm = new WebServiceMaker(sibling);
                    break;
                }
            }
            UserContextInterface uc = Workspace.getWorkspace().getUserContext();
            if (wsm != null) {
                List existingServices = wsm.listWebServices(uc);
                boolean overwrite = false;
                if (existingServices.contains(name)) {
                    boolean bl = overwrite = deleteInterface.displayMessage(RB.getStringResource("WSIP.ConfirmOverwrite.title.txt"), RB.getStringResource("WSIP.DuplicateName.txt"), 3, OperationUserInteractionInterface.YES_NO_CANCEL_CHOICE_SET) == 0;
                    if (!overwrite) {
                        return;
                    }
                    wsm.deleteService(name, uc);
                }
                ArrayList<String> classifierMaps = new ArrayList<String>();
                ServerInterface authServer = Workspace.getWorkspace().getUserContext().getAuthServer();
                for (Object implementedObject : deployedComponent.getImplementedObjects()) {
                    ClassifierMap cm;
                    MetadataInterface mi;
                    if (!(implementedObject instanceof ClassifierMap) || (mi = authServer.fetch((cm = (ClassifierMap)implementedObject).getFQID() + "/" + cm.getCMetadataType(), true)) == null) continue;
                    classifierMaps.add(mi.getPathUrl().getDisplayPath());
                }
                String namespace = null;
                AssociationList targetProperties = deployedComponent.getProperties();
                for (Property prop : targetProperties) {
                    if (!prop.getName().equalsIgnoreCase("Namespace") || prop.getDefaultValue().trim().equals("")) continue;
                    namespace = prop.getDefaultValue().trim();
                    break;
                }
                AssociationList keywordsList = deployedComponent.getKeywords();
                String[] keywords = new String[keywordsList.size()];
                int keywordIndex = 0;
                for (Keyword keyword : keywordsList) {
                    keywords[keywordIndex] = keyword.getName();
                    ++keywordIndex;
                }
                String[] stps = new String[classifierMaps.size()];
                int index = 0;
                Iterator cmIt = classifierMaps.iterator();
                while (cmIt.hasNext()) {
                    stps[index] = (String)cmIt.next();
                    ++index;
                }
                wsm.makeWebService(name, stps, namespace, keywords, uc, true);
                String oldName = deployedComponent.getName();
                DeployedComponent dcToDelete = null;
                for (DeployedComponent sibling : parent.getDeployedComponents(true)) {
                    if (!sibling.getName().equals(name)) continue;
                    dcToDelete = sibling;
                }
                dcToDelete.delete();
                deployedComponent.setName(name);
                deployedComponent.updateMetadataAll();
                DeployedComponent dummyDc = (DeployedComponent)this.getFactory().getMdFactory().createComplexMetadataObject(mdObjectStore, oldName, "DeployedComponent", deployedComponent.getRepositoryID());
                parent.getDeployedComponents().add((Object)dummyDc);
                parent.updateMetadataAll();
                wsm.deleteService(oldName, uc);
            }
        }
        catch (MdException e1) {
            throw new LogicalTypeException((Exception)((Object)e1));
        }
        catch (MalformedURLException e) {
            throw new LogicalTypeException((Exception)e);
        }
        catch (ServiceException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        finally {
            if (mdObjectStore != null) {
                mdObjectStore.dispose();
            }
        }
    }

    protected String validateAndNormalizeName(String oldName) throws IllegalArgumentException {
        if (oldName == null || (oldName = oldName.trim()).length() == 0) {
            return null;
        }
        String serviceName = oldName;
        Pattern p = Pattern.compile("[ ]");
        Matcher m = p.matcher(serviceName);
        serviceName = m.replaceAll("");
        if (!Character.isJavaIdentifierStart(serviceName.charAt(0)) || serviceName.contains("$") || serviceName.contains("\\")) {
            return null;
        }
        for (int i = 1; i < serviceName.length(); ++i) {
            if (Character.isJavaIdentifierPart(serviceName.charAt(i))) continue;
            return null;
        }
        return serviceName;
    }

    private static boolean wasObjectDeleted(CMetadata obj, MdObjectStore mdObjectStore) throws RemoteException {
        try {
            mdObjectStore.refreshObjectFromServer(obj, true, true);
        }
        catch (MdException e) {
            return true;
        }
        return false;
    }
}

