/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.webservices;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.webservices.GeneratedSoapServiceImportItem;
import com.sas.metadata.logical.webservices.RB;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.swing.visuals.TriStateCheckBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

@SASScope
public class GeneratedSoapServiceImportOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private TriStateCheckBox _ckbOverwrite = new TriStateCheckBox(RB.getStringResource("GSSIOP.OverwriteExisting.txt"));
    private boolean _dataChanged;
    private SimpleLogicalObjectInterface[] m_aItems;

    public GeneratedSoapServiceImportOptionsPanel(int promotionType) {
        this._ckbOverwrite.setToolTipText(RB.getStringResource("GSSIOP.OverwriteExisting.tip"));
        this._ckbOverwrite.setCycleEnabled(false);
        this._ckbOverwrite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneratedSoapServiceImportOptionsPanel.this._dataChanged = true;
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this._ckbOverwrite, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void populateImportOptions(ImportItemInterface[] aItems) {
        this.m_aItems = aItems;
        this._ckbOverwrite.setSelectedValue(this.determineCheckBoxState((SimpleLogicalObjectInterface[])aItems));
    }

    public void saveSettings() {
        if (!this._dataChanged) {
            return;
        }
        for (int i = 0; i < this.m_aItems.length; ++i) {
            ((GeneratedSoapServiceImportItem)this.m_aItems[i]).setOverwriteService(this._ckbOverwrite.isSelected());
        }
        this._dataChanged = false;
    }

    private int determineCheckBoxState(SimpleLogicalObjectInterface[] aItems) {
        boolean bAllOn = true;
        boolean bAllOff = true;
        for (int i = 0; i < this.m_aItems.length; ++i) {
            boolean bOn = ((GeneratedSoapServiceImportItem)this.m_aItems[i]).isOverwriteService();
            bAllOn &= bOn;
            bAllOff &= !bOn;
        }
        if (bAllOn) {
            return 2;
        }
        if (bAllOff) {
            return 0;
        }
        return 1;
    }
}

