/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.webservices;

import com.ctc.wstx.exc.WstxUnexpectedCharException;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.visuals.Images;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.logical.webservices.RB;
import com.sas.metadata.logical.webservices.WebServiceConfirmationPanel;
import com.sas.metadata.logical.webservices.WebServiceInfoPanel;
import com.sas.metadata.logical.webservices.WebServiceKeywordsAndNamespacePanel;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.web.services.common.WebServiceInfo;
import com.sas.web.services.common.WebServiceUtilities;
import com.sas.web.services.common.operations.CreateWebServiceOperation;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JDialog;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;

@SASScope
public class DeployWebServiceWizard
extends WAWizardDialog {
    private static final long serialVersionUID = 1L;
    static final Logger log = Logger.getLogger(DeployWebServiceWizard.class.getName());
    private WebServiceInfo _wsInfo;

    public DeployWebServiceWizard(Frame frame, Root[] roots, LogicalObjectInterface[] logicalObjects) {
        super(frame, RB.getStringResource("DWSW.Title.txt"), true);
        this._initialize(roots, logicalObjects);
    }

    public Root getNonNullRoot(Root root, LogicalObjectInterface logicalObject, MdObjectStore store) throws MdException, RemoteException {
        if (root == null) {
            root = UtilMetadata.getJOMAObjectFromLogicalObject((LogicalObjectInterface)logicalObject, (MdObjectStore)store);
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _initialize(Root[] roots, LogicalObjectInterface[] logicalObjects) {
        String namespace = RB.getStringResource("WSKANP.Default.Namespace.url");
        if (roots == null || roots.length != logicalObjects.length) {
            roots = new Root[logicalObjects.length];
        }
        String[] storedProcesses = new String[logicalObjects.length];
        MdObjectStore store = null;
        try {
            store = Workspace.getMdFactory().createObjectStore();
            for (int i = 0; i < logicalObjects.length; ++i) {
                roots[i] = this.getNonNullRoot(roots[i], logicalObjects[i], store);
                storedProcesses[i] = "/" + UtilPlatformServices.getSmartObject((Root)roots[i]).getParentPath(null) + logicalObjects[i].getName();
            }
        }
        catch (RemoteException e) {
            String msg = RB.getStringResource("COM.IntError.txt") + e.getMessage();
            UtilGui.displayError((String)msg);
        }
        catch (MdException e) {
            String msg = RB.getStringResource("COM.IntError.txt") + e.getMessage();
            UtilGui.displayError((String)msg);
        }
        catch (ServiceException e) {
            String msg = RB.getStringResource("COM.IntError.txt") + e.getMessage();
            UtilGui.displayError((String)msg);
        }
        finally {
            if (store != null) {
                try {
                    store.dispose();
                }
                catch (RemoteException e) {}
            }
        }
        this._wsInfo = new WebServiceInfo(storedProcesses, namespace, null);
        Icon icon = Images.getNameDescriptionWizardImage();
        this.addTab(RB.getStringResource("WSIP.Tab.txt"), null, (WAPropertyTab)new WebServiceInfoPanel(this._wsInfo), "gen", icon);
        this.addTab(RB.getStringResource("WSKANP.Tab.txt"), null, (WAPropertyTab)new WebServiceKeywordsAndNamespacePanel(this._wsInfo), "key", icon);
        this.addTab(RB.getStringResource("WSCP.Tab.txt"), null, (WAPropertyTab)new WebServiceConfirmationPanel(this._wsInfo), "conf", icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onFinish() {
        OpRequestUI request = new OpRequestUI((JDialog)((Object)this), RB.getStringResource("DWSW.CreatingService.ProgressBarStatus.txt"));
        CreateWebServiceOperation createService = new CreateWebServiceOperation(this._wsInfo);
        request.execute((Runnable)createService);
        if (createService.getResultState().wasSuccessful()) {
            ArrayList<String> urls;
            this._wsInfo.setDeployedWebServiceUrl(createService.getResultState().getUrl());
            if (createService.getResultState().getUrl() != null) {
                log.log(Level.INFO, MessageFormat.format(RB.getStringResource("WSCP.Log.DeployedServiceURL.fmt.txt"), createService.getResultState().getUrl()));
            }
            WorkspaceFile workspaceFile = Workspace.getWorkspace().getAppDefaultsFile();
            workspaceFile.setPropertyString("com.sas.metadata.logical.webservices.MakerUrl.txt", this._wsInfo.getWebServiceMakerUrl());
            workspaceFile.setPropertyBoolean("com.sas.metadata.logical.webservices.UseOtp.bool", this._wsInfo.isUseDefaultCredentials());
            MdObjectStore store = null;
            try {
                if (!this._wsInfo.isUseDefaultCredentials()) {
                    try {
                        workspaceFile.setPropertyString("WSIP.Defaults.Username.txt", this._wsInfo.getUserContext().getResolvedUserId());
                    }
                    catch (ServiceException serviceException) {
                        // empty catch block
                    }
                }
                workspaceFile.saveExisting();
                urls = new ArrayList<String>();
                urls.add(this._wsInfo.getDeployedWebServiceUrl());
                store = Workspace.getMdFactory().createObjectStore();
                List dcList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, Workspace.getMdFactory().getOMIUtil().getFoundationReposID(), "DeployedComponent", 128, "<XMLSelect search=\"*[@Name='" + this._wsInfo.getDeployedWebServiceName() + "'][DescriptiveComponent/SoftwareComponent[@Name='" + "BI Web Services for .NET 9.2" + "' or @Name='" + "BI Web Services for Java 9.4" + "']]\" />");
                if (dcList.size() > 1) {
                    log.warning("More than one Generated SOAP Service exists with the name '" + this._wsInfo.getDeployedWebServiceName() + "'");
                } else if (dcList.size() == 1) {
                    DeployedComponent dc = (DeployedComponent)dcList.get(0);
                    HashMap<String, String> objectMap = new HashMap<String, String>();
                    objectMap.put(dc.getFQID(), dc.getCMetadataType());
                    ArrayList<String> dcIds = new ArrayList<String>();
                    dcIds.add(dc.getFQID());
                    if (this._wsInfo.isOverwriteExisting()) {
                        HashMap<String, String> deletedMap = new HashMap<String, String>();
                        deletedMap.put(this._wsInfo.getOldFQID(), dc.getCMetadataType());
                        Workspace.getMdFactory().fireMdObjectsDeleted(new MdFactoryEvent(Workspace.getMdFactory(), deletedMap));
                    }
                    Workspace.getMdFactory().fireMdObjectsCreated(new MdFactoryEvent(Workspace.getMdFactory(), objectMap));
                }
            }
            catch (RemoteException e) {
                log.warning(e.getLocalizedMessage());
            }
            catch (MdException e) {
                log.warning(e.getLocalizedMessage());
            }
            finally {
                if (store != null) {
                    try {
                        store.dispose();
                    }
                    catch (RemoteException e) {}
                }
            }
            if (createService.getResultState().getUrl() != null) {
                urls = new ArrayList(1);
                urls.add(createService.getResultState().getUrl());
                MessageUtil.displayListMessage((String)RB.getStringResource("WSCP.SuccessMessage.txt"), urls, (String)RB.getStringResource("WSCP.SuccessMessage.title.txt"), (int)1, (int)-1);
            } else {
                MessageUtil.displayMessage((String)RB.getStringResource("WSCP.Success.NotDeployed.txt"), (int)1);
            }
        } else {
            Throwable createServiceThrowable = createService.getResultState().getCapturedThrowable();
            String errorTitle = "";
            String shortMessage = "";
            String longMessage = "";
            if (createServiceThrowable instanceof AxisFault) {
                Throwable causeOfTheCause;
                Throwable cause;
                AxisFault axisFault = (AxisFault)createServiceThrowable;
                log.warning(RB.getStringResource("WSIP.Execution.SoapFault.txt") + ":" + axisFault.getLocalizedMessage());
                OMElement detailEl = axisFault.getDetail();
                if (detailEl != null && !detailEl.toString().trim().equals("")) {
                    log.warning(detailEl.toString().trim());
                }
                if ((cause = axisFault.getCause()) != null && (causeOfTheCause = cause.getCause()) instanceof WstxUnexpectedCharException) {
                    shortMessage = RB.getStringResource("WSIP.ParsingError.txt");
                    longMessage = axisFault.getLocalizedMessage();
                    WebServiceUtilities.ShowScrollableError((String)errorTitle, (String)shortMessage, (String)longMessage);
                    return false;
                }
                shortMessage = axisFault.getLocalizedMessage() != null && !axisFault.getLocalizedMessage().trim().equals("") && !axisFault.getLocalizedMessage().trim().equals(longMessage) ? axisFault.getLocalizedMessage().trim() : RB.getStringResource("WSIP.Execution.SoapFault.txt");
                longMessage = detailEl != null ? WebServiceUtilities.GetErrorDetailFromAxisFault((AxisFault)axisFault) : axisFault.getLocalizedMessage();
                WebServiceUtilities.ShowScrollableError((String)errorTitle, (String)shortMessage, (String)longMessage);
            } else if (createServiceThrowable != null && createServiceThrowable instanceof RemoteException) {
                log.log(Level.WARNING, createServiceThrowable.getLocalizedMessage(), createServiceThrowable);
                MessageUtil.displayRemoteExceptionMessage((RemoteException)((RemoteException)createServiceThrowable));
            } else {
                log.log(Level.WARNING, RB.getStringResource("COM.IntError.txt") + ":" + createServiceThrowable.getLocalizedMessage());
                log.log(Level.FINE, createServiceThrowable.getStackTrace().toString());
                errorTitle = RB.getStringResource("COM.IntError.title.txt");
                shortMessage = RB.getStringResource("COM.IntError.txt");
                longMessage = createServiceThrowable.getLocalizedMessage();
                WebServiceUtilities.ShowScrollableError((String)errorTitle, (String)shortMessage, (String)longMessage);
            }
        }
        return createService.getResultState().wasSuccessful();
    }
}

