/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocessreport;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.storedprocessreport.RB;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.SmartWsDescriptionWizardTab;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.publicobjects.storedprocessreport.MetadataConstants;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.prompt.PersistenceFactoryWithServices;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.models.ISimpleObjectFilter;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

class StoredProcessTabPanel
extends SmartWsDescriptionWizardTab {
    static String[] _publicTypes = new String[]{"StoredProcess"};
    private WATextField _txtStoredProcess;
    private JButton _btnSelectStoredProcess;
    private PromptPropertiesPanel _promptPanel;
    private int _type;
    private Transformation _transformation;
    private Property _promptValuesProperty;
    private ClassifierMap _storedProcessCM;
    private StoredProcessInterface _storedProcessSmartObject;
    private PromptValuesInterface _promptValues;
    private UtilPlatformServices.DetachedTransaction _detachedTransaction;
    private SimpleObjectsFilter _simpeObjectsFilter;

    public StoredProcessTabPanel(Transformation transformation, int type, Config config) {
        this._transformation = transformation;
        this._type = type;
        this.setName(RB.getStringResource("SPTP.Tab.txt"));
        this.setDescription(RB.getStringResource("SPTP.Wiz.txt"));
        if (type == 1) {
            this.setHelpProduct("storedprocessreport");
            this.setHelpTopic("stptab");
        } else {
            this.setHelpProduct("newstprpt");
            this.setHelpTopic("stpwin");
        }
        this.setLayout(new GridBagLayout());
        int row = 0;
        this._txtStoredProcess = new WATextField();
        this._txtStoredProcess.setEditable(false);
        this._txtStoredProcess.setToolTipText(RB.getStringResource("SPTP.Tooltip.SP.txt"));
        JLabel lblStoredProcess = UtilGui.createLabelForComponent((Component)this._txtStoredProcess, (String)RB.getStringResource("SPTP.Lbl.SP.txt"));
        this._btnSelectStoredProcess = UtilGui.createButton((String)RB.getStringResource("SPTP.Btn.Select.txt"));
        this.add(lblStoredProcess, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add((Component)this._txtStoredProcess, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        this.add(this._btnSelectStoredProcess, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 18, 0, NEXT_INSETS_IN_ROW, 0, 0));
        this._btnSelectStoredProcess.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    StoredProcessTabPanel.this.doSelectStoredProcess();
                }
                catch (MdException e) {
                    UtilGui.displayMdException((MdException)e);
                }
                catch (RemoteException e) {
                    UtilGui.displayRemoteException((RemoteException)e);
                }
                catch (Exception e) {
                    UtilGui.displayExceptionError((Exception)e);
                }
            }
        });
        JLabel promptLabel = new JLabel(RB.getStringResource("SPTP.Lbl.PV.txt"));
        this.add(promptLabel, new GridBagConstraints(0, ++row, 3, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this._promptPanel = new PromptPropertiesPanel(null, (DataProviderInterface)new DataProvider(UtilPlatformServices.getUserContext()), Locale.getDefault());
        this.add((Component)this._promptPanel, new GridBagConstraints(0, ++row, 3, 1, 1.0, 1.0, 10, 1, FIRST_INSETS_IN_ROW, 0, 0));
        this._promptPanel.setShowHiddenPrompts(true);
        this.setPreferredSize(new Dimension(500, 500));
    }

    protected void smartPopulateStore() throws MdException, RemoteException {
        try {
            this._detachedTransaction = UtilPlatformServices.getDetachedTransaction();
        }
        catch (LogicalTypeException e) {
            throw new MdException((Throwable)e);
        }
        if (this._type == 1) {
            this._promptValuesProperty = UtilMetadata.getProperty((Root)this._transformation, (String)"PromptValues", null);
            AssociationList al = this._transformation.getTransformationSources();
            if (al.size() > 1) {
                throw new MdException(RB.getStringResource("SPTP.MulSP.txt"));
            }
            if (al.size() == 1) {
                this._storedProcessCM = (ClassifierMap)al.get(0);
                try {
                    this.setSmartObjectAndPromptValues();
                }
                catch (ServiceException e1) {
                    throw new MdException((Throwable)e1);
                }
                catch (LogicalTypeException e1) {
                    throw new MdException((Throwable)e1);
                }
                if (this._promptValuesProperty != null && this._promptValuesProperty.getDefaultValue().length() > 0) {
                    String promptValuesXML = this._promptValuesProperty.getDefaultValue();
                    StringReader reader = new StringReader(promptValuesXML);
                    PromptsReadingContext prc = null;
                    try {
                        prc = PersistenceFactoryWithServices.newReadingContext((UserContextInterface)UtilPlatformServices.getUserContext());
                        LoggerFactoryInterface lf = PersistenceFactoryWithServices.newLoggerFactory((SessionContextInterface)UtilPlatformServices.getSessionContext());
                        PromptValuesInterface pvFromXML = (PromptValuesInterface)PromptUtil.newObjectFromXML((Reader)reader, (LoggerFactoryInterface)lf, (PromptsReadingContext)prc);
                        if (this._promptValues != null && pvFromXML != null) {
                            ArrayList ignoredDefinitionsList = new ArrayList();
                            ArrayList errorDefinitionsList = new ArrayList();
                            PromptUtil.mergePromptValuesByPromptDefinitionID((PromptValuesInterface)pvFromXML, (PromptValuesInterface)this._promptValues, ignoredDefinitionsList, errorDefinitionsList);
                            if (errorDefinitionsList.size() > 0 || ignoredDefinitionsList.size() > 0) {
                                ArrayList<String> combinedList = new ArrayList<String>();
                                for (PromptDefinitionInterface pdi : ignoredDefinitionsList) {
                                    combinedList.add(pdi.getPromptName());
                                }
                                for (PromptDefinitionInterface pdi : errorDefinitionsList) {
                                    combinedList.add(pdi.getPromptName());
                                }
                                MessageUtil.displayListMessage((String)RB.getStringResource("SPTP.PromptMismatch.txt"), combinedList, (String)RB.getStringResource("SPTP.Prompt.Title.txt"), (int)2, (int)-1);
                            }
                        }
                    }
                    catch (SAXException e) {
                        throw new MdException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new MdException((Throwable)e);
                    }
                    catch (ParserConfigurationException e) {
                        throw new MdException((Throwable)e);
                    }
                    finally {
                        reader.close();
                        if (prc != null) {
                            prc.destroy();
                        }
                    }
                }
            }
        }
    }

    private void setSmartObjectAndPromptValues() throws RemoteException, ServiceException, MdException, LogicalTypeException {
        this._promptValues = null;
        this._storedProcessSmartObject = (StoredProcessInterface)this._detachedTransaction.getSmartObject((Root)this._storedProcessCM);
        this._promptValues = this._storedProcessSmartObject.getPromptValues();
    }

    public void saveSettingsAndCleanUp() {
        if (this._detachedTransaction != null) {
            try {
                this._detachedTransaction.rollback();
            }
            catch (RemoteException e) {
                UtilGui.displayRemoteException((RemoteException)e);
            }
            catch (LogicalTypeException e) {
                UtilGui.displayExceptionError((Exception)((Object)e));
            }
        }
    }

    protected boolean dataValidate() throws RemoteException {
        if (this._storedProcessCM == null) {
            UtilGui.displayError((String)RB.getStringResource("SPTP.noSP.txt"));
            this._btnSelectStoredProcess.requestFocus();
            return false;
        }
        try {
            String msg = MetadataConstants.validateStoredProcess((StoredProcessInterface)this._storedProcessSmartObject, (PromptValuesInterface)this._promptValues);
            if (msg != null) {
                UtilGui.displayError((String)msg);
                return false;
            }
            List valueless = PromptUtil.getRequiredPromptsWithoutValues((PromptValuesInterface)this._promptValues);
            if (valueless.size() > 0) {
                UtilGui.displayError((String)RB.getStringResource("SPTP.missingVals.txt"));
                return false;
            }
        }
        catch (ServiceException e) {
            UtilGui.displayExceptionError((Exception)((Object)e));
            return false;
        }
        return true;
    }

    public void moveDataToView() throws MdException, RemoteException {
        try {
            this.setStoredProcessPathInTextBox();
        }
        catch (ServiceException e) {
            UtilGui.displayExceptionError((Exception)((Object)e));
        }
        this._btnSelectStoredProcess.requestFocus();
        this._promptPanel.setPromptValues(this._promptValues);
        this._promptPanel.revalidate();
        this._promptPanel.repaint();
    }

    private void setStoredProcessPathInTextBox() throws ServiceException, RemoteException {
        PathUrl pathURL;
        String textToSet = this._storedProcessCM == null ? "" : (this._storedProcessSmartObject == null ? this._storedProcessCM.getName() : ((pathURL = this._storedProcessSmartObject.getPathUrl()) == null ? this._storedProcessCM.getName() : pathURL.getDisplayPath()));
        this._txtStoredProcess.setText(textToSet);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        AssociationList al = this._transformation.getTransformationSources();
        al.clear();
        al.add((Object)this._storedProcessCM);
        if (this._promptValues != null) {
            String promptValuesXML;
            try {
                promptValuesXML = XmlUtil.promptModelToPrettyString((PersistenceInterface)((PersistenceInterface)this._promptValues));
            }
            catch (ParserConfigurationException e) {
                throw new MdException((Throwable)e);
            }
            catch (BackingStoreException e) {
                throw new MdException((Throwable)e);
            }
            if (this._promptValuesProperty == null) {
                this._promptValuesProperty = UtilMetadata.addPropertyToObject((Root)this._transformation, (String)"PromptValues", null, null);
            }
            this._promptValuesProperty.setDefaultValue(promptValuesXML);
        }
    }

    private void doSelectStoredProcess() throws RemoteException, MdException, ServiceException, LogicalTypeException {
        SimpleObject so;
        SimpleObject o;
        UserContextInterface user = UtilPlatformServices.getUserContext();
        ObjectSelectorPanel _selectorPanel = new ObjectSelectorPanel(user, -1, null, true);
        _selectorPanel.setSelectionOptional(false);
        _selectorPanel.setVisibleTypes(_publicTypes);
        _selectorPanel.setInventoryTypes(_publicTypes);
        _selectorPanel.setAdditionalHierarchyModel(null);
        _selectorPanel.setInvalidObjectSelectedErrorMessage(RB.getStringResource("SPTP.selTRP.txt"));
        if (this._simpeObjectsFilter == null) {
            this._simpeObjectsFilter = new SimpleObjectsFilter();
        }
        _selectorPanel.setSelectableObjectsFilter((ISimpleObjectFilter)this._simpeObjectsFilter);
        if (this._storedProcessCM != null) {
            SimpleObjectImpl selected = new SimpleObjectImpl(this._storedProcessCM.getName(), this._storedProcessCM.getFQID(), "ClassifierMap", "StoredProcess");
            _selectorPanel.setSelectedObject((SimpleObject)selected);
        }
        String dialogTitle = RB.getStringResource("SPTP.SPDlg.Title.txt");
        WAStandardDialog _selectorDialog = new WAStandardDialog(Factory.getInstance().getFrame(), dialogTitle, true, (WAPanel)_selectorPanel);
        _selectorDialog.setResizable(true);
        _selectorDialog.setHelpProduct("storedprocessreport");
        _selectorDialog.setHelpTopic("choosestp");
        _selectorDialog.show();
        if (_selectorDialog.getReturnValue() == 1 && (o = _selectorPanel.getSelectedObject()) != null && o instanceof SimpleObject && (so = o).getPublicType().equals("StoredProcess")) {
            this._storedProcessCM = (ClassifierMap)UtilMetadata.locateExistingObject((MdObjectStore)((MdObjectStore)this._transformation.getObjectStore()), (String)"ClassifierMap", (String)so.getID());
            this.setSmartObjectAndPromptValues();
            this.setStoredProcessPathInTextBox();
            this._promptPanel.setPromptValues(this._promptValues);
            this._promptPanel.revalidate();
            this._promptPanel.repaint();
        }
    }

    class SimpleObjectsFilter
    implements ISimpleObjectFilter {
        SimpleObjectsFilter() {
        }

        public boolean accept(SimpleObject simpleObject) {
            if (!simpleObject.getPublicType().equals("StoredProcess")) {
                return false;
            }
            try {
                StoredProcessInterface spi = (StoredProcessInterface)StoredProcessTabPanel.this._detachedTransaction.getSmartObject(simpleObject.getID(), simpleObject.getMetadataType());
                return MetadataConstants.validateStoredProcess((StoredProcessInterface)spi, (PromptValuesInterface)spi.getPromptValues()) == null;
            }
            catch (Exception e) {
                UtilGui.displayExceptionError((Exception)e);
                return false;
            }
        }
    }
}

