/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocessreport;

import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.storedprocessreport.RB;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.SmartWsDescriptionWizardTab;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.publicobjects.storedprocessreport.ExpirationPolicyInterface;
import com.sas.publicobjects.storedprocessreport.StoredProcessReportInterface;
import com.sas.publicobjects.storedprocessreport.StoredProcessReportOutputInterface;
import com.sas.scheduler.model.DailyRecurrence;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.MonthlyRecurrence;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.Timezone;
import com.sas.scheduler.model.WeeklyRecurrence;
import com.sas.scheduler.visuals.swing.TimeHourMinutePanel;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.workspace.MessageUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

class OutputTabPanel
extends SmartWsDescriptionWizardTab
implements ListSelectionListener {
    private JTable _table;
    private JSpinner _spinnerMaxGenerations;
    private int _type;
    private Transformation _transformation;
    private Property _maxGensProperty;
    private boolean _maxGensValidValuePresentInProperty;
    private int _maxGenerations;
    private Property _expirationPolicyProperty;
    private ExpirationPolicyInterface.Period _period;
    private TableModel _tableModel;
    private JButton _buttonDelete;
    private JRadioButton _policy_none;
    private JRadioButton _policy_daily;
    private JRadioButton _policy_weekly;
    private JRadioButton _policy_monthly;
    private TimeHourMinutePanel _timePanel;
    private JPanel _daysOfTheWeekPanel;
    private JCheckBox[] _daysOfTheWeek;
    private JPanel _dayOfTheMonthPanel;
    private JComboBox _dayOfTheMonth;
    private int _dayOfTheMonthIndexValue;
    private int _hourValue;
    private int _minValue;
    private String _timeZoneID;
    private int _dayMaskValue;
    private boolean _firstTimeInWizard = true;
    private String[] _daysOfMonth = new String[]{RB.getStringResource("OTP.dom.1.txt"), RB.getStringResource("OTP.dom.2.txt"), RB.getStringResource("OTP.dom.3.txt"), RB.getStringResource("OTP.dom.4.txt"), RB.getStringResource("OTP.dom.5.txt"), RB.getStringResource("OTP.dom.6.txt"), RB.getStringResource("OTP.dom.7.txt"), RB.getStringResource("OTP.dom.8.txt"), RB.getStringResource("OTP.dom.9.txt"), RB.getStringResource("OTP.dom.10.txt"), RB.getStringResource("OTP.dom.11.txt"), RB.getStringResource("OTP.dom.12.txt"), RB.getStringResource("OTP.dom.13.txt"), RB.getStringResource("OTP.dom.14.txt"), RB.getStringResource("OTP.dom.15.txt"), RB.getStringResource("OTP.dom.16.txt"), RB.getStringResource("OTP.dom.17.txt"), RB.getStringResource("OTP.dom.18.txt"), RB.getStringResource("OTP.dom.19.txt"), RB.getStringResource("OTP.dom.20.txt"), RB.getStringResource("OTP.dom.21.txt"), RB.getStringResource("OTP.dom.22.txt"), RB.getStringResource("OTP.dom.23.txt"), RB.getStringResource("OTP.dom.24.txt"), RB.getStringResource("OTP.dom.25.txt"), RB.getStringResource("OTP.dom.26.txt"), RB.getStringResource("OTP.dom.27.txt"), RB.getStringResource("OTP.dom.28.txt"), RB.getStringResource("OTP.dom.29.txt"), RB.getStringResource("OTP.dom.30.txt"), RB.getStringResource("OTP.dom.31.txt"), RB.getStringResource("OTP.dom.Last.txt")};

    public OutputTabPanel(Transformation transformation, int type, Config config) {
        this._transformation = transformation;
        this._type = type;
        this.setName(RB.getStringResource("OTP.Tab.txt"));
        this.setDescription(RB.getStringResource("OTP.Wiz.txt"));
        if (type == 1) {
            this.setHelpProduct("storedprocessreport");
            this.setHelpTopic("outputtab");
        } else {
            this.setHelpProduct("newstprpt");
            this.setHelpTopic("outputwin");
        }
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 1, 5, 5, true, true, true);
        this.setLayout((LayoutManager)layout);
        Timezone schedulerTZ = new Timezone();
        this._timeZoneID = schedulerTZ.getID();
        if (this._type == 1) {
            JLabel timeStuff = new JLabel(Message.format((String)RB.getStringResource("OTP.Lbl.TZ.fmt.txt"), (Object)schedulerTZ.getDisplayName()));
            this.add(timeStuff);
            JPanel tableAndButtonPanel = new JPanel();
            AutoSizingGridLayout tAndBlayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
            tAndBlayout.setRemainderColumn(1);
            tableAndButtonPanel.setLayout((LayoutManager)tAndBlayout);
            this._tableModel = new TableModel();
            this._table = new JTable(this._tableModel);
            this._table.setDefaultRenderer(Object.class, (TableCellRenderer)new UtilGui.NoHtmlTableCellRenderer());
            this._table.getSelectionModel().addListSelectionListener(this);
            this._table.setSelectionMode(0);
            JScrollPane scrollPane = new JScrollPane(this._table);
            scrollPane.setPreferredSize(new Dimension(300, 150));
            JPanel buttonsPanel = new JPanel();
            AutoSizingGridLayout buttonLayout = new AutoSizingGridLayout(2, 1, 5, 5, false, true, true);
            buttonsPanel.setLayout((LayoutManager)buttonLayout);
            buttonLayout.setRemainderRow(2);
            this._buttonDelete = UtilGui.createButton((String)RB.getStringResource("COM.Btn.Del0.txt"));
            this._buttonDelete.setEnabled(false);
            buttonsPanel.add(this._buttonDelete);
            buttonsPanel.add(new JPanel());
            tableAndButtonPanel.add(scrollPane);
            tableAndButtonPanel.add(buttonsPanel);
            this.add(tableAndButtonPanel);
        }
        JPanel spinnerPanel = new JPanel();
        AutoSizingGridLayout spinnerLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, false, false);
        spinnerPanel.setLayout((LayoutManager)spinnerLayout);
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1);
        this._spinnerMaxGenerations = new JSpinner(spinnerModel);
        Dimension dim = this._spinnerMaxGenerations.getPreferredSize();
        this._spinnerMaxGenerations.setPreferredSize(new Dimension((int)(dim.getWidth() * 0.5), (int)dim.getHeight()));
        this._spinnerMaxGenerations.setToolTipText(RB.getStringResource("OTP.Tooltip.NumGen.txt"));
        JLabel lblMaxGens = UtilGui.createLabelForComponent((Component)this._spinnerMaxGenerations, (String)RB.getStringResource("OTP.Lbl.NumGen.txt"));
        spinnerPanel.add(lblMaxGens);
        spinnerPanel.add(this._spinnerMaxGenerations);
        this.add(spinnerPanel);
        this.add(new JSeparator(0));
        this.add(new JLabel(RB.getStringResource("OTP.Lbl.ExpratnPol.txt")));
        JPanel expirationPeriodPanel = new JPanel();
        AutoSizingGridLayout expirationPeriodLayout = new AutoSizingGridLayout(1, 3, 5, 5, true, false, true);
        expirationPeriodLayout.setRemainderColumn(3);
        expirationPeriodPanel.setLayout((LayoutManager)expirationPeriodLayout);
        this._policy_none = UtilGui.createRadioButton((String)RB.getStringResource("OTP.Lbl.None.txt"));
        this._policy_none.setToolTipText(RB.getStringResource("OTP.Tooltip.None.txt"));
        this._policy_daily = UtilGui.createRadioButton((String)RB.getStringResource("OTP.Lbl.Dly.txt"));
        this._policy_daily.setToolTipText(RB.getStringResource("OTP.Tooltip.Dly.txt"));
        this._policy_weekly = UtilGui.createRadioButton((String)RB.getStringResource("OTP.Lbl.Wkly.txt"));
        this._policy_weekly.setToolTipText(RB.getStringResource("OTP.Tooltip.Wkly.txt"));
        this._policy_monthly = UtilGui.createRadioButton((String)RB.getStringResource("OTP.Lbl.Mnthly.txt"));
        this._policy_monthly.setToolTipText(RB.getStringResource("OTP.Tooltip.Mnthly.txt"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._policy_none);
        bg.add(this._policy_daily);
        bg.add(this._policy_weekly);
        bg.add(this._policy_monthly);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(4, 1, 5, 5));
        buttonPanel.add(this._policy_none);
        buttonPanel.add(this._policy_daily);
        buttonPanel.add(this._policy_weekly);
        buttonPanel.add(this._policy_monthly);
        expirationPeriodPanel.add(buttonPanel);
        expirationPeriodPanel.add(new JSeparator(1));
        JPanel optionsPanel = new JPanel();
        AutoSizingGridLayout optionsPanelLayout = new AutoSizingGridLayout(3, 1, 5, 5, false, false, false);
        optionsPanel.setLayout((LayoutManager)optionsPanelLayout);
        optionsPanelLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this._daysOfTheWeekPanel = new JPanel();
        AutoSizingGridLayout daysOfTheWeekLayout = new AutoSizingGridLayout(2, 4, 5, 5, false, false, false);
        this._daysOfTheWeekPanel.setLayout((LayoutManager)daysOfTheWeekLayout);
        this._daysOfTheWeek = new JCheckBox[7];
        this._daysOfTheWeek[0] = UtilGui.createCheckBox((String)RB.getStringResource("OTP.Lbl.Sun.txt"));
        this._daysOfTheWeek[1] = UtilGui.createCheckBox((String)RB.getStringResource("OTP.Lbl.Mon.txt"));
        this._daysOfTheWeek[2] = UtilGui.createCheckBox((String)RB.getStringResource("OTP.Lbl.Tue.txt"));
        this._daysOfTheWeek[3] = UtilGui.createCheckBox((String)RB.getStringResource("OTP.Lbl.Wed.txt"));
        this._daysOfTheWeek[4] = UtilGui.createCheckBox((String)RB.getStringResource("OTP.Lbl.Thu.txt"));
        this._daysOfTheWeek[5] = UtilGui.createCheckBox((String)RB.getStringResource("OTP.Lbl.Fri.txt"));
        this._daysOfTheWeek[6] = UtilGui.createCheckBox((String)RB.getStringResource("OTP.Lbl.Sat.txt"));
        for (int i = 0; i < 7; ++i) {
            this._daysOfTheWeekPanel.add(this._daysOfTheWeek[i]);
        }
        optionsPanel.add(this._daysOfTheWeekPanel);
        this._dayOfTheMonthPanel = new JPanel();
        AutoSizingGridLayout dayOfTheMonthLayout = new AutoSizingGridLayout(1, 2, 5, 5, false, false, false);
        this._dayOfTheMonthPanel.setLayout((LayoutManager)dayOfTheMonthLayout);
        this._dayOfTheMonth = new JComboBox<String>(this._daysOfMonth);
        JLabel lblDOM = UtilGui.createLabelForComponent((Component)this._dayOfTheMonth, (String)RB.getStringResource("OTP.Lbl.DOM.txt"));
        this._dayOfTheMonthPanel.add(lblDOM);
        this._dayOfTheMonthPanel.add(this._dayOfTheMonth);
        optionsPanel.add(this._dayOfTheMonthPanel);
        this._timePanel = new TimeHourMinutePanel(0, 0, 1, this._timeZoneID);
        optionsPanel.add((Component)this._timePanel);
        expirationPeriodPanel.add(optionsPanel);
        this.add(expirationPeriodPanel);
        this.createListeners();
    }

    private void createListeners() {
        if (this._type == 1) {
            this._buttonDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    int selected = OutputTabPanel.this._table.getSelectedRow();
                    if (selected != -1) {
                        boolean ret;
                        String msg;
                        StoredProcessReportOutputInterface sproi = OutputTabPanel.this._tableModel.getTableEntryElementAt(selected);
                        try {
                            msg = sproi.isValid() ? Message.format((ResourceBundle)RB.getResources(), (String)"OTP.ConfDel.msg.fmt.txt", (Object)Long.toString(sproi.getGeneration())) : RB.getStringResource("OTP.ConfDel.msg.txt");
                        }
                        catch (Exception e) {
                            UtilGui.displayExceptionError((Exception)e);
                            return;
                        }
                        boolean bl = ret = MessageUtil.displayMessage((String)msg, (String)RB.getStringResource("COM.ConfDel.DlgTitle.txt"), (int)2, (int)0) == 0;
                        if (ret) {
                            try {
                                sproi.delete();
                            }
                            catch (Exception e) {
                                MessageUtil.displayMessage((String)Message.format((ResourceBundle)RB.getResources(), (String)"OTP.DelExcpOccurd.msg.fmt.txt", (Object)e.toString()));
                                return;
                            }
                            OutputTabPanel.this._tableModel.removeTableEntry(sproi);
                            OutputTabPanel.this._tableModel.fireTableDataChanged();
                            OutputTabPanel.this.setEnabledStateOfButtons();
                        }
                    }
                }
            });
        }
        this._policy_none.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputTabPanel.this._period = ExpirationPolicyInterface.Period.NONE;
                OutputTabPanel.this.enableTimePanels(OutputTabPanel.this._policy_none);
            }
        });
        this._policy_daily.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputTabPanel.this._period = ExpirationPolicyInterface.Period.DAILY;
                OutputTabPanel.this.enableTimePanels(OutputTabPanel.this._policy_daily);
            }
        });
        this._policy_weekly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputTabPanel.this._period = ExpirationPolicyInterface.Period.WEEKLY;
                OutputTabPanel.this.enableTimePanels(OutputTabPanel.this._policy_weekly);
            }
        });
        this._policy_monthly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputTabPanel.this._period = ExpirationPolicyInterface.Period.MONTHLY;
                OutputTabPanel.this.enableTimePanels(OutputTabPanel.this._policy_monthly);
            }
        });
    }

    private void enableTimePanels(JRadioButton button) {
        if (button == this._policy_none) {
            this._timePanel.setVisible(false);
            this._daysOfTheWeekPanel.setVisible(false);
            this._dayOfTheMonthPanel.setVisible(false);
        } else {
            if (button == this._policy_weekly) {
                this._daysOfTheWeekPanel.setVisible(true);
                this._dayOfTheMonthPanel.setVisible(false);
            } else if (button == this._policy_monthly) {
                this._daysOfTheWeekPanel.setVisible(false);
                this._dayOfTheMonthPanel.setVisible(true);
            } else if (button == this._policy_daily) {
                this._daysOfTheWeekPanel.setVisible(false);
                this._dayOfTheMonthPanel.setVisible(false);
            }
            this._timePanel.setVisible(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void smartPopulateStore() throws MdException, RemoteException {
        if (this._type == 1) {
            String value;
            this._maxGensProperty = UtilMetadata.getProperty((Root)this._transformation, (String)"MaxGenerations", null);
            if (this._maxGensProperty != null && (value = this._maxGensProperty.getDefaultValue()) != null) {
                try {
                    this._maxGenerations = Integer.parseInt(value);
                    this._maxGensValidValuePresentInProperty = true;
                }
                catch (NumberFormatException nfe) {
                    String msg = Message.format((String)RB.getStringResource("COM.badMaxGen.fmt.txt"), (Object)value);
                    throw new MdException(msg);
                }
            }
            this._expirationPolicyProperty = UtilMetadata.getProperty((Root)this._transformation, (String)"ExpirationPolicy", null);
            this._period = null;
            if (this._expirationPolicyProperty != null) {
                String xml = this._expirationPolicyProperty.getDefaultValue();
                if (xml == null || xml.length() == 0) {
                    this._period = ExpirationPolicyInterface.Period.NONE;
                } else {
                    TimeEventInfo tei = new TimeEventInfo();
                    try {
                        tei.initFromXML(xml);
                    }
                    catch (SchedulerException e) {
                        throw new MdException(e.getMessage());
                    }
                    try {
                        this._hourValue = Integer.parseInt(tei.getHours());
                    }
                    catch (NumberFormatException nfe) {
                        String msg = Message.format((String)RB.getStringResource("COM.InvHr.msg.txt"), (Object)tei.getHours());
                        throw new MdException(msg);
                    }
                    try {
                        this._minValue = Integer.parseInt(tei.getMinutes());
                    }
                    catch (NumberFormatException nfe) {
                        String msg = Message.format((String)RB.getStringResource("COM.InvMin.msg.txt"), (Object)tei.getHours());
                        throw new MdException(msg);
                    }
                    this._timeZoneID = tei.getTimezoneId();
                    IRecurrenceInfo ir = tei.getRecurrence();
                    if (ir instanceof DailyRecurrence) {
                        this._period = ExpirationPolicyInterface.Period.DAILY;
                    } else if (ir instanceof WeeklyRecurrence) {
                        this._period = ExpirationPolicyInterface.Period.WEEKLY;
                        WeeklyRecurrence wr = (WeeklyRecurrence)ir;
                        this._dayMaskValue = wr.getDaysToRun();
                    } else if (ir instanceof MonthlyRecurrence) {
                        this._period = ExpirationPolicyInterface.Period.MONTHLY;
                        MonthlyRecurrence mr = (MonthlyRecurrence)ir;
                        int domValue = mr.getDayOfMonth();
                        if (domValue > 0) {
                            this._dayOfTheMonthIndexValue = domValue - 1;
                        } else if (mr.getDayOfWeek() == 128) {
                            this._dayOfTheMonthIndexValue = 31;
                        } else {
                            String msg = Message.format((String)RB.getStringResource("COM.InvDOW.fmt.txt"), (Object)new Integer(mr.getDayOfWeek()));
                            throw new MdException(msg);
                        }
                    }
                }
            }
            try {
                MetadataInterface mi = UtilPlatformServices.getSmartObject((Root)this._transformation);
                if (!(mi instanceof StoredProcessReportInterface)) return;
                StoredProcessReportInterface spri = (StoredProcessReportInterface)mi;
                List sourceList = spri.getAllOutput();
                ArrayList targetList = new ArrayList(sourceList.size());
                targetList.addAll(sourceList);
                this._tableModel.setData(targetList);
                return;
            }
            catch (Exception e) {
                throw new MdException((Throwable)e);
            }
        }
        if (this._type != 0) return;
        Property property = UtilMetadata.addPropertyToObject((Root)this._transformation, (String)"##CACHE_NAME_LIST##", (String)"", (String)"SPRCache");
        property.setPropertyName("");
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (this._type == 1) {
            if (this._maxGensValidValuePresentInProperty) {
                this._spinnerMaxGenerations.setValue(new Integer(this._maxGenerations));
            }
            this._tableModel.fireTableDataChanged();
            if (this._period == null) {
                this._policy_none.setSelected(true);
                this.enableTimePanels(this._policy_none);
            } else {
                switch (this._period) {
                    case NONE: {
                        this._policy_none.setSelected(true);
                        this.enableTimePanels(this._policy_none);
                        break;
                    }
                    case DAILY: {
                        this._policy_daily.setSelected(true);
                        this.enableTimePanels(this._policy_daily);
                        break;
                    }
                    case WEEKLY: {
                        this._policy_weekly.setSelected(true);
                        this.enableTimePanels(this._policy_weekly);
                        this._daysOfTheWeek[0].setSelected((this._dayMaskValue & 0x40) > 0);
                        this._daysOfTheWeek[1].setSelected((this._dayMaskValue & 1) > 0);
                        this._daysOfTheWeek[2].setSelected((this._dayMaskValue & 2) > 0);
                        this._daysOfTheWeek[3].setSelected((this._dayMaskValue & 4) > 0);
                        this._daysOfTheWeek[4].setSelected((this._dayMaskValue & 8) > 0);
                        this._daysOfTheWeek[5].setSelected((this._dayMaskValue & 0x10) > 0);
                        this._daysOfTheWeek[6].setSelected((this._dayMaskValue & 0x20) > 0);
                        break;
                    }
                    case MONTHLY: {
                        this._policy_monthly.setSelected(true);
                        this.enableTimePanels(this._policy_monthly);
                        this._dayOfTheMonth.setSelectedIndex(this._dayOfTheMonthIndexValue);
                    }
                }
                if (this._period != ExpirationPolicyInterface.Period.NONE) {
                    this._timePanel.setHour(this._hourValue);
                    this._timePanel.setMinute(this._minValue);
                    if (!this._timePanel.setTimezone(this._timeZoneID)) {
                        UtilGui.displayError((String)Message.format((String)RB.getStringResource("OTP.TZErr.fmt.txt"), (Object)this._timeZoneID));
                    }
                }
            }
        } else if (this._firstTimeInWizard) {
            this._spinnerMaxGenerations.setValue(new Integer(1));
            this.enableTimePanels(this._policy_none);
            this._firstTimeInWizard = false;
        }
    }

    protected boolean dataValidate() throws RemoteException {
        if (!(this._policy_none.isSelected() || this._policy_daily.isSelected() || this._policy_weekly.isSelected() || this._policy_monthly.isSelected())) {
            UtilGui.displayError((String)RB.getStringResource("OTP.NoEPSel.msg.txt"));
            return false;
        }
        if (this._policy_weekly.isSelected()) {
            boolean someBoxSelected = false;
            for (int i = 0; i < 7; ++i) {
                if (!this._daysOfTheWeek[i].isSelected()) continue;
                someBoxSelected = true;
            }
            if (!someBoxSelected) {
                UtilGui.displayError((String)RB.getStringResource("OTP.NoDaySel.msg.txt"));
                return false;
            }
        }
        if (this._policy_monthly.isSelected()) {
            this._dayOfTheMonthIndexValue = this._dayOfTheMonth.getSelectedIndex();
        }
        try {
            this._maxGenerations = (Integer)this._spinnerMaxGenerations.getValue();
            return true;
        }
        catch (NumberFormatException nfe) {
            UtilGui.displayError((String)RB.getStringResource("OTP.invMaxGen.txt"));
            this._spinnerMaxGenerations.requestFocus();
            return false;
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this._maxGensProperty == null) {
            this._maxGensProperty = UtilMetadata.addPropertyToObject((Root)this._transformation, (String)"MaxGenerations", null, null);
        }
        this._maxGensProperty.setDefaultValue(Integer.toString(this._maxGenerations));
        if (this._expirationPolicyProperty == null) {
            this._expirationPolicyProperty = UtilMetadata.addPropertyToObject((Root)this._transformation, (String)"ExpirationPolicy", null, null);
        }
        String xml = "";
        TimeEventInfo tei = null;
        if (this._period != ExpirationPolicyInterface.Period.NONE) {
            tei = new TimeEventInfo();
            this._hourValue = this._timePanel.getHour();
            tei.setHours(String.valueOf(this._hourValue));
            this._minValue = this._timePanel.getMinutes();
            tei.setMinutes(String.valueOf(this._minValue));
            this._timeZoneID = this._timePanel.getTimezone();
            tei.setTimezoneId(this._timeZoneID);
        }
        switch (this._period) {
            case NONE: {
                xml = "";
                break;
            }
            case DAILY: {
                DailyRecurrence dr = new DailyRecurrence();
                tei.setRecurrence((IRecurrenceInfo)dr);
                break;
            }
            case WEEKLY: {
                WeeklyRecurrence wr = new WeeklyRecurrence();
                this._dayMaskValue = 0;
                if (this._daysOfTheWeek[0].isSelected()) {
                    this._dayMaskValue |= 0x40;
                }
                if (this._daysOfTheWeek[1].isSelected()) {
                    this._dayMaskValue |= 1;
                }
                if (this._daysOfTheWeek[2].isSelected()) {
                    this._dayMaskValue |= 2;
                }
                if (this._daysOfTheWeek[3].isSelected()) {
                    this._dayMaskValue |= 4;
                }
                if (this._daysOfTheWeek[4].isSelected()) {
                    this._dayMaskValue |= 8;
                }
                if (this._daysOfTheWeek[5].isSelected()) {
                    this._dayMaskValue |= 0x10;
                }
                if (this._daysOfTheWeek[6].isSelected()) {
                    this._dayMaskValue |= 0x20;
                }
                wr.setDaysToRun(this._dayMaskValue);
                tei.setRecurrence((IRecurrenceInfo)wr);
                break;
            }
            case MONTHLY: {
                MonthlyRecurrence mr = new MonthlyRecurrence();
                if (this._dayOfTheMonthIndexValue == 31) {
                    mr.setRecurringDay(128, 6);
                } else {
                    mr.setDayOfMonth(this._dayOfTheMonthIndexValue + 1);
                }
                tei.setRecurrence((IRecurrenceInfo)mr);
            }
        }
        if (this._period != ExpirationPolicyInterface.Period.NONE) {
            xml = tei.generateXML();
        }
        this._expirationPolicyProperty.setDefaultValue(xml);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.setEnabledStateOfButtons();
    }

    void setEnabledStateOfButtons() {
        boolean editingPermitted = this.isEditable();
        int selectedRow = this._table.getSelectedRow();
        boolean enableEditDelete = selectedRow >= 0 && editingPermitted;
        this._buttonDelete.setEnabled(enableEditDelete);
    }

    TableModel getModel() {
        return this._tableModel;
    }

    static class TableModel
    extends AbstractTableModel {
        private List<StoredProcessReportOutputInterface> _data = new ArrayList<StoredProcessReportOutputInterface>(0);

        TableModel() {
        }

        void clear() {
            this._data.clear();
        }

        private void setData(List<StoredProcessReportOutputInterface> data) {
            this._data = data;
        }

        private StoredProcessReportOutputInterface getTableEntryElementAt(int row) {
            return this._data.get(row);
        }

        private void removeTableEntry(StoredProcessReportOutputInterface di) {
            this._data.remove(di);
        }

        int locateRowFor(StoredProcessReportOutputInterface matchOP) {
            Iterator<StoredProcessReportOutputInterface> it = this._data.iterator();
            int i = 0;
            while (it.hasNext()) {
                StoredProcessReportOutputInterface di = it.next();
                if (di == matchOP) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this._data.size();
        }

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return Long.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int c) {
            switch (c) {
                case 0: {
                    return RB.getStringResource("OTP.Lbl.Date.Nmbr.txt");
                }
                case 1: {
                    return RB.getStringResource("OTP.Lbl.CrtnTime.Hdr.txt");
                }
                case 2: {
                    return RB.getStringResource("OTP.Lbl.ExprTime.Hdr.txt");
                }
                case 3: {
                    return RB.getStringResource("OTP.Lbl.UserName.Hdr.txt");
                }
            }
            return " ";
        }

        @Override
        public Object getValueAt(int row, int col) {
            block16: {
                StoredProcessReportOutputInterface sproi = this._data.get(row);
                try {
                    if (sproi.isValid()) {
                        switch (col) {
                            case 0: {
                                return new Long(sproi.getGeneration());
                            }
                            case 1: {
                                return UtilMisc.SAS_DATE_FORMAT.format(sproi.getCreationDate());
                            }
                            case 2: {
                                Date date = sproi.getExpirationDate();
                                if (date == null) {
                                    return RB.getStringResource("OTP.NoExprTime.txt");
                                }
                                return UtilMisc.SAS_DATE_FORMAT.format(date);
                            }
                            case 3: {
                                IdentityInterface ii = sproi.getCreatorIdentity();
                                if (ii != null) {
                                    return ii.getEffectiveDisplayName();
                                }
                                String creator = sproi.getCreator();
                                if (creator.equals("PublicUser")) {
                                    return RB.getStringResource("OTP.PubUser.txt");
                                }
                                return creator;
                            }
                        }
                        break block16;
                    }
                    switch (col) {
                        case 0: {
                            return Message.format((String)RB.getStringResource("OTP.BadGen.fmt.txt"), (Object)sproi.getName());
                        }
                    }
                    return "";
                }
                catch (RemoteException re) {
                    return re.toString();
                }
                catch (ServiceException se) {
                    return se.toString();
                }
            }
            return "";
        }
    }
}

