/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocessreport;

import com.sas.metadata.logical.BaseObjectFactory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.storedprocessreport.LogicalObject;
import com.sas.metadata.logical.storedprocessreport.NewStoredProcessReportAction;
import com.sas.metadata.logical.storedprocessreport.OutputTabPanel;
import com.sas.metadata.logical.storedprocessreport.StoredProcessTabPanel;
import com.sas.metadata.logical.storedprocessreport.Type;
import com.sas.metadata.logical.visuals.BIPTreeElementGeneralPropertyTab;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.ConfigGeneralPanel;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;

class ObjectFactory
extends BaseObjectFactory
implements ObjectFactoryInterface {
    static UsageVersion OLDEST_VERSION = new UsageVersion(1, 0);
    static UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    ObjectFactory(Type type) {
        super((TypeInterface)type);
    }

    public LogicalObjectInterface createItemFromMetadataObject(Root root) throws RemoteException {
        if (!this.isObjectOfInterest(root)) {
            throw new IllegalArgumentException("Internal logic error: Not an object of interest " + root.toString() + " .");
        }
        LogicalObject lo = new LogicalObject((Transformation)root, this._type, this._factory);
        return lo;
    }

    public List getPropertyTabs(LogicalObjectInterface logicalObject, Root complexSPR, Config config) throws MdException, RemoteException {
        if (!this.isObjectOfInterest(complexSPR)) {
            throw new IllegalArgumentException("Internal logic error: Not an object of interest " + complexSPR.toString() + " .");
        }
        if (config == null) {
            config = new Config();
        }
        config.setEnabled(ConfigGeneralPanel.NAME, false);
        ArrayList<Object> list = new ArrayList<Object>();
        Transformation transformation = (Transformation)complexSPR;
        AssociationList al = transformation.getTrees();
        Tree tree = al.size() > 0 ? (Tree)al.get(0) : null;
        BIPTreeElementGeneralPropertyTab generalTab = new BIPTreeElementGeneralPropertyTab((Root)transformation, tree, 1, this._type, config);
        list.add(generalTab);
        if (logicalObject.isReadCompatible()) {
            StoredProcessTabPanel executionTab = new StoredProcessTabPanel(transformation, 1, config);
            list.add((Object)executionTab);
            OutputTabPanel generationsTab = new OutputTabPanel(transformation, 1, config);
            list.add(generationsTab);
        }
        return list;
    }

    public Action[] getActions(LogicalObjectInterface logicalObject, Root root, Config config) throws RemoteException {
        if (logicalObject instanceof FolderInterface) {
            if (!(root == null || root.getCMetadataType().equals("Tree") && logicalObject.getID().equalsIgnoreCase(root.getFQID()))) {
                throw new IllegalArgumentException("Logic error: Tree with FQID " + logicalObject.getID() + " expected.  Root object is " + root.getCMetadataType() + " with id " + root.getFQID());
            }
            try {
                Action[] array = new Action[]{new NewStoredProcessReportAction(this._factory.getFrame(), (FolderInterface)logicalObject, (Tree)root, this, this._type, config)};
                array[0].setEnabled(((FolderInterface)logicalObject).isCreateChildAllowed());
                return array;
            }
            catch (LogicalTypeException e) {
                UtilGui.displayExceptionError((Exception)((Object)e));
                return EMPTY_ACTION_ARRAY;
            }
        }
        return EMPTY_ACTION_ARRAY;
    }
}

