/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocessreport;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.storedprocess.StoredProcessConnectionType;
import com.sas.metadata.logical.storedprocessreport.RB;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.publicobjects.storedprocessreport.RRSupport;
import com.sas.publicobjects.storedprocessreport.StoredProcessReportInterface;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.text.Message;
import java.io.IOException;
import java.util.List;

class ImportListener
extends AbstractImportListener {
    static final Class[] CONNECTION_TYPES = new Class[]{StoredProcessConnectionType.class};

    ImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public int importContent(ImportOperationInterface operation, List objects) throws TransportException, IOException {
        Log importLogger = operation.getLogger();
        if (importLogger == null) {
            throw new TransportException(RB.getStringResource("IL.NoLog.txt"));
        }
        boolean hadException = false;
        for (Object o : objects) {
            PathUrl pathUrl;
            StoredProcessReportInterface spri;
            ImportItemInterface item = (ImportItemInterface)o;
            try {
                spri = (StoredProcessReportInterface)PromotionUtil.getSmartObject((PromotionInterface)operation, (String)item.getTargetID(), (String)"Transformation");
                if (spri == null) {
                    throw new ServiceException(RB.getStringResource(Message.format((String)"COM.noSmartObj.txt", (Object)item.getTargetID())));
                }
                pathUrl = spri.getPathUrl();
                if (pathUrl == null) {
                    throw new ServiceException(RB.getStringResource(Message.format((String)"COM.noPathURL.txt", (Object)item.getTargetID())));
                }
            }
            catch (ServiceException e) {
                hadException = true;
                importLogger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            try {
                RRSupport rrSupport = new RRSupport((MetadataInterface)spri);
                rrSupport.createHighWaterMark(pathUrl);
            }
            catch (Exception exception) {}
        }
        return hadException ? 8 : 0;
    }
}

