/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.storedprocess.ObjectFactory;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Text;
import java.awt.Component;
import java.awt.Cursor;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;

@SASScope
public final class UtilMetadataSP {
    static final int SIZE_DIRECTORY_NAME = 256;
    static final int SIZE_FILE_NAME = 256;
    static final int SIZE_URI = 256;
    public static final int CONTEXT_SET_ARCHIVE = 1;
    public static final int CONTEXT_SET_SOURCE = 2;
    public static final int CONTEXT_SET_BOTH = 3;
    static final String ROOT_TREE_TEMPLATE = "<Templates><SoftwareComponent><SoftwareTrees/></SoftwareComponent><Tree Name=\"\" TreeType=\"\"><SubTrees/><Members/></Tree><ClassifierMap Name=\"\" TransformRole=\"\"/></Templates>";
    static final String TREE_TEMPLATE = "<Templates><Tree Name=\"\" TreeType=\"\"><SubTrees/><Members/></Tree><ClassifierMap Name=\"\" TransformRole=\"\"/></Templates>";
    public static final String EXCLUDE_CONTENT_KEY = "_ExcludeContent";
    public static final String EXCLUDE_CONTENT_VALUE = "true";
    static final String INCLUDE_SOURCE_CODE_PROPERTY = System.getProperty("sas.promotion.stp.includesourcecode");
    public static final String CLASSIFIERMAP_CONSUMED_BY_TEMPLATE = "<Templates><ClassifierMap><Implementors/><SourceTransformations/></ClassifierMap></Templates>";
    public static final String CLASSIFIERMAP_CONSUMES_TEMPLATE = "<Templates><ClassifierMap><SourceTransformations/></ClassifierMap></Templates>";
    public static final String CLASSIFIERMAP_SOURCE_CODE_TEMPLATE = "<Templates><ClassifierMap><ComputeLocations/><SourceCode/></ClassifierMap><File><Directories/></File><Directory><Properties/><DeployedComponents/></Directory></Templates>";
    static final String OMR_NAME_ARCHIVE_DIR = "SP Archive Directory";
    static final String OMR_NAME_ARCHIVEFILE = "SP ArchiveFile";
    static final String OMR_NAME_CLASSIFIER_MAP = "SP Classifier Map";
    static final String OMR_NAME_FOLDER = "SP Folder";
    static final String OMR_NAME_PR_DIR = "SP PR Directory";
    static final String OMR_NAME_REPORT_OUTPUT = "SP Report (Output)";
    static final String OMR_NAME_WEBDAV_DIR = "SP WebDAV Directory";
    static final int FIND_WORKSPACE_SERVERS = 1;
    static final int FIND_STOREDPROCESS_SERVERS = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void determineAllRepositoryContextsForLogicalServer(Component comp, int type, LogicalServer logicalServer, List<Directory> sourceRepositories, List<Directory> archiveRepositories) throws MdException, RemoteException {
        if (comp != null) {
            comp.setCursor(Cursor.getPredefinedCursor(3));
        }
        try {
            if ((type & 2) != 0) {
                sourceRepositories.clear();
            }
            if ((type & 1) != 0) {
                archiveRepositories.clear();
            }
            if (logicalServer != null) {
                for (Object c : logicalServer.getUsedByComponents(true)) {
                    if (!(c instanceof ServerContext)) continue;
                    ServerContext sc = (ServerContext)c;
                    UtilMetadataSP.findAllRepositoryContextsForServerContext(type, sc, sourceRepositories, archiveRepositories);
                }
            }
        }
        finally {
            if (comp != null) {
                comp.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    static void determineAllRepositoryContextsForServerContext(Component comp, ServerContext serverContext, List<Directory> sourceRepositories) throws MdException, RemoteException {
        if (comp != null) {
            comp.setCursor(Cursor.getPredefinedCursor(3));
        }
        try {
            sourceRepositories.clear();
            if (serverContext != null) {
                UtilMetadataSP.findAllRepositoryContextsForServerContext(2, serverContext, sourceRepositories, null);
            }
        }
        finally {
            if (comp != null) {
                comp.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public static void findAllRepositoryContextsForServerContext(int type, ServerContext sc, List sourceRepositories, List archiveRepositories) throws MdException, RemoteException {
        boolean getSourceRepositories = (type & 2) != 0;
        boolean getArchiveRepositories = (type & 1) != 0;
        for (Object c0 : sc.getDataPackages(true)) {
            if (!(c0 instanceof Directory)) continue;
            Directory d = (Directory)c0;
            for (Property p : d.getProperties(true)) {
                if (p.getPropertyRole().equalsIgnoreCase("SPSourceCodeRepository")) {
                    if (!getSourceRepositories) continue;
                    sourceRepositories.add(d);
                    continue;
                }
                if (!p.getPropertyRole().equalsIgnoreCase("SPPackageFileRepository") || !getArchiveRepositories) continue;
                archiveRepositories.add(d);
            }
        }
    }

    static List findStoredProcessAndWorkspaceServers(MdStore objectStore, String repositoryID, int findFlag) throws MdException, RemoteException {
        String searchClassid;
        if (findFlag == 3) {
            searchClassid = "@ClassIdentifier = '440196d4-90f0-11d0-9f41-00a024bb830c' or @ClassIdentifier = '15931e31-667f-11d5-8804-00c04f35ac8c'";
        } else if (findFlag == 1) {
            searchClassid = "@ClassIdentifier = '440196d4-90f0-11d0-9f41-00a024bb830c'";
        } else if (findFlag == 2) {
            searchClassid = "@ClassIdentifier = '15931e31-667f-11d5-8804-00c04f35ac8c'";
        } else {
            throw new IllegalArgumentException("Invalid value of findFlag specified: " + findFlag);
        }
        int flags = 8584;
        List servers = objectStore.getFactory().getOMIUtil().getMetadataObjectsSubset(objectStore, repositoryID, "LogicalServer", flags, "<XMLSELECT search=\"" + searchClassid + "\"/>");
        return servers;
    }

    static List<ServerContext> findServerContextsWithStoredProcessAndOrWorkspaceServers(MdStore objectStore, String repositoryID, int findFlag) throws MdException, RemoteException {
        String searchClassid;
        if (findFlag == 3) {
            searchClassid = "@ClassIdentifier = '440196d4-90f0-11d0-9f41-00a024bb830c' or @ClassIdentifier = '15931e31-667f-11d5-8804-00c04f35ac8c'";
        } else if (findFlag == 1) {
            searchClassid = "@ClassIdentifier = '440196d4-90f0-11d0-9f41-00a024bb830c'";
        } else if (findFlag == 2) {
            searchClassid = "@ClassIdentifier = '15931e31-667f-11d5-8804-00c04f35ac8c'";
        } else {
            throw new IllegalArgumentException("Invalid value of findFlag specified: " + findFlag);
        }
        int flags = 8584;
        List servers = objectStore.getFactory().getOMIUtil().getMetadataObjectsSubset(objectStore, repositoryID, "ServerContext", flags, "<XMLSELECT search=\"ServerContext[UsingComponents/LogicalServer[" + searchClassid + "]]\"/>");
        return servers;
    }

    public static ObjectFactory.SourceLocation getSourceCodeLocation(ClassifierMap classifierMap) throws MdException, RemoteException {
        ObjectFactory.SourceLocation sl;
        double uv = classifierMap.getUsageVersion();
        boolean post92 = uv > ObjectFactory.NINETWO_VERSION.encode();
        DirectoryAndFile df = UtilMetadataSP.determineDirectoryAndFile(classifierMap);
        if (post92) {
            Iterator it = classifierMap.getComputeLocations().iterator();
            if (!it.hasNext()) {
                throw new MdException(UtilMisc.getMessage((String)RB.getStringResource("UM.NoSrvrCtxt.txt"), (Object)classifierMap.getName(), (Object)classifierMap.getFQID()));
            }
            ServerContext sc = (ServerContext)it.next();
            if (sc == null) {
                throw new MdException(UtilMisc.getMessage((String)RB.getStringResource("UM.NoSrvrCtxt.txt"), (Object)classifierMap.getName(), (Object)classifierMap.getFQID()));
            }
            if (df._file != null) {
                if (df._directory == null) {
                    throw new MdException(UtilMisc.getMessage((String)RB.getStringResource("UM.NoSrcDir.txt"), (Object)classifierMap.getName(), (Object)classifierMap.getFQID()));
                }
                sl = new ObjectFactory.SourceLocation(classifierMap, sc, df._directory, df._file, false);
            } else {
                sl = new ObjectFactory.SourceLocation(classifierMap, sc, null, null, true);
            }
        } else {
            if (df._file == null) {
                throw new MdException(UtilMisc.getMessage((String)RB.getStringResource("UM.NoSrcFil.txt"), (Object)classifierMap.getName(), (Object)classifierMap.getFQID()));
            }
            if (df._directory == null) {
                throw new MdException(UtilMisc.getMessage((String)RB.getStringResource("UM.NoSrcDir.txt"), (Object)classifierMap.getName(), (Object)classifierMap.getFQID()));
            }
            Iterator it = classifierMap.getComputeLocations().iterator();
            if (!it.hasNext()) {
                throw new MdException(UtilMisc.getMessage((String)RB.getStringResource("UM.NoLogSrvr.txt"), (Object)classifierMap.getName(), (Object)classifierMap.getFQID()));
            }
            LogicalServer ls = (LogicalServer)it.next();
            if (ls == null) {
                throw new MdException(UtilMisc.getMessage((String)RB.getStringResource("UM.NoLogSrvr.txt"), (Object)classifierMap.getName(), (Object)classifierMap.getFQID()));
            }
            sl = new ObjectFactory.SourceLocation(classifierMap, ls, df._directory, df._file);
        }
        return sl;
    }

    static DirectoryAndFile determineDirectoryAndFile(ClassifierMap classifierMap) throws MdException, RemoteException {
        DirectoryAndFile df = new DirectoryAndFile();
        Text sc = classifierMap.getSourceCode();
        if (sc instanceof File) {
            df._file = (File)sc;
            df._fileName = df._file.getFileName();
            if (df._file.getIsARelativeName() != 0) {
                AssociationList v = df._file.getDirectories();
                for (int i = 0; i < v.size(); ++i) {
                    Directory d = (Directory)v.get(i);
                    AssociationList vv = d.getProperties();
                    boolean isASourceCodeRepository = false;
                    for (int ii = 0; ii < vv.size(); ++ii) {
                        Property p = (Property)vv.get(ii);
                        if (!p.getPropertyRole().equalsIgnoreCase("SPSourceCodeRepository")) continue;
                        isASourceCodeRepository = true;
                        break;
                    }
                    if (!isASourceCodeRepository) continue;
                    df._directory = d;
                    break;
                }
            }
        }
        return df;
    }

    static class DirectoryAndFile {
        String _fileName;
        File _file;
        Directory _directory;

        DirectoryAndFile() {
        }
    }
}

