/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.storedprocess.MetadataManipulator;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.AbstractAction;

class UpgradeRepositoryAction
extends AbstractAction {
    private Tree _tree;
    private static String _dialogTitle = "Stored Process Upgrade";

    public UpgradeRepositoryAction(Tree tree) {
        this._tree = tree;
        UtilGui.setLabelAndMnemonicOnAction((AbstractAction)this, (String)"Upgrade pre-9.2 Stored Processes");
        this.putValue("ShortDescription", "Upgrades ALL pre-9.2 stored processes to the latest 9.2 format in the Repository");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String repositoryFQID = UtilMetadata.makeRepositoryFQIDFromRoot((Root)this._tree);
            try {
                MdObjectStore upgradeStore = Factory.getInstance().getMdFactory().createObjectStore();
                try {
                    String options = "<XMLSELECT Search=\"*[@PublicType='StoredProcess' AND @TransformRole='StoredProcess' AND @UsageVersion='0.0']\"/><Templates><ClassifierMap><ClassifierSources/><ClassifierTargets/><ComputeLocations/><Keywords/><Notes/><Properties/><SourceCode/><Trees/></ClassifierMap><ArchiveFile><Directories/></ArchiveFile><Directory><Parent/><Properties/><DeployedComponents/></Directory><File><Directories/></File><Report><Properties/><ReportLocation/></Report><Stream><Properties/></Stream><Tree><ParentTree/><SoftwareComponents/></Tree></Templates>";
                    List storedProcessesOldToNew = Factory.getInstance().getOMIUtil().getMetadataObjectsSubset((MdStore)upgradeStore, repositoryFQID, "ClassifierMap", 396, options);
                    int countOldToNew = storedProcessesOldToNew.size();
                    if (countOldToNew == 0) {
                        MessageUtil.displayMessage((String)"There are no stored processes to upgrade.", (String)_dialogTitle, (int)1, (int)-1);
                        return;
                    }
                    if (MessageUtil.displayMessage((String)("This action affect the ENTIRE REPOSITORY and not just the folder selected.  There are " + countOldToNew + " stored processes to modify.  You should backup the stored processes before this upgrade process is executed.  Have the stored processes been backed up?"), (String)_dialogTitle, (int)3, (int)0) == 1) {
                        return;
                    }
                    if (countOldToNew > 0 && MessageUtil.displayMessage((String)("Proceed to convert " + countOldToNew + " pre-9.2 stored processes?"), (String)_dialogTitle, (int)3, (int)0) == 0) {
                        for (ClassifierMap cm : storedProcessesOldToNew) {
                            try {
                                MetadataManipulator mm = new MetadataManipulator(cm);
                                mm.convertTo92();
                                mm.writeXML();
                                upgradeStore.updatedMetadataAll();
                            }
                            catch (Exception ex) {
                                if (MessageUtil.displayMessage((String)("Exception occurred converting " + cm.getName() + ".  Attempt to convert other pre-9.2 stored processes?"), (String)_dialogTitle, (int)3, (int)0) != 1) continue;
                                break;
                            }
                        }
                    }
                    MessageUtil.displayMessage((String)"Stored process operation(s) complete.", (String)_dialogTitle, (int)1, (int)-1);
                }
                finally {
                    upgradeStore.dispose();
                }
            }
            catch (MdException mde) {
                UtilGui.displayMdException((MdException)mde);
                return;
            }
        }
        catch (RemoteException e1) {
            UtilGui.displayRemoteException((RemoteException)e1);
        }
    }
}

