/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.bicommon.UtilPromotion;
import com.sas.metadata.logical.storedprocess.ObjectFactory;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.storedprocess.StoredProcessExportItem;
import com.sas.metadata.logical.storedprocess.StoredProcessImportListener;
import com.sas.metadata.logical.storedprocess.StoredProcessPromotionOptionsPanel;
import com.sas.metadata.logical.storedprocess.UtilMetadataSP;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionPointUtil;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ContentHelper;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionPropertiesFile;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.storedprocess.metadata.DataSourceOrTarget;
import com.sas.services.storedprocess.metadata.DataTable;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

class StoredProcessExportListener
extends AbstractExportListener
implements PromotionOptionsInterface {
    private StoredProcessPromotionOptionsPanel _optionsPanel;

    public StoredProcessExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return StoredProcessImportListener.CONNECTION_TYPES;
    }

    public int analyzeConnections(ExportOperationInterface operation, List objects) throws MdException, RemoteException {
        int retVal = 0;
        Log exportLogger = operation.getLogger();
        for (Object o : objects) {
            ExportItemInterface exportItem = (ExportItemInterface)o;
            String exportItemID = exportItem.getID();
            CMetadata temp = UtilMetadata.locateExistingObject((MdObjectStore)operation.getStore(), (String)"ClassifierMap", (String)exportItemID, (String)"<Templates><ClassifierMap><ComputeLocations/><SourceCode/></ClassifierMap><File><Directories/></File><Directory><Properties/><DeployedComponents/></Directory></Templates>");
            if (!(temp instanceof ClassifierMap)) {
                retVal = 8;
                exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPEL.BadSPNoCM.fmt.txt"), (Object)exportItemID));
                continue;
            }
            ClassifierMap cm = (ClassifierMap)temp;
            double uv = cm.getUsageVersion();
            boolean post92 = uv > ObjectFactory.NINETWO_VERSION.encode();
            temp = cm.getSourceCode();
            if (!(temp instanceof File)) {
                if (post92) {
                    if (temp != null) {
                        retVal = 8;
                        exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPEL.BadSPNoSrcCdeNF.fmt.txt"), (Object)exportItemID));
                        continue;
                    }
                } else {
                    retVal = 8;
                    exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPEL.BadSPNoSrcCde.fmt.txt"), (Object)exportItemID));
                    continue;
                }
            }
            if (temp != null) {
                File file = (File)temp;
                AssociationList al = file.getDirectories();
                if (al.size() != 1) {
                    retVal = 8;
                    exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPEL.BadSPBadDirs.fmt.txt"), (Object)exportItemID));
                    continue;
                }
                Directory dir = (Directory)al.get(0);
                ConnectionManagerInterface manager = operation.getConnectionManager();
                ConnectionPointInterface directoryConnection = manager.getConnection(dir.getId());
                if (directoryConnection == null) {
                    retVal = 8;
                    exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPEL.BadSPNoDirConn.fmt.txt"), (Object)dir.getId(), (Object)exportItemID));
                    continue;
                }
                if (directoryConnection.getUserDefinedProperty(StoredProcessImportListener.SOURCE_CODE_DIRECTORY) == null) {
                    directoryConnection.addUserDefinedProperty(StoredProcessImportListener.SOURCE_CODE_DIRECTORY, "yes");
                }
            }
            if (!post92) continue;
            try {
                StoredProcessInterface spi = (StoredProcessInterface)PromotionUtil.getSmartObject((PromotionInterface)operation, (SimpleLogicalObjectInterface)exportItem);
                if (spi == null) {
                    retVal = 8;
                    exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPEL.NoSmartObj.fmt.txt"), (Object)exportItemID));
                    continue;
                }
                List list = spi.getDataSourcesAndTargets();
                for (DataSourceOrTarget dsot : list) {
                    PhysicalTableInterface pti;
                    if (!(dsot instanceof DataTable)) continue;
                    DataTable dataTable = (DataTable)dsot;
                    try {
                        pti = dataTable.getTemplateTable();
                    }
                    catch (ServiceException se) {
                        retVal = 8;
                        exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPEL.BadSPCantLocTabl.fmt.txt"), (Object)exportItemID, (Object)se.getMessage()));
                        continue;
                    }
                    if (pti == null) continue;
                    PathUrl pathUrl = pti.getPathUrl();
                    if (pathUrl != null) {
                        try {
                            ConnectionPointInterface cpi = ConnectionPointUtil.createExportConnectionPoint((ExportOperationInterface)operation, (ExportItemInterface)exportItem, (PathUrl)pathUrl);
                            String userDefinedProperty = StoredProcessImportListener.DATA_TABLE_PREFIX + exportItemID + ":" + dataTable.getParameterName();
                            cpi.addUserDefinedProperty(userDefinedProperty, "yes");
                        }
                        catch (MetadataPromotionException e) {
                            retVal = 8;
                            exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPEL.BadSPCantCreatTablCP.fmt.txt"), (Object)exportItemID, (Object)pathUrl.getAbsolutePath(), (Object)e.getMessage()));
                        }
                        continue;
                    }
                    retVal = 8;
                    exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPEL.BadSPNoPathUrlForTabl.fmt.txt"), (Object)pti.getName(), (Object)exportItemID));
                }
            }
            catch (ServiceException e) {
                throw new MdException((Throwable)e);
            }
        }
        return retVal;
    }

    public ExportItemInterface createExportItem(String name, String id, TransportableTypeInterface type) {
        return new StoredProcessExportItem(name, id, type);
    }

    public int exportContent(ExportOperationInterface operation, List objects) throws TransportException, IOException, MdException {
        class SPExportInfo {
            ExportItemInterface _exportItem;
            ClassifierMap _classifierMap;
            ObjectFactory.SourceLocation _sourceLocation;

            SPExportInfo(ClassifierMap classifierMap, ObjectFactory.SourceLocation sl, ExportItemInterface exportItem) {
                this._classifierMap = classifierMap;
                this._sourceLocation = sl;
                this._exportItem = exportItem;
            }
        }
        if (operation.getPromotionType() == 2) {
            return 0;
        }
        PromotionPropertiesFile propertiesFile = operation.getPropertiesFile();
        Log exportLogger = operation.getLogger();
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        int retVal = 0;
        if (exportLogger.isDebugEnabled() && UtilMetadataSP.INCLUDE_SOURCE_CODE_PROPERTY != null) {
            exportLogger.debug((Object)("Include source code property set to: " + UtilMetadataSP.INCLUDE_SOURCE_CODE_PROPERTY));
        }
        HashMap<ServerContext, ArrayList<SPExportInfo>> map = new HashMap<ServerContext, ArrayList<SPExportInfo>>();
        for (ExportItemInterface exportItemInterface : objects) {
            ObjectFactory.SourceLocation sl;
            if (!((StoredProcessExportItem)exportItemInterface).getIncludeContent()) {
                propertiesFile.addProperty(exportItemInterface.getID() + "_ExcludeContent", "true");
                continue;
            }
            ClassifierMap cm = (ClassifierMap)UtilMetadata.locateExistingObject((MdObjectStore)operation.getStore(), (String)"ClassifierMap", (String)exportItemInterface.getID(), (String)"<Templates><ClassifierMap><ComputeLocations/><SourceCode/></ClassifierMap><File><Directories/></File><Directory><Properties/><DeployedComponents/></Directory></Templates>");
            this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("SPEL.StatusIndicator.fmt.txt"), (Object)cm.getName()));
            try {
                sl = UtilMetadataSP.getSourceCodeLocation(cm);
            }
            catch (MdException mde) {
                retVal = 8;
                exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPEL.NoContentBadSP.fmt.txt"), (Object)mde.getMessage()));
                continue;
            }
            if (sl.isSourceInMetadata()) continue;
            Directory dir = sl.getStoredProcessRepository();
            Iterator it1 = dir.getDeployedComponents().iterator();
            if (!it1.hasNext()) {
                retVal = 8;
                exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPEL.NoContentNoSrvrCtxt.fmt.txt"), (Object)cm.getName(), (Object)cm.getFQID(), (Object)dir.getDirectoryName(), (Object)dir.getFQID()));
                continue;
            }
            ServerContext sc = (ServerContext)it1.next();
            ArrayList<SPExportInfo> exportInfoList = (ArrayList<SPExportInfo>)map.get(sc);
            if (exportInfoList == null) {
                exportInfoList = new ArrayList<SPExportInfo>();
                map.put(sc, exportInfoList);
            }
            exportInfoList.add(new SPExportInfo(cm, sl, exportItemInterface));
        }
        for (Map.Entry entry : map.entrySet()) {
            boolean openSucceeded;
            ServerContext sc = (ServerContext)entry.getKey();
            List exportInfoList = (List)entry.getValue();
            WsAppServer wsAppServer = null;
            String failureMsg = null;
            try {
                wsAppServer = ContentHelper.openAppServerConnection((PromotionInterface)operation, (ServerContext)sc);
                openSucceeded = true;
            }
            catch (WsAppServerFailException e1) {
                openSucceeded = false;
                failureMsg = UtilMisc.getMessage((String)RB.getStringResource("COM.ImpExpNoConn.fmt.txt"), (Object)sc.getName(), (Object)e1.getMessage());
            }
            for (SPExportInfo spExportInfo : exportInfoList) {
                exportLogger.info((Object)UtilMisc.getMessage((String)UtilPromotion.getPromotionLogFormatString(), (Object)spExportInfo._exportItem.getTypeInterface().getDisplayType(), (Object)spExportInfo._exportItem.toString(), (Object)spExportInfo._classifierMap.getFQID()));
                try {
                    if (openSucceeded) {
                        File file = spExportInfo._sourceLocation.getStoredProcessFile();
                        String fileInAString = wsAppServer.readFile(spExportInfo._sourceLocation.getStoredProcessRepository(), file, false);
                        byte[] fileAsUTF8Bytes = fileInAString.getBytes("UTF-8");
                        ByteArrayInputStream is = new ByteArrayInputStream(fileAsUTF8Bytes);
                        contentHandler.addBinaryContent(spExportInfo._classifierMap.getFQID(), file.getFileName(), (InputStream)is);
                        exportLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("SPEL.ContentPkgd.fmt.txt"), (Object)spExportInfo._sourceLocation.getStoredProcessFile().getFileName(), (Object)spExportInfo._sourceLocation.getStoredProcessRepository().getDirectoryName()));
                        continue;
                    }
                    retVal = 8;
                    exportLogger.error((Object)failureMsg);
                }
                catch (Exception e) {
                    if (retVal == 0) {
                        retVal = 4;
                    }
                    exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("SPEL.NoContentNoAccess.fmt.txt"), (Object)spExportInfo._sourceLocation.getStoredProcessFile().getFileName(), (Object)spExportInfo._sourceLocation.getStoredProcessRepository().getDirectoryName(), (Object)sc.getName(), (Object)e.getMessage()));
                }
            }
            if (wsAppServer == null) continue;
            wsAppServer.dispose();
        }
        return retVal;
    }

    public JPanel getOptionsPanel(ExportItemInterface[] items, ExportOperationInterface exportHandler) {
        if (this._optionsPanel == null) {
            this._optionsPanel = new StoredProcessPromotionOptionsPanel(exportHandler.getPromotionType());
        }
        this._optionsPanel.populateExportOptions(items);
        return this._optionsPanel;
    }

    public JPanel getOptionsPanel(ImportItemInterface[] items, ImportOperationInterface importHandler) {
        return null;
    }

    public void saveSettings() {
        this._optionsPanel.saveSettings();
    }
}

