/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.logical.server.PhysicalDirectoryManager;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.storedprocess.StoredProcessImportListener;
import com.sas.metadata.logical.storedprocess.UtilMetadataSP;
import com.sas.metadata.promotion.AbstractConnectionType;
import com.sas.metadata.promotion.ConnectionCreationInterface;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.DependentConnectionMapping;
import com.sas.metadata.promotion.DependentConnectionTypeInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.ValidationResponse;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerContext;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

@SASScope
public class SourceCodeRepositoryConnectionType
extends AbstractConnectionType
implements DependentConnectionTypeInterface,
ConnectionCreationInterface {
    private static final String TYPE_NAME = "Source Code Repository";
    private List _directoryConnections;
    private DependentConnectionMapping _dependentConnectionMap;
    private Map _targetValueMap;
    private PhysicalDirectoryManager _dirManager;

    public SourceCodeRepositoryConnectionType(PromotionInterface operation) {
        super(operation);
        this._dirManager = new PhysicalDirectoryManager(operation);
    }

    public String getConnectionTypeName() {
        return TYPE_NAME;
    }

    public List getSourceConnections() {
        if (this._directoryConnections == null) {
            this._directoryConnections = new ArrayList();
            List directories = this._connectionManager.getConnections(ConnectionObjectType.MetadataType, "Directory");
            for (ConnectionPointInterface pt : directories) {
                if (pt.getUserDefinedProperty(StoredProcessImportListener.SOURCE_CODE_DIRECTORY) == null) continue;
                String directoryName = this.getDirectoryName(pt);
                SourceConnectionInterface source = this.createSourceConnection(pt, directoryName == null ? pt.getName() : directoryName);
                this._directoryConnections.add(source);
            }
        }
        return this._directoryConnections;
    }

    public String getLocalizedTypeName() {
        return RB.getStringResource("SCRT.ConnectionType.txt");
    }

    public String getPanelName() {
        return "com.sas.metadata.logical.storedprocess.SourceCodeRepositoryConnectionPanel";
    }

    public String getTypeAttributeLabel() {
        return "Directory";
    }

    public List getTargetConnections() throws MdException, RemoteException {
        return new ArrayList();
    }

    public boolean isConnectionRequired(SourceConnectionInterface connection) {
        return true;
    }

    public DependentConnectionMapping getDependentConnectionMapping() {
        if (this._dependentConnectionMap == null) {
            this._dependentConnectionMap = new DependentConnectionMapping();
            ConnectionTypeInterface serverType = this._operation.getConnectionType(AppServerConnectionType.class.getName());
            List serverConnections = serverType.getSourceConnections();
            if (serverConnections == null || serverConnections.size() == 0) {
                return this._dependentConnectionMap;
            }
            List connections = this.getSourceConnections();
            for (SourceConnectionInterface directoryConnection : connections) {
                String serverName = SourceCodeRepositoryConnectionType.getServerName(directoryConnection);
                SourceConnectionInterface serverConnection = this.getServerConnection(serverType, serverConnections, serverName);
                if (serverConnection == null) continue;
                this._dependentConnectionMap.addDependentConnection(serverConnection, directoryConnection);
            }
        }
        return this._dependentConnectionMap;
    }

    public List getTargetValues(SourceConnectionInterface parentConnection) throws MdException, RemoteException {
        TargetConnectionInterface target;
        ConnectionTypeInterface type = this._operation.getConnectionType(AppServerConnectionType.getTypeClassName());
        if (type != null && (target = type.getTargetConnection(parentConnection)) != null && target.getMetadataObject() instanceof ServerContext) {
            if (this._targetValueMap == null) {
                this._targetValueMap = new HashMap();
            }
            ArrayList<TargetConnectionInterface> directoryList = new ArrayList<TargetConnectionInterface>();
            MdFactory factory = this._operation.getMetadataFactory();
            int flags = 268;
            String options = "<Templates><ServerContext><DataPackages/></ServerContext><Directory><Properties/></Directory></Templates>";
            ServerContext server = (ServerContext)factory.getOMIUtil().getMetadataAllDepths(target.getMetadataObject(), null, null, options, flags);
            AssociationList directories = server.getDataPackages();
            block0: for (Object obj : directories) {
                if (!(obj instanceof Directory)) continue;
                Directory dir = (Directory)obj;
                AssociationList properties = dir.getProperties();
                for (Property prop : properties) {
                    if (!prop.getPropertyRole().equalsIgnoreCase("SPSourceCodeRepository")) continue;
                    directoryList.add(this.createTargetConnection((CMetadata)dir, dir.getDirectoryName()));
                    continue block0;
                }
            }
            this._targetValueMap.put(target, directoryList);
            return directoryList;
        }
        return new ArrayList();
    }

    public ConnectionTypeInterface getDependentType() {
        return this._operation.getConnectionType(AppServerConnectionType.getTypeClassName());
    }

    public TargetConnectionInterface createTargetConnection(SourceConnectionInterface source, String targetValue) throws MetadataPromotionException {
        TargetConnectionInterface targetServer = null;
        DependentConnectionMapping mapping = this.getDependentConnectionMapping();
        SourceConnectionInterface sourceServer = mapping.getDependentConnection(source);
        if (sourceServer != null) {
            ConnectionTypeInterface serverType = sourceServer.getConnectionType();
            targetServer = serverType.getTargetConnection(sourceServer);
        }
        if (targetServer != null) {
            MdFactory factory = this._operation.getMetadataFactory();
            MdObjectStore store = this._operation.getStore();
            String reposID = this._operation.getRepositoryID().substring(9);
            try {
                if (this.isCreateNeeded(targetServer, targetValue)) {
                    Directory dir = (Directory)factory.createComplexMetadataObject(store, "SP Source Directory", "Directory", reposID);
                    dir.setDirectoryName(targetValue);
                    Property prop = (Property)factory.createComplexMetadataObject(store, "SP Source Directory", "Property", reposID);
                    prop.setPropertyRole("SPSourceCodeRepository");
                    prop.setSQLType(12);
                    dir.getProperties().add((Object)prop);
                    dir.getDeployedComponents().add((Object)targetServer.getMetadataObject());
                    dir.updateMetadataAll();
                    return this.createTargetConnection((CMetadata)dir, dir.getDirectoryName());
                }
            }
            catch (Exception e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SCRT.TargetCreateFailed.fmt.txt", (Object)targetValue);
                throw new MetadataPromotionException((Throwable)e, msg);
            }
        }
        return null;
    }

    private boolean isCreateNeeded(TargetConnectionInterface targetServer, String dirName) throws RemoteException, MdException {
        CMetadata meta = targetServer.getMetadataObject();
        if (meta instanceof ServerContext) {
            ArrayList directories = new ArrayList();
            UtilMetadataSP.findAllRepositoryContextsForServerContext(2, (ServerContext)meta, directories, null);
            for (Directory dir : directories) {
                String path = dir.getDirectoryName();
                if (!path.equalsIgnoreCase(dirName)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private String getDirectoryName(ConnectionPointInterface pt) {
        return PromotionUtil.getAttrValue((String)pt.getSourceSearchString(), (String)"DirectoryName");
    }

    private SourceConnectionInterface getServerConnection(ConnectionTypeInterface serverType, List connections, String serverName) {
        if (serverName == null) {
            return null;
        }
        for (SourceConnectionInterface source : connections) {
            if (!serverName.equals(source.getDisplayName())) continue;
            return source;
        }
        return null;
    }

    public static String getServerName(SourceConnectionInterface source) {
        int startIndex;
        ConnectionPointInterface pt;
        String searchAttribute;
        int index;
        List connections = source.getConnectionPoints();
        if (connections.size() > 0 && (index = (searchAttribute = (pt = (ConnectionPointInterface)connections.get(0)).getSourceSearchString()).indexOf("@Name='", startIndex = searchAttribute.indexOf("DeployedComponents"))) > -1) {
            return searchAttribute.substring(index + 7, searchAttribute.indexOf(39, index + 7));
        }
        return null;
    }

    public void validate(ValidationResponse response, ImportOperationInterface importOperation, SourceConnectionInterface sourceValue) throws MdException, RemoteException {
        if (sourceValue != null) {
            if (importOperation.isInstallProcess()) {
                return;
            }
            TargetConnectionInterface targetValue = this.getTargetConnection(sourceValue);
            if (targetValue != null && targetValue.getTargetID() != null) {
                CMetadata meta;
                String dirName = targetValue.getDisplayName();
                TargetConnectionInterface targetServer = this.getTargetServerConnection(sourceValue);
                if (targetServer != null && (meta = targetServer.getMetadataObject()) instanceof ServerContext) {
                    try {
                        boolean exists = this._dirManager.exists((ServerContext)meta, dirName);
                        if (!exists) {
                            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SCRT.DoesNotExist.fmt.txt", (Object)dirName, (Object)targetServer.getDisplayName());
                            response.setReturnCode(1);
                            response.setMessage(msg);
                        }
                    }
                    catch (Exception e) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SCRT.UnableToValidate.fmt.txt", (Object)dirName, (Object)targetServer.getDisplayName());
                        importOperation.getLogger().info((Object)msg);
                    }
                }
            }
        }
    }

    private TargetConnectionInterface getTargetServerConnection(SourceConnectionInterface sourceConnection) {
        DependentConnectionMapping mapping = this.getDependentConnectionMapping();
        SourceConnectionInterface sourceServer = mapping.getDependentConnection(sourceConnection);
        if (sourceServer != null) {
            ConnectionTypeInterface serverType = sourceServer.getConnectionType();
            return serverType.getTargetConnection(sourceServer);
        }
        return null;
    }
}

