/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.storedprocess.RepositoryPropertyVC;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

class RepositoryPropertyPanel
extends RepositoryPropertyVC {
    private Directory _directory;
    private String[] _existingRepositoryNames;
    private String _originalName;
    private boolean _isPrepopulatingOnAdd = false;

    public RepositoryPropertyPanel(Directory directory, int context, String[] existingRepositoryNames) throws RemoteException {
        super(context);
        this._directory = directory;
        if (this._context == 2) {
            this._originalName = this._directory.getDirectoryName();
        }
        this._existingRepositoryNames = existingRepositoryNames;
    }

    public void setIsPrepopulatingOnAdd(boolean prepopulate) {
        this._isPrepopulatingOnAdd = prepopulate;
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (this._context == 2 || this._isPrepopulatingOnAdd) {
            this._txtLocation.setText(this._directory.getDirectoryName());
            this._txtDescription.setText(this._directory.getDesc());
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this._context == 1) {
            Property property = (Property)UtilMetadata.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)this._directory, (String)"SP Source Directory", (String)"Property");
            property.setPropertyRole("SPSourceCodeRepository");
            property.setSQLType(12);
            this._directory.getProperties().add((Object)property);
        }
        this._directory.setDirectoryName(this._txtLocation.getText().trim());
        this._directory.setDesc(this._txtDescription.getText());
    }

    public boolean dataValidate() {
        String dirName = this._txtLocation.getText();
        if (UtilMisc.isBlankOrEmptyString((String)dirName)) {
            MessageUtil.displayMessage((String)RB.getStringResource("RMP.NoName.txt"), (String)RB.getStringResource("RMP.ErrDlgTitle.txt"), (int)0);
            this._txtLocation.requestFocus();
            return false;
        }
        boolean checkNameForDuplicates = true;
        if (this._context == 2 && this._originalName.equals(dirName)) {
            checkNameForDuplicates = false;
        }
        if (checkNameForDuplicates) {
            boolean isDuplicate = false;
            for (int i = 0; i < this._existingRepositoryNames.length; ++i) {
                if (!this._existingRepositoryNames[i].equals(dirName)) continue;
                isDuplicate = true;
                break;
            }
            if (isDuplicate) {
                String text = Message.format((ResourceBundle)RB.getResources(), (String)"COM.Exsts.fmt.txt", (Object)dirName);
                MessageUtil.displayMessage((String)text, (String)RB.getStringResource("RMP.ErrDlgTitle.txt"), (int)0);
                this._txtLocation.requestFocus();
                return false;
            }
        }
        return true;
    }
}

