/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.storedprocess.RepositoryManagerTableModel;
import com.sas.metadata.logical.storedprocess.SourceCodeRepositoryElementInterface;
import com.sas.metadata.logical.visuals.MetadataDialogPanel;
import com.sas.metadata.logical.visuals.UtilGui;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

abstract class RepositoryManagerVC
extends MetadataDialogPanel
implements ListSelectionListener {
    private JTable _tableRepositories;
    protected RepositoryManagerTableModel _repositoryTableModel;
    private JScrollPane _scrRepositories;
    private JButton _buttonAdd;
    private JButton _buttonModify;
    private JButton _buttonDelete;

    RepositoryManagerVC() {
        this._initialize();
        this._layoutWidgets();
    }

    protected void _initialize() {
        this.setHelpProduct("storedprocess");
        this.setHelpTopic("stp_managescrepwin");
        this._repositoryTableModel = new RepositoryManagerTableModel();
        this._tableRepositories = new JTable(this._repositoryTableModel);
        this._tableRepositories.setDefaultRenderer(Object.class, (TableCellRenderer)new UtilGui.NoHtmlTableCellRenderer());
        this._tableRepositories.setToolTipText(RB.getStringResource("COM.Table.Tooltip.txt"));
        this._tableRepositories.getSelectionModel().addListSelectionListener(this);
        this._tableRepositories.setShowHorizontalLines(false);
        this._tableRepositories.setShowVerticalLines(false);
        this._tableRepositories.setSelectionMode(0);
        this._scrRepositories = new JScrollPane(this._tableRepositories);
        this._buttonAdd = UtilGui.createButton((String)RB.getStringResource("COM.Btn.Add0.txt"));
        this._buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    SourceCodeRepositoryElementInterface re = RepositoryManagerVC.this.doAddRepository();
                    if (re != null) {
                        RepositoryManagerVC.this._repositoryTableModel.addRepository(re);
                        RepositoryManagerVC.this._repositoryTableModel.fireTableDataChanged();
                        RepositoryManagerVC.this.setSelection(re.getDirectory());
                    }
                }
                catch (RemoteException e) {
                    UtilGui.displayRemoteException((RemoteException)e);
                }
            }
        });
        this._buttonModify = UtilGui.createButton((String)RB.getStringResource("COM.Btn.Mod0.txt"));
        this._buttonModify.setEnabled(false);
        this._buttonModify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selected = RepositoryManagerVC.this._tableRepositories.getSelectedRow();
                if (selected != -1) {
                    SourceCodeRepositoryElementInterface rei = RepositoryManagerVC.this._repositoryTableModel.getRepositoryElementAt(selected);
                    try {
                        if (RepositoryManagerVC.this.doModifyRepository(rei)) {
                            RepositoryManagerVC.this._repositoryTableModel.fireTableDataChanged();
                        }
                    }
                    catch (RemoteException e) {
                        UtilGui.displayRemoteException((RemoteException)e);
                    }
                }
            }
        });
        this._buttonDelete = UtilGui.createButton((String)RB.getStringResource("COM.Btn.Del0.txt"));
        this._buttonDelete.setEnabled(false);
        this._buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selected = RepositoryManagerVC.this._tableRepositories.getSelectedRow();
                if (selected != -1) {
                    SourceCodeRepositoryElementInterface rei = RepositoryManagerVC.this._repositoryTableModel.getRepositoryElementAt(selected);
                    try {
                        if (RepositoryManagerVC.this.doRemoveRepository(rei)) {
                            RepositoryManagerVC.this._repositoryTableModel.removeRepository(rei);
                            RepositoryManagerVC.this._repositoryTableModel.fireTableDataChanged();
                            RepositoryManagerVC.this.setEnabledStateOfButtons();
                        }
                    }
                    catch (RemoteException e) {
                        UtilGui.displayRemoteException((RemoteException)e);
                    }
                }
            }
        });
    }

    protected void _layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this._scrRepositories.setPreferredSize(new Dimension(350, 200));
        JPanel amrParmButtonsPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(3, 1);
        gridLayout.setVgap(5);
        amrParmButtonsPanel.setLayout(gridLayout);
        amrParmButtonsPanel.add(this._buttonAdd);
        amrParmButtonsPanel.add(this._buttonModify);
        amrParmButtonsPanel.add(this._buttonDelete);
        this.add(this._scrRepositories, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.add(amrParmButtonsPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, NEXT_INSETS_IN_TOP_ROW, 0, 0));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.setEnabledStateOfButtons();
    }

    protected SourceCodeRepositoryElementInterface getSelection() {
        int selected = this._tableRepositories.getSelectedRow();
        if (selected != -1) {
            return this._repositoryTableModel.getRepositoryElementAt(selected);
        }
        return null;
    }

    protected void setSelection(String nameToBeShownSelected) {
        int row = this._repositoryTableModel.locateRowFor(nameToBeShownSelected);
        if (row != -1) {
            this._tableRepositories.changeSelection(row, 0, false, false);
        }
    }

    private void setEnabledStateOfButtons() {
        try {
            boolean editingPermitted = this.isAddEditDeleteEnableable();
            this._buttonAdd.setEnabled(editingPermitted);
            boolean enable = this._tableRepositories.getSelectedRow() >= 0 && editingPermitted;
            this._buttonModify.setEnabled(enable);
            this._buttonDelete.setEnabled(enable);
        }
        catch (RemoteException e) {
            UtilGui.displayRemoteException((RemoteException)e);
        }
    }

    protected abstract boolean isAddEditDeleteEnableable() throws RemoteException;

    protected abstract SourceCodeRepositoryElementInterface doAddRepository() throws RemoteException;

    protected abstract boolean doModifyRepository(SourceCodeRepositoryElementInterface var1) throws RemoteException;

    protected abstract boolean doRemoveRepository(SourceCodeRepositoryElementInterface var1) throws RemoteException;
}

