/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.storedprocess.SourceCodeRepositoryElementInterface;
import com.sas.metadata.logical.visuals.UtilGui;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class RepositoryManagerTableModel
extends AbstractTableModel {
    private List _data = new ArrayList();

    RepositoryManagerTableModel() {
    }

    void addRepositories(List list) {
        this._data.addAll(list);
    }

    SourceCodeRepositoryElementInterface getRepositoryElementAt(int row) {
        return (SourceCodeRepositoryElementInterface)this._data.get(row);
    }

    void addRepository(SourceCodeRepositoryElementInterface rei) {
        this._data.add(rei);
    }

    void removeRepository(SourceCodeRepositoryElementInterface rei) {
        this._data.remove(rei);
    }

    void removeAll() {
        this._data.clear();
    }

    void sortRepositories() {
        if (this._data == null || this._data.size() <= 1) {
            return;
        }
        Collections.sort(this._data, new RepositorySorter());
    }

    int locateRowFor(String name) {
        Iterator it = this._data.iterator();
        int i = 0;
        while (it.hasNext()) {
            SourceCodeRepositoryElementInterface rei = (SourceCodeRepositoryElementInterface)it.next();
            try {
                if (rei.getDirectory().equals(name)) {
                    return i;
                }
            }
            catch (RemoteException e) {
                UtilGui.displayRemoteException((RemoteException)e);
                return -1;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this._data.size();
    }

    @Override
    public String getColumnName(int c) {
        String colName = c == 0 ? RB.getStringResource("RMTM.ColHdrPath.txt") : RB.getStringResource("RMTM.ColHdrDesc.txt");
        return colName;
    }

    @Override
    public Object getValueAt(int row, int col) {
        SourceCodeRepositoryElementInterface re = (SourceCodeRepositoryElementInterface)this._data.get(row);
        try {
            return col == 0 ? re.getDirectory() : re.getDescription();
        }
        catch (RemoteException e) {
            UtilGui.displayRemoteException((RemoteException)e);
            return "";
        }
    }

    private class RepositorySorter
    implements Comparator {
        private RepositorySorter() {
        }

        public int compare(Object obj1, Object obj2) {
            try {
                String name1 = null;
                if (obj1 instanceof SourceCodeRepositoryElementInterface) {
                    name1 = ((SourceCodeRepositoryElementInterface)obj1).getDirectory();
                }
                if (name1 == null) {
                    return -1;
                }
                String name2 = null;
                if (obj2 instanceof SourceCodeRepositoryElementInterface) {
                    name2 = ((SourceCodeRepositoryElementInterface)obj2).getDirectory();
                }
                if (name2 == null) {
                    return 1;
                }
                return name1.compareToIgnoreCase(name2);
            }
            catch (RemoteException re) {
                return 0;
            }
        }
    }
}

