/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.metadata.logical.ObjectContainer;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.WizardCompletionInterface;
import com.sas.metadata.logical.storedprocess.ConfigDataPanel;
import com.sas.metadata.logical.storedprocess.ConfigExecutionPanel;
import com.sas.metadata.logical.storedprocess.ConfigParameterPanel;
import com.sas.metadata.logical.storedprocess.DataTabPanel;
import com.sas.metadata.logical.storedprocess.ExecutionTabPanel93;
import com.sas.metadata.logical.storedprocess.GeneralTabPanel;
import com.sas.metadata.logical.storedprocess.MetadataManipulator;
import com.sas.metadata.logical.storedprocess.NewExecutionTabPanel;
import com.sas.metadata.logical.storedprocess.NewParameterTabPanel;
import com.sas.metadata.logical.storedprocess.ObjectFactory;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.ConfigGeneralPanel;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAWizardDialog;
import java.awt.Cursor;
import java.awt.Frame;
import java.rmi.RemoteException;

class NewStoredProcessWizard
extends WAWizardDialog {
    private final ObjectFactory _objectFactory;
    private ObjectContainer _sourceCodeLocationOC = new ObjectContainer();
    private WizardCompletionInterface _wizardInterface;
    private MetadataManipulator _metadataManipulator;

    public NewStoredProcessWizard(ObjectFactory objectfactory, Frame frame, ClassifierMap classifierMap, WizardCompletionInterface wizardInterface, String repositoryFQID, Tree tree, Config config) throws RemoteException {
        super(frame, true);
        this._objectFactory = objectfactory;
        this._metadataManipulator = new MetadataManipulator(classifierMap);
        this.initialize(frame, classifierMap, repositoryFQID, tree, config);
        this._wizardInterface = wizardInterface;
        this.setResizable(true);
    }

    protected boolean onFinish() {
        if (super.onFinish()) {
            try {
                this._metadataManipulator.writeXML();
            }
            catch (RemoteException re) {
                UtilGui.displayRemoteException((RemoteException)re);
                return false;
            }
            if (this._wizardInterface == null) {
                return true;
            }
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                ObjectFactory.SourceLocation sl = (ObjectFactory.SourceLocation)this._sourceCodeLocationOC.getObject();
                boolean bl = this._wizardInterface.onFinish((Object)sl);
                return bl;
            }
            catch (Exception e) {
                UtilGui.displayExceptionError((Exception)e);
                boolean bl = false;
                return bl;
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return false;
    }

    protected void initialize(Frame frame, ClassifierMap classifierMap, String repositoryFQID, Tree tree, Config config) throws RemoteException {
        boolean nine_two;
        double uv = classifierMap.getUsageVersion();
        boolean bl = nine_two = ObjectFactory.NINETWO_VERSION.encode() == uv;
        if (nine_two) {
            this.setTitle(RB.getStringResource("NSPW.Title92.txt"));
        } else {
            this.setTitle(RB.getStringResource("NSPW.Title.txt"));
        }
        String genTitle = (String)config.getInitValue(ConfigGeneralPanel.WIZARD_TITLE, (Object)RB.getStringResource("NSPW.Gen.Title.txt"));
        this.addTab(genTitle, RB.getStringResource("COM.GPV.Tab.txt"), (WAPropertyTab)new GeneralTabPanel(classifierMap, tree, 0, (TypeInterface)this._objectFactory._type, config, this._metadataManipulator), "gen", null);
        String execTitle = (String)config.getInitValue(ConfigExecutionPanel.WIZARD_TITLE, (Object)RB.getStringResource("NSPW.Exec.Title.txt"));
        if (nine_two) {
            this.addTab(execTitle, RB.getStringResource("NETVC.Tab.txt"), (WAPropertyTab)new NewExecutionTabPanel(classifierMap, this._objectFactory, 0, repositoryFQID, this._sourceCodeLocationOC, config, this._metadataManipulator), "exe", null);
        } else {
            this.addTab(execTitle, RB.getStringResource("NETVC.Tab.txt"), (WAPropertyTab)new ExecutionTabPanel93(classifierMap, this._objectFactory, 0, repositoryFQID, this._sourceCodeLocationOC, config, this._metadataManipulator), "exe", null);
        }
        if (config.isVisible(ConfigParameterPanel.PANEL)) {
            String parmTitle = (String)config.getInitValue(ConfigParameterPanel.WIZARD_TITLE, (Object)RB.getStringResource("NSPW.Parms.Title.txt"));
            this.addTab(parmTitle, RB.getStringResource("NPTP.Tab.txt"), (WAPropertyTab)new NewParameterTabPanel(classifierMap, 0, config, this._metadataManipulator), "parm", null, true);
        }
        String dataTitle = (String)config.getInitValue(ConfigDataPanel.WIZARD_TITLE, (Object)RB.getStringResource("NSPW.Data.Title.txt"));
        this.addTab(dataTitle, RB.getStringResource("DTP.Tab.txt"), (WAPropertyTab)new DataTabPanel(classifierMap, 0, config, this._metadataManipulator), "data", null, true);
    }
}

