/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.storedprocess.Images;
import com.sas.metadata.logical.storedprocess.NewStoredProcessWizard;
import com.sas.metadata.logical.storedprocess.ObjectFactory;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.storedprocess.StoredProcessLogicalObject;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.ConfigGeneralPanel;
import com.sas.metadata.logical.visuals.NewObjectActionInterface;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;

class NewStoredProcessAction
extends AbstractAction
implements NewObjectActionInterface {
    private ObjectFactory _objectFactory;
    private Tree _tree;
    private Frame _frame;
    private FolderInterface _folderInterface;
    private ClassifierMap _classifierMap;
    private Config _config;

    public NewStoredProcessAction(Frame frame, FolderInterface folderInterface, Tree tree, ObjectFactory objectFactory, Config config) {
        this._frame = frame;
        this._folderInterface = folderInterface;
        this._tree = tree;
        this._objectFactory = objectFactory;
        this._config = config;
        UtilGui.setLabelAndMnemonicOnAction((AbstractAction)this, (String)RB.getStringResource("NSPA.CtxtMenuItm.txt"));
        this.putValue("SmallIcon", Images.getSPNewIcon16());
        this.putValue("ShortDescription", RB.getStringResource("NSPA.ToolTip.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String reposid = UtilMetadata.get8CharReposidFromFQID((String)this._folderInterface.getID());
            this._classifierMap = (ClassifierMap)UtilMetadata.createANewComplexObjectInANewStore((String)"SP Classifier Map", (String)"ClassifierMap", (String)reposid);
            if (this._tree == null) {
                try {
                    this._tree = (Tree)UtilMetadata.getJOMAObjectFromLogicalObject((LogicalObjectInterface)this._folderInterface, (MdObjectStore)((MdObjectStore)this._classifierMap.getObjectStore()));
                }
                catch (MdException e1) {
                    UtilGui.displayMdException((MdException)e1);
                    return;
                }
            }
            this._classifierMap.setTransformRole("StoredProcess");
            this._classifierMap.setPublicType("StoredProcess");
            this._classifierMap.setUsageVersion(ObjectFactory.CURRENT_VERSION.encode());
            String repositoryFQID = UtilMetadata.makeRepositoryFQIDFromRoot((Root)this._tree);
            if (this._config == null) {
                this._config = new Config();
            }
            if (this._config.getInitValue(ConfigGeneralPanel.HELP_PRODUCT, null) == null) {
                this._config.setInitValue(ConfigGeneralPanel.HELP_PRODUCT, (Object)"newstp");
            }
            if (this._config.getInitValue(ConfigGeneralPanel.HELP_TOPIC, null) == null) {
                this._config.setInitValue(ConfigGeneralPanel.HELP_TOPIC, (Object)"namewin");
            }
            this._config.setVisible(ConfigGeneralPanel.CONTEXT, false);
            this._config.setVisible(ConfigGeneralPanel.TYPE, false);
            this._config.setVisible(ConfigGeneralPanel.CREATED, false);
            this._config.setVisible(ConfigGeneralPanel.MODIFIED, false);
            NewStoredProcessWizard wizard = new NewStoredProcessWizard(this._objectFactory, this._frame, this._classifierMap, null, repositoryFQID, this._tree, this._config);
            wizard.show();
            MdObjectStore newStore = (MdObjectStore)this._classifierMap.getObjectStore();
            if (wizard.getReturnValue() == 1) {
                this._frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Tree treeInNewStore = (Tree)UtilMetadata.locateExistingObject((MdObjectStore)newStore, (String)"Tree", (String)this._tree.getFQID());
                    this._classifierMap.getTrees().add((Object)treeInNewStore);
                    newStore.updatedMetadataAll();
                    this._classifierMap = (ClassifierMap)UtilMetadata.locateExistingObject((MdObjectStore)newStore, (String)"ClassifierMap", (String)this._classifierMap.getFQID());
                    StoredProcessLogicalObject lo = new StoredProcessLogicalObject(this._classifierMap, (TypeInterface)this._objectFactory._type, this._objectFactory._type.getFactory());
                    this.firePropertyChange(Factory.EVENT_MEMBER_ADDED, null, (Object)lo);
                }
                catch (MdException mde) {
                    UtilGui.displayMdException((MdException)mde);
                }
                finally {
                    this._frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            newStore.dispose();
        }
        catch (RemoteException re) {
            UtilGui.displayRemoteException((RemoteException)re);
        }
    }

    public String getActionLabel() {
        return RB.getStringResource("NSPA.NewMenuLabel.txt");
    }
}

