/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.datatypes.DataTypeInterface;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.storedprocess.ConfigParameterPanel;
import com.sas.metadata.logical.storedprocess.MetadataManipulator;
import com.sas.metadata.logical.storedprocess.OutputParametersPanel;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.LayoutConstants;
import com.sas.metadata.logical.visuals.SmartWsDescriptionWizardTab;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.Root;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.visuals.swing.designtime.MainPromptPanel;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptNameInterface;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.MetadataConstants;
import com.sas.services.util.Names;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.ProportionalSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import com.sas.workspace.MessageUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.xml.parsers.ParserConfigurationException;

class NewParameterTabPanel
extends SmartWsDescriptionWizardTab
implements LayoutConstants {
    private ClassifierMap _classifierMap;
    private Config _config;
    private int _type;
    private MainPromptPanel _mainPromptPanel;
    private OutputParametersPanel _outputParmsPanel;

    public NewParameterTabPanel(ClassifierMap classifierMap, int type, Config config, MetadataManipulator metadataManipulator) {
        this._config = config;
        this._type = type;
        this._classifierMap = classifierMap;
        String description = (String)config.getInitValue(ConfigParameterPanel.WIZARD_DESCRIPTION, (Object)RB.getStringResource("NPTP.Wiz.txt"));
        this.setDescription(description);
        this.setName(RB.getStringResource("NPTP.Tab.txt"));
        if (type == 1) {
            this.setHelpProduct("storedprocess");
            this.setHelpTopic("stp_parameterstab");
        } else {
            this.setHelpProduct("newstp");
            this.setHelpTopic("parameterswin");
        }
        AutoSizingGridLayout layout = new AutoSizingGridLayout(4, 1, 5, 5, true, true, true);
        double[] sizes = new double[4];
        int[] mins = new int[4];
        this.setLayout((LayoutManager)layout);
        JLabel promptLabel = new JLabel(RB.getStringResource("NPTP.Lbl.Prmpts.txt"));
        this.add(promptLabel);
        sizes[0] = -2.0;
        mins[0] = 0;
        this._mainPromptPanel = new MainPromptPanel(null);
        PromptNameValidator nameValidator = new PromptNameValidator();
        this._mainPromptPanel.setNameValidator((ValidatePromptNameInterface)nameValidator);
        this._mainPromptPanel.setValidateDataItems(true);
        this._mainPromptPanel.setRootPromptGroupShareable(false);
        this._mainPromptPanel.getPropertiesCommunicator().setAppendPasswordToPromptName(true);
        this.add((Component)this._mainPromptPanel);
        sizes[1] = 0.6;
        mins[1] = this._mainPromptPanel.getPreferredSize().height;
        this.add(new JLabel(RB.getStringResource("NPTP.Lbl.OutParms.txt")));
        sizes[2] = -2.0;
        mins[2] = 0;
        this._outputParmsPanel = new OutputParametersPanel(metadataManipulator);
        ((AutoSizingGridLayout)this._outputParmsPanel.getLayout()).setInterlockedColumnContainer((Container)this._mainPromptPanel);
        this.add((Component)((Object)this._outputParmsPanel));
        sizes[3] = 0.4;
        mins[3] = this._outputParmsPanel.getPreferredSize().height;
        ProportionalSpacePartitioner psp = new ProportionalSpacePartitioner(sizes, mins, null);
        layout.setRowSpacePartitioner((SpacePartitionerInterface)psp);
    }

    protected void smartPopulateStore() throws MdException {
        PromptGroupInterface promptGroup;
        if (this._type == 0) {
            Locale locale;
            String promptGroupLabel;
            promptGroup = (PromptGroupInterface)this._config.getInitValue(ConfigParameterPanel.PARAMETER_TREE, null);
            if (promptGroup == null) {
                promptGroup = new PromptGroup();
            }
            if ((promptGroupLabel = promptGroup.getPromptGroupLabel(locale = Locale.getDefault())) == null || promptGroupLabel.length() == 0) {
                promptGroup.setPromptGroupLabel(MetadataConstants.getLabelForParameterPromptGroup((Locale)locale), locale);
            }
        } else {
            try {
                promptGroup = PromptsPersistUtil.getPromptGroupFromOMRObject((Root)this._classifierMap, (SessionContextInterface)UtilPlatformServices.getSessionContext());
            }
            catch (Exception e) {
                throw new MdException((Throwable)e);
            }
            this._outputParmsPanel.readParmsFromXML();
        }
        this._mainPromptPanel.setRootPromptGroup(promptGroup);
        this._mainPromptPanel.setUserContext(UtilPlatformServices.getUserContext());
    }

    protected boolean dataValidate() throws RemoteException {
        ValidationEntry validationEntry = this._mainPromptPanel.validate(null);
        if (validationEntry == null) {
            return true;
        }
        MessageUtil.displayMessage((String)validationEntry.getMessage(), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
        return false;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        try {
            PromptsPersistUtil.setPromptGroupOnOMRObject((PromptGroupInterface)this._mainPromptPanel.getRootPromptGroup(), (Root)this._classifierMap, (SessionContextInterface)UtilPlatformServices.getSessionContext(), (MdFactory)this._classifierMap.getObjectStore().getFactory());
        }
        catch (Exception e) {
            throw new MdException((Throwable)e);
        }
        try {
            this._outputParmsPanel.writeParmsToXML();
        }
        catch (ParserConfigurationException e) {
            throw new MdException((Throwable)e);
        }
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this._mainPromptPanel.setEnabled(editable);
        this._outputParmsPanel.setEditable(editable);
    }

    class PromptNameValidator
    implements ValidatePromptNameInterface {
        PromptNameValidator() {
        }

        public Collection validatePromptName(int mode, PromptDefinitionInterface prompt, PromptGroupInterface promptGroup) {
            ArrayList<ValidationEntry> errors = new ArrayList<ValidationEntry>();
            String incomingPromptsName = prompt.getPromptName();
            try {
                Names.validateSASVariableName((String)incomingPromptsName, (boolean)true);
            }
            catch (Exception e) {
                errors.add(new ValidationEntry(-1L, e.getMessage()));
                return errors;
            }
            DataTypeInterface dti = prompt.getPromptDataType();
            int len = dti.getEstimatedMaxMacroVariableNameLength(incomingPromptsName);
            if (len > 32) {
                String text = Message.format((ResourceBundle)RB.getResources(), (String)"NPTP.LenErr.fmt.txt", (Object)new Integer(len - 32));
                errors.add(new ValidationEntry(-1L, text));
                return errors;
            }
            PromptGroupInterface rootGroup = NewParameterTabPanel.this._mainPromptPanel.getRootPromptGroup();
            List visiblePrompts = PromptUtil.getPromptsVisibleFromGroup((PromptGroupInterface)rootGroup, (PromptGroupInterface)promptGroup);
            Map errorMap = PromptUtil.getConflictingPromptsBasedOnMacroVariableName((Collection)visiblePrompts, (PromptDefinitionInterface)prompt, (boolean)true, (mode == 2 || mode == 3 ? 1 : 0) != 0);
            if (!errorMap.isEmpty()) {
                errors.add(new ValidationEntry(-1L, RB.getStringResource("NPTP.ValidErr.txt")));
                return errors;
            }
            return errors;
        }
    }
}

