/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.entities.Entity;
import com.sas.entities.RemoteEntityInterface;
import com.sas.entities.persist.EntityConverter;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.storedprocess.DataItemPanel;
import com.sas.metadata.logical.storedprocess.DataTabPanel;
import com.sas.metadata.logical.storedprocess.DeleteStoredProcess;
import com.sas.metadata.logical.storedprocess.ObjectFactory;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.ArchiveFile;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.ContentLocation;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Keyword;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Report;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Stream;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.entities.MdOMAEntityUtility;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.MetadataConstants;
import com.sas.services.storedprocess.URLUtil;
import com.sas.services.storedprocess.metadata.MetadataManipulatorForUpgrade;
import com.sas.services.storedprocess.metadata.StoredProcess;
import com.sas.services.util.XMLUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class MetadataManipulator {
    static final int MODE_COMPLETE = 0;
    static final int MODE_SUBSTITUTIONS = 1;
    private ClassifierMap _classifierMap;
    private PromptGroupInterface _promptGroup;
    private TextStore _textStore;
    private Map _substitutions;
    private int _mode;
    boolean _pre_92_version;
    Document _document;
    Element _storedProcessE;
    boolean _storedProcessServerSelected;
    boolean _hasStreams;
    double _usageVersion;
    boolean _isPreNineThree;

    public MetadataManipulator(ClassifierMap classifierMap) throws RemoteException {
        this.init(classifierMap);
        this._mode = 0;
    }

    public MetadataManipulator(ClassifierMap classifierMap, Map substitutions) throws RemoteException {
        this.init(classifierMap);
        this._substitutions = substitutions;
        this._mode = 1;
    }

    private void init(ClassifierMap classifierMap) throws RemoteException {
        this._classifierMap = classifierMap;
        String transformRole = classifierMap.getTransformRole();
        if (transformRole.equals("StoredProcess")) {
            this._usageVersion = classifierMap.getUsageVersion();
            this._pre_92_version = this._usageVersion == 0.0;
            this._isPreNineThree = this._usageVersion <= ObjectFactory.NINETWO_VERSION.encode();
            return;
        }
        throw new IllegalStateException("Internal logic error: TransformRole \"" + transformRole + "\" on ClassifierMap " + classifierMap.getFQID() + " is not valid.");
    }

    void convertTo92() throws MdException, RemoteException {
        this.convertClassiferMap();
        this.setServerType();
        try {
            this.convertParameters();
            this.convertStreams();
        }
        catch (ParserConfigurationException e) {
            throw new MdException((Throwable)e);
        }
    }

    private void convertClassiferMap() throws RemoteException {
        this._classifierMap.setPublicType("StoredProcess");
        this._classifierMap.setUsageVersion(ObjectFactory.NINETWO_VERSION.encode());
    }

    private void convertParameters() throws MdException, ParserConfigurationException, RemoteException {
        Entity entity = new Entity();
        MdOMAEntityUtility.populateEntityFromOMRObject((RemoteEntityInterface)entity, (Root)this._classifierMap);
        try {
            this._promptGroup = EntityConverter.DEFAULT_INSTANCE.newPromptGroup((RemoteEntityInterface)entity, null);
            Locale locale = Locale.getDefault();
            this._promptGroup.setPromptGroupLabel(MetadataConstants.getLabelForParameterPromptGroup((Locale)locale), locale);
        }
        catch (Exception e) {
            throw new MdException((Throwable)e);
        }
        MdOMAEntityUtility.removeEntityFromOMR((Root)this._classifierMap);
        this.convertResults();
        PromptsPersistUtil.setPromptGroupOnOMRObject((PromptGroupInterface)this._promptGroup, (Root)this._classifierMap, (SessionContextInterface)UtilPlatformServices.getSessionContext(), (MdFactory)this._classifierMap.getObjectStore().getFactory());
    }

    private void convertStreams() throws MdException, ParserConfigurationException, RemoteException {
        AssociationList _classiferSourcesAL = this._classifierMap.getClassifierSources();
        if (_classiferSourcesAL.size() == 0) {
            return;
        }
        boolean isWebService = false;
        AssociationList _keywordsAL = this._classifierMap.getKeywords();
        for (Keyword k : _keywordsAL) {
            if (!k.getName().equalsIgnoreCase("XMLA Web Service")) continue;
            isWebService = true;
            break;
        }
        ArrayList<DataItemPanel.DataItem> list = new ArrayList<DataItemPanel.DataItem>();
        for (Root root : _classiferSourcesAL) {
            Report report;
            if (!(root instanceof Report) || !(report = (Report)root).getReportType().equalsIgnoreCase("SPInputStream") || !((root = report.getReportLocation()) instanceof Stream)) continue;
            DataItemPanel.DataItem di = new DataItemPanel.DataItem();
            di._type = isWebService ? "XMLStream" : "GenericStream";
            di._label = di._fileref = root.getName();
            di._description = root.getDesc();
            di._supportsMultiPass = UtilMetadata.getBooleanPropertyValue((Root)root, (String)"MultiPass");
            list.add(di);
        }
        DeleteStoredProcess.deleteClassifierSources(this._classifierMap);
        if (list.size() > 0) {
            this._hasStreams = true;
            DataTabPanel.writeDataItemsToXML(this.getStoredProcessXMLElementCreatingItIfItDoesNotExist(), true, list);
        } else {
            this._hasStreams = false;
        }
    }

    private void convertResults() throws MdException, ParserConfigurationException, RemoteException {
        boolean packagesSupported = false;
        boolean streamingSupported = false;
        boolean shouldCreateNewPackageInstancePrompt = false;
        Report theReport = null;
        Directory davDirectory = null;
        PromptGroupInterface resultOptionsPG = null;
        AssociationList logicalServers = this._classifierMap.getComputeLocations();
        boolean allIsWellWithReport = false;
        for (CMetadata obj : this._classifierMap.getClassifierTargets()) {
            if (!(obj instanceof Report)) continue;
            Report report = (Report)obj;
            String reportType = report.getReportType();
            ContentLocation location = report.getReportLocation();
            if (reportType.equalsIgnoreCase("SPResultsTransientPackage")) {
                theReport = report;
                allIsWellWithReport = true;
                packagesSupported = true;
                break;
            }
            if (reportType.equalsIgnoreCase("SPResultsPermanentFilePackage")) {
                ArchiveFile af;
                theReport = report;
                if (logicalServers.size() == 0) continue;
                LogicalServer cmLogicalServer = (LogicalServer)logicalServers.get(0);
                boolean runningOnWorkSpaceServer = !cmLogicalServer.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c");
                Directory archiveDirectory = null;
                ArchiveFile archiveFile = null;
                String archiveDirectoryName = null;
                String archiveFileName = null;
                if (this._mode == 0) {
                    if (location instanceof ArchiveFile || location instanceof Directory) {
                        ArchiveLocation al;
                        if (location instanceof ArchiveFile) {
                            af = (ArchiveFile)location;
                            al = MetadataManipulator.validateArchiveLocation(af);
                        } else {
                            af = null;
                            Directory d = (Directory)location;
                            al = MetadataManipulator.validateArchiveLocation(d);
                        }
                        if (al != null) {
                            allIsWellWithReport = true;
                            archiveDirectory = al._repository;
                            archiveDirectoryName = archiveDirectory.getDirectoryName();
                            if (af != null) {
                                archiveFile = af;
                                archiveFileName = af.getFileName();
                            }
                        }
                    }
                } else {
                    boolean seenBadArchiveFile = false;
                    if (location instanceof ArchiveFile) {
                        af = (ArchiveFile)location;
                        String fileName = af.getFileName();
                        if (fileName.length() == 0 || af.getIsARelativeName() == 0) {
                            seenBadArchiveFile = true;
                        } else {
                            archiveFile = af;
                            archiveFileName = af.getFileName();
                        }
                    }
                    if (!seenBadArchiveFile && (archiveDirectoryName = (String)this._substitutions.get(StoredProcess.SUBSTITUTION_PROPERTY_ARCHIVE_PATH)) != null && archiveDirectoryName.length() > 0) {
                        allIsWellWithReport = true;
                    }
                }
                if (!allIsWellWithReport) continue;
                packagesSupported = true;
                resultOptionsPG = MetadataManipulatorForUpgrade.createResultOptionsPromptGroup((int)(runningOnWorkSpaceServer ? 1 : 0), (archiveFileName == null ? 1 : 0) != 0, null);
                TextDefinition td = MetadataManipulatorForUpgrade.addPromptFor_Result((PromptGroupInterface)resultOptionsPG, null);
                td.setDefaultValue((Object)(runningOnWorkSpaceServer ? "PACKAGE_TO_REQUESTER" : "PACKAGE_TO_ARCHIVE"));
                td = MetadataManipulatorForUpgrade.addPromptFor_Archive_Path((PromptGroupInterface)resultOptionsPG, null);
                td.setDefaultValue((Object)archiveDirectoryName);
                if (archiveFileName != null) {
                    td = MetadataManipulatorForUpgrade.addPromptFor_Archive_Name((PromptGroupInterface)resultOptionsPG, null);
                    td.setDefaultValue((Object)archiveFileName);
                }
                if (archiveFile == null) break;
                archiveFile.delete();
                break;
            }
            if (reportType.equalsIgnoreCase("SPResultsPermanentWebdavPackage")) {
                String resultURL;
                WebDAVLocation wl;
                theReport = report;
                shouldCreateNewPackageInstancePrompt = this.obtainValueOfNewInstancePropertyAndDeletePropertyObject(theReport);
                if (!(location instanceof Directory)) continue;
                Directory basePathDir = (Directory)location;
                Object object = davDirectory = UtilMetadata.checkPropertyNamePresence((Root)basePathDir, (String)"FileSystemType", (String)"WebDAV", (boolean)true) ? basePathDir : null;
                if (davDirectory != null) {
                    basePathDir = davDirectory.getParent();
                }
                if (basePathDir == null || (wl = MetadataManipulator.validateWebDAVLocation(basePathDir)) == null) break;
                resultOptionsPG = MetadataManipulatorForUpgrade.createResultOptionsPromptGroup((int)2, (boolean)shouldCreateNewPackageInstancePrompt, null);
                TextDefinition td = MetadataManipulatorForUpgrade.addPromptFor_Result((PromptGroupInterface)resultOptionsPG, null);
                td.setDefaultValue((Object)"PACKAGE_TO_WEBDAV");
                Directory basePathDirectory = wl._basePathDirectory;
                ServerComponent DAVServer = wl._serverComponent;
                Iterator itt = DAVServer.getSourceConnections().iterator();
                String serverURL = null;
                while (itt.hasNext()) {
                    Object o = itt.next();
                    if (!(o instanceof TCPIPConnection)) continue;
                    TCPIPConnection con = (TCPIPConnection)o;
                    String host = con.getHostName();
                    int port = con.getPort();
                    String protocol = con.getApplicationProtocol();
                    serverURL = protocol + "://" + host + (port > 0 ? ":" + port : "");
                    break;
                }
                if (serverURL == null) break;
                allIsWellWithReport = true;
                packagesSupported = true;
                String URLOfServerAndBasePath = URLUtil.concat(serverURL, (String)basePathDirectory.getDirectoryName());
                if (davDirectory != null) {
                    resultURL = URLUtil.concat((String)URLOfServerAndBasePath, (String)davDirectory.getDirectoryName());
                    davDirectory.delete();
                } else {
                    resultURL = URLOfServerAndBasePath;
                }
                td = MetadataManipulatorForUpgrade.addPromptFor_Collection_URL((PromptGroupInterface)resultOptionsPG, null);
                td.setDefaultValue((Object)resultURL);
                break;
            }
            if (reportType.equalsIgnoreCase("SPResultsPermanentWebdavPRPackage")) {
                theReport = report;
                shouldCreateNewPackageInstancePrompt = this.obtainValueOfNewInstancePropertyAndDeletePropertyObject(theReport);
                packagesSupported = true;
                allIsWellWithReport = true;
                resultOptionsPG = MetadataManipulatorForUpgrade.createResultOptionsPromptGroup((int)3, (boolean)shouldCreateNewPackageInstancePrompt, null);
                TextDefinition td = MetadataManipulatorForUpgrade.addPromptFor_Result((PromptGroupInterface)resultOptionsPG, null);
                td.setDefaultValue((Object)"PACKAGE_TO_WEBDAV");
                if (location instanceof Directory) {
                    Directory d = (Directory)location;
                    td = MetadataManipulatorForUpgrade.addPromptFor_PR_Collection_Path((PromptGroupInterface)resultOptionsPG, null, (!shouldCreateNewPackageInstancePrompt ? 1 : 0) != 0);
                    td.setDefaultValue((Object)d.getDirectoryName());
                    d.delete();
                }
                MetadataManipulatorForUpgrade.addPromptFor_Publish_To_PR((PromptGroupInterface)resultOptionsPG, null);
                break;
            }
            if (!reportType.equalsIgnoreCase("SPResultsStream")) continue;
            theReport = report;
            if (!(location instanceof Stream)) continue;
            allIsWellWithReport = true;
            location.delete();
            streamingSupported = true;
            break;
        }
        if (theReport != null) {
            if (!allIsWellWithReport) {
                UtilGui.displayError((String)RB.getStringResource("MM.BadReportData.txt"));
                return;
            }
            theReport.delete();
        }
        if (shouldCreateNewPackageInstancePrompt) {
            MetadataManipulatorForUpgrade.addPromptFor_Create_New_Package_Instance(resultOptionsPG, null);
        }
        if (resultOptionsPG != null) {
            this._promptGroup.addPromptSubgroup(resultOptionsPG);
        }
        if (packagesSupported || streamingSupported) {
            this.getStoredProcessXMLElementCreatingItIfItDoesNotExist();
            Element resultCapabilitiesE = this._document.createElement("ResultCapabilities");
            resultCapabilitiesE.setAttribute("Streaming", streamingSupported ? "true" : "false");
            resultCapabilitiesE.setAttribute("Package", packagesSupported ? "true" : "false");
            this._storedProcessE.appendChild(resultCapabilitiesE);
        }
    }

    private void setServerType() throws MdException, RemoteException {
        AssociationList logicalServers = this._classifierMap.getComputeLocations();
        if (logicalServers.size() > 0) {
            LogicalServer cmLogicalServer = (LogicalServer)logicalServers.get(0);
            this._storedProcessServerSelected = cmLogicalServer.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c");
        }
    }

    void readXML() throws MdException, RemoteException {
        String xml;
        if (this._isPreNineThree) {
            this.setServerType();
        }
        for (Object o : this._classifierMap.getNotes()) {
            TextStore ts;
            if (!(o instanceof TextStore) || !(ts = (TextStore)o).getTextRole().equalsIgnoreCase("StoredProcessConfiguration") || !ts.getTextType().equalsIgnoreCase("XML")) continue;
            this._textStore = ts;
            break;
        }
        if (this._textStore != null && (xml = this._textStore.getStoredText()).length() > 0) {
            try {
                this._document = XMLUtil.convertStringToDocument((String)xml);
            }
            catch (Exception e) {
                throw new MdException((Throwable)e);
            }
            NodeList list = this._document.getElementsByTagName("StoredProcess");
            if (list.getLength() > 1) {
                throw new MdException(RB.getStringResource("MM.MultplSPTag.txt"));
            }
            if (list.getLength() == 1) {
                this._storedProcessE = (Element)list.item(0);
            }
        }
        this._hasStreams = false;
        if (this._storedProcessE == null) {
            return;
        }
        NodeList list = this._storedProcessE.getElementsByTagName("Data");
        if (list.getLength() == 0) {
            return;
        }
        if (list.getLength() > 1) {
            throw new MdException(RB.getStringResource("MM.MultplDataTag.txt"));
        }
        Element dataE = (Element)list.item(0);
        list = dataE.getElementsByTagName("Source");
        this.set_hasStreamsIfStreamsDataItemsArePresent(list);
        list = dataE.getElementsByTagName("Target");
        this.set_hasStreamsIfStreamsDataItemsArePresent(list);
    }

    private void set_hasStreamsIfStreamsDataItemsArePresent(NodeList list) throws MdException {
        for (int i = 0; i < list.getLength(); ++i) {
            Element dataItemE = (Element)list.item(i);
            String type = dataItemE.getAttribute("Type");
            if (type.equalsIgnoreCase("GenericStream")) {
                this._hasStreams = true;
                continue;
            }
            if (!type.equalsIgnoreCase("XMLStream")) continue;
            this._hasStreams = true;
        }
    }

    void writeXML() throws RemoteException {
        if (this._textStore != null) {
            this._textStore.setStoredText("");
        }
        if (this._document == null) {
            return;
        }
        if (this._storedProcessE == null) {
            return;
        }
        this._document.normalize();
        this._textStore.setStoredText(XMLUtil.convertNodeToString((Node)this._document));
    }

    Element getStoredProcessXMLElementIfExists() {
        return this._storedProcessE;
    }

    Document getDocumentCreatingItIfItDoesNotExist() throws ParserConfigurationException, MdException, RemoteException {
        if (this._textStore == null) {
            this._textStore = (TextStore)UtilMetadata.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)this._classifierMap, (String)"Stored Process", (String)"TextStore");
            this._textStore.setTextRole("StoredProcessConfiguration");
            this._textStore.setTextType("XML");
            this._classifierMap.getNotes().add((Object)this._textStore);
        }
        if (this._document == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this._document = builder.newDocument();
        }
        return this._document;
    }

    Element getStoredProcessXMLElementCreatingItIfItDoesNotExist() throws ParserConfigurationException, MdException, RemoteException {
        if (this._storedProcessE == null) {
            this.getDocumentCreatingItIfItDoesNotExist();
            this._storedProcessE = this._document.createElement("StoredProcess");
            this._document.appendChild(this._storedProcessE);
        }
        return this._storedProcessE;
    }

    static ArchiveLocation validateArchiveLocation(ArchiveFile af) throws MdException, RemoteException {
        String fileName = af.getFileName();
        if (fileName.length() == 0) {
            return null;
        }
        if (af.getIsARelativeName() == 0) {
            return null;
        }
        Directory repository = null;
        AssociationList vv = af.getDirectories();
        for (int i = 0; i < vv.size(); ++i) {
            Directory d = (Directory)vv.get(i);
            AssociationList vvv = d.getProperties();
            boolean isAFileRepository = false;
            for (int ii = 0; ii < vvv.size(); ++ii) {
                Property p = (Property)vvv.get(ii);
                if (!p.getPropertyRole().equalsIgnoreCase("SPPackageFileRepository")) continue;
                isAFileRepository = true;
                break;
            }
            if (!isAFileRepository) continue;
            if (repository != null) {
                return null;
            }
            repository = d;
        }
        if (repository == null || repository.getDirectoryName().length() == 0) {
            return null;
        }
        return new ArchiveLocation(repository);
    }

    static ArchiveLocation validateArchiveLocation(Directory d) throws MdException, RemoteException {
        boolean isAFileRepository = UtilMetadata.checkPropertyRolePresence((Root)d, (String)"SPPackageFileRepository", null, (boolean)true);
        if (!isAFileRepository) {
            return null;
        }
        return new ArchiveLocation(d);
    }

    static WebDAVLocation validateWebDAVLocation(Directory d) throws MdException, RemoteException {
        if (!UtilMetadata.checkPropertyNamePresence((Root)d, (String)"HttpServerBasePath", (String)"0", (boolean)false)) {
            return null;
        }
        if (!UtilMetadata.checkPropertyNamePresence((Root)d, (String)"SupportsWebDAV", (String)"0", (boolean)false)) {
            return null;
        }
        for (Root root : d.getDeployedComponents()) {
            ServerComponent sc;
            if (!(root instanceof ServerComponent) || !(sc = (ServerComponent)root).getClassIdentifier().equalsIgnoreCase("DAC0D7F0-10DA-11D6-8816-AA0004006D06")) continue;
            return new WebDAVLocation(sc, d);
        }
        return null;
    }

    private boolean obtainValueOfNewInstancePropertyAndDeletePropertyObject(Report report) throws MdException, RemoteException {
        Iterator it = report.getProperties().iterator();
        boolean newInstance = false;
        while (it.hasNext()) {
            Property p = (Property)it.next();
            if (!p.getPropertyName().equals("SPNewInstance")) continue;
            newInstance = !p.getDefaultValue().equals("0");
            p.delete();
            break;
        }
        return newInstance;
    }

    static class ArchiveLocation {
        Directory _repository;

        ArchiveLocation(Directory repository) {
            this._repository = repository;
        }
    }

    static class WebDAVLocation {
        ServerComponent _serverComponent;
        Directory _basePathDirectory;

        WebDAVLocation(ServerComponent serverComponent, Directory basePathDirectory) {
            this._basePathDirectory = basePathDirectory;
            this._serverComponent = serverComponent;
        }
    }
}

