/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.metadata.logical.ObjectContainer;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.server.RepositoryListElement;
import com.sas.metadata.logical.storedprocess.CodeEditorFileSystemDialog;
import com.sas.metadata.logical.storedprocess.CodeEditorMetadataRepositoryDialog;
import com.sas.metadata.logical.storedprocess.ConfigExecutionPanel;
import com.sas.metadata.logical.storedprocess.MetadataManipulator;
import com.sas.metadata.logical.storedprocess.ObjectFactory;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.storedprocess.RepositoryManagerDialog;
import com.sas.metadata.logical.storedprocess.UtilMetadataSP;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.EditableComboBox;
import com.sas.metadata.logical.visuals.ListElementInterface;
import com.sas.metadata.logical.visuals.MetadataDialog;
import com.sas.metadata.logical.visuals.ServerComponentListElement;
import com.sas.metadata.logical.visuals.SmartWsDescriptionWizardTab;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.services.storedprocess.MetadataConstants;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ExecutionTabPanel93
extends SmartWsDescriptionWizardTab {
    private static final int DISABLE_SERVER = 1;
    private static final int DISABLE_SOURCE_CODE_REPOSITORY = 2;
    private static final int DISABLE_SOURCE_FILE = 4;
    private static final int DISABLE_SERVER_TYPE_ANY = 16;
    private static final int DISABLE_SERVER_TYPE_WKS = 32;
    private static final int DISABLE_SERVER_TYPE_SPS = 64;
    private static final int DISABLE_ALLOW_EXECECUTION_ON_OTHER_SERVERS = 128;
    private static final int DISABLE_ALLOW_EXECECUTION_ON_SELECTED_SERVER_ONLY = 256;
    private static final int DISABLE_STORE_SOURCE_CODE_IN_METADATA = 512;
    private static final int DISABLE_STORE_SOURCE_CODE_ON_SERVER = 1024;
    private JLabel _lblServer;
    private DefaultComboBoxModel _serverComboBoxModel;
    private EditableComboBox _comboServer;
    private JLabel _lblServerType;
    private JRadioButton _logicalServerAnyRB;
    private JRadioButton _logicalServerWKSRB;
    private JRadioButton _logicalServerSPSRB;
    private boolean _needToValidateLogicalServerPresent;
    private JLabel _lblSourceCodeAndExecution;
    private JRadioButton _allowOtherServersRB;
    private JRadioButton _selectedServerOnlyRB;
    private JRadioButton _selSrvrInMetaRB;
    private JRadioButton _selSrvrInFileRB;
    private JPanel fileSystemPanel;
    private JLabel _lblRepository;
    private DefaultComboBoxModel _repositoryComboBoxModel;
    private EditableComboBox _comboRepository;
    private JButton _btnManageRepository;
    private int _disableVisual;
    private JLabel _lblFile;
    protected WATextField _txtFile;
    private JButton _btnEditSourceCode;
    private JLabel _lblResults;
    protected JCheckBox _streamCB;
    protected JCheckBox _packageCB;
    protected Config _config;
    private ClassifierMap _classifierMap;
    private ObjectFactoryInterface _objectFactory;
    private ObjectContainer _sourceCodeLocationOC;
    private File _sourceFile;
    private Directory _sourceDirectory;
    private boolean _sourceInFileSystem;
    private TextStore _sourceTextStore;
    private boolean _sourceLocationDetermined;
    private MetadataManipulator _metadataManipulator;
    private String _serverRepositoryID;
    private int _type;
    private ServerContext _displayedServerContext;
    private boolean _packageSupported;
    private boolean _streamSupported;
    private boolean _otherServersAllowed;
    private LOGICAL_SERVER_TYPE _logicalServerType;
    private Element _resultCapabilitiesE;
    private Element _serverContextE;
    private boolean _dataPreviouslyMovedToView;
    private ArrayList<Directory> _sourceRepositories = new ArrayList();
    private ArrayList<ServerComponentListElement> _servers = new ArrayList();
    private ServerComponentListElement _displayedServerContextListElement;

    ExecutionTabPanel93(ClassifierMap classifierMap, ObjectFactoryInterface objectFactory, int type, String serverRepositoryID, ObjectContainer sourceCodeLocationOC, Config config, MetadataManipulator metadataManipulator) {
        String description = (String)config.getInitValue(ConfigExecutionPanel.WIZARD_DESCRIPTION, (Object)RB.getStringResource("NETVC.Wiz.txt"));
        this.setDescription(description);
        this._disableVisual = 0;
        if (!config.isEnabled(ConfigExecutionPanel.SERVER)) {
            this._disableVisual |= 1;
        }
        if (!config.isEnabled(ConfigExecutionPanel.SOURCE_CODE_REPOSITORY)) {
            this._disableVisual |= 2;
        }
        if (!config.isEnabled(ConfigExecutionPanel.SOURCE_FILE)) {
            this._disableVisual |= 4;
        }
        if (!config.isEnabled(ConfigExecutionPanel.SERVER_TYPE_ANY)) {
            this._disableVisual |= 0x10;
        }
        if (!config.isEnabled(ConfigExecutionPanel.SERVER_TYPE_WKS)) {
            this._disableVisual |= 0x20;
        }
        if (!config.isEnabled(ConfigExecutionPanel.SERVER_TYPE_SPS)) {
            this._disableVisual |= 0x40;
        }
        if (!config.isEnabled(ConfigExecutionPanel.ALLOW_EXECECUTION_ON_OTHER_SERVERS)) {
            this._disableVisual |= 0x80;
        }
        if (!config.isEnabled(ConfigExecutionPanel.ALLOW_EXECECUTION_ON_SELECTED_SERVER_ONLY)) {
            this._disableVisual |= 0x100;
        }
        if (!config.isEnabled(ConfigExecutionPanel.STORE_SOURCE_CODE_IN_METADATA)) {
            this._disableVisual |= 0x200;
        }
        if (!config.isEnabled(ConfigExecutionPanel.STORE_SOURCE_CODE_ON_SERVER)) {
            this._disableVisual |= 0x400;
        }
        this.initialize(type);
        this.layoutWidgets();
        this._config = config;
        this._classifierMap = classifierMap;
        this._objectFactory = objectFactory;
        this._sourceCodeLocationOC = sourceCodeLocationOC;
        this._type = type;
        this._serverRepositoryID = serverRepositoryID;
        this._metadataManipulator = metadataManipulator;
    }

    protected void initialize(int type) {
        this.setName(RB.getStringResource("NETVC.Tab.txt"));
        if (type == 1) {
            this.setHelpProduct("storedprocess");
            this.setHelpTopic("stp_executiontab2");
        } else {
            this.setHelpProduct("newstp");
            this.setHelpTopic("executionwin2");
        }
        this._serverComboBoxModel = new DefaultComboBoxModel();
        this._comboServer = new EditableComboBox(this._serverComboBoxModel, false){

            protected void doListItemSelected(ListElementInterface le) {
                try {
                    ExecutionTabPanel93.this.doServerSelected(le, (Component)((Object)this));
                }
                catch (RemoteException e) {
                    UtilGui.displayRemoteException((RemoteException)e);
                }
            }
        };
        this._lblServer = UtilGui.createLabelForComponent((Component)this._comboServer, (String)RB.getStringResource("ETP93.Lbl.AppSrvr.txt"));
        if ((this._disableVisual & 1) != 0) {
            this._comboServer.setEnabled(false);
        }
        this._comboServer.setToolTipText(RB.getStringResource("NETVC.Tooltip.Srvr.txt"));
        this._lblServerType = new JLabel(RB.getStringResource("ETP93.Lbl.SrvrType.txt"));
        this._logicalServerAnyRB = UtilGui.createRadioButton((String)RB.getStringResource("ETP93.Lbl.Any.txt"));
        this._logicalServerWKSRB = UtilGui.createRadioButton((String)RB.getStringResource("ETP93.Lbl.WKSOnly.txt"));
        this._logicalServerSPSRB = UtilGui.createRadioButton((String)RB.getStringResource("ETP93.Lbl.SPSOnly.txt"));
        this._logicalServerAnyRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecutionTabPanel93.this._needToValidateLogicalServerPresent = false;
                ExecutionTabPanel93.this._logicalServerType = LOGICAL_SERVER_TYPE.ANY;
            }
        });
        this._logicalServerWKSRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecutionTabPanel93.this._needToValidateLogicalServerPresent = true;
                ExecutionTabPanel93.this._logicalServerType = LOGICAL_SERVER_TYPE.WKS;
            }
        });
        this._logicalServerSPSRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecutionTabPanel93.this._needToValidateLogicalServerPresent = true;
                ExecutionTabPanel93.this._logicalServerType = LOGICAL_SERVER_TYPE.SPS;
            }
        });
        ButtonGroup lstBG = new ButtonGroup();
        lstBG.add(this._logicalServerAnyRB);
        lstBG.add(this._logicalServerWKSRB);
        lstBG.add(this._logicalServerSPSRB);
        if ((this._disableVisual & 0x10) != 0) {
            this._logicalServerAnyRB.setEnabled(false);
        }
        if ((this._disableVisual & 0x20) != 0) {
            this._logicalServerWKSRB.setEnabled(false);
        }
        if ((this._disableVisual & 0x40) != 0) {
            this._logicalServerSPSRB.setEnabled(false);
        }
        this._lblSourceCodeAndExecution = new JLabel(RB.getStringResource("ETP93.Lbl.SrcCdeExec.txt"));
        this._allowOtherServersRB = UtilGui.createRadioButton((String)RB.getStringResource("ETP93.Lbl.OtherSrvrs.txt"));
        this._selectedServerOnlyRB = UtilGui.createRadioButton((String)RB.getStringResource("ETP93.Lbl.SelectedOnly.txt"));
        this._allowOtherServersRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecutionTabPanel93.this._otherServersAllowed = true;
                ExecutionTabPanel93.this.enableSelectedServerPanel(false);
                ExecutionTabPanel93.this._sourceInFileSystem = false;
                ExecutionTabPanel93.this.enableEditSourceCodeButton();
            }
        });
        this._selectedServerOnlyRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecutionTabPanel93.this._otherServersAllowed = false;
                ExecutionTabPanel93.this.enableSelectedServerPanel(true);
                ExecutionTabPanel93.this._sourceInFileSystem = ExecutionTabPanel93.this._selSrvrInFileRB.isSelected();
                ExecutionTabPanel93.this.enableEditSourceCodeButton();
            }
        });
        ButtonGroup scBG = new ButtonGroup();
        scBG.add(this._allowOtherServersRB);
        scBG.add(this._selectedServerOnlyRB);
        if ((this._disableVisual & 0x80) != 0) {
            this._allowOtherServersRB.setEnabled(false);
        }
        if ((this._disableVisual & 0x100) != 0) {
            this._selectedServerOnlyRB.setEnabled(false);
        }
        this._selSrvrInMetaRB = UtilGui.createRadioButton((String)RB.getStringResource("ETP93.Lbl.CodeInMeta.txt"));
        this._selSrvrInFileRB = UtilGui.createRadioButton((String)RB.getStringResource("ETP93.Lbl.CodeOnSrvr.txt"));
        this._selSrvrInMetaRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecutionTabPanel93.this.enableFileSystemPanel(false);
                ExecutionTabPanel93.this._sourceInFileSystem = false;
                ExecutionTabPanel93.this.enableEditSourceCodeButton();
            }
        });
        this._selSrvrInFileRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecutionTabPanel93.this.enableFileSystemPanel(ExecutionTabPanel93.this._displayedServerContext != null);
                ExecutionTabPanel93.this._sourceInFileSystem = true;
                ExecutionTabPanel93.this.enableEditSourceCodeButton();
            }
        });
        ButtonGroup ssBG = new ButtonGroup();
        ssBG.add(this._selSrvrInMetaRB);
        ssBG.add(this._selSrvrInFileRB);
        if ((this._disableVisual & 0x200) != 0) {
            this._selSrvrInMetaRB.setEnabled(false);
        }
        if ((this._disableVisual & 0x400) != 0) {
            this._selSrvrInFileRB.setEnabled(false);
        }
        this._repositoryComboBoxModel = new DefaultComboBoxModel();
        this._comboRepository = new EditableComboBox(this._repositoryComboBoxModel, false){

            protected void doListItemSelected(ListElementInterface le) {
                ExecutionTabPanel93.this.enableEditSourceCodeButton();
            }
        };
        this._comboRepository.setListener(true);
        this._comboRepository.setToolTipText(RB.getStringResource("NETVC.Tooltip.Repo.txt"));
        this._lblRepository = UtilGui.createLabelForComponent((Component)this._comboRepository, (String)RB.getStringResource("NETVC.Lbl.Repo.txt"));
        this._btnManageRepository = UtilGui.createButton((String)RB.getStringResource("COM.Btn.Manage0.txt"));
        this._btnManageRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    ExecutionTabPanel93.this.doManageRepository();
                }
                catch (RemoteException e) {
                    UtilGui.displayRemoteException((RemoteException)e);
                }
            }
        });
        this._txtFile = new WATextField();
        this._txtFile.setMaxCharacters(256);
        this._txtFile.setToolTipText(RB.getStringResource("NETVC.Tooltip.FilNm.txt"));
        this._lblFile = UtilGui.createLabelForComponent((Component)this._txtFile, (String)RB.getStringResource("NETVC.Lbl.FilNm.txt"));
        this._btnEditSourceCode = UtilGui.createButton((String)RB.getStringResource("ETP93.Lbl.EditSrcCode.txt"));
        this._btnEditSourceCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExecutionTabPanel93.this.doEditFile();
            }
        });
        if ((this._disableVisual & 2) != 0) {
            this._btnManageRepository.setEnabled(false);
            this._comboRepository.setEnabled(false);
        }
        if ((this._disableVisual & 4) != 0) {
            this._txtFile.setEnabled(false);
        }
        this._lblResults = new JLabel(RB.getStringResource("ETP93.Lbl.ResCap.txt"));
        this._streamCB = UtilGui.createCheckBox((String)RB.getStringResource("NETVC.Lbl.ResStrm.txt"));
        this._packageCB = UtilGui.createCheckBox((String)RB.getStringResource("NETVC.Lbl.ResPkg.txt"));
    }

    private void enableEditSourceCodeButton() {
        boolean enable = false;
        if (this._otherServersAllowed) {
            enable = true;
        } else if (this._selSrvrInFileRB.isSelected()) {
            RepositoryListElement re;
            if (this._displayedServerContext != null && (re = (RepositoryListElement)this._repositoryComboBoxModel.getSelectedItem()) != null) {
                enable = re.isReal();
            }
        } else if (this._selSrvrInMetaRB.isSelected()) {
            enable = true;
        }
        this._btnEditSourceCode.setEnabled(enable);
    }

    private void enableFileSystemPanel(boolean enable) {
        this._comboRepository.setEnabled(enable);
        this._lblRepository.setEnabled(enable);
        this._btnManageRepository.setEnabled(enable);
        this._txtFile.setEnabled(enable);
        this._lblFile.setEnabled(enable);
    }

    private void enableSelectedServerPanel(boolean enable) {
        this._selSrvrInFileRB.setEnabled(enable && (this._disableVisual & 0x400) == 0);
        this._selSrvrInMetaRB.setEnabled(enable && (this._disableVisual & 0x200) == 0);
        this.enableFileSystemPanel(enable && this._displayedServerContext != null && this._selSrvrInFileRB.isSelected());
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this._comboServer.setEnabled(editable && (this._disableVisual & 1) == 0);
        this._logicalServerAnyRB.setEnabled(editable && (this._disableVisual & 0x10) == 0);
        this._logicalServerWKSRB.setEnabled(editable && (this._disableVisual & 0x20) == 0);
        this._logicalServerSPSRB.setEnabled(editable && (this._disableVisual & 0x40) == 0);
        this._allowOtherServersRB.setEnabled(editable && (this._disableVisual & 0x80) == 0);
        this._selectedServerOnlyRB.setEnabled(editable && (this._disableVisual & 0x100) == 0);
        this._selSrvrInMetaRB.setEnabled(editable && (this._disableVisual & 0x200) == 0);
        this._selSrvrInFileRB.setEnabled(editable && (this._disableVisual & 0x400) == 0);
        this._txtFile.setEnabled(editable && (this._disableVisual & 4) == 0);
        this._btnManageRepository.setEnabled(editable && (this._disableVisual & 2) == 0);
        this._comboRepository.setEnabled(editable && (this._disableVisual & 2) == 0);
        Util.configureMnemonicForButton((AbstractButton)this._btnEditSourceCode, (String)RB.getStringResource(editable ? "ETP93.Lbl.EditSrcCode.txt" : "ETP93.Lbl.ViewSrcCode.txt"));
        this._streamCB.setEnabled(editable);
        this._packageCB.setEnabled(editable);
    }

    private void setServerListener(boolean on) {
        this._comboServer.setListener(on);
    }

    private void setRepositoryListener(boolean on) {
        this._comboRepository.setListener(on);
    }

    private void enableManageRepository(boolean on) {
        if ((this._disableVisual & 2) == 0) {
            this._btnManageRepository.setEnabled(on);
        }
    }

    protected void layoutWidgets() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 1, 5, 5, true, true, true);
        this.setLayout((LayoutManager)layout);
        this.add(this._lblServer);
        this.add((Component)this._comboServer);
        this.add(this._lblServerType);
        Insets inSrvrTyp1 = new Insets(0, 0, 10, 0);
        this._logicalServerWKSRB.setMargin(inSrvrTyp1);
        this.add(this._logicalServerAnyRB);
        this.add(this._logicalServerSPSRB);
        this.add(this._logicalServerWKSRB);
        this.add(new JSeparator());
        this._lblSourceCodeAndExecution.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.add(this._lblSourceCodeAndExecution);
        Insets inCtxt0 = new Insets(5, 0, 0, 0);
        this._allowOtherServersRB.setMargin(inCtxt0);
        this.add(this._allowOtherServersRB);
        Insets inCtxt1 = new Insets(0, 0, 0, 0);
        this._selectedServerOnlyRB.setMargin(inCtxt1);
        this.add(this._selectedServerOnlyRB);
        Insets inCtxt2 = new Insets(0, 20, 0, 0);
        this._selSrvrInMetaRB.setMargin(inCtxt2);
        this._selSrvrInFileRB.setMargin(inCtxt2);
        this.add(this._selSrvrInMetaRB);
        this.add(this._selSrvrInFileRB);
        this.fileSystemPanel = new JPanel();
        this.fileSystemPanel.setBorder(BorderFactory.createEmptyBorder(0, 40, 0, 0));
        AutoSizingGridLayout fileSystemPanelLayout = new AutoSizingGridLayout(2, 3, 5, 5, true, false, true);
        this.fileSystemPanel.setLayout((LayoutManager)fileSystemPanelLayout);
        fileSystemPanelLayout.setRemainderColumn(2);
        this.fileSystemPanel.add(this._lblRepository);
        this.fileSystemPanel.add((Component)this._comboRepository);
        this.fileSystemPanel.add(this._btnManageRepository);
        this.fileSystemPanel.add(this._lblFile);
        this.fileSystemPanel.add((Component)this._txtFile);
        this.add(this.fileSystemPanel);
        JPanel editSourceButtonPanel = new JPanel();
        editSourceButtonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        AutoSizingGridLayout buttonPanelLayout = new AutoSizingGridLayout(1, 2, 0, 5, true, false, false);
        editSourceButtonPanel.setLayout((LayoutManager)buttonPanelLayout);
        editSourceButtonPanel.add(this._btnEditSourceCode);
        this.add(editSourceButtonPanel);
        this.add(new JSeparator());
        JPanel resultsPanel = new JPanel();
        resultsPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        AutoSizingGridLayout resultsPanelLayout = new AutoSizingGridLayout(1, 3, 0, 5, true, false, true);
        resultsPanel.setLayout((LayoutManager)resultsPanelLayout);
        resultsPanel.add(this._lblResults);
        resultsPanel.add(this._streamCB);
        resultsPanel.add(this._packageCB);
        this.add(resultsPanel);
        JPanel eaterPanel = new JPanel();
        this.add(eaterPanel);
    }

    protected void smartPopulateStore() throws MdException, RemoteException {
        this.determineAvailbleServers();
        UtilMetadataSP.determineAllRepositoryContextsForServerContext(null, this._displayedServerContext, this._sourceRepositories);
        if (this._type == 1) {
            this.determineSourceLocationForThisStoredProcess();
            this.determineResultCapabilitiesOfThisStoredProcess();
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (!this._dataPreviouslyMovedToView) {
            this.setServersInVisual();
            this.setAllRepositoryContextsBasedOnDisplayedServer();
            if (this._type == 1) {
                if (this._displayedServerContext != null) {
                    this.setSourceLocationForThisStoredProcess();
                    this.setResultCapabilitiesForThisStoredProcess();
                }
            } else {
                String sourceFile;
                this._selSrvrInFileRB.doClick();
                String sourceCodeRepository = (String)this._config.getInitValue(ConfigExecutionPanel.SOURCE_CODE_REPOSITORY, null);
                if (sourceCodeRepository != null) {
                    int size = this._repositoryComboBoxModel.getSize();
                    for (int i = 0; i < size; ++i) {
                        RepositoryListElement re = (RepositoryListElement)this._repositoryComboBoxModel.getElementAt(i);
                        if (!re.isReal() || !re.getDirectory().getDirectoryName().equals(sourceCodeRepository)) continue;
                        this._repositoryComboBoxModel.setSelectedItem(re);
                        break;
                    }
                }
                if ((sourceFile = (String)this._config.getInitValue(ConfigExecutionPanel.SOURCE_FILE, null)) != null) {
                    this._txtFile.setText(sourceFile);
                }
            }
            boolean editable = this.isEditable();
            switch (this._logicalServerType.ordinal()) {
                case 0: {
                    if (editable) {
                        this._logicalServerAnyRB.doClick();
                        break;
                    }
                    this._logicalServerAnyRB.setSelected(true);
                    break;
                }
                case 2: {
                    if (editable) {
                        this._logicalServerSPSRB.doClick();
                        break;
                    }
                    this._logicalServerSPSRB.setSelected(true);
                    break;
                }
                case 1: {
                    if (editable) {
                        this._logicalServerWKSRB.doClick();
                        break;
                    }
                    this._logicalServerWKSRB.setSelected(true);
                }
            }
            if (this._otherServersAllowed) {
                if (editable) {
                    this._allowOtherServersRB.doClick();
                } else {
                    this._allowOtherServersRB.setSelected(true);
                }
            } else if (editable) {
                this._selectedServerOnlyRB.doClick();
            } else {
                this._selectedServerOnlyRB.setSelected(true);
            }
            this._dataPreviouslyMovedToView = true;
        }
    }

    protected boolean dataValidate() {
        ServerComponentListElement sle = (ServerComponentListElement)this._serverComboBoxModel.getSelectedItem();
        if (sle == null || !sle.isRealServer()) {
            MessageUtil.displayMessage((String)RB.getStringResource("ETP.NoSrvr.txt"), (String)RB.getStringResource("ETP.NoSrvr.title.txt"), (int)0);
            this._comboServer.requestFocus();
            return false;
        }
        if (this._sourceInFileSystem) {
            RepositoryListElement re = (RepositoryListElement)this._repositoryComboBoxModel.getSelectedItem();
            if (!re.isReal()) {
                MessageUtil.displayMessage((String)RB.getStringResource("ETP.NoSoRepo.txt"), (String)RB.getStringResource("ETP.RepoErr.title.txt"), (int)0);
                this._comboRepository.requestFocus();
                return false;
            }
            String newFileName = this._txtFile.getText().trim();
            if (newFileName.length() == 0) {
                MessageUtil.displayMessage((String)RB.getStringResource("ETP.NoName.txt"), (String)RB.getStringResource("ETP.NoName.title.txt"), (int)0);
                this._txtFile.requestFocus();
                return false;
            }
        } else {
            boolean sourceMissingWarningNeeded = false;
            try {
                if (this._sourceTextStore == null || this._sourceTextStore.getStoredText().length() == 0) {
                    sourceMissingWarningNeeded = true;
                }
            }
            catch (RemoteException e) {
                UtilGui.displayRemoteException((RemoteException)e);
                return false;
            }
            if (sourceMissingWarningNeeded) {
                MessageUtil.displayMessage((String)Message.format((String)RB.getStringResource("ETP93.needSrcCode.fmt.txt"), (Object)Util.getLabelWithoutMnemonic((String)RB.getStringResource("ETP93.Lbl.EditSrcCode.txt"))), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
                this._btnEditSourceCode.requestFocus();
                return false;
            }
        }
        if (this._needToValidateLogicalServerPresent) {
            ServerContext sc = (ServerContext)sle.getServerComponent();
            try {
                if (MetadataConstants.getLogicalServerFromServerContext((this._logicalServerType == LOGICAL_SERVER_TYPE.WKS ? 1 : 0) != 0, (ServerContext)sc) == null) {
                    UtilGui.displayError((String)RB.getStringResource("ETP93.LogServTypeNotAvail.txt"));
                    return false;
                }
            }
            catch (RemoteException e) {
                UtilGui.displayRemoteException((RemoteException)e);
                return false;
            }
            catch (MdException e) {
                UtilGui.displayMdException((MdException)e);
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void determineAvailbleServers() throws MdException, RemoteException {
        int findFlag;
        Set filters;
        String serverNameOfDesiredServer = null;
        if (this._type == 1) {
            Element spE = this._metadataManipulator.getStoredProcessXMLElementIfExists();
            if (spE == null) {
                throw new MdException(RB.getStringResource("ETP93.noXML.txt"));
            }
            NodeList list = spE.getElementsByTagName("ServerContext");
            if (list.getLength() == 0) {
                throw new MdException(RB.getStringResource("ETP93.NoASTag.txt"));
            }
            if (list.getLength() > 1) {
                throw new MdException(RB.getStringResource("ETP93.MultplASTag.txt"));
            }
            this._serverContextE = (Element)list.item(0);
            String value = this._serverContextE.getAttribute("OtherAllowed");
            if (value == null) {
                throw new MdException(RB.getStringResource("ETP93.noASC.txt"));
            }
            this._otherServersAllowed = value.equalsIgnoreCase("true");
            value = this._serverContextE.getAttribute("LogicalServerType");
            if (value == null) {
                throw new MdException(RB.getStringResource("ETP93.noLST.txt"));
            }
            if (value.equalsIgnoreCase("Any")) {
                this._logicalServerType = LOGICAL_SERVER_TYPE.ANY;
            } else if (value.equalsIgnoreCase("Wks")) {
                this._logicalServerType = LOGICAL_SERVER_TYPE.WKS;
            } else {
                if (!value.equalsIgnoreCase("Sps")) throw new MdException(Message.format((String)RB.getStringResource("ETP93.InvldLSTVal.fmt.txt"), (Object)value));
                this._logicalServerType = LOGICAL_SERVER_TYPE.SPS;
            }
        } else {
            this._otherServersAllowed = false;
            this._logicalServerType = LOGICAL_SERVER_TYPE.ANY;
            serverNameOfDesiredServer = (String)this._config.getInitValue(ConfigExecutionPanel.SERVER, null);
        }
        this._displayedServerContext = null;
        this._displayedServerContextListElement = null;
        this._servers.clear();
        AssociationList serverContexts = this._classifierMap.getComputeLocations();
        ServerContext cmServerContext = null;
        if (serverContexts.size() > 0) {
            this._displayedServerContext = cmServerContext = (ServerContext)serverContexts.get(0);
            this._displayedServerContextListElement = new ServerComponentListElement((ServerComponent)cmServerContext);
            this._servers.add(this._displayedServerContextListElement);
        }
        if ((filters = this._config.getFilter(ConfigExecutionPanel.SERVER)) != null) {
            findFlag = 0;
            for (Config.Filter filter : filters) {
                if (filter == ConfigExecutionPanel.STORED_PROCESS_SERVERS) {
                    findFlag |= 2;
                    continue;
                }
                if (filter != ConfigExecutionPanel.WORKSPACE_SERVERS) continue;
                findFlag |= 1;
            }
        } else {
            findFlag = 3;
        }
        List<ServerContext> servers = UtilMetadataSP.findServerContextsWithStoredProcessAndOrWorkspaceServers(this._classifierMap.getObjectStore(), this._serverRepositoryID, findFlag);
        for (ServerContext sc : servers) {
            if (cmServerContext != null && cmServerContext.getFQID().equals(sc.getFQID())) continue;
            ServerComponentListElement scle = new ServerComponentListElement((ServerComponent)sc);
            this._servers.add(scle);
            if (serverNameOfDesiredServer == null || !serverNameOfDesiredServer.equals(sc.getName())) continue;
            this._displayedServerContext = sc;
            this._displayedServerContextListElement = scle;
        }
    }

    private void setServersInVisual() throws MdException {
        this.setServerListener(false);
        this._serverComboBoxModel.removeAllElements();
        if (this._displayedServerContext == null) {
            this._displayedServerContextListElement = ServerComponentListElement.SELECT_A_SERVER;
            this._serverComboBoxModel.addElement(this._displayedServerContextListElement);
        }
        for (ServerComponentListElement scle : this._servers) {
            this._serverComboBoxModel.addElement(scle);
        }
        if (this._displayedServerContextListElement != null) {
            this._serverComboBoxModel.setSelectedItem(this._displayedServerContextListElement);
        }
        this.setServerListener(true);
    }

    private void setAllRepositoryContextsBasedOnDisplayedServer() {
        this.setRepositoryListener(false);
        this._repositoryComboBoxModel.removeAllElements();
        if (this._displayedServerContextListElement == null || !this._displayedServerContextListElement.isRealServer()) {
            return;
        }
        Iterator<Directory> it = this._sourceRepositories.iterator();
        this._repositoryComboBoxModel.addElement(RepositoryListElement.SELECT_A_REPOSITORY);
        while (it.hasNext()) {
            this._repositoryComboBoxModel.addElement(new RepositoryListElement(it.next()));
        }
        this.setRepositoryListener(true);
    }

    private void determineSourceLocationForThisStoredProcess() throws MdException, RemoteException {
        this._sourceLocationDetermined = false;
        UtilMetadataSP.DirectoryAndFile df = UtilMetadataSP.determineDirectoryAndFile(this._classifierMap);
        if (df._file != null) {
            if (this._displayedServerContext == null) {
                df._file.delete();
                return;
            }
            this._sourceFile = df._file;
            this._sourceDirectory = df._directory;
            this._sourceInFileSystem = true;
            this._sourceLocationDetermined = true;
        } else {
            for (Object obj : this._classifierMap.getNotes()) {
                TextStore ts;
                if (!(obj instanceof TextStore) || !(ts = (TextStore)obj).getName().equalsIgnoreCase("SourceCode") || !ts.getTextRole().equalsIgnoreCase("StoredProcessSourceCode")) continue;
                this._sourceTextStore = ts;
                this._sourceInFileSystem = false;
                this._sourceLocationDetermined = true;
                break;
            }
        }
    }

    private void setSourceLocationForThisStoredProcess() throws MdException, RemoteException {
        if (this._sourceLocationDetermined) {
            boolean editable = this.isEditable();
            if (this._sourceInFileSystem) {
                if (this._otherServersAllowed) {
                    MessageUtil.displayMessage((String)RB.getStringResource("ETP93.OtherSrvsAndSrcInFS.txt"), (String)RB.getStringResource("ETP.MetaErr.title.txt"), (int)0);
                    this._otherServersAllowed = false;
                }
                if (editable) {
                    this._selSrvrInFileRB.doClick();
                } else {
                    this._selSrvrInFileRB.setSelected(true);
                }
                this._txtFile.setText(this._sourceFile.getFileName());
                if (this._sourceDirectory == null) {
                    MessageUtil.displayMessage((String)RB.getStringResource("ETP.BadRepo.txt"), (String)RB.getStringResource("ETP.RepoErr.title.txt"), (int)0);
                } else {
                    this.setDirectoryAsSelectedAddingToModelIfNeeded(this._sourceDirectory, this._repositoryComboBoxModel);
                }
            } else if (!this._otherServersAllowed) {
                if (editable) {
                    this._selSrvrInMetaRB.doClick();
                } else {
                    this._selSrvrInMetaRB.setSelected(true);
                }
            }
        } else {
            MessageUtil.displayMessage((String)RB.getStringResource("ETP93.CantDetermnSrc.txt"), (String)RB.getStringResource("ETP.MetaErr.title.txt"), (int)0);
        }
    }

    private RepositoryListElement setDirectoryAsSelected(String directory, DefaultComboBoxModel model) throws RemoteException {
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            RepositoryListElement re = (RepositoryListElement)model.getElementAt(i);
            if (!re.isReal() || !re.getDirectory().getDirectoryName().equals(directory)) continue;
            model.setSelectedItem(re);
            return re;
        }
        return null;
    }

    private RepositoryListElement setDirectoryAsSelectedAddingToModelIfNeeded(Directory directory, DefaultComboBoxModel model) {
        RepositoryListElement selected = null;
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            RepositoryListElement re = (RepositoryListElement)model.getElementAt(i);
            if (!re.isReal() || re.getDirectory() != directory) continue;
            selected = re;
            break;
        }
        if (selected == null) {
            selected = new RepositoryListElement(directory);
            model.addElement(selected);
        }
        model.setSelectedItem(selected);
        return selected;
    }

    private void determineResultCapabilitiesOfThisStoredProcess() throws MdException {
        this._packageSupported = false;
        this._streamSupported = false;
        Element spE = this._metadataManipulator.getStoredProcessXMLElementIfExists();
        if (spE == null) {
            return;
        }
        NodeList list = spE.getElementsByTagName("ResultCapabilities");
        if (list.getLength() == 0) {
            return;
        }
        if (list.getLength() > 1) {
            throw new MdException(RB.getStringResource("NETP.MultplRCTag.txt"));
        }
        this._resultCapabilitiesE = (Element)list.item(0);
        String value = this._resultCapabilitiesE.getAttribute("Package");
        if (value != null && value.equalsIgnoreCase("true")) {
            this._packageSupported = true;
        }
        if ((value = this._resultCapabilitiesE.getAttribute("Streaming")) != null && value.equalsIgnoreCase("true")) {
            this._streamSupported = true;
        }
    }

    private void setResultCapabilitiesForThisStoredProcess() {
        this._packageCB.setSelected(this._packageSupported);
        this._streamCB.setSelected(this._streamSupported);
    }

    private void doServerSelected(ListElementInterface lei, Component c) throws RemoteException {
        ServerComponentListElement le = (ServerComponentListElement)lei;
        ServerContext selectedSC = (ServerContext)le.getServerComponent();
        if (this._displayedServerContext == selectedSC) {
            return;
        }
        this._displayedServerContextListElement = le;
        this._displayedServerContext = selectedSC;
        if (this._sourceInFileSystem) {
            this.enableFileSystemPanel(this._displayedServerContext != null);
            this.enableEditSourceCodeButton();
        }
        Component parent = SwingUtilities.getRoot(c);
        try {
            UtilMetadataSP.determineAllRepositoryContextsForServerContext(parent, this._displayedServerContext, this._sourceRepositories);
            this.setAllRepositoryContextsBasedOnDisplayedServer();
        }
        catch (MdException e) {
            UtilGui.displayMdException((MdException)e);
            this.setOtherMetaDataException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doEditFile() {
        block27: {
            if (this._sourceInFileSystem) {
                RepositoryListElement re = (RepositoryListElement)this._repositoryComboBoxModel.getSelectedItem();
                if (!re.isReal()) {
                    MessageUtil.displayMessage((String)RB.getStringResource("ETP.NoSoRepo.txt"), (String)RB.getStringResource("ETP.RepoErr.title.txt"), (int)0);
                    this._comboRepository.requestFocus();
                    return;
                }
                String sourceFileName = this._txtFile.getText().trim();
                if (sourceFileName.length() == 0) {
                    MessageUtil.displayMessage((String)RB.getStringResource("ETP.NoName.txt"), (String)RB.getStringResource("ETP.NoName.title.txt"), (int)0);
                    this._txtFile.requestFocus();
                    return;
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    CodeEditorFileSystemDialog dlg = CodeEditorFileSystemDialog.createInstance((JComponent)((Object)this));
                    try {
                        if (!dlg.initialize(re.getDirectory(), sourceFileName, this.isEditable())) {
                            return;
                        }
                    }
                    catch (RemoteException e) {
                        UtilGui.displayRemoteException((RemoteException)e);
                        return;
                    }
                    catch (MdException e) {
                        UtilGui.displayMdException((MdException)e);
                        this.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    dlg.setModal(true);
                    dlg.setVisible(true);
                    break block27;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            try {
                if (this._sourceTextStore == null) {
                    this._sourceTextStore = (TextStore)UtilMetadata.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)this._classifierMap, (String)"SourceCode", (String)"TextStore");
                    this._sourceTextStore.setTextRole("StoredProcessSourceCode");
                    this._classifierMap.getNotes().add((Object)this._sourceTextStore);
                }
            }
            catch (RemoteException e) {
                UtilGui.displayRemoteException((RemoteException)e);
                return;
            }
            catch (MdException e) {
                UtilGui.displayMdException((MdException)e);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                CodeEditorMetadataRepositoryDialog dlg = CodeEditorMetadataRepositoryDialog.createInstance((JComponent)((Object)this));
                try {
                    if (!dlg.initialize(this._sourceTextStore, this.isEditable())) {
                        return;
                    }
                }
                catch (RemoteException e) {
                    UtilGui.displayRemoteException((RemoteException)e);
                    return;
                }
                catch (MdException e) {
                    UtilGui.displayMdException((MdException)e);
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                dlg.setModal(true);
                dlg.setVisible(true);
                break block27;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    protected void doManageRepository() throws RemoteException {
        try {
            MetadataDialog dialog;
            int retVal;
            ObjectContainer objectContainer = new ObjectContainer();
            RepositoryListElement re = (RepositoryListElement)this._repositoryComboBoxModel.getSelectedItem();
            if (re != null && re.isReal()) {
                objectContainer.setObject((Object)re.getDirectory());
            }
            if ((retVal = (dialog = RepositoryManagerDialog.createInstance((JComponent)((Object)this), this._displayedServerContext, this._repositoryComboBoxModel, objectContainer, this._objectFactory.getFactory())).doModal()) == 1) {
                Directory dirToUse = (Directory)objectContainer.getObject();
                if (dirToUse == null && re != null) {
                    dirToUse = re.getDirectory();
                }
                UtilMetadataSP.determineAllRepositoryContextsForServerContext((Component)((Object)this), this._displayedServerContext, this._sourceRepositories);
                this.setAllRepositoryContextsBasedOnDisplayedServer();
                if (dirToUse != null) {
                    this.setDirectoryAsSelected(dirToUse.getDirectoryName(), this._repositoryComboBoxModel);
                }
            }
        }
        catch (MdException e) {
            UtilGui.displayMdException((MdException)e);
            this.setOtherMetaDataException();
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        Element spE;
        Document document;
        ServerComponentListElement sle = (ServerComponentListElement)this._serverComboBoxModel.getSelectedItem();
        AssociationList al = this._classifierMap.getComputeLocations();
        al.removeAllElements();
        al.add((Object)sle.getServerComponent());
        if (this._serverContextE == null) {
            try {
                document = this._metadataManipulator.getDocumentCreatingItIfItDoesNotExist();
                spE = this._metadataManipulator.getStoredProcessXMLElementCreatingItIfItDoesNotExist();
                this._serverContextE = document.createElement("ServerContext");
                spE.appendChild(this._serverContextE);
            }
            catch (ParserConfigurationException e) {
                throw new MdException((Throwable)e);
            }
        }
        this._serverContextE.setAttribute("OtherAllowed", this._otherServersAllowed ? "true" : "false");
        switch (this._logicalServerType.ordinal()) {
            case 0: {
                this._serverContextE.setAttribute("LogicalServerType", "Any");
                break;
            }
            case 2: {
                this._serverContextE.setAttribute("LogicalServerType", "Sps");
                break;
            }
            case 1: {
                this._serverContextE.setAttribute("LogicalServerType", "Wks");
            }
        }
        if (this._sourceInFileSystem) {
            if (this._sourceFile == null) {
                this._sourceFile = (File)UtilMetadata.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)this._classifierMap, (String)"SP Source File", (String)"File");
                this._classifierMap.setSourceCode((Text)this._sourceFile);
            }
            this._sourceFile.setFileName(this._txtFile.getText().trim());
            this._sourceFile.setIsARelativeName(1);
            RepositoryListElement re = (RepositoryListElement)this._repositoryComboBoxModel.getSelectedItem();
            al = this._sourceFile.getDirectories();
            al.removeAllElements();
            al.add((Object)re.getDirectory());
            if (this._sourceCodeLocationOC != null) {
                this._sourceCodeLocationOC.setObject((Object)new ObjectFactory.SourceLocation(this._classifierMap, (ServerContext)sle.getServerComponent(), re.getDirectory(), this._sourceFile, false));
            }
            if (this._sourceTextStore != null) {
                this._sourceTextStore.delete();
                this._sourceTextStore = null;
            }
        } else {
            if (this._sourceCodeLocationOC != null) {
                this._sourceCodeLocationOC.setObject((Object)new ObjectFactory.SourceLocation(this._classifierMap, (ServerContext)sle.getServerComponent(), null, null, true));
            }
            if (this._sourceTextStore == null) {
                this._sourceTextStore = (TextStore)UtilMetadata.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)this._classifierMap, (String)"SourceCode", (String)"TextStore");
                this._sourceTextStore.setTextRole("StoredProcessSourceCode");
                this._classifierMap.getNotes().add((Object)this._sourceTextStore);
            }
            if (this._sourceFile != null) {
                this._sourceFile.delete();
                this._sourceFile = null;
            }
        }
        if (this._resultCapabilitiesE == null) {
            try {
                document = this._metadataManipulator.getDocumentCreatingItIfItDoesNotExist();
                spE = this._metadataManipulator.getStoredProcessXMLElementCreatingItIfItDoesNotExist();
                this._resultCapabilitiesE = document.createElement("ResultCapabilities");
                spE.appendChild(this._resultCapabilitiesE);
            }
            catch (ParserConfigurationException e) {
                throw new MdException((Throwable)e);
            }
        }
        this._packageSupported = this._packageCB.isSelected();
        this._streamSupported = this._streamCB.isSelected();
        this._resultCapabilitiesE.setAttribute("Package", this._packageSupported ? "true" : "false");
        this._resultCapabilitiesE.setAttribute("Streaming", this._streamSupported ? "true" : "false");
    }

    static enum LOGICAL_SERVER_TYPE {
        ANY,
        WKS,
        SPS;

    }
}

