/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.metadata.logical.storedprocess.ConfigDataPanel;
import com.sas.metadata.logical.storedprocess.DataItemPanel;
import com.sas.metadata.logical.storedprocess.DataSourcesAndTargetsPanel;
import com.sas.metadata.logical.storedprocess.MetadataManipulator;
import com.sas.metadata.logical.storedprocess.ObjectFactory;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.LayoutConstants;
import com.sas.metadata.logical.visuals.SmartWsDescriptionWizardTab;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.ProportionalSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import com.sas.workspace.MessageUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class DataTabPanel
extends SmartWsDescriptionWizardTab
implements LayoutConstants {
    private int _type;
    private Config _config;
    private DataSourcesAndTargetsPanel _dataSourcesPanel;
    private DataSourcesAndTargetsPanel _dataTargetsPanel;
    private MetadataManipulator _metadataManipulator;
    private boolean _hadItemsPreviously;
    private double _usageVersion;

    public DataTabPanel(ClassifierMap classifierMap, int type, Config config, MetadataManipulator metadataManipulator) throws RemoteException {
        this._config = config;
        this._type = type;
        this._metadataManipulator = metadataManipulator;
        this._usageVersion = classifierMap.getUsageVersion();
        String description = (String)config.getInitValue(ConfigDataPanel.WIZARD_DESCRIPTION, (Object)RB.getStringResource("DTP.Wiz.txt"));
        this.setDescription(description);
        this.setName(RB.getStringResource("DTP.Tab.txt"));
        if (type == 1) {
            this.setHelpProduct("storedprocess");
            this.setHelpTopic("stp_datatab");
        } else {
            this.setHelpProduct("newstp");
            this.setHelpTopic("datawin");
        }
        AutoSizingGridLayout layout = new AutoSizingGridLayout(4, 1, 5, 5, true, true, true);
        double[] sizes = new double[4];
        int[] mins = new int[4];
        this.setLayout((LayoutManager)layout);
        this.add(new JLabel(RB.getStringResource("DTP.Lbl.Srcs.txt")));
        sizes[0] = -2.0;
        mins[0] = 0;
        this._dataSourcesPanel = new DataSourcesAndTargetsPanel(metadataManipulator, true, this._usageVersion);
        this.add((Component)((Object)this._dataSourcesPanel));
        sizes[1] = 0.5;
        mins[1] = 200;
        this.add(new JLabel(RB.getStringResource("DTP.Lbl.Trgts.txt")));
        sizes[2] = -2.0;
        mins[2] = 0;
        this._dataTargetsPanel = new DataSourcesAndTargetsPanel(metadataManipulator, false, this._usageVersion);
        this.add((Component)((Object)this._dataTargetsPanel));
        sizes[3] = 0.5;
        mins[3] = 200;
        ((AutoSizingGridLayout)this._dataTargetsPanel.getLayout()).setInterlockedColumnContainer((Container)((Object)this._dataSourcesPanel));
        this._dataSourcesPanel.setOtherModel(this._dataTargetsPanel.getModel());
        this._dataTargetsPanel.setOtherModel(this._dataSourcesPanel.getModel());
        ProportionalSpacePartitioner psp = new ProportionalSpacePartitioner(sizes, mins, null);
        layout.setRowSpacePartitioner((SpacePartitionerInterface)psp);
    }

    protected void smartPopulateStore() throws MdException {
        if (this._type == 0) {
            Collection sources = (Collection)this._config.getInitValue(ConfigDataPanel.SOURCES, null);
            Collection targets = (Collection)this._config.getInitValue(ConfigDataPanel.TARGETS, null);
            if (sources != null) {
                this.setStreamsFromConfigIntoModel(sources, this._dataSourcesPanel.getModel());
            }
            if (targets != null) {
                this.setStreamsFromConfigIntoModel(targets, this._dataTargetsPanel.getModel());
            }
        } else {
            this.readFromXML();
            this._hadItemsPreviously = this._dataSourcesPanel.getModel().getRowCount() + this._dataTargetsPanel.getModel().getRowCount() > 0;
        }
    }

    protected boolean dataValidate() {
        boolean hasStreams;
        boolean bl = hasStreams = this._dataSourcesPanel.getModel().getRowCount() + this._dataTargetsPanel.getModel().getRowCount() > 0;
        if (this._usageVersion == ObjectFactory.NINETWO_VERSION.encode() && hasStreams && !this._metadataManipulator._storedProcessServerSelected) {
            MessageUtil.displayMessage((String)RB.getStringResource("DTP.StrmsInvld.msg.txt"), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
            return false;
        }
        this._metadataManipulator._hasStreams = hasStreams;
        return true;
    }

    public void moveDataToView() throws MdException {
        this._dataSourcesPanel.setEnabledStateOfButtons();
        this._dataTargetsPanel.setEnabledStateOfButtons();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        try {
            this.writeToXML();
        }
        catch (ParserConfigurationException e) {
            throw new MdException((Throwable)e);
        }
    }

    private void readFromXML() throws MdException {
        DataSourcesAndTargetsPanel.DataTableModel sourcesModel = this._dataSourcesPanel.getModel();
        DataSourcesAndTargetsPanel.DataTableModel targetsModel = this._dataTargetsPanel.getModel();
        Element spE = this._metadataManipulator.getStoredProcessXMLElementIfExists();
        if (spE == null) {
            return;
        }
        NodeList list = spE.getElementsByTagName("Data");
        if (list.getLength() == 0) {
            return;
        }
        if (list.getLength() > 1) {
            throw new MdException(RB.getStringResource("DTP.MultplDataTag.txt"));
        }
        Element dataE = (Element)list.item(0);
        list = dataE.getElementsByTagName("Source");
        this.readDataItemsFromXML(list, sourcesModel);
        sourcesModel.fireTableDataChanged();
        list = dataE.getElementsByTagName("Target");
        this.readDataItemsFromXML(list, targetsModel);
        targetsModel.fireTableDataChanged();
    }

    private void writeToXML() throws ParserConfigurationException, MdException, RemoteException {
        if (!this._hadItemsPreviously && this._dataSourcesPanel.getModel().getRowCount() + this._dataTargetsPanel.getModel().getRowCount() == 0) {
            return;
        }
        Element spE = this._metadataManipulator.getStoredProcessXMLElementCreatingItIfItDoesNotExist();
        NodeList list = spE.getElementsByTagName("Data");
        ArrayList<Node> tempList = new ArrayList<Node>();
        for (int i = 0; i < list.getLength(); ++i) {
            tempList.add(list.item(i));
        }
        Iterator it = tempList.iterator();
        while (it.hasNext()) {
            spE.removeChild((Node)it.next());
        }
        DataTabPanel.writeDataItemsToXML(spE, true, this._dataSourcesPanel.getModel().getList());
        DataTabPanel.writeDataItemsToXML(spE, false, this._dataTargetsPanel.getModel().getList());
    }

    private void setStreamsFromConfigIntoModel(Collection collection, DataSourcesAndTargetsPanel.DataTableModel model) {
        for (Object o : collection) {
            DataItemPanel.DataItem di = new DataItemPanel.DataItem();
            if (o instanceof ConfigDataPanel.GenericStream) {
                ConfigDataPanel.GenericStream gs = (ConfigDataPanel.GenericStream)o;
                di._label = gs._label;
                di._fileref = gs._fileref;
                di._description = gs._description;
                di._supportsMultiPass = gs._allowRewind;
                di._contentType = gs._contentType;
                if (gs instanceof ConfigDataPanel.XMLStream) {
                    di._type = "XMLStream";
                    ConfigDataPanel.XMLStream xs = (ConfigDataPanel.XMLStream)gs;
                    if (xs._hasSchema) {
                        di._hasSchema = true;
                        di._schemaURI = xs._schemaURI;
                        di._schemaToplevelNS = xs._schemaToplevelNS;
                        di._schemaToplevelName = xs._schemaToplevelName;
                        di._isSchemaReferenceTypeAType = xs._isSchemaReferenceTypeAType;
                        di._isWSDLEmbedded = xs._isWSDLEmbedded;
                    }
                } else {
                    di._type = "GenericStream";
                }
            } else if (o instanceof ConfigDataPanel.DataTable) {
                ConfigDataPanel.DataTable dt = (ConfigDataPanel.DataTable)o;
                di._type = "DataTable";
                di._label = dt._label;
                di._description = dt._description;
                di._tableParmName = dt._parameterName;
                di._templateTableAbsolutePath = dt._absolutePathOfTemplateTable;
            }
            model.addTableEntry(di, -1);
        }
        model.fireTableDataChanged();
    }

    private void readDataItemsFromXML(NodeList list, DataSourcesAndTargetsPanel.DataTableModel model) throws MdException {
        for (int i = 0; i < list.getLength(); ++i) {
            Element dataItemE = (Element)list.item(i);
            DataItemPanel.DataItem di = new DataItemPanel.DataItem();
            boolean dataTable = false;
            String type = dataItemE.getAttribute("Type");
            if (type.length() == 0) {
                throw new MdException(RB.getStringResource("DTP.MissnType.txt"));
            }
            if (type.equalsIgnoreCase("GenericStream")) {
                di._type = "GenericStream";
            } else if (type.equalsIgnoreCase("XMLStream")) {
                di._type = "XMLStream";
            } else if (type.equalsIgnoreCase("DataTable")) {
                di._type = "DataTable";
                dataTable = true;
            } else {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"DTP.UnsuppType.fmt.txt", (Object)type);
                throw new MdException(msg);
            }
            if (dataTable) {
                di._tableParmName = dataItemE.getAttribute("Name");
                di._templateTableAbsolutePath = dataItemE.getAttribute("TemplateTableLocation");
            } else {
                di._fileref = dataItemE.getAttribute("Fileref");
                if (di._fileref.length() == 0) {
                    throw new MdException(RB.getStringResource("DTP.MissnFileref.txt"));
                }
                String multiPass = dataItemE.getAttribute("Multipass");
                di._supportsMultiPass = multiPass.equalsIgnoreCase("true");
                di._contentType = dataItemE.getAttribute("ContentType");
            }
            di._description = "";
            di._label = "";
            NodeList cultureElements = dataItemE.getElementsByTagName("Culture");
            boolean seenValidCulture = false;
            for (int j = 0; j < cultureElements.getLength(); ++j) {
                Element cultureE = (Element)cultureElements.item(j);
                String xmlLangValue = cultureE.getAttribute("xml:lang");
                if (xmlLangValue.length() != 0) continue;
                if (seenValidCulture) {
                    throw new MdException(RB.getStringResource("DTP.MultplVldCultr.txt"));
                }
                seenValidCulture = true;
                NodeList cultureChildren = cultureE.getChildNodes();
                for (int k = 0; k < cultureChildren.getLength(); ++k) {
                    Element labelOrDesc;
                    Node nn = cultureChildren.item(k);
                    if (nn.getNodeType() != 1 || !(labelOrDesc = (Element)nn).getTagName().equals("Label") && !labelOrDesc.getTagName().equals("Description")) continue;
                    NodeList labelChildren = labelOrDesc.getChildNodes();
                    for (int l = 0; l < labelChildren.getLength(); ++l) {
                        Node tt = labelChildren.item(l);
                        if (tt.getNodeType() != 3) continue;
                        Text text = (Text)tt;
                        if (labelOrDesc.getTagName().equals("Label")) {
                            di._label = text.getNodeValue();
                            continue;
                        }
                        di._description = text.getNodeValue();
                    }
                }
            }
            if (!dataTable && di._type.equals("XMLStream")) {
                NodeList schemaElements = dataItemE.getElementsByTagName("Schema");
                if (schemaElements.getLength() > 1) {
                    throw new MdException(RB.getStringResource("DTP.MultplSchemaTag.txt"));
                }
                if (schemaElements.getLength() == 1) {
                    Element schemaE = (Element)schemaElements.item(0);
                    di._hasSchema = true;
                    di._schemaURI = schemaE.getAttribute("URI");
                    di._schemaToplevelNS = schemaE.getAttribute("Namespace");
                    di._schemaToplevelName = schemaE.getAttribute("Name");
                    NodeList wsdlElements = dataItemE.getElementsByTagName("WSDL");
                    if (wsdlElements.getLength() > 1) {
                        throw new MdException(RB.getStringResource("DTP.MultplWSDLTag.txt"));
                    }
                    if (wsdlElements.getLength() == 0) {
                        throw new MdException(RB.getStringResource("DTP.MissnWSDLTag.txt"));
                    }
                    Element wsdlE = (Element)wsdlElements.item(0);
                    di._isWSDLEmbedded = wsdlE.getAttribute("Embed").equalsIgnoreCase("true");
                    String refType = wsdlE.getAttribute("ReferenceType");
                    if (refType.equalsIgnoreCase("Element")) {
                        di._isSchemaReferenceTypeAType = false;
                    } else if (refType.equalsIgnoreCase("Type")) {
                        di._isSchemaReferenceTypeAType = true;
                    } else {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"DTP.UnsuppRefType.fmt.txt", (Object)refType);
                        throw new MdException(msg);
                    }
                }
            }
            model.addTableEntry(di, -1);
        }
    }

    static void writeDataItemsToXML(Element spE, boolean sources, ArrayList<DataItemPanel.DataItem> dataItems) throws MdException {
        Element dataE = DataTabPanel.getOrCreateDataElement(spE);
        Document document = spE.getOwnerDocument();
        for (DataItemPanel.DataItem di : dataItems) {
            boolean hasLabel;
            Element diE = document.createElement(sources ? "Source" : "Target");
            diE.setAttribute("Type", di._type);
            boolean dataTable = di._type.equalsIgnoreCase("DataTable");
            if (dataTable) {
                diE.setAttribute("Name", di._tableParmName);
                if (di._templateTableAbsolutePath.length() > 0) {
                    diE.setAttribute("TemplateTableLocation", di._templateTableAbsolutePath);
                }
            } else {
                diE.setAttribute("Fileref", di._fileref);
                if (sources) {
                    diE.setAttribute("Multipass", di._supportsMultiPass ? "true" : "false");
                }
                diE.setAttribute("ContentType", di._contentType);
            }
            boolean hasDesc = di._description != null && di._description.length() > 0;
            boolean bl = hasLabel = di._label != null && di._label.length() > 0;
            if (hasDesc || hasLabel) {
                Element cultureE = document.createElement("Culture");
                if (hasLabel) {
                    Element labelE = document.createElement("Label");
                    labelE.appendChild(document.createTextNode(di._label));
                    cultureE.appendChild(labelE);
                }
                if (hasDesc) {
                    Element descriptionE = document.createElement("Description");
                    descriptionE.appendChild(document.createTextNode(di._description));
                    cultureE.appendChild(descriptionE);
                }
                diE.appendChild(cultureE);
            }
            if (!dataTable && di._type.equals("XMLStream") && di._hasSchema) {
                Element schemaE = document.createElement("Schema");
                schemaE.setAttribute("URI", di._schemaURI);
                schemaE.setAttribute("Namespace", di._schemaToplevelNS);
                schemaE.setAttribute("Name", di._schemaToplevelName);
                diE.appendChild(schemaE);
                Element wsdlE = document.createElement("WSDL");
                wsdlE.setAttribute("Embed", di._isWSDLEmbedded ? "true" : "false");
                wsdlE.setAttribute("ReferenceType", di._isSchemaReferenceTypeAType ? "Type" : "Element");
                schemaE.appendChild(wsdlE);
            }
            dataE.appendChild(diE);
        }
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this._dataSourcesPanel.setEditable(this.isEditable());
        this._dataTargetsPanel.setEditable(this.isEditable());
    }

    static Element getOrCreateDataElement(Element spE) throws MdException {
        Element dataE;
        NodeList list = spE.getElementsByTagName("Data");
        if (list.getLength() > 1) {
            throw new MdException(RB.getStringResource("DTP.MultplDataTag.txt"));
        }
        Document document = spE.getOwnerDocument();
        if (list.getLength() == 0) {
            dataE = document.createElement("Data");
            spE.appendChild(dataE);
        } else {
            dataE = (Element)list.item(0);
        }
        return dataE;
    }
}

